# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgClVote(PrettyPrint):
    def __init__(
            self,
            vote: int = 0
    ) -> None:
        self.message_name = 'cl_vote'
        self.system_message = False
        self.header: ChunkHeader

        self.vote: int = vote

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.vote = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.vote)