# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int, pack_str

class MsgClCallVote(PrettyPrint):
    def __init__(
            self,
            type: str = 'default',
            value: str = 'default',
            reason: str = 'default',
            force: bool = False
    ) -> None:
        self.message_name = 'cl_call_vote'
        self.system_message = False
        self.header: ChunkHeader

        self.type: str = type
        self.value: str = value
        self.reason: str = reason
        self.force: bool = force

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.type = unpacker.get_str()
        self.value = unpacker.get_str()
        self.reason = unpacker.get_str()
        self.force = unpacker.get_int() == 1
        return True

    def pack(self) -> bytes:
        return pack_str(self.type) + \
            pack_str(self.value) + \
            pack_str(self.reason) + \
            pack_int(self.force)