"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const lib_1 = require("../lib");
describe('Pass State', () => {
    test('fromString has proper value', () => {
        const testValue = 'test string';
        const result = lib_1.Result.fromString(testValue);
        expect(result.value).toEqual(testValue);
    }),
        test('fromNumber has proper value', () => {
            const testValue = 1;
            const result = lib_1.Result.fromNumber(testValue);
            expect(result.value).toEqual(testValue);
        }),
        test('fromBoolean has proper value', () => {
            const testValue = false;
            const result = lib_1.Result.fromBoolean(testValue);
            expect(result.value).toEqual(testValue);
        }),
        test('fromObject has proper value', () => {
            const testValue = { a: 1 };
            const result = lib_1.Result.fromObject(testValue);
            expect(result.value).toStrictEqual(testValue);
        }),
        test('fromArray has proper value', () => {
            const testValue = [1];
            const result = lib_1.Result.fromArray(testValue);
            expect(result.value).toEqual(testValue);
        });
});
//# sourceMappingURL=data:application/json;base64,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