"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
// import * as kong_core from '../../kong-core/';
const index_1 = require("./resources/eks/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        // const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey', {
            enableKeyRotation: true,
        });
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
        });
        data_plane.vpc.addFlowLog('DpVpcFlowLog');
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        dp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        // new ElastiCacheStack(this, 'KongCache', {
        //   numberofnodegroups: 3,
        //   vpc: data_plane.vpc,
        // });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'AwsCertManager', {
            cluster: data_plane,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            privateCaArn: props.privateCaArn,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: data_plane,
        });
        //TODO : Error: kong-dp/KongEksDp/KongPreReqsStack/AutoScalar/KarpenterNodeRole should be defined in the scope of the kong-dp stack to prevent circular dependencies
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.MetricsServer(kong_pre_requisites_nested_stack, 'MetricsServer', {
            cluster: data_plane,
        });
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.kongTelemetryOptions.createPrometheusWorkspace,
            prometheusEndpoint: props.kongTelemetryOptions.prometheusEndpoint,
            cluster: data_plane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        const kong_data_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongDpStack');
        new index_1.KongEksDataPlane(kong_data_plane_nested_stack, 'KongDPHelmInstall', {
            cluster: data_plane,
            namespace: kong_core.Namespace.KONG_DATA_PLANE,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemetryDns,
            // nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_DP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        kong_data_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "3.0.0-dev.1" };
//# sourceMappingURL=data:application/json;base64,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