"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropsUtil = exports.AttiniRunner = exports.DeploymentPlan = exports.DeploymentPlanStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const constructs_1 = require("constructs");
class DeploymentPlanStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addTransform('AttiniDeploymentPlan');
        this.addTransform('AWS::Serverless-2016-10-31');
    }
}
exports.DeploymentPlanStack = DeploymentPlanStack;
_a = JSII_RTTI_SYMBOL_1;
DeploymentPlanStack[_a] = { fqn: "@attini/cdk.DeploymentPlanStack", version: "0.0.31" };
class DeploymentPlan extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::DeploymentPlan',
            properties: {
                DeploymentPlan: new aws_stepfunctions_1.StateGraph(props.definition.startState, 'not important').toGraphJson(),
            },
        });
    }
}
exports.DeploymentPlan = DeploymentPlan;
_b = JSII_RTTI_SYMBOL_1;
DeploymentPlan[_b] = { fqn: "@attini/cdk.DeploymentPlan", version: "0.0.31" };
class AttiniRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.runnerName = id;
        let copy = { ...props };
        if (props.awsVpcConfiguration?.subnets) {
            copy.awsVpcConfiguration.subnets = props.awsVpcConfiguration.subnets.join(',');
        }
        if (props.awsVpcConfiguration?.securityGroups) {
            copy.securityGroups.securityGroups = props.awsVpcConfiguration.securityGroups.join(',');
        }
        if (props.awsVpcConfiguration) {
            copy.securityGroups = PropsUtil.fixCase(props.awsVpcConfiguration);
        }
        if (props.runnerConfiguration) {
            copy.runnerConfiguration = PropsUtil.fixCase(props.runnerConfiguration);
        }
        if (props.startup) {
            copy.startup = PropsUtil.fixCase(props.startup);
        }
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::Runner',
            properties: PropsUtil.fixCase(copy),
        });
    }
}
exports.AttiniRunner = AttiniRunner;
_c = JSII_RTTI_SYMBOL_1;
AttiniRunner[_c] = { fqn: "@attini/cdk.AttiniRunner", version: "0.0.31" };
class PropsUtil {
    static fixCase(props) {
        let copy = {};
        Object.entries(props).forEach(([key, value]) => {
            copy[key.charAt(0).toUpperCase() + key.slice(1)] = value;
        });
        return copy;
    }
}
exports.PropsUtil = PropsUtil;
_d = JSII_RTTI_SYMBOL_1;
PropsUtil[_d] = { fqn: "@attini/cdk.PropsUtil", version: "0.0.31" };
__exportStar(require("./attini-state"), exports);
__exportStar(require("./attini-merge"), exports);
__exportStar(require("./attini-runner-job"), exports);
__exportStar(require("./attini-cfn"), exports);
__exportStar(require("./attini-manual-approval"), exports);
__exportStar(require("./attini-import"), exports);
__exportStar(require("./attini-lambda-invoke"), exports);
__exportStar(require("./attini-sam"), exports);
__exportStar(require("./attini-task"), exports);
//# sourceMappingURL=data:application/json;base64,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