import { Stack, StackProps } from 'aws-cdk-lib';
import { Chain } from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface DeploymentPlanProps {
    readonly definition: Chain;
}
export declare class DeploymentPlanStack extends Stack {
    constructor(scope: Construct, id: string, props: StackProps);
}
export declare class DeploymentPlan extends Construct {
    constructor(scope: Construct, id: string, props: DeploymentPlanProps);
}
export interface AttiniRunnerProps {
    readonly taskDefinitionArn?: string;
    readonly containerName?: string;
    readonly ecsCluster?: string;
    readonly roleArn?: string;
    readonly image?: string;
    readonly runnerConfiguration?: RunnerConfiguration;
    readonly awsVpcConfiguration?: AwsVpcConfiguration;
    readonly startup?: Startup;
}
export interface RunnerConfiguration {
    readonly maxConcurrentJobs?: number;
    readonly idleTimeToLive?: number;
    readonly jobTimeout?: number;
    readonly logLevel?: string;
}
export interface AwsVpcConfiguration {
    readonly subnets?: Array<string>;
    readonly securityGroups?: Array<string>;
    readonly assignPublicIp?: string;
}
export interface Startup {
    readonly commands?: Array<string>;
    readonly commandsTimeout?: number;
}
export declare class AttiniRunner extends Construct {
    readonly runnerName: string;
    constructor(scope: Construct, id: string, props: AttiniRunnerProps);
}
export declare class PropsUtil {
    static fixCase(props: any): object;
}
export * from './attini-state';
export * from './attini-merge';
export * from './attini-runner-job';
export * from './attini-cfn';
export * from './attini-manual-approval';
export * from './attini-import';
export * from './attini-lambda-invoke';
export * from './attini-sam';
export * from './attini-task';
