"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniImport = exports.SourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
var SourceType;
(function (SourceType) {
    SourceType[SourceType["S3_SOURCE"] = 0] = "S3_SOURCE";
    SourceType[SourceType["DISTRIBUTION_SOURCE"] = 1] = "DISTRIBUTION_SOURCE";
})(SourceType = exports.SourceType || (exports.SourceType = {}));
class AttiniImport extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniImport';
        if (this.props.sourceType.valueOf() === SourceType.S3_SOURCE.valueOf() && !this.props.s3Source) {
            throw new Error('S3 source is set as type for Attini import step but no S3 source is configured, id =' + id);
        }
        if (this.props.sourceType.valueOf() === SourceType.DISTRIBUTION_SOURCE.valueOf() && !this.props.distributionSource) {
            throw new Error('Distribution source is set as type for Attini import step but no distribution source is configured, id: ' + id);
        }
    }
    renderProps() {
        let properties = {};
        if (this.props.sourceType.valueOf() === SourceType.S3_SOURCE.valueOf()) {
            properties.SourceType = 'S3';
            properties.Source = index_1.PropsUtil.fixCase(this.props.s3Source);
        }
        else {
            properties.SourceType = 'Distribution';
            properties.Source = index_1.PropsUtil.fixCase(this.props.distributionSource);
        }
        if (properties.Mapping) {
            properties.Mapping = this.props.mapping;
        }
        if (properties.ExecutionRoleArn) {
            properties.ExecutionRoleArn = this.props.executionRoleArn;
        }
        return {
            Properties: aws_stepfunctions_1.FieldUtils.renderObject(properties),
        };
    }
}
exports.AttiniImport = AttiniImport;
_a = JSII_RTTI_SYMBOL_1;
AttiniImport[_a] = { fqn: "@attini/cdk.AttiniImport", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,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