import { Construct } from 'constructs';
import { AttiniTask } from './attini-task';
export interface S3Source {
    readonly key: string;
    readonly bucket: string;
}
export interface DistributionSource {
    readonly name: string;
}
export declare enum SourceType {
    S3_SOURCE = 0,
    DISTRIBUTION_SOURCE = 1
}
export interface AttiniImportProps {
    readonly sourceType: SourceType;
    readonly s3Source?: S3Source;
    readonly distributionSource?: DistributionSource;
    readonly mapping?: {
        [key: string]: string;
    };
    readonly executionRoleArn?: String;
}
export declare class AttiniImport extends AttiniTask {
    private props;
    type: string;
    constructor(scope: Construct, id: string, props: AttiniImportProps);
    protected renderProps(): object;
}
