# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-04-16 10:07
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='AnonymizedData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('field', models.CharField(max_length=250, verbose_name='anonymized field name')),
                ('object_id', models.TextField(verbose_name='related object ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('content_type',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='related object content type')),
            ],
            options={
                'verbose_name': 'anonymized data',
                'verbose_name_plural': 'anonymized data',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='LegalReason',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('expires_at', models.DateTimeField(db_index=True, verbose_name='expires at')),
                ('tag', models.CharField(blank=True, max_length=100, null=True, verbose_name='tag')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('purpose_slug', models.CharField(max_length=100, verbose_name='purpose')),
                ('source_object_id', models.TextField(verbose_name='source object ID')),
                ('source_object_content_type',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='source object content type')),
            ],
            options={
                'verbose_name': 'legal reason',
                'verbose_name_plural': 'legal reasons',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='LegalReasonRelatedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(verbose_name='related object ID')),
                ('content_type',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='related object content type')),
                ('legal_reason',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='related_objects',
                                   to='gdpr.LegalReason', verbose_name='legal reason')),
            ],
            options={
                'verbose_name': 'legal reason related object',
                'verbose_name_plural': 'legal reasons related objects',
                'ordering': ('-created_at',),
            },
        ),
        migrations.AddField(
            model_name='anonymizeddata',
            name='expired_reason',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to='gdpr.LegalReason', verbose_name='expired reason'),
        ),
    ]
