---
jupyter:
  jupytext:
    formats: ipynb,md
    text_representation:
      extension: .md
      format_name: markdown
      format_version: '1.2'
      jupytext_version: 1.6.0
  kernelspec:
    display_name: Python 3
    language: python
    name: python3
---

```python
%load_ext autoreload
%autoreload 2

import sys
import os
import inspect
import getpass
import json

import pandas as pd

project_path = os.path.abspath( os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe()))) + "/../../" )
sys.path.insert(0, project_path)
print(project_path)

from nestor.store_data import helper

from nestor.store_data.database import DatabaseNeo4J 
from nestor.store_data import integration 

from nestor.store_data.objects import human
from nestor.store_data.objects import issue
from nestor.store_data.objects import machine
from nestor.store_data.objects import tag
from nestor.store_data.objects import maintenanceworkorder

```

```python
        for key1, value1 in csvHeaderOriginal.items():
            for key2, value2 in value1.items():
                for keyO, valueO in csvHeaderMapping.items():
                    if valueO == value2:
                        csvHeaderOriginal[key1][key2] = keyO

        self.csv_header = csvHeaderOriginal
```

# Setup Dataset informations


foreach Dataset get all the specific information such as:

    bolt : the url of the database server {e.g.: bolt://localhost:7687}
    user : Identification to connect to the database -STRING
    password : Password to connect to the database -STRING
    
    nestor_file: the h5 files generated by Nestor (the tagging app)
    csvSchemas_file : Path of the file use to link the header of the CSV with the properties in the database -YAML
    
------------------------------------
    
    vocab1g_file : Path of the vocab 1G file created by Nestor -CSV
    vocabNg_file : Path of the vocab NG file created by Nestor -JSON
    
    tree_path : Path of the item-item hierarchy (created by <insert a name here>) -JSON

```python
bolt = input('bolt:')
user = input('user:')
password = getpass.getpass("Password:")

nestor_file = input('path of the nestor file:')
csvSchemas_file = input('path of the csv header links:')
```

```python
bolt = "bolt://localhost:7687"
user = "neo4j"
password = "MINE!!"

nestor_file = os.path.join(project_path ,'data','public', 'output.h5')
csvSchemas_file = os.path.join(project_path ,'data','public', 'header.yaml')
```

# Load Files from Path


foreach path file, load them into the memory using the needed format:
    
    Dataframe for : csv_file, bincsv_file, binNcsv_file, vocabcsv_file, vocabNcsv_file
   
    Dictionary for : csvSchemas_file, tree_path

```python
dataframe = pd.read_hdf(nestor_file, key="df")
dataframe.fillna("", inplace=True)
csvSchemas_dict = helper.openYAMLFile(csvSchemas_file)


dataframe_tag = pd.read_hdf(nestor_file, key="tags")
dataframe_rel = pd.read_hdf(nestor_file, key="rels")


dataframe_vocab1g = None
dataframe_vocabNg = None
```

```python
with open(tree_path) as file:
    tree_dict = json.load(file)
```

# ConnectGraphDatabase

```python
databaseSchema_file = os.path.join(project_path ,'nestor', 'store_data', 'DatabaseSchema.yaml')
databaseSchema_dict = helper.openYAMLFile(databaseSchema_file)

database = DatabaseNeo4J(bolt, user, password, databaseSchema_dict) 
```

## Clean the database

```python
database.deleteData()

database.dropConstraints()
database.dropIndexes()

database.createIndexes()
database.createConstraints()
```

## Create Cypher Queries


### Create historical_data

```python
database.runQueries(integration.cypherCreate_historicalMaintenanceWorkOrder (database.schema, dataframe, csvSchemas_dict))
```

### Create tag_data

```python
database.runQueries(integration.cypherCreate_tag(database.schema, dataframe_tag, dataframe_vocab1g, dataframe_vocabNg))
```

```python
database.runQueries(integration.cypherCreate_tag(database.schema, dataframe_rel, dataframe_vocab1g, dataframe_vocabNg))
```

### Update 1gram-->Ngram

```python
database.runQueries(integration.cypherLink_Ngram1gram(database.schema))
```

### Update issue-->item

```python
database.runQueries(integration.cypherLink_itemIssue(database.schema))
```

### Update item-->item

```python
database.runQueries(integration.cypherCreate_itemsTree(database.schema,tree_dict ))
```

```python
t = 1
r = str(t)

print(type(t))
print(type(r))
```

------------------
