# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['blackbricks']

package_data = \
{'': ['*']}

install_requires = \
['black>=21.5b1,<22.0',
 'databricks-cli>=0.14.3,<0.15.0',
 'sqlparse>=0.4.1,<0.5.0',
 'typer[all]>=0.3.2,<0.4.0']

entry_points = \
{'console_scripts': ['blackbricks = blackbricks.cli:app']}

setup_kwargs = {
    'name': 'blackbricks',
    'version': '0.7.0',
    'description': 'Black for Databricks notebooks',
    'long_description': "[![PyPI version](https://img.shields.io/pypi/v/blackbricks.svg?logo=pypi&logoColor=FFE873)](https://pypi.org/project/blackbricks/)\n[![Downloads](https://pepy.tech/badge/blackbricks)](https://pepy.tech/project/blackbricks)\n[![Downloads per month](https://pepy.tech/badge/blackbricks/month)](https://pepy.tech/project/blackbricks/month)\n[![License](https://img.shields.io/pypi/l/blackbricks)](LICENSE)\n[![Code style: Black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n# Blackbricks\n\nA formatting tool for your Databricks notebooks.\n\n- Python cells are formatted with [black](https://github.com/psf/black)\n- SQL cells are formatted with [sqlparse](https://github.com/andialbrecht/sqlparse)\n\n## Table of Contents\n\n* [Installation](#installation)\n* [Usage](#usage)\n* [Version control integration](#version-control-integration)\n* [Contributing](#contributing)\n* [FAQ](#faq)\n\n## Installation\n\nInstall:\n\n```bash\n$ pip install blackbricks\n```\n\nYou probably also want to have installed the `databricks-cli`, in order to use `blackbricks` directly on your notebooks.\n\n``` bash\n$ pip install databricks-cli\n$ databricks configure  # Required in order to use `blackbricks` on remote notebooks.\n```\n\n## Usage\nYou can use `blackbricks` on Python notebook files stored locally, or directly on the notebooks stored in Databricks. \n\nFor the most part, `blackbricks` operates very similary to `black`.\n\n``` bash\n$ blackbricks notebook1.py notebook2.py  # Formats both notebooks.\n$ blackbricks notebook_directory/  # Formats every notebook under the directory (recursively).\n```\nAn important difference is that `blackbricks` will ignore any file that does not contain the `# Databricks notebook source` header on the first line. Databricks adds this line to all Python notebooks. This means you can happily run `blackbricks` on a directory with both notebooks and regular Python files, and `blackbricks` won't touch the latter.\n\nIf you specify the `-r` or `--remote` flag, `blackbricks` will work directly on your notebooks stored in Databricks.\n\n``` bash\n$ blackbricks --remote /Users/username/notebook.py\n```\n\nWhen working on remote files, you _can not_ add whole directories.\n\n### Full usage\n\n```text\n$ blackbricks --help\nUsage: blackbricks [OPTIONS] [FILENAMES]...\n\n  Formatting tool for Databricks python notebooks.\n\n  Python cells are formatted using `black`, and SQL cells are formatted by\n  `sqlparse`.\n\n  Local files (without the `--remote` option):\n\n    - Only files that look like Databricks (Python) notebooks will be\n    processed. That is, they must start with the header `# Databricks\n    notebook source`\n\n    - If you specify a directory as one of the file names, all files in that\n    directory will be added, including any subdirectory.\n\n  Remote files (with the `--remote` option):\n\n    - Make sure you have installed the Databricks CLI (``pip install\n    databricks_cli``)\n\n    - Make sure you have configured at least one profile (`databricks\n    configure`). Check the file `~/.databrickscfg` if you are not sure.\n\n    - File paths should start with `/`. Otherwise they are interpreted as\n    relative to `/Users/username`, where `username` is the username\n    specified in the Databricks profile used.\n\nArguments:\n  [FILENAMES]...  Path to the notebook(s) to format.\n\nOptions:\n  -r, --remote                    If this option is used, all filenames are\n                                  treated as paths to notebooks on your\n                                  Databricks host (i.e. not local files).\n                                  [default: False]\n\n  -p, --profile NAME              If using --remote, which Databricks profile\n                                  to use.  [default: DEFAULT]\n\n  --line-length INTEGER           How many characters per line to allow.\n                                  [default: 88]\n\n  --sql-upper / --no-sql-upper    SQL keywords should be UPPERCASE or\n                                  lowercase.  [default: True]\n\n  --indent-with-two-spaces / --no-indent-with-two-spaces\n                                  Use two spaces for indentation in Python\n                                  cells instead of Black's default of four.\n                                  Databricks uses two spaces.  [default: True]\n\n  --check                         Don't write the files back, just return the\n                                  status. Return code 0 means nothing would\n                                  change.\n\n  --diff                          Don't write the files back, just output a\n                                  diff for each file on stdout.\n\n  --version                       Display version information and exit.\n  --help                          Show this message and exit.\n```\n\n\n\n## Version control integration\n\nUse [pre-commit](https://pre-commit.com). Add a `.pre-commit-config.yaml` file\nto your repo with the following content (changing/removing the `args` as you\nwish): \n\n```yaml\nrepos:\n-   repo: https://github.com/bsamseth/blackbricks\n    rev: 0.6.0\n    hooks:\n    - id: blackbricks\n      args: [--line-length=120, --indent-with-two-spaces]\n```\n\nSet the `rev` attribute to the most recent version of `blackbricks`.\nThe `args` are optional and can be used to set any of `blackbricks` options.\n\n## Contributing\n\nIf you find blackbricks useful, feel free to say so with a star. If you think it is utterly broken, you are more than welcome to contribute improvements. Please open an issue first to discuss what you want added/fixed. Unless you are just adding tests. In that case your pull request is extremely likely to be merged right away.\n\n## FAQ\n\n### Can I disable SQL formatting?\n\nSure! Certain SQL statements might not be parsed and indented properly by `sqlparse`, and the result can be jumbled formatting. You can disable SQL formatting for a cell by adding `-- nofmt` to the very first line of a cell:\n\n```sql\n%sql  -- nofmt\nselect this,\n             sql_will,   -- be kept just\n         like_this\n  from if_that_is.what_you_need\n```\n\n### How do I use `blackbricks` on my Databricks notebooks?\n\nFirst, make sure you have set up `databricks-cli` on your system (see\n[installation](#installation)), and that you have at least one profile setup in\n`~/.databrickscfg`. As an example:\n\n```cfg\n# File: ~/.databrickscfg\n\n[DEFAULT]\nhost = https://dbc-b23456-a1243.cloud.databricks.com/\nusername = username@example.com\npassword = dapi12345678901234567890\n\n[OTHERPROFILE]\nhost = https://dbc-c54321-d234.cloud.databricks.com\nusername = name.user@example.com\npassword = dapi09876543211234567890\n```\n\nYou should use [access tokens](https://docs.databricks.com/dev-tools/api/latest/authentication.html) instead of your actual password.\n\nYou can then do:\n\n``` bash\n$ blackbricks --remote /Users/username@example.com/notebook.py  # Uses DEFAULT profile.\n$ blackbricks --remote notebook.py  # Equivalent to the above.\n$ blackbricks --remote --profile OTHERPROFILE /Users/name.user@example.com/notebook.py\n$ blackbricks --remote --profile OTHERPROFILE notebook.py  # Equivalent to the above.\n```\n\n### I get an error: `TypeError: init() got an unexpected keyword argument 'no_args_is_help'`\n\nThis means you had an old version of `click` installed from before, and your installation didn't upgrade it automatically. Updating your installation should do the trick, e.g. `pip install -U blackbricks` or similar depending on your installation method of choice.\n",
    'author': 'Bendik Samseth',
    'author_email': 'bendik.samseth@inspera.no',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/inspera/blackbricks',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
