"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackCapabilities = void 0;
/**
 * Acknowledge IAM resources in AWS CloudFormation templates.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities
 */
var StackCapabilities;
(function (StackCapabilities) {
    /** Acknowledge your stack includes IAM resources */
    StackCapabilities["IAM"] = "CAPABILITY_IAM";
    /** Acknowledge your stack includes custom names for IAM resources */
    StackCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /** Acknowledge your stack contains one or more macros */
    StackCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(StackCapabilities = exports.StackCapabilities || (exports.StackCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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