# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six


class RuleChainMetaData(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'connections': 'list[NodeConnectionInfo]',
        'first_node_index': 'int',
        'nodes': 'list[RuleNode]',
        'rule_chain_connections': 'list[RuleChainConnectionInfo]',
        'rule_chain_id': 'RuleChainId'
    }

    attribute_map = {
        'connections': 'connections',
        'first_node_index': 'firstNodeIndex',
        'nodes': 'nodes',
        'rule_chain_connections': 'ruleChainConnections',
        'rule_chain_id': 'ruleChainId'
    }

    def __init__(self, connections=None, first_node_index=None, nodes=None, rule_chain_connections=None, rule_chain_id=None):  # noqa: E501
        """RuleChainMetaData - a model defined in Swagger"""  # noqa: E501

        self._connections = None
        self._first_node_index = None
        self._nodes = None
        self._rule_chain_connections = None
        self._rule_chain_id = None
        self.discriminator = None

        if connections is not None:
            self.connections = connections
        if first_node_index is not None:
            self.first_node_index = first_node_index
        if nodes is not None:
            self.nodes = nodes
        if rule_chain_connections is not None:
            self.rule_chain_connections = rule_chain_connections
        if rule_chain_id is not None:
            self.rule_chain_id = rule_chain_id

    @property
    def connections(self):
        """Gets the connections of this RuleChainMetaData.  # noqa: E501


        :return: The connections of this RuleChainMetaData.  # noqa: E501
        :rtype: list[NodeConnectionInfo]
        """
        return self._connections

    @connections.setter
    def connections(self, connections):
        """Sets the connections of this RuleChainMetaData.


        :param connections: The connections of this RuleChainMetaData.  # noqa: E501
        :type: list[NodeConnectionInfo]
        """

        self._connections = connections

    @property
    def first_node_index(self):
        """Gets the first_node_index of this RuleChainMetaData.  # noqa: E501


        :return: The first_node_index of this RuleChainMetaData.  # noqa: E501
        :rtype: int
        """
        return self._first_node_index

    @first_node_index.setter
    def first_node_index(self, first_node_index):
        """Sets the first_node_index of this RuleChainMetaData.


        :param first_node_index: The first_node_index of this RuleChainMetaData.  # noqa: E501
        :type: int
        """

        self._first_node_index = first_node_index

    @property
    def nodes(self):
        """Gets the nodes of this RuleChainMetaData.  # noqa: E501


        :return: The nodes of this RuleChainMetaData.  # noqa: E501
        :rtype: list[RuleNode]
        """
        return self._nodes

    @nodes.setter
    def nodes(self, nodes):
        """Sets the nodes of this RuleChainMetaData.


        :param nodes: The nodes of this RuleChainMetaData.  # noqa: E501
        :type: list[RuleNode]
        """

        self._nodes = nodes

    @property
    def rule_chain_connections(self):
        """Gets the rule_chain_connections of this RuleChainMetaData.  # noqa: E501


        :return: The rule_chain_connections of this RuleChainMetaData.  # noqa: E501
        :rtype: list[RuleChainConnectionInfo]
        """
        return self._rule_chain_connections

    @rule_chain_connections.setter
    def rule_chain_connections(self, rule_chain_connections):
        """Sets the rule_chain_connections of this RuleChainMetaData.


        :param rule_chain_connections: The rule_chain_connections of this RuleChainMetaData.  # noqa: E501
        :type: list[RuleChainConnectionInfo]
        """

        self._rule_chain_connections = rule_chain_connections

    @property
    def rule_chain_id(self):
        """Gets the rule_chain_id of this RuleChainMetaData.  # noqa: E501


        :return: The rule_chain_id of this RuleChainMetaData.  # noqa: E501
        :rtype: RuleChainId
        """
        return self._rule_chain_id

    @rule_chain_id.setter
    def rule_chain_id(self, rule_chain_id):
        """Sets the rule_chain_id of this RuleChainMetaData.


        :param rule_chain_id: The rule_chain_id of this RuleChainMetaData.  # noqa: E501
        :type: RuleChainId
        """

        self._rule_chain_id = rule_chain_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RuleChainMetaData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RuleChainMetaData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
