# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client32.api_client import ApiClient


class EntityRelationControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_relation_using_delete(self, from_id, from_type, relation_type, to_id, to_type, **kwargs):  # noqa: E501
        """deleteRelation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_relation_using_delete(from_id, from_type, relation_type, to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type: relationType (required)
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_relation_using_delete_with_http_info(from_id, from_type, relation_type, to_id, to_type, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_relation_using_delete_with_http_info(from_id, from_type, relation_type, to_id, to_type, **kwargs)  # noqa: E501
            return data

    def delete_relation_using_delete_with_http_info(self, from_id, from_type, relation_type, to_id, to_type, **kwargs):  # noqa: E501
        """deleteRelation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_relation_using_delete_with_http_info(from_id, from_type, relation_type, to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type: relationType (required)
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['from_id', 'from_type', 'relation_type', 'to_id', 'to_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'from_id' is set
        if ('from_id' not in params or
                params['from_id'] is None):
            raise ValueError("Missing the required parameter `from_id` when calling `delete_relation_using_delete`")  # noqa: E501
        # verify the required parameter 'from_type' is set
        if ('from_type' not in params or
                params['from_type'] is None):
            raise ValueError("Missing the required parameter `from_type` when calling `delete_relation_using_delete`")  # noqa: E501
        # verify the required parameter 'relation_type' is set
        if ('relation_type' not in params or
                params['relation_type'] is None):
            raise ValueError("Missing the required parameter `relation_type` when calling `delete_relation_using_delete`")  # noqa: E501
        # verify the required parameter 'to_id' is set
        if ('to_id' not in params or
                params['to_id'] is None):
            raise ValueError("Missing the required parameter `to_id` when calling `delete_relation_using_delete`")  # noqa: E501
        # verify the required parameter 'to_type' is set
        if ('to_type' not in params or
                params['to_type'] is None):
            raise ValueError("Missing the required parameter `to_type` when calling `delete_relation_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'from_id' in params:
            query_params.append(('fromId', params['from_id']))  # noqa: E501
        if 'from_type' in params:
            query_params.append(('fromType', params['from_type']))  # noqa: E501
        if 'relation_type' in params:
            query_params.append(('relationType', params['relation_type']))  # noqa: E501
        if 'to_id' in params:
            query_params.append(('toId', params['to_id']))  # noqa: E501
        if 'to_type' in params:
            query_params.append(('toType', params['to_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relation{?relationTypeGroup,fromId,fromType,relationType,toId,toType}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_relations_using_delete(self, entity_id, entity_type, id, type, **kwargs):  # noqa: E501
        """deleteRelations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_relations_using_delete(entity_id, entity_type, id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: entityId (required)
        :param str entity_type: entityType (required)
        :param str id: (required)
        :param str type: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_relations_using_delete_with_http_info(entity_id, entity_type, id, type, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_relations_using_delete_with_http_info(entity_id, entity_type, id, type, **kwargs)  # noqa: E501
            return data

    def delete_relations_using_delete_with_http_info(self, entity_id, entity_type, id, type, **kwargs):  # noqa: E501
        """deleteRelations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_relations_using_delete_with_http_info(entity_id, entity_type, id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: entityId (required)
        :param str entity_type: entityType (required)
        :param str id: (required)
        :param str type: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'entity_type', 'id', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `delete_relations_using_delete`")  # noqa: E501
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `delete_relations_using_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_relations_using_delete`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `delete_relations_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'entity_id' in params:
            query_params.append(('entityId', params['entity_id']))  # noqa: E501
        if 'entity_type' in params:
            query_params.append(('entityType', params['entity_type']))  # noqa: E501
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations{?entityId,entityType,id,type}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_by_from_using_get(self, from_id, from_type, **kwargs):  # noqa: E501
        """findByFrom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_from_using_get(from_id, from_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_by_from_using_get_with_http_info(from_id, from_type, **kwargs)  # noqa: E501
        else:
            (data) = self.find_by_from_using_get_with_http_info(from_id, from_type, **kwargs)  # noqa: E501
            return data

    def find_by_from_using_get_with_http_info(self, from_id, from_type, **kwargs):  # noqa: E501
        """findByFrom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_from_using_get_with_http_info(from_id, from_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['from_id', 'from_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'from_id' is set
        if ('from_id' not in params or
                params['from_id'] is None):
            raise ValueError("Missing the required parameter `from_id` when calling `find_by_from_using_get`")  # noqa: E501
        # verify the required parameter 'from_type' is set
        if ('from_type' not in params or
                params['from_type'] is None):
            raise ValueError("Missing the required parameter `from_type` when calling `find_by_from_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'from_id' in params:
            query_params.append(('fromId', params['from_id']))  # noqa: E501
        if 'from_type' in params:
            query_params.append(('fromType', params['from_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations{?relationTypeGroup,fromId,fromType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_by_from_using_get1(self, from_id, from_type, relation_type, **kwargs):  # noqa: E501
        """findByFrom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_from_using_get1(from_id, from_type, relation_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type: relationType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_by_from_using_get1_with_http_info(from_id, from_type, relation_type, **kwargs)  # noqa: E501
        else:
            (data) = self.find_by_from_using_get1_with_http_info(from_id, from_type, relation_type, **kwargs)  # noqa: E501
            return data

    def find_by_from_using_get1_with_http_info(self, from_id, from_type, relation_type, **kwargs):  # noqa: E501
        """findByFrom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_from_using_get1_with_http_info(from_id, from_type, relation_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type: relationType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['from_id', 'from_type', 'relation_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'from_id' is set
        if ('from_id' not in params or
                params['from_id'] is None):
            raise ValueError("Missing the required parameter `from_id` when calling `find_by_from_using_get1`")  # noqa: E501
        # verify the required parameter 'from_type' is set
        if ('from_type' not in params or
                params['from_type'] is None):
            raise ValueError("Missing the required parameter `from_type` when calling `find_by_from_using_get1`")  # noqa: E501
        # verify the required parameter 'relation_type' is set
        if ('relation_type' not in params or
                params['relation_type'] is None):
            raise ValueError("Missing the required parameter `relation_type` when calling `find_by_from_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'from_id' in params:
            query_params.append(('fromId', params['from_id']))  # noqa: E501
        if 'from_type' in params:
            query_params.append(('fromType', params['from_type']))  # noqa: E501
        if 'relation_type' in params:
            query_params.append(('relationType', params['relation_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations{?relationTypeGroup,fromId,fromType,relationType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_by_query_using_post2(self, query, **kwargs):  # noqa: E501
        """findByQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_query_using_post2(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityRelationsQuery query: query (required)
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_by_query_using_post2_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.find_by_query_using_post2_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def find_by_query_using_post2_with_http_info(self, query, **kwargs):  # noqa: E501
        """findByQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_query_using_post2_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityRelationsQuery query: query (required)
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `find_by_query_using_post2`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query' in params:
            body_params = params['query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_by_to_using_get(self, to_id, to_type, **kwargs):  # noqa: E501
        """findByTo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_to_using_get(to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_by_to_using_get_with_http_info(to_id, to_type, **kwargs)  # noqa: E501
        else:
            (data) = self.find_by_to_using_get_with_http_info(to_id, to_type, **kwargs)  # noqa: E501
            return data

    def find_by_to_using_get_with_http_info(self, to_id, to_type, **kwargs):  # noqa: E501
        """findByTo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_to_using_get_with_http_info(to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['to_id', 'to_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'to_id' is set
        if ('to_id' not in params or
                params['to_id'] is None):
            raise ValueError("Missing the required parameter `to_id` when calling `find_by_to_using_get`")  # noqa: E501
        # verify the required parameter 'to_type' is set
        if ('to_type' not in params or
                params['to_type'] is None):
            raise ValueError("Missing the required parameter `to_type` when calling `find_by_to_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'to_id' in params:
            query_params.append(('toId', params['to_id']))  # noqa: E501
        if 'to_type' in params:
            query_params.append(('toType', params['to_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations{?relationTypeGroup,toId,toType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_by_to_using_get1(self, to_id, to_type, relation_type, **kwargs):  # noqa: E501
        """findByTo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_to_using_get1(to_id, to_type, relation_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type: relationType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_by_to_using_get1_with_http_info(to_id, to_type, relation_type, **kwargs)  # noqa: E501
        else:
            (data) = self.find_by_to_using_get1_with_http_info(to_id, to_type, relation_type, **kwargs)  # noqa: E501
            return data

    def find_by_to_using_get1_with_http_info(self, to_id, to_type, relation_type, **kwargs):  # noqa: E501
        """findByTo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_by_to_using_get1_with_http_info(to_id, to_type, relation_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type: relationType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['to_id', 'to_type', 'relation_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'to_id' is set
        if ('to_id' not in params or
                params['to_id'] is None):
            raise ValueError("Missing the required parameter `to_id` when calling `find_by_to_using_get1`")  # noqa: E501
        # verify the required parameter 'to_type' is set
        if ('to_type' not in params or
                params['to_type'] is None):
            raise ValueError("Missing the required parameter `to_type` when calling `find_by_to_using_get1`")  # noqa: E501
        # verify the required parameter 'relation_type' is set
        if ('relation_type' not in params or
                params['relation_type'] is None):
            raise ValueError("Missing the required parameter `relation_type` when calling `find_by_to_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'to_id' in params:
            query_params.append(('toId', params['to_id']))  # noqa: E501
        if 'to_type' in params:
            query_params.append(('toType', params['to_type']))  # noqa: E501
        if 'relation_type' in params:
            query_params.append(('relationType', params['relation_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations{?relationTypeGroup,toId,toType,relationType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_info_by_from_using_get(self, from_id, from_type, **kwargs):  # noqa: E501
        """findInfoByFrom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_info_by_from_using_get(from_id, from_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelationInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_info_by_from_using_get_with_http_info(from_id, from_type, **kwargs)  # noqa: E501
        else:
            (data) = self.find_info_by_from_using_get_with_http_info(from_id, from_type, **kwargs)  # noqa: E501
            return data

    def find_info_by_from_using_get_with_http_info(self, from_id, from_type, **kwargs):  # noqa: E501
        """findInfoByFrom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_info_by_from_using_get_with_http_info(from_id, from_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelationInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['from_id', 'from_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'from_id' is set
        if ('from_id' not in params or
                params['from_id'] is None):
            raise ValueError("Missing the required parameter `from_id` when calling `find_info_by_from_using_get`")  # noqa: E501
        # verify the required parameter 'from_type' is set
        if ('from_type' not in params or
                params['from_type'] is None):
            raise ValueError("Missing the required parameter `from_type` when calling `find_info_by_from_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'from_id' in params:
            query_params.append(('fromId', params['from_id']))  # noqa: E501
        if 'from_type' in params:
            query_params.append(('fromType', params['from_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations/info{?relationTypeGroup,fromId,fromType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelationInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_info_by_query_using_post(self, query, **kwargs):  # noqa: E501
        """findInfoByQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_info_by_query_using_post(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityRelationsQuery query: query (required)
        :return: list[EntityRelationInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_info_by_query_using_post_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.find_info_by_query_using_post_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def find_info_by_query_using_post_with_http_info(self, query, **kwargs):  # noqa: E501
        """findInfoByQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_info_by_query_using_post_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityRelationsQuery query: query (required)
        :return: list[EntityRelationInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `find_info_by_query_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query' in params:
            body_params = params['query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations/info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelationInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_info_by_to_using_get(self, to_id, to_type, **kwargs):  # noqa: E501
        """findInfoByTo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_info_by_to_using_get(to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelationInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_info_by_to_using_get_with_http_info(to_id, to_type, **kwargs)  # noqa: E501
        else:
            (data) = self.find_info_by_to_using_get_with_http_info(to_id, to_type, **kwargs)  # noqa: E501
            return data

    def find_info_by_to_using_get_with_http_info(self, to_id, to_type, **kwargs):  # noqa: E501
        """findInfoByTo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_info_by_to_using_get_with_http_info(to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: list[EntityRelationInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['to_id', 'to_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'to_id' is set
        if ('to_id' not in params or
                params['to_id'] is None):
            raise ValueError("Missing the required parameter `to_id` when calling `find_info_by_to_using_get`")  # noqa: E501
        # verify the required parameter 'to_type' is set
        if ('to_type' not in params or
                params['to_type'] is None):
            raise ValueError("Missing the required parameter `to_type` when calling `find_info_by_to_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'to_id' in params:
            query_params.append(('toId', params['to_id']))  # noqa: E501
        if 'to_type' in params:
            query_params.append(('toType', params['to_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relations/info{?relationTypeGroup,toId,toType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityRelationInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_relation_using_get(self, from_id, from_type, relation_type, to_id, to_type, **kwargs):  # noqa: E501
        """getRelation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_relation_using_get(from_id, from_type, relation_type, to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type: relationType (required)
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: EntityRelation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_relation_using_get_with_http_info(from_id, from_type, relation_type, to_id, to_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_relation_using_get_with_http_info(from_id, from_type, relation_type, to_id, to_type, **kwargs)  # noqa: E501
            return data

    def get_relation_using_get_with_http_info(self, from_id, from_type, relation_type, to_id, to_type, **kwargs):  # noqa: E501
        """getRelation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_relation_using_get_with_http_info(from_id, from_type, relation_type, to_id, to_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_id: fromId (required)
        :param str from_type: fromType (required)
        :param str relation_type: relationType (required)
        :param str to_id: toId (required)
        :param str to_type: toType (required)
        :param str relation_type_group: relationTypeGroup
        :return: EntityRelation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['from_id', 'from_type', 'relation_type', 'to_id', 'to_type', 'relation_type_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'from_id' is set
        if ('from_id' not in params or
                params['from_id'] is None):
            raise ValueError("Missing the required parameter `from_id` when calling `get_relation_using_get`")  # noqa: E501
        # verify the required parameter 'from_type' is set
        if ('from_type' not in params or
                params['from_type'] is None):
            raise ValueError("Missing the required parameter `from_type` when calling `get_relation_using_get`")  # noqa: E501
        # verify the required parameter 'relation_type' is set
        if ('relation_type' not in params or
                params['relation_type'] is None):
            raise ValueError("Missing the required parameter `relation_type` when calling `get_relation_using_get`")  # noqa: E501
        # verify the required parameter 'to_id' is set
        if ('to_id' not in params or
                params['to_id'] is None):
            raise ValueError("Missing the required parameter `to_id` when calling `get_relation_using_get`")  # noqa: E501
        # verify the required parameter 'to_type' is set
        if ('to_type' not in params or
                params['to_type'] is None):
            raise ValueError("Missing the required parameter `to_type` when calling `get_relation_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'relation_type_group' in params:
            query_params.append(('relationTypeGroup', params['relation_type_group']))  # noqa: E501
        if 'from_id' in params:
            query_params.append(('fromId', params['from_id']))  # noqa: E501
        if 'from_type' in params:
            query_params.append(('fromType', params['from_type']))  # noqa: E501
        if 'relation_type' in params:
            query_params.append(('relationType', params['relation_type']))  # noqa: E501
        if 'to_id' in params:
            query_params.append(('toId', params['to_id']))  # noqa: E501
        if 'to_type' in params:
            query_params.append(('toType', params['to_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relation{?relationTypeGroup,fromId,fromType,relationType,toId,toType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityRelation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_relation_using_post(self, relation, **kwargs):  # noqa: E501
        """saveRelation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_relation_using_post(relation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityRelation relation: relation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_relation_using_post_with_http_info(relation, **kwargs)  # noqa: E501
        else:
            (data) = self.save_relation_using_post_with_http_info(relation, **kwargs)  # noqa: E501
            return data

    def save_relation_using_post_with_http_info(self, relation, **kwargs):  # noqa: E501
        """saveRelation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_relation_using_post_with_http_info(relation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityRelation relation: relation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'relation' is set
        if ('relation' not in params or
                params['relation'] is None):
            raise ValueError("Missing the required parameter `relation` when calling `save_relation_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'relation' in params:
            body_params = params['relation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/relation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
