# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client32.api_client import ApiClient


class RuleChainControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_rule_chain_using_delete(self, rule_chain_id, **kwargs):  # noqa: E501
        """deleteRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_chain_using_delete(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_rule_chain_using_delete_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_rule_chain_using_delete_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def delete_rule_chain_using_delete_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """deleteRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_chain_using_delete_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `delete_rule_chain_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_rule_chains_using_get(self, limit, **kwargs):  # noqa: E501
        """exportRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_rule_chains_using_get(limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str limit: limit (required)
        :return: RuleChainData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_rule_chains_using_get_with_http_info(limit, **kwargs)  # noqa: E501
        else:
            (data) = self.export_rule_chains_using_get_with_http_info(limit, **kwargs)  # noqa: E501
            return data

    def export_rule_chains_using_get_with_http_info(self, limit, **kwargs):  # noqa: E501
        """exportRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_rule_chains_using_get_with_http_info(limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str limit: limit (required)
        :return: RuleChainData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `export_rule_chains_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChains/export{?limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChainData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_rule_node_debug_input_using_get(self, rule_node_id, **kwargs):  # noqa: E501
        """getLatestRuleNodeDebugInput  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_rule_node_debug_input_using_get(rule_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_node_id: ruleNodeId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_rule_node_debug_input_using_get_with_http_info(rule_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_rule_node_debug_input_using_get_with_http_info(rule_node_id, **kwargs)  # noqa: E501
            return data

    def get_latest_rule_node_debug_input_using_get_with_http_info(self, rule_node_id, **kwargs):  # noqa: E501
        """getLatestRuleNodeDebugInput  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_rule_node_debug_input_using_get_with_http_info(rule_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_node_id: ruleNodeId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_node_id' is set
        if ('rule_node_id' not in params or
                params['rule_node_id'] is None):
            raise ValueError("Missing the required parameter `rule_node_id` when calling `get_latest_rule_node_debug_input_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_node_id' in params:
            path_params['ruleNodeId'] = params['rule_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleNode/{ruleNodeId}/debugIn', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_chain_by_id_using_get(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_by_id_using_get(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_chain_by_id_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_chain_by_id_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def get_rule_chain_by_id_using_get_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_by_id_using_get_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `get_rule_chain_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_chain_meta_data_using_get(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_meta_data_using_get(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_chain_meta_data_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_chain_meta_data_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def get_rule_chain_meta_data_using_get_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_meta_data_using_get_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `get_rule_chain_meta_data_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChainMetaData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_chains_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chains_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataRuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_chains_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_chains_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_rule_chains_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chains_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataRuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_rule_chains_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_rule_chains_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChains{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataRuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_rule_chains_using_post(self, rule_chain_data, **kwargs):  # noqa: E501
        """importRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_rule_chains_using_post(rule_chain_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainData rule_chain_data: ruleChainData (required)
        :param bool overwrite: overwrite
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_rule_chains_using_post_with_http_info(rule_chain_data, **kwargs)  # noqa: E501
        else:
            (data) = self.import_rule_chains_using_post_with_http_info(rule_chain_data, **kwargs)  # noqa: E501
            return data

    def import_rule_chains_using_post_with_http_info(self, rule_chain_data, **kwargs):  # noqa: E501
        """importRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_rule_chains_using_post_with_http_info(rule_chain_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainData rule_chain_data: ruleChainData (required)
        :param bool overwrite: overwrite
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_data', 'overwrite']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_data' is set
        if ('rule_chain_data' not in params or
                params['rule_chain_data'] is None):
            raise ValueError("Missing the required parameter `rule_chain_data` when calling `import_rule_chains_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_chain_data' in params:
            body_params = params['rule_chain_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChains/import{?overwrite}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_rule_chain_meta_data_using_post(self, rule_chain_meta_data, **kwargs):  # noqa: E501
        """saveRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_meta_data_using_post(rule_chain_meta_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainMetaData rule_chain_meta_data: ruleChainMetaData (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_rule_chain_meta_data_using_post_with_http_info(rule_chain_meta_data, **kwargs)  # noqa: E501
        else:
            (data) = self.save_rule_chain_meta_data_using_post_with_http_info(rule_chain_meta_data, **kwargs)  # noqa: E501
            return data

    def save_rule_chain_meta_data_using_post_with_http_info(self, rule_chain_meta_data, **kwargs):  # noqa: E501
        """saveRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_meta_data_using_post_with_http_info(rule_chain_meta_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainMetaData rule_chain_meta_data: ruleChainMetaData (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_meta_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_meta_data' is set
        if ('rule_chain_meta_data' not in params or
                params['rule_chain_meta_data'] is None):
            raise ValueError("Missing the required parameter `rule_chain_meta_data` when calling `save_rule_chain_meta_data_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_chain_meta_data' in params:
            body_params = params['rule_chain_meta_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChainMetaData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_rule_chain_using_post(self, request, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DefaultRuleChainCreateRequest request: request (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_rule_chain_using_post_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.save_rule_chain_using_post_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def save_rule_chain_using_post_with_http_info(self, request, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DefaultRuleChainCreateRequest request: request (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `save_rule_chain_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/device/default', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_rule_chain_using_post1(self, rule_chain, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post1(rule_chain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChain rule_chain: ruleChain (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_rule_chain_using_post1_with_http_info(rule_chain, **kwargs)  # noqa: E501
        else:
            (data) = self.save_rule_chain_using_post1_with_http_info(rule_chain, **kwargs)  # noqa: E501
            return data

    def save_rule_chain_using_post1_with_http_info(self, rule_chain, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post1_with_http_info(rule_chain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChain rule_chain: ruleChain (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain' is set
        if ('rule_chain' not in params or
                params['rule_chain'] is None):
            raise ValueError("Missing the required parameter `rule_chain` when calling `save_rule_chain_using_post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_chain' in params:
            body_params = params['rule_chain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_root_rule_chain_using_post(self, rule_chain_id, **kwargs):  # noqa: E501
        """setRootRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_root_rule_chain_using_post(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_root_rule_chain_using_post_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_root_rule_chain_using_post_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def set_root_rule_chain_using_post_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """setRootRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_root_rule_chain_using_post_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `set_root_rule_chain_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/root', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def test_script_using_post(self, input_params, **kwargs):  # noqa: E501
        """testScript  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_script_using_post(input_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str input_params: inputParams (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.test_script_using_post_with_http_info(input_params, **kwargs)  # noqa: E501
        else:
            (data) = self.test_script_using_post_with_http_info(input_params, **kwargs)  # noqa: E501
            return data

    def test_script_using_post_with_http_info(self, input_params, **kwargs):  # noqa: E501
        """testScript  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_script_using_post_with_http_info(input_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str input_params: inputParams (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_params' is set
        if ('input_params' not in params or
                params['input_params'] is None):
            raise ValueError("Missing the required parameter `input_params` when calling `test_script_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input_params' in params:
            body_params = params['input_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/testScript', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
