# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client32.api_client import ApiClient


class DeviceProfileControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_device_profile_using_delete(self, device_profile_id, **kwargs):  # noqa: E501
        """deleteDeviceProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_profile_using_delete(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_profile_using_delete_with_http_info(device_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_profile_using_delete_with_http_info(device_profile_id, **kwargs)  # noqa: E501
            return data

    def delete_device_profile_using_delete_with_http_info(self, device_profile_id, **kwargs):  # noqa: E501
        """deleteDeviceProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_profile_using_delete_with_http_info(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_profile_id' is set
        if ('device_profile_id' not in params or
                params['device_profile_id'] is None):
            raise ValueError("Missing the required parameter `device_profile_id` when calling `delete_device_profile_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_profile_id' in params:
            path_params['deviceProfileId'] = params['device_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfile/{deviceProfileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_default_device_profile_info_using_get(self, **kwargs):  # noqa: E501
        """getDefaultDeviceProfileInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_device_profile_info_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DeviceProfileInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_default_device_profile_info_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_default_device_profile_info_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_default_device_profile_info_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getDefaultDeviceProfileInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_device_profile_info_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DeviceProfileInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfileInfo/default', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceProfileInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_profile_by_id_using_get(self, device_profile_id, **kwargs):  # noqa: E501
        """getDeviceProfileById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profile_by_id_using_get(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: DeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_profile_by_id_using_get_with_http_info(device_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_profile_by_id_using_get_with_http_info(device_profile_id, **kwargs)  # noqa: E501
            return data

    def get_device_profile_by_id_using_get_with_http_info(self, device_profile_id, **kwargs):  # noqa: E501
        """getDeviceProfileById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profile_by_id_using_get_with_http_info(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: DeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_profile_id' is set
        if ('device_profile_id' not in params or
                params['device_profile_id'] is None):
            raise ValueError("Missing the required parameter `device_profile_id` when calling `get_device_profile_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_profile_id' in params:
            path_params['deviceProfileId'] = params['device_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfile/{deviceProfileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_profile_info_by_id_using_get(self, device_profile_id, **kwargs):  # noqa: E501
        """getDeviceProfileInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profile_info_by_id_using_get(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: DeviceProfileInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_profile_info_by_id_using_get_with_http_info(device_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_profile_info_by_id_using_get_with_http_info(device_profile_id, **kwargs)  # noqa: E501
            return data

    def get_device_profile_info_by_id_using_get_with_http_info(self, device_profile_id, **kwargs):  # noqa: E501
        """getDeviceProfileInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profile_info_by_id_using_get_with_http_info(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: DeviceProfileInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_profile_id' is set
        if ('device_profile_id' not in params or
                params['device_profile_id'] is None):
            raise ValueError("Missing the required parameter `device_profile_id` when calling `get_device_profile_info_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_profile_id' in params:
            path_params['deviceProfileId'] = params['device_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfileInfo/{deviceProfileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceProfileInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_profile_infos_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getDeviceProfileInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profile_infos_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :param str transport_type: transportType
        :return: PageDataDeviceProfileInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_profile_infos_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_profile_infos_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_device_profile_infos_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getDeviceProfileInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profile_infos_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :param str transport_type: transportType
        :return: PageDataDeviceProfileInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order', 'transport_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_device_profile_infos_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_device_profile_infos_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'transport_type' in params:
            query_params.append(('transportType', params['transport_type']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfileInfos{?textSearch,sortProperty,sortOrder,transportType,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataDeviceProfileInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_profiles_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getDeviceProfiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profiles_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_profiles_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_profiles_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_device_profiles_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getDeviceProfiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_profiles_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_device_profiles_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_device_profiles_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfiles{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataDeviceProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_device_profile_using_post(self, device_profile, **kwargs):  # noqa: E501
        """saveDeviceProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_device_profile_using_post(device_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceProfile device_profile: deviceProfile (required)
        :return: DeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_device_profile_using_post_with_http_info(device_profile, **kwargs)  # noqa: E501
        else:
            (data) = self.save_device_profile_using_post_with_http_info(device_profile, **kwargs)  # noqa: E501
            return data

    def save_device_profile_using_post_with_http_info(self, device_profile, **kwargs):  # noqa: E501
        """saveDeviceProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_device_profile_using_post_with_http_info(device_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceProfile device_profile: deviceProfile (required)
        :return: DeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_profile']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_profile' is set
        if ('device_profile' not in params or
                params['device_profile'] is None):
            raise ValueError("Missing the required parameter `device_profile` when calling `save_device_profile_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'device_profile' in params:
            body_params = params['device_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfile', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_default_device_profile_using_post(self, device_profile_id, **kwargs):  # noqa: E501
        """setDefaultDeviceProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_default_device_profile_using_post(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: DeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_default_device_profile_using_post_with_http_info(device_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_default_device_profile_using_post_with_http_info(device_profile_id, **kwargs)  # noqa: E501
            return data

    def set_default_device_profile_using_post_with_http_info(self, device_profile_id, **kwargs):  # noqa: E501
        """setDefaultDeviceProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_default_device_profile_using_post_with_http_info(device_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :return: DeviceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):

            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_profile_id' is set
        if ('device_profile_id' not in params or
                params['device_profile_id'] is None):
            raise ValueError("Missing the required parameter `device_profile_id` when calling `set_default_device_profile_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_profile_id' in params:
            path_params['deviceProfileId'] = params['device_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceProfile/{deviceProfileId}/default', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
