# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#
#

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client32.api_client import ApiClient


class AdminControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.    
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def check_updates_using_get(self, **kwargs):  # noqa: E501
        """checkUpdates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.check_updates_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: UpdateMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.check_updates_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.check_updates_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def check_updates_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """checkUpdates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.check_updates_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: UpdateMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/updates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_admin_settings_using_get(self, key, **kwargs):  # noqa: E501
        """getAdminSettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_admin_settings_using_get(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: key (required)
        :return: AdminSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_admin_settings_using_get_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_admin_settings_using_get_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def get_admin_settings_using_get_with_http_info(self, key, **kwargs):  # noqa: E501
        """getAdminSettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_admin_settings_using_get_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: key (required)
        :return: AdminSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_admin_settings_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/settings/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_settings_using_get(self, **kwargs):  # noqa: E501
        """getSecuritySettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_security_settings_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SecuritySettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_settings_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_security_settings_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_security_settings_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getSecuritySettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_security_settings_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SecuritySettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/securitySettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecuritySettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_admin_settings_using_post(self, admin_settings, **kwargs):  # noqa: E501
        """saveAdminSettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_admin_settings_using_post(admin_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminSettings admin_settings: adminSettings (required)
        :return: AdminSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_admin_settings_using_post_with_http_info(admin_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.save_admin_settings_using_post_with_http_info(admin_settings, **kwargs)  # noqa: E501
            return data

    def save_admin_settings_using_post_with_http_info(self, admin_settings, **kwargs):  # noqa: E501
        """saveAdminSettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_admin_settings_using_post_with_http_info(admin_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminSettings admin_settings: adminSettings (required)
        :return: AdminSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['admin_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_settings' is set
        if ('admin_settings' not in params or
                params['admin_settings'] is None):
            raise ValueError("Missing the required parameter `admin_settings` when calling `save_admin_settings_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'admin_settings' in params:
            body_params = params['admin_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_security_settings_using_post(self, security_settings, **kwargs):  # noqa: E501
        """saveSecuritySettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_security_settings_using_post(security_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecuritySettings security_settings: securitySettings (required)
        :return: SecuritySettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_security_settings_using_post_with_http_info(security_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.save_security_settings_using_post_with_http_info(security_settings, **kwargs)  # noqa: E501
            return data

    def save_security_settings_using_post_with_http_info(self, security_settings, **kwargs):  # noqa: E501
        """saveSecuritySettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_security_settings_using_post_with_http_info(security_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecuritySettings security_settings: securitySettings (required)
        :return: SecuritySettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_settings' is set
        if ('security_settings' not in params or
                params['security_settings'] is None):
            raise ValueError("Missing the required parameter `security_settings` when calling `save_security_settings_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'security_settings' in params:
            body_params = params['security_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/securitySettings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecuritySettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_test_mail_using_post(self, admin_settings, **kwargs):  # noqa: E501
        """sendTestMail  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.send_test_mail_using_post(admin_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminSettings admin_settings: adminSettings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_test_mail_using_post_with_http_info(admin_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.send_test_mail_using_post_with_http_info(admin_settings, **kwargs)  # noqa: E501
            return data

    def send_test_mail_using_post_with_http_info(self, admin_settings, **kwargs):  # noqa: E501
        """sendTestMail  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.send_test_mail_using_post_with_http_info(admin_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminSettings admin_settings: adminSettings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['admin_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_settings' is set
        if ('admin_settings' not in params or
                params['admin_settings'] is None):
            raise ValueError(
                "Missing the required parameter `admin_settings` when calling `send_test_mail_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'admin_settings' in params:
            body_params = params['admin_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/settings/testMail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
    
    def send_test_sms_using_post(self, message, number_to, provider_configuration, **kwargs):  # noqa: E501
        """sendTestSms  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.send_test_sms_using_post(admin_settings, async_req=True)
        >>> result = thread.get()

        :param message str
        :param number_to str
        :param provider_configuration str 
        :param async_req bool
        :param AdminSettings admin_settings: adminSettings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_test_sms_using_post_with_http_info(message, number_to, provider_configuration, **kwargs)  # noqa: E501
        else:
            (data) = self.send_test_sms_using_post_with_http_info(message, number_to, provider_configuration, **kwargs)  # noqa: E501
            return data

    def send_test_sms_using_post_with_http_info(self, message, number_to, provider_configuration, **kwargs):  # noqa: E501
        """sendTestSms  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_ce.send_test_sms_using_post_with_http_info(message, number_to, provider_configuration, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message', 'number_to', 'provider_configuration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_settings' is set
        if ('message' not in params or
                params['message'] is None):
            raise ValueError("Missing the required parameter `message` when calling `send_test_sms_using_post`")  # noqa: E501
        if ('number_to' not in params or
                params['number_to'] is None):
            raise ValueError("Missing the required parameter `number_to` when calling `send_test_sms_using_post`")  # noqa: E501
        if ('provider_configuration' not in params or
                params['provider_configuration'] is None):
            raise ValueError("Missing the required parameter `provider_configuration` when calling `send_test_sms_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'message' in params:
            body_params = params['message']
        if 'number_to' in params:
            body_params = params['number_to']
        if 'provider_configuration' in params:
            body_params = params['provider_configuration']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/admin/settings/testSms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
