"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Channel = exports.ChannelType = exports.LatencyMode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
const stream_key_1 = require("./stream-key");
/**
 * Reference to a new or existing IVS Channel
 */
class ChannelBase extends core.Resource {
    addStreamKey(id) {
        return new stream_key_1.StreamKey(this, id, {
            channel: this,
        });
    }
}
/**
  Channel latency mode
*/
var LatencyMode;
(function (LatencyMode) {
    /**
     * Use LOW to minimize broadcaster-to-viewer latency for interactive broadcasts.
     */
    LatencyMode["LOW"] = "LOW";
    /**
     * Use NORMAL for broadcasts that do not require viewer interaction.
     */
    LatencyMode["NORMAL"] = "NORMAL";
})(LatencyMode = exports.LatencyMode || (exports.LatencyMode = {}));
/**
  * The channel type, which determines the allowable resolution and bitrate.
  * If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
*/
var ChannelType;
(function (ChannelType) {
    /**
     * Multiple qualities are generated from the original input, to automatically give viewers the best experience for
     * their devices and network conditions.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html
     */
    ChannelType["STANDARD"] = "STANDARD";
    /**
     * delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html
     */
    ChannelType["BASIC"] = "BASIC";
})(ChannelType = exports.ChannelType || (exports.ChannelType = {}));
/**
  A new IVS channel
*/
class Channel extends ChannelBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.name,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_ChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Channel);
            }
            throw error;
        }
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnChannel(this, 'Resource', {
            authorized: props.authorized,
            latencyMode: props.latencyMode,
            name: props.name,
            type: props.type,
        });
        this.channelArn = resource.attrArn;
        this.channelIngestEndpoint = resource.attrIngestEndpoint;
        this.channelPlaybackUrl = resource.attrPlaybackUrl;
    }
    /**
     * Import an existing channel
     */
    static fromChannelArn(scope, id, channelArn) {
        // This will throw an error if the arn cannot be parsed
        let arnComponents = core.Arn.split(channelArn, core.ArnFormat.SLASH_RESOURCE_NAME);
        if (!core.Token.isUnresolved(arnComponents.service) && arnComponents.service !== 'ivs') {
            throw new Error(`Invalid service, expected 'ivs', got '${arnComponents.service}'`);
        }
        if (!core.Token.isUnresolved(arnComponents.resource) && arnComponents.resource !== 'channel') {
            throw new Error(`Invalid resource, expected 'channel', got '${arnComponents.resource}'`);
        }
        class Import extends ChannelBase {
            constructor() {
                super(...arguments);
                this.channelArn = channelArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Channel = Channel;
_a = JSII_RTTI_SYMBOL_1;
Channel[_a] = { fqn: "@aws-cdk/aws-ivs.Channel", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hhbm5lbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNoYW5uZWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsc0NBQXNDO0FBRXRDLG1EQUE2QztBQUM3Qyw2Q0FBeUM7QUFvQnpDOztHQUVHO0FBQ0gsTUFBZSxXQUFZLFNBQVEsSUFBSSxDQUFDLFFBQVE7SUFHdkMsWUFBWSxDQUFDLEVBQVU7UUFDNUIsT0FBTyxJQUFJLHNCQUFTLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUM3QixPQUFPLEVBQUUsSUFBSTtTQUNkLENBQUMsQ0FBQztLQUNKO0NBQ0Y7QUFFRDs7RUFFRTtBQUNGLElBQVksV0FVWDtBQVZELFdBQVksV0FBVztJQUNyQjs7T0FFRztJQUNILDBCQUFXLENBQUE7SUFFWDs7T0FFRztJQUNILGdDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFWVyxXQUFXLEdBQVgsbUJBQVcsS0FBWCxtQkFBVyxRQVV0QjtBQUVEOzs7RUFHRTtBQUNGLElBQVksV0FlWDtBQWZELFdBQVksV0FBVztJQUNyQjs7Ozs7T0FLRztJQUNILG9DQUFxQixDQUFBO0lBRXJCOzs7O09BSUc7SUFDSCw4QkFBZSxDQUFBO0FBQ2pCLENBQUMsRUFmVyxXQUFXLEdBQVgsbUJBQVcsS0FBWCxtQkFBVyxRQWV0QjtBQXdDRDs7RUFFRTtBQUNGLE1BQWEsT0FBUSxTQUFRLFdBQVc7SUF1Q3RDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBc0IsRUFBRTtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxLQUFLLENBQUMsSUFBSTtTQUN6QixDQUFDLENBQUM7Ozs7OzsrQ0ExQ00sT0FBTzs7OztRQTRDaEIsSUFBSSxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUM5RixNQUFNLElBQUksS0FBSyxDQUFDLDJFQUEyRSxLQUFLLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQztTQUMzRztRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksMEJBQVUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2hELFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtTQUNqQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsVUFBVSxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUM7UUFDbkMsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQztRQUN6RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsUUFBUSxDQUFDLGVBQWUsQ0FBQztLQUNwRDtJQXpERDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxjQUFjLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsVUFBa0I7UUFDM0UsdURBQXVEO1FBQ3ZELElBQUksYUFBYSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixDQUFDLENBQUM7UUFFbkYsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsSUFBSSxhQUFhLENBQUMsT0FBTyxLQUFLLEtBQUssRUFBRTtZQUN0RixNQUFNLElBQUksS0FBSyxDQUFDLHlDQUF5QyxhQUFhLENBQUMsT0FBTyxHQUFHLENBQUMsQ0FBQztTQUNwRjtRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsUUFBUSxDQUFDLElBQUksYUFBYSxDQUFDLFFBQVEsS0FBSyxTQUFTLEVBQUU7WUFDNUYsTUFBTSxJQUFJLEtBQUssQ0FBQyw4Q0FBOEMsYUFBYSxDQUFDLFFBQVEsR0FBRyxDQUFDLENBQUM7U0FDMUY7UUFFRCxNQUFNLE1BQU8sU0FBUSxXQUFXO1lBQWhDOztnQkFDa0IsZUFBVSxHQUFHLFVBQVUsQ0FBQztZQUMxQyxDQUFDO1NBQUE7UUFFRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5Qjs7QUFyQkgsMEJBMkRDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY29yZSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuQ2hhbm5lbCB9IGZyb20gJy4vaXZzLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBTdHJlYW1LZXkgfSBmcm9tICcuL3N0cmVhbS1rZXknO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gSVZTIENoYW5uZWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQ2hhbm5lbCBleHRlbmRzIGNvcmUuSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBjaGFubmVsIEFSTi4gRm9yIGV4YW1wbGU6IGFybjphd3M6aXZzOnVzLXdlc3QtMjoxMjM0NTY3ODkwMTI6Y2hhbm5lbC9hYmNkQUJDRGVmZ2hcbiAgICpcbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgY2hhbm5lbEFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgc3RyZWFtIGtleSBmb3IgdGhpcyBJVlMgQ2hhbm5lbC5cbiAgICogQHBhcmFtIGlkIGNvbnN0cnVjdCBJRFxuICAgKi9cbiAgYWRkU3RyZWFtS2V5KGlkOiBzdHJpbmcpOiBTdHJlYW1LZXk7XG59XG5cbi8qKlxuICogUmVmZXJlbmNlIHRvIGEgbmV3IG9yIGV4aXN0aW5nIElWUyBDaGFubmVsXG4gKi9cbmFic3RyYWN0IGNsYXNzIENoYW5uZWxCYXNlIGV4dGVuZHMgY29yZS5SZXNvdXJjZSBpbXBsZW1lbnRzIElDaGFubmVsIHtcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGNoYW5uZWxBcm46IHN0cmluZztcblxuICBwdWJsaWMgYWRkU3RyZWFtS2V5KGlkOiBzdHJpbmcpOiBTdHJlYW1LZXkge1xuICAgIHJldHVybiBuZXcgU3RyZWFtS2V5KHRoaXMsIGlkLCB7XG4gICAgICBjaGFubmVsOiB0aGlzLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICBDaGFubmVsIGxhdGVuY3kgbW9kZVxuKi9cbmV4cG9ydCBlbnVtIExhdGVuY3lNb2RlIHtcbiAgLyoqXG4gICAqIFVzZSBMT1cgdG8gbWluaW1pemUgYnJvYWRjYXN0ZXItdG8tdmlld2VyIGxhdGVuY3kgZm9yIGludGVyYWN0aXZlIGJyb2FkY2FzdHMuXG4gICAqL1xuICBMT1cgPSAnTE9XJyxcblxuICAvKipcbiAgICogVXNlIE5PUk1BTCBmb3IgYnJvYWRjYXN0cyB0aGF0IGRvIG5vdCByZXF1aXJlIHZpZXdlciBpbnRlcmFjdGlvbi5cbiAgICovXG4gIE5PUk1BTCA9ICdOT1JNQUwnLFxufVxuXG4vKipcbiAgKiBUaGUgY2hhbm5lbCB0eXBlLCB3aGljaCBkZXRlcm1pbmVzIHRoZSBhbGxvd2FibGUgcmVzb2x1dGlvbiBhbmQgYml0cmF0ZS5cbiAgKiBJZiB5b3UgZXhjZWVkIHRoZSBhbGxvd2FibGUgcmVzb2x1dGlvbiBvciBiaXRyYXRlLCB0aGUgc3RyZWFtIHByb2JhYmx5IHdpbGwgZGlzY29ubmVjdCBpbW1lZGlhdGVseS5cbiovXG5leHBvcnQgZW51bSBDaGFubmVsVHlwZSB7XG4gIC8qKlxuICAgKiBNdWx0aXBsZSBxdWFsaXRpZXMgYXJlIGdlbmVyYXRlZCBmcm9tIHRoZSBvcmlnaW5hbCBpbnB1dCwgdG8gYXV0b21hdGljYWxseSBnaXZlIHZpZXdlcnMgdGhlIGJlc3QgZXhwZXJpZW5jZSBmb3JcbiAgICogdGhlaXIgZGV2aWNlcyBhbmQgbmV0d29yayBjb25kaXRpb25zLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1pdnMtY2hhbm5lbC5odG1sXG4gICAqL1xuICBTVEFOREFSRCA9ICdTVEFOREFSRCcsXG5cbiAgLyoqXG4gICAqIGRlbGl2ZXJzIHRoZSBvcmlnaW5hbCBpbnB1dCB0byB2aWV3ZXJzLiBUaGUgdmlld2Vy4oCZcyB2aWRlby1xdWFsaXR5IGNob2ljZSBpcyBsaW1pdGVkIHRvIHRoZSBvcmlnaW5hbCBpbnB1dC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtaXZzLWNoYW5uZWwuaHRtbFxuICAgKi9cbiAgQkFTSUMgPSAnQkFTSUMnLFxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGNyZWF0aW5nIGEgbmV3IENoYW5uZWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDaGFubmVsUHJvcHMge1xuICAvKipcbiAgICogV2hldGhlciB0aGUgY2hhbm5lbCBpcyBhdXRob3JpemVkLlxuICAgKlxuICAgKiBJZiB5b3Ugd2lzaCB0byBtYWtlIGFuIGF1dGhvcml6ZWQgY2hhbm5lbCwgeW91IHdpbGwgbmVlZCB0byBlbnN1cmUgdGhhdFxuICAgKiBhIFBsYXliYWNrS2V5UGFpciBoYXMgYmVlbiB1cGxvYWRlZCB0byB5b3VyIGFjY291bnQgYXMgdGhpcyBpcyB1c2VkIHRvXG4gICAqIHZhbGlkYXRlIHRoZSBzaWduZWQgSldUIHRoYXQgaXMgcmVxdWlyZWQgZm9yIGF1dGhvcml6YXRpb25cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGF1dGhvcml6ZWQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBDaGFubmVsIGxhdGVuY3kgbW9kZS5cbiAgICpcbiAgICogQGRlZmF1bHQgTGF0ZW5jeU1vZGUuTE9XXG4gICAqL1xuICByZWFkb25seSBsYXRlbmN5TW9kZT86IExhdGVuY3lNb2RlO1xuXG4gIC8qKlxuICAgKiBDaGFubmVsIG5hbWUuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGNoYW5uZWwgdHlwZSwgd2hpY2ggZGV0ZXJtaW5lcyB0aGUgYWxsb3dhYmxlIHJlc29sdXRpb24gYW5kIGJpdHJhdGUuXG4gICAqIElmIHlvdSBleGNlZWQgdGhlIGFsbG93YWJsZSByZXNvbHV0aW9uIG9yIGJpdHJhdGUsIHRoZSBzdHJlYW0gd2lsbCBkaXNjb25uZWN0IGltbWVkaWF0ZWx5XG4gICAqXG4gICAqIEBkZWZhdWx0IENoYW5uZWxUeXBlLlNUQU5EQVJEXG4gICAqL1xuICByZWFkb25seSB0eXBlPzogQ2hhbm5lbFR5cGU7XG59XG5cbi8qKlxuICBBIG5ldyBJVlMgY2hhbm5lbFxuKi9cbmV4cG9ydCBjbGFzcyBDaGFubmVsIGV4dGVuZHMgQ2hhbm5lbEJhc2Uge1xuICAvKipcbiAgICogSW1wb3J0IGFuIGV4aXN0aW5nIGNoYW5uZWxcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUNoYW5uZWxBcm4oc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY2hhbm5lbEFybjogc3RyaW5nKTogSUNoYW5uZWwge1xuICAgIC8vIFRoaXMgd2lsbCB0aHJvdyBhbiBlcnJvciBpZiB0aGUgYXJuIGNhbm5vdCBiZSBwYXJzZWRcbiAgICBsZXQgYXJuQ29tcG9uZW50cyA9IGNvcmUuQXJuLnNwbGl0KGNoYW5uZWxBcm4sIGNvcmUuQXJuRm9ybWF0LlNMQVNIX1JFU09VUkNFX05BTUUpO1xuXG4gICAgaWYgKCFjb3JlLlRva2VuLmlzVW5yZXNvbHZlZChhcm5Db21wb25lbnRzLnNlcnZpY2UpICYmIGFybkNvbXBvbmVudHMuc2VydmljZSAhPT0gJ2l2cycpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgSW52YWxpZCBzZXJ2aWNlLCBleHBlY3RlZCAnaXZzJywgZ290ICcke2FybkNvbXBvbmVudHMuc2VydmljZX0nYCk7XG4gICAgfVxuXG4gICAgaWYgKCFjb3JlLlRva2VuLmlzVW5yZXNvbHZlZChhcm5Db21wb25lbnRzLnJlc291cmNlKSAmJiBhcm5Db21wb25lbnRzLnJlc291cmNlICE9PSAnY2hhbm5lbCcpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgSW52YWxpZCByZXNvdXJjZSwgZXhwZWN0ZWQgJ2NoYW5uZWwnLCBnb3QgJyR7YXJuQ29tcG9uZW50cy5yZXNvdXJjZX0nYCk7XG4gICAgfVxuXG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgQ2hhbm5lbEJhc2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGNoYW5uZWxBcm4gPSBjaGFubmVsQXJuO1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCk7XG4gIH1cblxuICBwdWJsaWMgcmVhZG9ubHkgY2hhbm5lbEFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAqIENoYW5uZWwgaW5nZXN0IGVuZHBvaW50LCBwYXJ0IG9mIHRoZSBkZWZpbml0aW9uIG9mIGFuIGluZ2VzdCBzZXJ2ZXIsIHVzZWQgd2hlbiB5b3Ugc2V0IHVwIHN0cmVhbWluZyBzb2Z0d2FyZS5cbiAgKiBGb3IgZXhhbXBsZTogYTFiMmMzZDRlNWY2Lmdsb2JhbC1jb250cmlidXRlLmxpdmUtdmlkZW8ubmV0XG4gICogQGF0dHJpYnV0ZVxuICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY2hhbm5lbEluZ2VzdEVuZHBvaW50OiBzdHJpbmc7XG5cbiAgLyoqXG4gICogQ2hhbm5lbCBwbGF5YmFjayBVUkwuIEZvciBleGFtcGxlOlxuICAqIGh0dHBzOi8vYTFiMmMzZDRlNWY2LnVzLXdlc3QtMi5wbGF5YmFjay5saXZlLXZpZGVvLm5ldC9hcGkvdmlkZW8vdjEvdXMtd2VzdC0yLjEyMzQ1Njc4OTAxMi5jaGFubmVsLmFiY2RFRkdILm0zdThcbiAgKiBAYXR0cmlidXRlXG4gICovXG4gIHB1YmxpYyByZWFkb25seSBjaGFubmVsUGxheWJhY2tVcmw6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2hhbm5lbFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBoeXNpY2FsTmFtZTogcHJvcHMubmFtZSxcbiAgICB9KTtcblxuICAgIGlmIChwcm9wcy5uYW1lICYmICFjb3JlLlRva2VuLmlzVW5yZXNvbHZlZChwcm9wcy5uYW1lKSAmJiAhL15bYS16QS1aMC05LV9dKiQvLnRlc3QocHJvcHMubmFtZSkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgbmFtZSBtdXN0IGNvbnRhaW4gb25seSBudW1iZXJzLCBsZXR0ZXJzLCBoeXBoZW5zIGFuZCB1bmRlcnNjb3JlcywgZ290OiAnJHtwcm9wcy5uYW1lfSdgKTtcbiAgICB9XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5DaGFubmVsKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGF1dGhvcml6ZWQ6IHByb3BzLmF1dGhvcml6ZWQsXG4gICAgICBsYXRlbmN5TW9kZTogcHJvcHMubGF0ZW5jeU1vZGUsXG4gICAgICBuYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgdHlwZTogcHJvcHMudHlwZSxcbiAgICB9KTtcblxuICAgIHRoaXMuY2hhbm5lbEFybiA9IHJlc291cmNlLmF0dHJBcm47XG4gICAgdGhpcy5jaGFubmVsSW5nZXN0RW5kcG9pbnQgPSByZXNvdXJjZS5hdHRySW5nZXN0RW5kcG9pbnQ7XG4gICAgdGhpcy5jaGFubmVsUGxheWJhY2tVcmwgPSByZXNvdXJjZS5hdHRyUGxheWJhY2tVcmw7XG4gIH1cbn1cbiJdfQ==