"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptedBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kms = require("aws-cdk-lib/aws-kms");
const s3 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * A CDK construct for encrypted S3 Buckets
 */
class EncryptedBucket extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.key = new kms.Key(this, 'Key');
        this.bucket = new s3.Bucket(this, 'Bucket', {
            accessControl: s3.BucketAccessControl.PRIVATE,
            bucketKeyEnabled: true,
            encryption: s3.BucketEncryption.KMS,
            encryptionKey: this.key,
            versioned: !!(props === null || props === void 0 ? void 0 : props.versioned),
        });
    }
}
exports.EncryptedBucket = EncryptedBucket;
_a = JSII_RTTI_SYMBOL_1;
EncryptedBucket[_a] = { fqn: "encrypted-bucket.EncryptedBucket", version: "0.0.9" };
//# sourceMappingURL=data:application/json;base64,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