import * as kms from 'aws-cdk-lib/aws-kms';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export interface EncryptedBucketProps {
    /**
     * Use S3 Versioning for bucket
     *
     * @default false
     */
    readonly versioned?: boolean;
}
/**
 * A CDK construct for encrypted S3 Buckets
 */
export declare class EncryptedBucket extends Construct {
    bucket: s3.IBucket;
    key: kms.IKey;
    constructor(scope: Construct, id: string, props?: EncryptedBucketProps);
}
