'use strict';

angular.module('ajenti.session_list', ['core']);


'use strict';

angular.module('ajenti.session_list').config(function ($routeProvider) {
    $routeProvider.when('/view/session_list', {
        templateUrl: '/session_list:resources/partial/index.html',
        controller: 'SessionListIndexController'
    });
});


// Generated by CoffeeScript 1.7.1
(function() {
  angular.module('ajenti.session_list').controller('SessionListIndexController', function($scope, $http, $interval, $timeout, notify, pageTitle, messagebox, gettext, config) {
    pageTitle.set(gettext('List all sessions'));
    $scope.getList = function() {
      return $http.get('/api/session_list/list').then(function(resp) {
        var session, _i, _len, _ref;
        $scope.sessions = resp.data;
        _ref = $scope.sessions;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          session = _ref[_i];
          session.date = new Date(session.timestamp);
        }
        $scope.number = Object.keys($scope.sessions).length;
        return $scope.session_max_time = config.data.session_max_time;
      });
    };
    $scope.getList();
    $scope.refresh = $interval($scope.getList, 15000, 0);
    return $scope.$on('$destroy', function() {
      return $interval.cancel($scope.refresh);
    });
  });

}).call(this);

'use strict';

angular.module('ajenti.session_list').controller('SessionWidgetController', function ($scope, $http, config) {
    return $scope.$on('widget-update', function ($event, id, data) {
        if (id !== $scope.widget.id) {
            return;
        }

        if (data) {
            $http.get('/api/session_list/list').then(function (resp) {
                $scope.sessions = resp.data;
                for (var session in $scope.sessions) {
                    session.date = new Date(session.timestamp);
                }$scope.number = Object.keys($scope.sessions).length;
            });
        }
    });
});


