"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const index_1 = require("./index");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const mockApp = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(mockApp, 'testing-stack', { env });
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'defaultVpc', {
    isDefault: true,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: stack.node.tryGetContext('GITLAB_TOKEN') ?? 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    spotFleet: true,
    dockerVolumes: [
        {
            hostPath: '/tmp/cahce',
            containerPath: '/tmp/cahce',
        },
    ],
});
//runner.expireAfter(Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new aws_cdk_lib_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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