# zencache

Pure memory cache powered by orpc.

## Install

```
pip install zencache
```

## Example server config: zencached-config.yml

```
daemon: true
pidfile: zencached.pid
loglevel: INFO
logfile: zencached.log
server:
  listen: 0.0.0.0
  port: 6779
  backlog: 8192
  buffer_size: 65536
  rfile_buffer_size: 65536
  wfile_buffer_size: 65536
  max_request_size: 4194304
authentication:
  enable: true
  users:
    app01: spnPF3HzY975GJYC
    app02: ZWRVfHrK8QkQoOnQ
    app03: xuFTlTy9i6KCfncp
```

## Example client usage

```
from orpc_client import OrpcConnectionPool

zencached_client_pool = OrpcConnectionPool(10, kwargs={
    "host": "127.0.0.1",
    "port": 6779,
    "username": "app01",
    "password": "spnPF3HzY975GJYC",
    "login_event": "zencache.login",
    "auto_login": True,
    })

with zencached_client_pool.get_session() as session:
    session.zencache.set('a', 'a')
    assert session.zencache.get('a') == 'a'
```

## Releases

### v0.1.0

- First release.
