# Generated by Django 4.0.3 on 2022-07-17 01:03

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_id', models.CharField(max_length=255, verbose_name='API ID')),
                ('api_hash', models.CharField(max_length=255, verbose_name='API Hash')),
            ],
            options={
                'verbose_name': 'App',
                'verbose_name_plural': 'Apps',
            },
        ),
        migrations.CreateModel(
            name='ClientSession',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Client Session Name')),
                (
                    'login_status',
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, 'Login Required'),
                            (2, 'Login Done'),
                            (3, 'Login Failed'),
                            (4, 'Login Waiting For Telegram Client'),
                        ],
                        default=1,
                        verbose_name='Login Required',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Client Session',
                'verbose_name_plural': 'Client Sessions',
            },
        ),
        migrations.CreateModel(
            name='UpdateState',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pts', models.IntegerField(verbose_name='pts')),
                ('qts', models.IntegerField(verbose_name='qts')),
                ('date', models.DateTimeField(verbose_name='date')),
                ('seq', models.IntegerField(verbose_name='seq')),
                (
                    'client_session',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='django_telethon.clientsession',
                        verbose_name='Client Session',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Update state',
                'verbose_name_plural': 'Update states',
            },
        ),
        migrations.CreateModel(
            name='Login',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('have_to_send_code', models.BooleanField(default=True, verbose_name='Have to send code')),
                ('bot_token', models.CharField(blank=True, max_length=255, null=True, verbose_name='Bot token')),
                ('phone_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Phone number')),
                ('code', models.CharField(blank=True, max_length=10, null=True, verbose_name='Code')),
                ('passcode', models.CharField(blank=True, max_length=100, null=True, verbose_name='Passcode')),
                ('hash_code', models.CharField(blank=True, max_length=100, null=True, verbose_name='Hash code')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                (
                    'client_session',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='django_telethon.clientsession',
                        verbose_name='Client session',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Login',
                'verbose_name_plural': 'Logins',
            },
        ),
        migrations.CreateModel(
            name='Entity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hash_value', models.BigIntegerField(verbose_name='Hash Value')),
                ('username', models.CharField(blank=True, max_length=255, null=True, verbose_name='Username')),
                ('phone', models.CharField(blank=True, max_length=15, null=True, verbose_name='Phone')),
                ('name', models.CharField(blank=True, max_length=50, null=True, verbose_name='Name')),
                ('date', models.DateTimeField(auto_now_add=True, verbose_name='Date')),
                (
                    'client_session',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to='django_telethon.clientsession',
                        verbose_name='Client Session',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Entity',
                'verbose_name_plural': 'Entities',
            },
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                (
                    'client_session',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to='django_telethon.clientsession',
                        verbose_name='Client Session',
                    ),
                ),
                ('auth_key', models.BinaryField(editable=True, verbose_name='Auth Key')),
                ('data_center_id', models.IntegerField(db_index=True, verbose_name='Data Center ID')),
                ('port', models.IntegerField(verbose_name='Port')),
                ('server_address', models.CharField(max_length=255, verbose_name='Server Address')),
                ('takeout_id', models.BigIntegerField(null=True, verbose_name='Takeout ID')),
            ],
            options={
                'verbose_name': 'Session',
                'verbose_name_plural': 'Sessions',
                'unique_together': {('client_session_id', 'data_center_id')},
            },
        ),
        migrations.CreateModel(
            name='SentFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('md5_digest', models.BinaryField(verbose_name='MD5 digest')),
                ('file_size', models.IntegerField(verbose_name='File size')),
                ('file_type', models.IntegerField(choices=[(0, 'Document'), (1, 'Photo')], verbose_name='Type')),
                ('hash_value', models.BigIntegerField(verbose_name='Hash value')),
                ('file_id', models.IntegerField(verbose_name='File ID')),
                (
                    'client_session',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='django_telethon.clientsession',
                        verbose_name='Client Session',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Sent file',
                'verbose_name_plural': 'Sent files',
                'unique_together': {('client_session', 'md5_digest', 'file_size', 'file_type')},
            },
        ),
    ]
