"""Broadworks OCI-P Interface Type Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-19T17:35:53.953786
# fmt: off
from typing import List

from classforge import Field

from .base import ElementInfo as E
from .base import OCIType


class AccessDevice(OCIType):
    """
    Uniquely identifies an Identity/device profile created anywhere in the system.


    Attributes:
        device_level: deviceLevel
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_level", "deviceLevel", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    device_level: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class AccessDeviceKey(OCIType):
    """
    Key to uniquely identify a system, service provider, or group device.


    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str),
        E("group_id", "groupId", str),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=False, mutable=False)
    group_id: str = Field(type=str, required=False, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class AccountAuthorizationCodeEntry(OCIType):
    """
    Account/Authorization Code.


    Attributes:
        code: code
        description: description
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class AgentStatistics(OCIType):
    """
    Contains Call Center Agent statistics for a given time frame.


    Attributes:
        number_of_calls_handled: numberOfCallsHandled
        number_of_calls_unanswered: numberOfCallsUnanswered
        average_call_seconds: averageCallSeconds
        total_talk_seconds: totalTalkSeconds
        total_staffed_seconds: totalStaffedSeconds
    """

    _ELEMENTS = (
        E("number_of_calls_handled", "numberOfCallsHandled", int, is_required=True),
        E("number_of_calls_unanswered", "numberOfCallsUnanswered", int, is_required=True),
        E("average_call_seconds", "averageCallSeconds", int, is_required=True),
        E("total_talk_seconds", "totalTalkSeconds", int, is_required=True),
        E("total_staffed_seconds", "totalStaffedSeconds", int, is_required=True),
    )

    number_of_calls_handled: int = Field(type=int, required=True, mutable=False)
    number_of_calls_unanswered: int = Field(type=int, required=True, mutable=False)
    average_call_seconds: int = Field(type=int, required=True, mutable=False)
    total_talk_seconds: int = Field(type=int, required=True, mutable=False)
    total_staffed_seconds: int = Field(type=int, required=True, mutable=False)


class AlternateNumberEntry(OCIType):
    """
    Alternate Number Entry.


    Attributes:
        phone_number: phoneNumber
        extension: extension
        ring_pattern: ringPattern
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("ring_pattern", "ringPattern", str),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    ring_pattern: str = Field(type=str, required=False, mutable=False)


class AlternateNumberEntry17(OCIType):
    """
    Alternate Number Entry.


    Attributes:
        phone_number: phoneNumber
        extension: extension
        ring_pattern: ringPattern
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("ring_pattern", "ringPattern", str),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    ring_pattern: str = Field(type=str, required=False, mutable=False)


class AlternateNumberEntry21(OCIType):
    """
    Alternate Number Entry.


    Attributes:
        phone_number: phoneNumber
        extension: extension
        ring_pattern: ringPattern
        description: description
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("ring_pattern", "ringPattern", str),
        E("description", "description", str),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    ring_pattern: str = Field(type=str, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class AnnouncementFileKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.


    Attributes:
        name: name
        media_file_type: mediaFileType
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("media_file_type", "mediaFileType", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    media_file_type: str = Field(type=str, required=True, mutable=False)


class AnnouncementFileLevelKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.

    Includes level to distinguish between group and user announcements in scenarios where
    both are listed.

    Attributes:
        name: name
        media_file_type: mediaFileType
        level: level
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("media_file_type", "mediaFileType", str, is_required=True),
        E("level", "level", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    media_file_type: str = Field(type=str, required=True, mutable=False)
    level: str = Field(type=str, required=True, mutable=False)


class AssignedGroupServicesEntry(OCIType):
    """
    Assigned Group Services List Entry.

    The isActive element is true, false, or could be missing completely.

    Attributes:
        service_name: serviceName
        is_active: isActive
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("is_active", "isActive", bool),
    )

    service_name: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)


class AssignedUserServicesEntry(OCIType):
    """
    Assigned User Services List Entry.

    The isActive element is true, false, or could be missing completely.

    Attributes:
        service_name: serviceName
        is_active: isActive
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("is_active", "isActive", bool),
    )

    service_name: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)


class AttendantConsoleReplacementDisplayColumnList(OCIType):
    """
    A list of attendant console display columns that replaces a previously configured
    list.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        display_column: displayColumn
    """

    _ELEMENTS = (
        E("display_column", "displayColumn", str, is_required=True),
    )

    display_column: str = Field(type=str, required=True, mutable=False)


class AutoAttendantKeyConfigurationReadEntry(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFileDescription
    audioMediaType videoFileDescription videoMediaType

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationReadEntry19(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFileDescription
    audioMediaType videoFileDescription videoMediaType submenuId The following data
    elements are only valid for Standard Auto Attendants: submenuId

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("submenu_id", "submenuId", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    submenu_id: str = Field(type=str, required=False, mutable=False)


class BasicCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    Replaced By: CallLogsEntry

    Attributes:
        country_code: countryCode
        phone_number: phoneNumber
        name: name
        time: time
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    country_code: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)


class BroadWorksMobilityAlertingMobileNumberReplacementList(OCIType):
    """
    A list of Mobile Numbers to be alerted.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        mobile_number: mobileNumber
    """

    _ELEMENTS = (
        E("mobile_number", "mobileNumber", str, is_required=True),
    )

    mobile_number: str = Field(type=str, required=True, mutable=False)


class BroadWorksMobilityUserMobileIdentityEntry(OCIType):
    """
    User's Mobile Identity Read Entry

    Attributes:
        mobile_number: mobileNumber
        description: description
        is_primary: isPrimary
        enable_alerting: enableAlerting
    """

    _ELEMENTS = (
        E("mobile_number", "mobileNumber", str, is_required=True),
        E("description", "description", str),
        E("is_primary", "isPrimary", bool, is_required=True),
        E("enable_alerting", "enableAlerting", bool, is_required=True),
    )

    mobile_number: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    is_primary: bool = Field(type=bool, required=True, mutable=False)
    enable_alerting: bool = Field(type=bool, required=True, mutable=False)


class BroadWorksMobilityUserMobileIdentityModifyEntry(OCIType):
    """
    User's Mobile Identity Modify Entry

    Attributes:
        mobile_number: mobileNumber
        description: description
        is_primary: isPrimary
        enable_alerting: enableAlerting
    """

    _ELEMENTS = (
        E("mobile_number", "mobileNumber", str, is_required=True),
        E("description", "description", str),
        E("is_primary", "isPrimary", bool),
        E("enable_alerting", "enableAlerting", bool),
    )

    mobile_number: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    is_primary: bool = Field(type=bool, required=False, mutable=False)
    enable_alerting: bool = Field(type=bool, required=False, mutable=False)


class CPEDeviceOptions(OCIType):
    """
    CPE device's options.

    Replaced by: CPEDeviceOptions14sp6

    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str, is_required=True),
        E("device_file_format", "deviceFileFormat", str, is_required=True),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    config_type: str = Field(type=str, required=True, mutable=False)
    system_file_name: str = Field(type=str, required=True, mutable=False)
    device_file_format: str = Field(type=str, required=True, mutable=False)


class CallCenterAgentAvailability(OCIType):
    """
    Specifies an agent's login state (availability) for a particular Call Center.


    Attributes:
        service_user_id: serviceUserId
        available: available
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("available", "available", bool, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    available: bool = Field(type=bool, required=True, mutable=False)


class CallCenterAgentDailyStatistics13mp8(OCIType):
    """
    Contains Call Center Agent statistics for one day.


    Attributes:
        number_of_calls_received: numberOfCallsReceived
        number_of_calls_not_answered: numberOfCallsNotAnswered
        average_time_per_call_seconds: averageTimePerCallSeconds
        time_in_calls_seconds: timeInCallsSeconds
        time_logged_off_seconds: timeLoggedOffSeconds
        time_logged_on_and_idle_seconds: timeLoggedOnAndIdleSeconds
    """

    _ELEMENTS = (
        E("number_of_calls_received", "numberOfCallsReceived", int, is_required=True),
        E("number_of_calls_not_answered", "numberOfCallsNotAnswered", int, is_required=True),
        E(
            "average_time_per_call_seconds", "averageTimePerCallSeconds", int,
            is_required=True,
        ),
        E("time_in_calls_seconds", "timeInCallsSeconds", int, is_required=True),
        E("time_logged_off_seconds", "timeLoggedOffSeconds", int, is_required=True),
        E(
            "time_logged_on_and_idle_seconds", "timeLoggedOnAndIdleSeconds", int,
            is_required=True,
        ),
    )

    number_of_calls_received: int = Field(type=int, required=True, mutable=False)
    number_of_calls_not_answered: int = Field(type=int, required=True, mutable=False)
    average_time_per_call_seconds: int = Field(type=int, required=True, mutable=False)
    time_in_calls_seconds: int = Field(type=int, required=True, mutable=False)
    time_logged_off_seconds: int = Field(type=int, required=True, mutable=False)
    time_logged_on_and_idle_seconds: int = Field(type=int, required=True, mutable=False)


class CallCenterAgentSettings(OCIType):
    """
    Specifies an agent's settings for a particular Call Center.

    The skillLevel only applies to Premium agents.

    Attributes:
        service_user_id: serviceUserId
        available: available
        skill_level: skillLevel
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("available", "available", bool),
        E("skill_level", "skillLevel", int),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    available: bool = Field(type=bool, required=False, mutable=False)
    skill_level: int = Field(type=int, required=False, mutable=False)


class CallCenterAgentThresholdProfileReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Agent Threshold Profile email is sent.

    The list replaces a previously configured list.

    Attributes:
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("email_address", "emailAddress", str, is_required=True),
    )

    email_address: str = Field(type=str, required=True, mutable=False)


class CallCenterAgentUnavailableCodeStateModify(OCIType):
    """
    Contains a Call Center Agent Unavailable Code and its active state

    Attributes:
        code: code
        is_active: isActive
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)


class CallCenterAnnouncementDescriptionList(OCIType):
    """
    Contains list of file descriptions for audio or video files

    Attributes:
        file_description1: fileDescription1
        file_description2: fileDescription2
        file_description3: fileDescription3
        file_description4: fileDescription4
    """

    _ELEMENTS = (
        E("file_description1", "fileDescription1", str),
        E("file_description2", "fileDescription2", str),
        E("file_description3", "fileDescription3", str),
        E("file_description4", "fileDescription4", str),
    )

    file_description1: str = Field(type=str, required=False, mutable=False)
    file_description2: str = Field(type=str, required=False, mutable=False)
    file_description3: str = Field(type=str, required=False, mutable=False)
    file_description4: str = Field(type=str, required=False, mutable=False)


class CallCenterAnnouncementMediaFileTypeList(OCIType):
    """
    Contains list of file media types for audio or video files

    Attributes:
        media_type1: mediaType1
        media_type2: mediaType2
        media_type3: mediaType3
        media_type4: mediaType4
    """

    _ELEMENTS = (
        E("media_type1", "mediaType1", str),
        E("media_type2", "mediaType2", str),
        E("media_type3", "mediaType3", str),
        E("media_type4", "mediaType4", str),
    )

    media_type1: str = Field(type=str, required=False, mutable=False)
    media_type2: str = Field(type=str, required=False, mutable=False)
    media_type3: str = Field(type=str, required=False, mutable=False)
    media_type4: str = Field(type=str, required=False, mutable=False)


class CallCenterAnnouncementURLList(OCIType):
    """
    Contains list of urls

    Attributes:
        url1: url1
        url2: url2
        url3: url3
        url4: url4
    """

    _ELEMENTS = (
        E("url1", "url1", str),
        E("url2", "url2", str),
        E("url3", "url3", str),
        E("url4", "url4", str),
    )

    url1: str = Field(type=str, required=False, mutable=False)
    url2: str = Field(type=str, required=False, mutable=False)
    url3: str = Field(type=str, required=False, mutable=False)
    url4: str = Field(type=str, required=False, mutable=False)


class CallCenterAnnouncementURLListModify(OCIType):
    """
    Contains a list of URLs for modify.


    Attributes:
        url1: url1
        url2: url2
        url3: url3
        url4: url4
    """

    _ELEMENTS = (
        E("url1", "url1", str),
        E("url2", "url2", str),
        E("url3", "url3", str),
        E("url4", "url4", str),
    )

    url1: str = Field(type=str, required=False, mutable=False)
    url2: str = Field(type=str, required=False, mutable=False)
    url3: str = Field(type=str, required=False, mutable=False)
    url4: str = Field(type=str, required=False, mutable=False)


class CallCenterMusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=False, mutable=False)
    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class CallCenterMusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class CallCenterQueueStatistics13mp8(OCIType):
    """
    Contains Call Center Queue statistics.


    Attributes:
        number_of_incoming_calls: numberOfIncomingCalls
        number_of_calls_queued: numberOfCallsQueued
        number_of_busy_overflows: numberOfBusyOverflows
        number_of_calls_answered: numberOfCallsAnswered
        average_time_with_agent_seconds: averageTimeWithAgentSeconds
        average_time_in_queue_seconds: averageTimeInQueueSeconds
        average_number_of_agents_busy: averageNumberOfAgentsBusy
        average_number_of_agents_logged_off: averageNumberOfAgentsLoggedOff
        average_hold_time_before_call_loss_seconds: averageHoldTimeBeforeCallLossSeconds
    """

    _ELEMENTS = (
        E("number_of_incoming_calls", "numberOfIncomingCalls", int, is_required=True),
        E("number_of_calls_queued", "numberOfCallsQueued", int, is_required=True),
        E("number_of_busy_overflows", "numberOfBusyOverflows", int, is_required=True),
        E("number_of_calls_answered", "numberOfCallsAnswered", int, is_required=True),
        E(
            "average_time_with_agent_seconds", "averageTimeWithAgentSeconds", int,
            is_required=True,
        ),
        E(
            "average_time_in_queue_seconds", "averageTimeInQueueSeconds", int,
            is_required=True,
        ),
        E(
            "average_number_of_agents_busy", "averageNumberOfAgentsBusy", int,
            is_required=True,
        ),
        E(
            "average_number_of_agents_logged_off", "averageNumberOfAgentsLoggedOff", int,
            is_required=True,
        ),
        E(
            "average_hold_time_before_call_loss_seconds",
            "averageHoldTimeBeforeCallLossSeconds", int, is_required=True,
        ),
    )

    number_of_incoming_calls: int = Field(type=int, required=True, mutable=False)
    number_of_calls_queued: int = Field(type=int, required=True, mutable=False)
    number_of_busy_overflows: int = Field(type=int, required=True, mutable=False)
    number_of_calls_answered: int = Field(type=int, required=True, mutable=False)
    average_time_with_agent_seconds: int = Field(type=int, required=True, mutable=False)
    average_time_in_queue_seconds: int = Field(type=int, required=True, mutable=False)
    average_number_of_agents_busy: int = Field(type=int, required=True, mutable=False)
    average_number_of_agents_logged_off: int = Field(type=int, required=True, mutable=False)
    average_hold_time_before_call_loss_seconds: int = Field(
        type=int, required=True, mutable=False,
    )


class CallCenterQueueStatistics14sp9(OCIType):
    """
    Contains Call Center Queue statistics.


    Attributes:
        number_of_busy_overflows: numberOfBusyOverflows
        number_of_calls_answered: numberOfCallsAnswered
        number_of_calls_abandoned: numberOfCallsAbandoned
        number_of_calls_transferred: numberOfCallsTransferred
        number_of_calls_timedout: numberOfCallsTimedout
        average_number_of_agents_talking: averageNumberOfAgentsTalking
        average_number_of_agents_staffed: averageNumberOfAgentsStaffed
        average_wait_seconds: averageWaitSeconds
        average_abandonment_seconds: averageAbandonmentSeconds
    """

    _ELEMENTS = (
        E("number_of_busy_overflows", "numberOfBusyOverflows", int, is_required=True),
        E("number_of_calls_answered", "numberOfCallsAnswered", int, is_required=True),
        E("number_of_calls_abandoned", "numberOfCallsAbandoned", int, is_required=True),
        E("number_of_calls_transferred", "numberOfCallsTransferred", int, is_required=True),
        E("number_of_calls_timedout", "numberOfCallsTimedout", int, is_required=True),
        E(
            "average_number_of_agents_talking", "averageNumberOfAgentsTalking", int,
            is_required=True,
        ),
        E(
            "average_number_of_agents_staffed", "averageNumberOfAgentsStaffed", int,
            is_required=True,
        ),
        E("average_wait_seconds", "averageWaitSeconds", int, is_required=True),
        E("average_abandonment_seconds", "averageAbandonmentSeconds", int, is_required=True),
    )

    number_of_busy_overflows: int = Field(type=int, required=True, mutable=False)
    number_of_calls_answered: int = Field(type=int, required=True, mutable=False)
    number_of_calls_abandoned: int = Field(type=int, required=True, mutable=False)
    number_of_calls_transferred: int = Field(type=int, required=True, mutable=False)
    number_of_calls_timedout: int = Field(type=int, required=True, mutable=False)
    average_number_of_agents_talking: int = Field(type=int, required=True, mutable=False)
    average_number_of_agents_staffed: int = Field(type=int, required=True, mutable=False)
    average_wait_seconds: int = Field(type=int, required=True, mutable=False)
    average_abandonment_seconds: int = Field(type=int, required=True, mutable=False)


class CallCenterQueueThresholdReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Call Center Queue Threshold email is sent.

    The list replaces a previously configured list.

    Attributes:
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("email_address", "emailAddress", str, is_required=True),
    )

    email_address: str = Field(type=str, required=True, mutable=False)


class CallCenterReportAbandonedCallThresholdReplacementList(OCIType):
    """
    A list of call center reporting abandoned call threshold seconds that replaces a
    previously configured list.


    Attributes:
        abandoned_call_threshold_seconds: abandonedCallThresholdSeconds
    """

    _ELEMENTS = (
        E(
            "abandoned_call_threshold_seconds", "abandonedCallThresholdSeconds", int,
            is_required=True,
        ),
    )

    abandoned_call_threshold_seconds: int = Field(type=int, required=True, mutable=False)


class CallCenterReportCurrentInterval(OCIType):
    """
    The call center enhanced reporting report current interval, for example, current week.


    Attributes:
        time_unit: timeUnit
    """

    _ELEMENTS = (
        E("time_unit", "timeUnit", str, is_required=True),
    )

    time_unit: str = Field(type=str, required=True, mutable=False)


class CallCenterReportDataTemplateInfo(OCIType):
    """
    Call center reporting data template info.


    Attributes:
        data_template: dataTemplate
        report_type: reportType
        is_realtime_report: isRealtimeReport
        is_agent_param_required: isAgentParamRequired
        is_call_center_param_required: isCallCenterParamRequired
        is_call_center_dnis_param_required: isCallCenterDnisParamRequired
        is_sampling_period_param_required: isSamplingPeriodParamRequired
        is_call_completion_threshold_param_required:
            isCallCompletionThresholdParamRequired
        is_short_duration_threshold_param_required: isShortDurationThresholdParamRequired
        is_service_level_threshold_param_required: isServiceLevelThresholdParamRequired
        is_service_level_inclusions_param_required: isServiceLevelInclusionsParamRequired
        is_service_level_objective_threshold_param_required:
            isServiceLevelObjectiveThresholdParamRequired
        is_abandoned_call_threshold_param_required: isAbandonedCallThresholdParamRequired
    """

    _ELEMENTS = (
        E("data_template", "dataTemplate", str, is_required=True),
        E("report_type", "reportType", str, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool, is_required=True),
        E("is_agent_param_required", "isAgentParamRequired", str, is_required=True),
        E(
            "is_call_center_param_required", "isCallCenterParamRequired", str,
            is_required=True,
        ),
        E(
            "is_call_center_dnis_param_required", "isCallCenterDnisParamRequired", str,
            is_required=True,
        ),
        E(
            "is_sampling_period_param_required", "isSamplingPeriodParamRequired", str,
            is_required=True,
        ),
        E(
            "is_call_completion_threshold_param_required",
            "isCallCompletionThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_short_duration_threshold_param_required",
            "isShortDurationThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_service_level_threshold_param_required",
            "isServiceLevelThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_service_level_inclusions_param_required",
            "isServiceLevelInclusionsParamRequired", str, is_required=True,
        ),
        E(
            "is_service_level_objective_threshold_param_required",
            "isServiceLevelObjectiveThresholdParamRequired", str, is_required=True,
        ),
        E(
            "is_abandoned_call_threshold_param_required",
            "isAbandonedCallThresholdParamRequired", str, is_required=True,
        ),
    )

    data_template: str = Field(type=str, required=True, mutable=False)
    report_type: str = Field(type=str, required=True, mutable=False)
    is_realtime_report: bool = Field(type=bool, required=True, mutable=False)
    is_agent_param_required: str = Field(type=str, required=True, mutable=False)
    is_call_center_param_required: str = Field(type=str, required=True, mutable=False)
    is_call_center_dnis_param_required: str = Field(type=str, required=True, mutable=False)
    is_sampling_period_param_required: str = Field(type=str, required=True, mutable=False)
    is_call_completion_threshold_param_required: str = Field(
        type=str, required=True, mutable=False,
    )
    is_short_duration_threshold_param_required: str = Field(
        type=str, required=True, mutable=False,
    )
    is_service_level_threshold_param_required: str = Field(
        type=str, required=True, mutable=False,
    )
    is_service_level_inclusions_param_required: str = Field(
        type=str, required=True, mutable=False,
    )
    is_service_level_objective_threshold_param_required: str = Field(
        type=str, required=True, mutable=False,
    )
    is_abandoned_call_threshold_param_required: str = Field(
        type=str, required=True, mutable=False,
    )


class CallCenterReportDataTemplateQueryFilterValueReplacementList(OCIType):
    """
    A list of call center reporting data template query filter values that replaces a
    previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        filter_value: filterValue
    """

    _ELEMENTS = (
        E("filter_value", "filterValue", str, is_required=True),
    )

    filter_value: str = Field(type=str, required=True, mutable=False)


class CallCenterReportPastInterval(OCIType):
    """
    The call center enhanced reporting report past interval, for example, last 24 month.


    Attributes:
        number: number
        time_unit: timeUnit
    """

    _ELEMENTS = (
        E("number", "number", int, is_required=True),
        E("time_unit", "timeUnit", str, is_required=True),
    )

    number: int = Field(type=int, required=True, mutable=False)
    time_unit: str = Field(type=str, required=True, mutable=False)


class CallCenterReportReplacementEmailList(OCIType):
    """
    A list of call center reporting email addresses that replaces a previously configured
    list.


    Attributes:
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("email_address", "emailAddress", str, is_required=True),
    )

    email_address: str = Field(type=str, required=True, mutable=False)


class CallCenterReportServiceLevelThresholdReplacementList(OCIType):
    """
    A list of call center reporting service level threshold seconds that replaces a
    previously configured list.


    Attributes:
        service_level_threshold_seconds: serviceLevelThresholdSeconds
    """

    _ELEMENTS = (
        E(
            "service_level_threshold_seconds", "serviceLevelThresholdSeconds", int,
            is_required=True,
        ),
    )

    service_level_threshold_seconds: int = Field(type=int, required=True, mutable=False)


class CallCenterReportTemplateKey(OCIType):
    """
    Uniquely identifies a call center report template created in the system.


    Attributes:
        template_level: templateLevel
        template_name: templateName
    """

    _ELEMENTS = (
        E("template_level", "templateLevel", str, is_required=True),
        E("template_name", "templateName", str, is_required=True),
    )

    template_level: str = Field(type=str, required=True, mutable=False)
    template_name: str = Field(type=str, required=True, mutable=False)


class CallCenterRoutingPriorityOrder(OCIType):
    """
    Call center routing order

    Attributes:
        service_user_id: serviceUserId
        priority: priority
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("priority", "priority", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class CallCenterScheduledReportAgentSelection(OCIType):
    """
    Either all agents or list of agents.


    Attributes:
        all_agent: allAgent
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("all_agent", "allAgent", bool),
        E("agent_user_id", "agentUserId", str),
    )

    all_agent: bool = Field(type=bool, required=False, mutable=False)
    agent_user_id: str = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportAgentSelectionAdminRead(OCIType):
    """
    Either all agents or 2 list of agents: one for current and one for past (deleted)
    agents.

    This is used when an admin reads a Scheduled Report.  Each agent table has the
    following column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name"
    and "Hiragana First Name".

    Attributes:
        all_agent: allAgent
        current_agent_table: currentAgentTable
        past_agent_table: pastAgentTable
    """

    _ELEMENTS = (
        E("all_agent", "allAgent", bool),
        E(
            "current_agent_table", "currentAgentTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
        E(
            "past_agent_table", "pastAgentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    all_agent: bool = Field(type=bool, required=False, mutable=False)
    current_agent_table: "list" = Field(type=list, required=True, mutable=False)
    past_agent_table: "list" = Field(type=list, required=True, mutable=False)


class CallCenterScheduledReportAgentSelectionRead(OCIType):
    """
    Either all agents or list of agents.

    The agent table has the following column headings: "User Id", "Last Name", "First
    Name", "Hiragana Last Name" and "Hiragana First Name".

    Attributes:
        all_agent: allAgent
        agent_table: agentTable
    """

    _ELEMENTS = (
        E("all_agent", "allAgent", bool),
        E("agent_table", "agentTable", list, is_complex=True, is_table=True),
    )

    all_agent: bool = Field(type=bool, required=False, mutable=False)
    agent_table: "list" = Field(type=list, required=False, mutable=False)


class CallCenterScheduledReportCallCenterSelection(OCIType):
    """
    Either all call centers or list of call centers.


    Attributes:
        all_call_center: allCallCenter
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("all_call_center", "allCallCenter", bool),
        E("service_user_id", "serviceUserId", str),
    )

    all_call_center: bool = Field(type=bool, required=False, mutable=False)
    service_user_id: str = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportCallCenterSelectionRead(OCIType):
    """
    User for admin read.

    Either all call centers or 2 lists of call centers: one for current and one for
    deleted call centers.

    Attributes:
        all_call_center: allCallCenter
        current_user_id: currentUserId
        past_user_id: pastUserId
    """

    _ELEMENTS = (
        E("all_call_center", "allCallCenter", bool),
        E("current_user_id", "currentUserId", str),
        E("past_user_id", "pastUserId", str),
    )

    all_call_center: bool = Field(type=bool, required=False, mutable=False)
    current_user_id: str = Field(type=str, required=False, mutable=False)
    past_user_id: str = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportDNISSelection(OCIType):
    """
    Either all DNIS under the specified Call Center or list of DNIS.


    Attributes:
        service_user_id: serviceUserId
        all_dnis: allDNIS
        name: name
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("all_dnis", "allDNIS", bool),
        E("name", "name", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    all_dnis: bool = Field(type=bool, required=False, mutable=False)
    name: str = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportDNISSelectionRead(OCIType):
    """
    Either all DNIS under the specified Call Center or 2 lists of DNIS, one for current
    one for past (deleted).


    Attributes:
        service_user_id: serviceUserId
        deleted: deleted
        all_dnis: allDNIS
        current_name: currentName
        past_name: pastName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("deleted", "deleted", bool),
        E("all_dnis", "allDNIS", bool),
        E("current_name", "currentName", str),
        E("past_name", "pastName", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    deleted: bool = Field(type=bool, required=False, mutable=False)
    all_dnis: bool = Field(type=bool, required=False, mutable=False)
    current_name: str = Field(type=str, required=False, mutable=False)
    past_name: str = Field(type=str, required=False, mutable=False)


class CallCenterScheduledReportServiceLevelInclusions(OCIType):
    """
    The call center enhanced reporting scheduled report inclusions related to the Service
    Level thresholds

    Attributes:
        include_overflow_time_transfered_in_service_level:
            includeOverflowTimeTransferedInServiceLevel
        include_other_transfers_in_service_level: includeOtherTransfersInServiceLevel
        abandoned_calls_in_service_level: abandonedCallsInServiceLevel
        abandoned_call_interval_seconds: abandonedCallIntervalSeconds
    """

    _ELEMENTS = (
        E(
            "include_overflow_time_transfered_in_service_level",
            "includeOverflowTimeTransferedInServiceLevel", bool, is_required=True,
        ),
        E(
            "include_other_transfers_in_service_level",
            "includeOtherTransfersInServiceLevel", bool, is_required=True,
        ),
        E(
            "abandoned_calls_in_service_level", "abandonedCallsInServiceLevel", str,
            is_required=True,
        ),
        E("abandoned_call_interval_seconds", "abandonedCallIntervalSeconds", int),
    )

    include_overflow_time_transfered_in_service_level: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_other_transfers_in_service_level: bool = Field(
        type=bool, required=True, mutable=False,
    )
    abandoned_calls_in_service_level: str = Field(type=str, required=True, mutable=False)
    abandoned_call_interval_seconds: int = Field(type=int, required=False, mutable=False)


class CallCenterScheduledReportServiceLevelInclusionsModify(OCIType):
    """
    The call center enhanced reporting scheduled report modified inclusions related to the
    Service Level thresholds

    Attributes:
        include_overflow_time_transfered_in_service_level:
            includeOverflowTimeTransferedInServiceLevel
        include_other_transfers_in_service_level: includeOtherTransfersInServiceLevel
        abandoned_calls_in_service_level: abandonedCallsInServiceLevel
        abandoned_call_interval_seconds: abandonedCallIntervalSeconds
    """

    _ELEMENTS = (
        E(
            "include_overflow_time_transfered_in_service_level",
            "includeOverflowTimeTransferedInServiceLevel", bool,
        ),
        E(
            "include_other_transfers_in_service_level",
            "includeOtherTransfersInServiceLevel", bool,
        ),
        E("abandoned_calls_in_service_level", "abandonedCallsInServiceLevel", str),
        E("abandoned_call_interval_seconds", "abandonedCallIntervalSeconds", int),
    )

    include_overflow_time_transfered_in_service_level: bool = Field(
        type=bool, required=False, mutable=False,
    )
    include_other_transfers_in_service_level: bool = Field(
        type=bool, required=False, mutable=False,
    )
    abandoned_calls_in_service_level: str = Field(type=str, required=False, mutable=False)
    abandoned_call_interval_seconds: int = Field(type=int, required=False, mutable=False)


class CallCenterSkillAgentList(OCIType):
    """
    A list of agents for a particular skill Level.


    Attributes:
        skill_level: skillLevel
        agent: agent
    """

    _ELEMENTS = (
        E("skill_level", "skillLevel", int, is_required=True),
        E("agent", "agent", str, is_array=True),
    )

    skill_level: int = Field(type=int, required=True, mutable=False)
    agent: "List[str]" = Field(type=list, required=False, mutable=False)


class CallCenterStatisticsRange(OCIType):
    """
    Statistics Range

    Attributes:
        start: start
        end: end
    """

    _ELEMENTS = (
        E("start", "start", str, is_required=True),
        E("end", "end", str),
    )

    start: str = Field(type=str, required=True, mutable=False)
    end: str = Field(type=str, required=False, mutable=False)


class CallDispositionCodeActivation(OCIType):
    """
    Contains a Call Center Call Disposition Code and its active state

    Attributes:
        code: code
        is_active: isActive
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)


class CallDispositionCodeWithLevel(OCIType):
    """
    Contains a Call Center Call Disposition Code and its Level

    Attributes:
        code: code
        level: level
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("level", "level", str, is_required=True),
    )

    code: str = Field(type=str, required=True, mutable=False)
    level: str = Field(type=str, required=True, mutable=False)


class CallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.


    Attributes:
        country_code: countryCode
        call_log_id: callLogId
        phone_number: phoneNumber
        name: name
        time: time
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str),
        E("call_log_id", "callLogId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    country_code: str = Field(type=str, required=False, mutable=False)
    call_log_id: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)


class CallMeNowToDnCriteria(OCIType):
    """
    The To dn criteria used on the call me now external number.


    Attributes:
        to_dn_criteria_selection: toDnCriteriaSelection
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("to_dn_criteria_selection", "toDnCriteriaSelection", str, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    to_dn_criteria_selection: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class CallToNumber(OCIType):
    """
    Call to Number.


    Attributes:
        type: type
        number: number
        extension: extension
    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("number", "number", str),
        E("extension", "extension", str),
    )

    type: str = Field(type=str, required=True, mutable=False)
    number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)


class CollaborateBridgeMaximumParticipants(OCIType):
    """
    Maximum number of Collaborate bridge participants.

    Can either be unlimited or limited to a value between 3 and 999999.

    Attributes:
        unlimited: unlimited
        quantity: quantity
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    unlimited: bool = Field(type=bool, required=False, mutable=False)
    quantity: int = Field(type=int, required=False, mutable=False)


class CollaborateGracePeriodDuration(OCIType):
    """
    Collaborate grace period duration.


    Attributes:
        hours: hours
        minutes: minutes
    """

    _ELEMENTS = (
        E("hours", "hours", int, is_required=True),
        E("minutes", "minutes", int, is_required=True),
    )

    hours: int = Field(type=int, required=True, mutable=False)
    minutes: int = Field(type=int, required=True, mutable=False)


class CollaborateRoomSchedule(OCIType):
    """
    Collaborate room schedule.


    Attributes:
        schedule_reservationless: scheduleReservationless
        schedule_one_time: scheduleOneTime
        schedule_recurring: scheduleRecurring
    """

    _ELEMENTS = (
        E(
            "schedule_reservationless", "scheduleReservationless", str, is_complex=True,
        ),  # unknown
        E("schedule_one_time", "scheduleOneTime", str, is_complex=True),  # unknown
        E("schedule_recurring", "scheduleRecurring", str, is_complex=True),  # unknown
    )

    schedule_reservationless: str = Field(type=str, required=False, mutable=False)
    schedule_one_time: str = Field(type=str, required=False, mutable=False)
    schedule_recurring: str = Field(type=str, required=False, mutable=False)


class CollaborateRoomScheduleDuration(OCIType):
    """
    Collaborate room schedule duration.


    Attributes:
        hours: hours
        minutes: minutes
    """

    _ELEMENTS = (
        E("hours", "hours", int, is_required=True),
        E("minutes", "minutes", int, is_required=True),
    )

    hours: int = Field(type=int, required=True, mutable=False)
    minutes: int = Field(type=int, required=True, mutable=False)


class CommPilotExpressEmailNotify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a get.


    Attributes:
        send_email: sendEmail
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool, is_required=True),
        E("email_address", "emailAddress", str),
    )

    send_email: bool = Field(type=bool, required=True, mutable=False)
    email_address: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressEmailNotifyModify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a modify.


    Attributes:
        send_email: sendEmail
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool),
        E("email_address", "emailAddress", str),
    )

    send_email: bool = Field(type=bool, required=False, mutable=False)
    email_address: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirection(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number used in the
    context of a get.


    Attributes:
        action: action
        forwarding_phone_number: forwardingPhoneNumber
    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    action: str = Field(type=str, required=True, mutable=False)
    forwarding_phone_number: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirectionModify(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number used in the
    context of a modify.


    Attributes:
        action: action
        forwarding_phone_number: forwardingPhoneNumber
    """

    _ELEMENTS = (
        E("action", "action", str),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    action: str = Field(type=str, required=False, mutable=False)
    forwarding_phone_number: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirectionWithException(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number with certain
    exceptions used in the context of a get.


    Attributes:
        send_calls_to_voice_mail_except_excluded_numbers:
            sendCallsToVoiceMailExceptExcludedNumbers
        excluded_phone_number01: excludedPhoneNumber01
        excluded_phone_number02: excludedPhoneNumber02
        excluded_phone_number03: excludedPhoneNumber03
        forward_excluded_numbers_to: forwardExcludedNumbersTo
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool, is_required=True,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    send_calls_to_voice_mail_except_excluded_numbers: bool = Field(
        type=bool, required=True, mutable=False,
    )
    excluded_phone_number01: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number02: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number03: str = Field(type=str, required=False, mutable=False)
    forward_excluded_numbers_to: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number with certain
    exceptions used in the context of a modify.


    Attributes:
        send_calls_to_voice_mail_except_excluded_numbers:
            sendCallsToVoiceMailExceptExcludedNumbers
        excluded_phone_number01: excludedPhoneNumber01
        excluded_phone_number02: excludedPhoneNumber02
        excluded_phone_number03: excludedPhoneNumber03
        forward_excluded_numbers_to: forwardExcludedNumbersTo
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    send_calls_to_voice_mail_except_excluded_numbers: bool = Field(
        type=bool, required=False, mutable=False,
    )
    excluded_phone_number01: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number02: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number03: str = Field(type=str, required=False, mutable=False)
    forward_excluded_numbers_to: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSREmailNotify(OCIType):
    """
    CommPilot Express SR Email Notify configuration used in the context of a get.


    Attributes:
        send_email: sendEmail
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool, is_required=True),
        E("email_address", "emailAddress", str),
    )

    send_email: bool = Field(type=bool, required=True, mutable=False)
    email_address: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSREmailNotifyModify(OCIType):
    """
    CommPilot Express SR Email Notify configuration used in the context of a modify.


    Attributes:
        send_email: sendEmail
        email_address: emailAddress
    """

    _ELEMENTS = (
        E("send_email", "sendEmail", bool),
        E("email_address", "emailAddress", str),
    )

    send_email: bool = Field(type=bool, required=False, mutable=False)
    email_address: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirection(OCIType):
    """
    CommPilot Express SR type to transfer to voice Mail or forward to a number used in the
    context of a get.


    Attributes:
        action: action
        forwarding_phone_number: forwardingPhoneNumber
    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    action: str = Field(type=str, required=True, mutable=False)
    forwarding_phone_number: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionModify(OCIType):
    """
    CommPilot Express SR type to transfer to voice Mail or forward to a number used in the
    context of a modify.


    Attributes:
        action: action
        forwarding_phone_number: forwardingPhoneNumber
    """

    _ELEMENTS = (
        E("action", "action", str),
        E("forwarding_phone_number", "forwardingPhoneNumber", str),
    )

    action: str = Field(type=str, required=False, mutable=False)
    forwarding_phone_number: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionWithException(OCIType):
    """
    CommPilot Express SR type to transfer to voice mail or forward to a number with
    certain exceptions used in the context of a get.


    Attributes:
        send_calls_to_voice_mail_except_excluded_numbers:
            sendCallsToVoiceMailExceptExcludedNumbers
        excluded_phone_number01: excludedPhoneNumber01
        excluded_phone_number02: excludedPhoneNumber02
        excluded_phone_number03: excludedPhoneNumber03
        forward_excluded_numbers_to: forwardExcludedNumbersTo
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool, is_required=True,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    send_calls_to_voice_mail_except_excluded_numbers: bool = Field(
        type=bool, required=True, mutable=False,
    )
    excluded_phone_number01: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number02: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number03: str = Field(type=str, required=False, mutable=False)
    forward_excluded_numbers_to: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express SR type to transfer to voice mail or forward to a number with
    certain exceptions used in the context of a modify.


    Attributes:
        send_calls_to_voice_mail_except_excluded_numbers:
            sendCallsToVoiceMailExceptExcludedNumbers
        excluded_phone_number01: excludedPhoneNumber01
        excluded_phone_number02: excludedPhoneNumber02
        excluded_phone_number03: excludedPhoneNumber03
        forward_excluded_numbers_to: forwardExcludedNumbersTo
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers", bool,
        ),
        E("excluded_phone_number01", "excludedPhoneNumber01", str),
        E("excluded_phone_number02", "excludedPhoneNumber02", str),
        E("excluded_phone_number03", "excludedPhoneNumber03", str),
        E("forward_excluded_numbers_to", "forwardExcludedNumbersTo", str),
    )

    send_calls_to_voice_mail_except_excluded_numbers: bool = Field(
        type=bool, required=False, mutable=False,
    )
    excluded_phone_number01: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number02: str = Field(type=str, required=False, mutable=False)
    excluded_phone_number03: str = Field(type=str, required=False, mutable=False)
    forward_excluded_numbers_to: str = Field(type=str, required=False, mutable=False)


class CommPilotExpressSRRedirectionWithRing(OCIType):
    """
    CommPilot Express SR Forward Number Entry with number of times to ring.


    Attributes:
        phone_number: phoneNumber
        number_of_times_to_ring: numberOfTimesToRing
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_times_to_ring", "numberOfTimesToRing", int, is_required=True),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    number_of_times_to_ring: int = Field(type=int, required=True, mutable=False)


class CommunicationBarringAuthorizationCodeEntry(OCIType):
    """
    Communication Barring Authorization Code entry.


    Attributes:
        code: code
        description: description
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class CommunicationBarringCallMeNowRule(OCIType):
    """
    Communication Barring Call Me Now Rule

    Attributes:
        criteria: criteria
        action: action
        call_timeout_seconds: callTimeoutSeconds
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
    )

    criteria: str = Field(type=str, required=True, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)


class CommunicationBarringIncomingRule(OCIType):
    """
    Communication Barring Incoming Rule

    Attributes:
        digit_pattern_criteria: digitPatternCriteria
        action: action
        call_timeout_seconds: callTimeoutSeconds
        time_schedule: timeSchedule
        holiday_schedule: holidaySchedule
        priority: priority
    """

    _ELEMENTS = (
        E("digit_pattern_criteria", "digitPatternCriteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    digit_pattern_criteria: str = Field(type=str, required=True, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    time_schedule: str = Field(type=str, required=False, mutable=False)
    holiday_schedule: str = Field(type=str, required=False, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class CommunicationBarringIncomingRule19sp1(OCIType):
    """
    Communication Barring Incoming Rule

    Attributes:
        digit_pattern_criteria: digitPatternCriteria
        incoming_criteria: incomingCriteria
        action: action
        call_timeout_seconds: callTimeoutSeconds
        time_schedule: timeSchedule
        holiday_schedule: holidaySchedule
        priority: priority
    """

    _ELEMENTS = (
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("incoming_criteria", "incomingCriteria", str),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    digit_pattern_criteria: str = Field(type=str, required=False, mutable=False)
    incoming_criteria: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    time_schedule: str = Field(type=str, required=False, mutable=False)
    holiday_schedule: str = Field(type=str, required=False, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class CommunicationBarringOriginatingRule(OCIType):
    """
    Communication Barring Originating Rule

    Attributes:
        criteria: criteria
        action: action
        treatment_id: treatmentId
        transfer_number: transferNumber
        call_timeout_seconds: callTimeoutSeconds
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("treatment_id", "treatmentId", str),
        E("transfer_number", "transferNumber", str),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
    )

    criteria: str = Field(type=str, required=True, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    treatment_id: str = Field(type=str, required=False, mutable=False)
    transfer_number: str = Field(type=str, required=False, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)


class CommunicationBarringOriginatingRule15sp2(OCIType):
    """
    Communication Barring Originating Rule

    Attributes:
        criteria: criteria
        action: action
        treatment_id: treatmentId
        transfer_number: transferNumber
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("treatment_id", "treatmentId", str),
        E("transfer_number", "transferNumber", str),
    )

    criteria: str = Field(type=str, required=True, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    treatment_id: str = Field(type=str, required=False, mutable=False)
    transfer_number: str = Field(type=str, required=False, mutable=False)


class CommunicationBarringProfileReplacementList(OCIType):
    """
    A list of communication barring profiles that replaces a previously configured list.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        profile_name: profileName
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
    )

    profile_name: str = Field(type=str, required=True, mutable=False)


class CommunicationBarringRedirectingRule(OCIType):
    """
    Communication Barring Redirecting Rule

    Attributes:
        criteria: criteria
        action: action
        call_timeout_seconds: callTimeoutSeconds
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
    )

    criteria: str = Field(type=str, required=True, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)


class CommunicationBarringRedirectingRule15sp2(OCIType):
    """
    Communication Barring Redirecting Rule

    Attributes:
        criteria: criteria
        action: action
    """

    _ELEMENTS = (
        E("criteria", "criteria", str, is_required=True),
        E("action", "action", str, is_required=True),
    )

    criteria: str = Field(type=str, required=True, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)


class Contact(OCIType):
    """
    Contact information.


    Attributes:
        contact_name: contactName
        contact_number: contactNumber
        contact_email: contactEmail
    """

    _ELEMENTS = (
        E("contact_name", "contactName", str),
        E("contact_number", "contactNumber", str),
        E("contact_email", "contactEmail", str),
    )

    contact_name: str = Field(type=str, required=False, mutable=False)
    contact_number: str = Field(type=str, required=False, mutable=False)
    contact_email: str = Field(type=str, required=False, mutable=False)


class CriteriaActivation(OCIType):
    """
    Criteria active status indicator

    Attributes:
        criteria_name: criteriaName
        is_active: isActive
    """

    _ELEMENTS = (
        E("criteria_name", "criteriaName", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    criteria_name: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)


class CriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    from_dn_criteria_selection: str = Field(type=str, required=True, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=True, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class CriteriaReplacementDNList(OCIType):
    """
    A list of criteria DNs that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)


class CustomContactDirectoryEntry(OCIType):
    """
    Represents either an existing user's Id or an existing Virtual On-Net user's DN.

    For a DN the groupId is used to make it unique within an Enterprise, however the
    groupId is not used with Service Providers.

    Attributes:
        user_id: userId
        virtual_on_net_phone_number: virtualOnNetPhoneNumber
        group_id: groupId
    """

    _ELEMENTS = (
        E("user_id", "userId", str),
        E("virtual_on_net_phone_number", "virtualOnNetPhoneNumber", str, is_required=True),
        E("group_id", "groupId", str),
    )

    user_id: str = Field(type=str, required=False, mutable=False)
    virtual_on_net_phone_number: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=False, mutable=False)


class DNISKey(OCIType):
    """
    Uniquely identifies a Call Center DNIS.


    Attributes:
        service_user_id: serviceUserId
        name: name
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class DNRange(OCIType):
    """
    Directory number range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_phone_number: minPhoneNumber
        max_phone_number: maxPhoneNumber
    """

    _ELEMENTS = (
        E("min_phone_number", "minPhoneNumber", str, is_required=True),
        E("max_phone_number", "maxPhoneNumber", str, is_required=True),
    )

    min_phone_number: str = Field(type=str, required=True, mutable=False)
    max_phone_number: str = Field(type=str, required=True, mutable=False)


class DefaultNetworkClassOfService(OCIType):
    """
    The default Network Class of Service to set during assignation/unassignation.


    Attributes:
        use_existing: useExisting
        network_class_of_service_name: networkClassOfServiceName
    """

    _ELEMENTS = (
        E("use_existing", "useExisting", bool),
        E("network_class_of_service_name", "networkClassOfServiceName", str),
    )

    use_existing: bool = Field(type=bool, required=False, mutable=False)
    network_class_of_service_name: str = Field(type=str, required=False, mutable=False)


class DepartmentKey(OCIType):
    """
    Uniquely identifies a department system-wide.

    Departments are contained in either an enterprise or a group.  Enterprise departments
    can be used by any or all groups within the enterprise.  Department names are unique
    within a group and within an enterprise, but the same department name can exist in 2
    different groups or in both a group and its parent enterprise.  Therefore, to uniquely
    identify a department, we must know the department name and which enterprise or group
    contains the department.  This type is extended by group and enterprise department
    keys.
    """

    _ELEMENTS = ()


class DeviceManagementAutoRebuildConfigEntry(OCIType):
    """
    Contains one automatic rebuild configuration list entry.


    Attributes:
        oci_request_prefix: ociRequestPrefix
        auto_rebuild_enabled: autoRebuildEnabled
    """

    _ELEMENTS = (
        E("oci_request_prefix", "ociRequestPrefix", str, is_required=True),
        E("auto_rebuild_enabled", "autoRebuildEnabled", bool),
    )

    oci_request_prefix: str = Field(type=str, required=True, mutable=False)
    auto_rebuild_enabled: bool = Field(type=bool, required=False, mutable=False)


class DeviceManagementDeviceTypeOptionsRead(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol: deviceAccessProtocol
        tag_mode: tagMode
        tag_set: tagSet
        allow_device_profile_custom_tag_set: allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set: allowGroupCustomTagSet
        send_email_upon_reset_failure: sendEmailUponResetFailure
        device_access_net_address: deviceAccessNetAddress
        device_access_port: deviceAccessPort
        device_access_context: deviceAccessContext
        device_access_uri: deviceAccessURI
        default_device_language: defaultDeviceLanguage
        default_device_encoding: defaultDeviceEncoding
        access_device_credentials: accessDeviceCredentials
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E("access_device_credentials", "accessDeviceCredentials", str),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    tag_mode: str = Field(type=str, required=True, mutable=False)
    tag_set: str = Field(type=str, required=False, mutable=False)
    allow_device_profile_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    allow_group_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    send_email_upon_reset_failure: bool = Field(type=bool, required=True, mutable=False)
    device_access_net_address: str = Field(type=str, required=False, mutable=False)
    device_access_port: int = Field(type=int, required=False, mutable=False)
    device_access_context: str = Field(type=str, required=False, mutable=False)
    device_access_uri: str = Field(type=str, required=False, mutable=False)
    default_device_language: str = Field(type=str, required=False, mutable=False)
    default_device_encoding: str = Field(type=str, required=False, mutable=False)
    access_device_credentials: str = Field(type=str, required=False, mutable=False)
    use_http_digest_authentication: bool = Field(type=bool, required=True, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=True, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=True, mutable=False,
    )
    mac_in_non_request_uri: bool = Field(type=bool, required=True, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeOptionsRead16(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol: deviceAccessProtocol
        tag_mode: tagMode
        tag_set: tagSet
        allow_device_profile_custom_tag_set: allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set: allowGroupCustomTagSet
        send_email_upon_reset_failure: sendEmailUponResetFailure
        device_access_net_address: deviceAccessNetAddress
        device_access_port: deviceAccessPort
        device_access_context: deviceAccessContext
        device_access_uri: deviceAccessURI
        default_device_language: defaultDeviceLanguage
        default_device_encoding: defaultDeviceEncoding
        access_device_credentials: accessDeviceCredentials
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E("access_device_credentials", "accessDeviceCredentials", str),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    tag_mode: str = Field(type=str, required=True, mutable=False)
    tag_set: str = Field(type=str, required=False, mutable=False)
    allow_device_profile_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    allow_group_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    send_email_upon_reset_failure: bool = Field(type=bool, required=True, mutable=False)
    device_access_net_address: str = Field(type=str, required=False, mutable=False)
    device_access_port: int = Field(type=int, required=False, mutable=False)
    device_access_context: str = Field(type=str, required=False, mutable=False)
    device_access_uri: str = Field(type=str, required=False, mutable=False)
    default_device_language: str = Field(type=str, required=False, mutable=False)
    default_device_encoding: str = Field(type=str, required=False, mutable=False)
    access_device_credentials: str = Field(type=str, required=False, mutable=False)
    use_http_digest_authentication: bool = Field(type=bool, required=True, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=True, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=True, mutable=False,
    )
    mac_in_non_request_uri: bool = Field(type=bool, required=True, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)


class DeviceManagementLanguageMapping(OCIType):
    """
    Maps a BroadWorks language to a device-equivalent language.


    Attributes:
        broad_works_language: broadWorksLanguage
        device_language: deviceLanguage
    """

    _ELEMENTS = (
        E("broad_works_language", "broadWorksLanguage", str, is_required=True),
        E("device_language", "deviceLanguage", str, is_required=True),
    )

    broad_works_language: str = Field(type=str, required=True, mutable=False)
    device_language: str = Field(type=str, required=True, mutable=False)


class DeviceManagementUserNamePassword(OCIType):
    """
    Access device credentials.


    Attributes:
        user_name: userName
        password: password
    """

    _ELEMENTS = (
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)


class DeviceManagementUserNamePassword16(OCIType):
    """
    Access device credentials.


    Attributes:
        user_name: userName
        password: password
    """

    _ELEMENTS = (
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)


class DialableCallerIDCriteriaPriorityOrder(OCIType):
    """
    Dialable Caller ID routing order

    Attributes:
        criteria_name: criteriaName
        priority: priority
    """

    _ELEMENTS = (
        E("criteria_name", "criteriaName", str, is_required=True),
        E("priority", "priority", str, is_required=True),
    )

    criteria_name: str = Field(type=str, required=True, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class EnhancedCallLogsAccountAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on the account code.

    When "callsWithCodes" is set to true, all call logs with account/authorization codes
    are returned.  When it set to false, all call logs without account/authorization codes
    are returned.

    Attributes:
        calls_with_codes: callsWithCodes
        account_authorization_code: accountAuthorizationCode
    """

    _ELEMENTS = (
        E("calls_with_codes", "callsWithCodes", bool),
        E("account_authorization_code", "accountAuthorizationCode", str),
    )

    calls_with_codes: bool = Field(type=bool, required=False, mutable=False)
    account_authorization_code: str = Field(type=str, required=False, mutable=False)


class EnhancedCallLogsCallAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on call authorization code.

    Note that this code filter is different than
    EnhancedCallLogsAccountAuthorizationCodeFilter, which applies strictly to codes
    entered using the account/authorization code service.  When "callsWithCodes" is set to
    true, all call logs with authorization codes are returned.  When it set to false, all
    call logs without authorization codes are returned.  If "authorizationCode" is set,
    all call logs matching that specific authorization code are returned.

    Attributes:
        calls_with_codes: callsWithCodes
        authorization_code: authorizationCode
    """

    _ELEMENTS = (
        E("calls_with_codes", "callsWithCodes", bool),
        E("authorization_code", "authorizationCode", str),
    )

    calls_with_codes: bool = Field(type=bool, required=False, mutable=False)
    authorization_code: str = Field(type=str, required=False, mutable=False)


class EnhancedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    Replaced By: CallLogsEntry

    Attributes:
        country_code: countryCode
        phone_number: phoneNumber
        name: name
        time: time
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    country_code: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)


class EnhancedCallLogsRedirectedCallSelection(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition is considered as a redirected call.

    Attributes:
        redirected_call: redirectedCall
        redirect_type: redirectType
    """

    _ELEMENTS = (
        E("redirected_call", "redirectedCall", bool, is_required=True),
        E("redirect_type", "redirectType", str, is_array=True),
    )

    redirected_call: bool = Field(type=bool, required=True, mutable=False)
    redirect_type: "List[str]" = Field(type=list, required=False, mutable=False)


class EnhancedCallLogsRedirectedCallSelection21(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition is considered as a redirected call.

    Attributes:
        redirected_call: redirectedCall
        redirect_type: redirectType
    """

    _ELEMENTS = (
        E("redirected_call", "redirectedCall", bool, is_required=True),
        E("redirect_type", "redirectType", str, is_array=True),
    )

    redirected_call: bool = Field(type=bool, required=True, mutable=False)
    redirect_type: "List[str]" = Field(type=list, required=False, mutable=False)


class EnhancedCallLogsResponsePagingControl(OCIType):
    """
    Used in enhanced call logs group and enterprise queries to restrict the set of result
    rows when making a request that can result in a large dataset.

    The client specifies the starting row and the number of rows requested.  The server
    only provides those rows in results, if available.

    Attributes:
        response_start_index: responseStartIndex
        response_page_size: responsePageSize
    """

    _ELEMENTS = (
        E("response_start_index", "responseStartIndex", int, is_required=True),
        E("response_page_size", "responsePageSize", int, is_required=True),
    )

    response_start_index: int = Field(type=int, required=True, mutable=False)
    response_page_size: int = Field(type=int, required=True, mutable=False)


class EnhancedCallLogsTimeRange(OCIType):
    """
    Time range used to filter call logs.


    Attributes:
        start_date_time: startDateTime
        end_date_time: endDateTime
    """

    _ELEMENTS = (
        E("start_date_time", "startDateTime", str, is_required=True),
        E("end_date_time", "endDateTime", str, is_required=True),
    )

    start_date_time: str = Field(type=str, required=True, mutable=False)
    end_date_time: str = Field(type=str, required=True, mutable=False)


class EnterpriseDepartmentKey(OCIType):
    """
    Uniquely identifies a department defined within an enterprise.

    To uniquely identify an enterprise department, we must know the department name and
    which enterprise contains the department.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseTrunkTrunkGroupKey(OCIType):
    """
    Identifies a trunk group within an Enterprise Trunk where the service provider id is
    already known.


    Attributes:
        group_id: groupId
        trunk_group_name: trunkGroupName
    """

    _ELEMENTS = (
        E("group_id", "groupId", str, is_required=True),
        E("trunk_group_name", "trunkGroupName", str, is_required=True),
    )

    group_id: str = Field(type=str, required=True, mutable=False)
    trunk_group_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNDigitManipulation(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry.

    """

    _ELEMENTS = ()


class EnterpriseVoiceVPNDigitManipulationNoValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that has no value.


    Attributes:
        operation: operation
    """

    _ELEMENTS = (
        E("operation", "operation", str, is_required=True),
    )

    operation: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNDigitManipulationOptionalValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that optionally has a value.


    Attributes:
        operation: operation
        value: value
    """

    _ELEMENTS = (
        E("operation", "operation", str, is_required=True),
        E("value", "value", str),
    )

    operation: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=False, mutable=False)


class EnterpriseVoiceVPNDigitManipulationRequiredValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that has a value.


    Attributes:
        operation: operation
        value: value
    """

    _ELEMENTS = (
        E("operation", "operation", str, is_required=True),
        E("value", "value", str, is_required=True),
    )

    operation: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNTreatmentEntry(OCIType):
    """
    Enterprise Voice VPN Treatment entry

    Attributes:
        id: id
        description: description
    """

    _ELEMENTS = (
        E("id", "id", str, is_required=True),
        E("description", "description", str),
    )

    id: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EstimatedWaitMessageOptionsModify(OCIType):
    """
    Estimated Wait Message Options

    Attributes:
        enabled: enabled
        operating_mode: operatingMode
        play_position_high_volume: playPositionHighVolume
        play_time_high_volume: playTimeHighVolume
        maximum_positions: maximumPositions
        maximum_waiting_minutes: maximumWaitingMinutes
        default_call_handling_minutes: defaultCallHandlingMinutes
        play_updated_ewm: playUpdatedEWM
        time_between_ewm_updates_seconds: timeBetweenEWMUpdatesSeconds
    """

    _ELEMENTS = (
        E("enabled", "enabled", bool),
        E("operating_mode", "operatingMode", str),
        E("play_position_high_volume", "playPositionHighVolume", bool),
        E("play_time_high_volume", "playTimeHighVolume", bool),
        E("maximum_positions", "maximumPositions", int),
        E("maximum_waiting_minutes", "maximumWaitingMinutes", int),
        E("default_call_handling_minutes", "defaultCallHandlingMinutes", int),
        E("play_updated_ewm", "playUpdatedEWM", bool),
        E("time_between_ewm_updates_seconds", "timeBetweenEWMUpdatesSeconds", int),
    )

    enabled: bool = Field(type=bool, required=False, mutable=False)
    operating_mode: str = Field(type=str, required=False, mutable=False)
    play_position_high_volume: bool = Field(type=bool, required=False, mutable=False)
    play_time_high_volume: bool = Field(type=bool, required=False, mutable=False)
    maximum_positions: int = Field(type=int, required=False, mutable=False)
    maximum_waiting_minutes: int = Field(type=int, required=False, mutable=False)
    default_call_handling_minutes: int = Field(type=int, required=False, mutable=False)
    play_updated_ewm: bool = Field(type=bool, required=False, mutable=False)
    time_between_ewm_updates_seconds: int = Field(type=int, required=False, mutable=False)


class EstimatedWaitMessageOptionsRead(OCIType):
    """
    Estimated Wait Message Options Replaced by EstimatedWaitMessageOptionsRead17sp4

    Attributes:
        enabled: enabled
        operating_mode: operatingMode
        play_position_high_volume: playPositionHighVolume
        play_time_high_volume: playTimeHighVolume
        maximum_positions: maximumPositions
        maximum_waiting_minutes: maximumWaitingMinutes
        default_call_handling_minutes: defaultCallHandlingMinutes
    """

    _ELEMENTS = (
        E("enabled", "enabled", bool, is_required=True),
        E("operating_mode", "operatingMode", str, is_required=True),
        E("play_position_high_volume", "playPositionHighVolume", bool, is_required=True),
        E("play_time_high_volume", "playTimeHighVolume", bool, is_required=True),
        E("maximum_positions", "maximumPositions", int, is_required=True),
        E("maximum_waiting_minutes", "maximumWaitingMinutes", int, is_required=True),
        E(
            "default_call_handling_minutes", "defaultCallHandlingMinutes", int,
            is_required=True,
        ),
    )

    enabled: bool = Field(type=bool, required=True, mutable=False)
    operating_mode: str = Field(type=str, required=True, mutable=False)
    play_position_high_volume: bool = Field(type=bool, required=True, mutable=False)
    play_time_high_volume: bool = Field(type=bool, required=True, mutable=False)
    maximum_positions: int = Field(type=int, required=True, mutable=False)
    maximum_waiting_minutes: int = Field(type=int, required=True, mutable=False)
    default_call_handling_minutes: int = Field(type=int, required=True, mutable=False)


class EstimatedWaitMessageOptionsRead17sp4(OCIType):
    """
    Estimated Wait Message Options

    Attributes:
        enabled: enabled
        operating_mode: operatingMode
        play_position_high_volume: playPositionHighVolume
        play_time_high_volume: playTimeHighVolume
        maximum_positions: maximumPositions
        maximum_waiting_minutes: maximumWaitingMinutes
        default_call_handling_minutes: defaultCallHandlingMinutes
        play_updated_ewm: playUpdatedEWM
        time_between_ewm_updates_seconds: timeBetweenEWMUpdatesSeconds
    """

    _ELEMENTS = (
        E("enabled", "enabled", bool, is_required=True),
        E("operating_mode", "operatingMode", str, is_required=True),
        E("play_position_high_volume", "playPositionHighVolume", bool, is_required=True),
        E("play_time_high_volume", "playTimeHighVolume", bool, is_required=True),
        E("maximum_positions", "maximumPositions", int, is_required=True),
        E("maximum_waiting_minutes", "maximumWaitingMinutes", int, is_required=True),
        E(
            "default_call_handling_minutes", "defaultCallHandlingMinutes", int,
            is_required=True,
        ),
        E("play_updated_ewm", "playUpdatedEWM", bool, is_required=True),
        E("time_between_ewm_updates_seconds", "timeBetweenEWMUpdatesSeconds", int),
    )

    enabled: bool = Field(type=bool, required=True, mutable=False)
    operating_mode: str = Field(type=str, required=True, mutable=False)
    play_position_high_volume: bool = Field(type=bool, required=True, mutable=False)
    play_time_high_volume: bool = Field(type=bool, required=True, mutable=False)
    maximum_positions: int = Field(type=int, required=True, mutable=False)
    maximum_waiting_minutes: int = Field(type=int, required=True, mutable=False)
    default_call_handling_minutes: int = Field(type=int, required=True, mutable=False)
    play_updated_ewm: bool = Field(type=bool, required=True, mutable=False)
    time_between_ewm_updates_seconds: int = Field(type=int, required=False, mutable=False)


class ExchangeUserNamePassword(OCIType):
    """
    Exchange server user name and password.


    Attributes:
        user_name: userName
        password: password
    """

    _ELEMENTS = (
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)


class ExecutiveAssistantOptInStatus(OCIType):
    """
    Executive assistant Opt-in status with executive.


    Attributes:
        executive_user_id: executiveUserId
        opt_in: optIn
    """

    _ELEMENTS = (
        E("executive_user_id", "executiveUserId", str, is_required=True),
        E("opt_in", "optIn", bool, is_required=True),
    )

    executive_user_id: str = Field(type=str, required=True, mutable=False)
    opt_in: bool = Field(type=bool, required=True, mutable=False)


class ExecutiveCallFilteringCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria add/get request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    from_dn_criteria_selection: str = Field(type=str, required=True, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=True, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachTime" represents the time when the call is successfully
    redirected by the system.  "releaseTime" represents the time when the call is
    released.  This time corresponds to the moment the call is released by the system, and
    not necessarily when one party hangs up, since this does not always mean the call is
    released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  Replaced by
    ExtendedMixedCallLogsEntry17sp4. Originally deprecated in release 20.

    Attributes:
        call_log_type: callLogType
        country_code: countryCode
        call_log_id: callLogId
        call_id: callId
        subscriber_type: subscriberType
        dialed_number: dialedNumber
        called_number: calledNumber
        network_translated_address: networkTranslatedAddress
        calling_asserted_number: callingAssertedNumber
        calling_presentation_number: callingPresentationNumber
        calling_presentation_number_source: callingPresentationNumberSource
        calling_presentation_name: callingPresentationName
        calling_presentation_indicator: callingPresentationIndicator
        calling_group_id: callingGroupId
        called_directory_name: calledDirectoryName
        called_group_id: calledGroupId
        connected_number: connectedNumber
        connected_number_source: connectedNumberSource
        connected_name: connectedName
        connected_presentation_indicator: connectedPresentationIndicator
        type_of_network: typeOfNetwork
        call_category: callCategory
        basic_call_type: basicCallType
        configurable_call_type: configurableCallType
        alternate_call_indicator: alternateCallIndicator
        virtual_on_net_call_type: virtualOnNetCallType
        time: time
        start_time: startTime
        answer_time: answerTime
        release_time: releaseTime
        detached_time: detachedTime
        detached_answer_time: detachedAnswerTime
        outgoing_dnis: outgoingDnis
        service_invocation_disposition: serviceInvocationDisposition
        service_invocation_dialed_number: serviceInvocationDialedNumber
        service_invocation_called_number: serviceInvocationCalledNumber
        service_invocation_network_translated_address:
            serviceInvocationNetworkTranslatedAddress
        service_invocation_type_of_network: serviceInvocationTypeOfNetwork
        service_invocation_call_category: serviceInvocationCallCategory
        service_invocation_basic_call_type: serviceInvocationBasicCallType
        service_invocation_configurable_call_type: serviceInvocationConfigurableCallType
        service_invocation_alternate_call_indicator:
            serviceInvocationAlternateCallIndicator
        service_invocation_virtual_on_net_call_type: serviceInvocationVirtualOnNetCallType
        service_invocation_called_directory_name: serviceInvocationCalledDirectoryName
        service_invocation_called_group_id: serviceInvocationCalledGroupId
        redirecting_number: redirectingNumber
        redirecting_name: redirectingName
        redirecting_presentation_indicator: redirectingPresentationIndicator
        redirecting_reason: RedirectingReason
        account_authorization_code: accountAuthorizationCode
        user_group_id: userGroupId
        user_id: userId
        user_primary_dn: userPrimaryDn
        user_primary_extension: userPrimaryExtension
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
    )

    call_log_type: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    call_log_id: str = Field(type=str, required=True, mutable=False)
    call_id: str = Field(type=str, required=True, mutable=False)
    subscriber_type: str = Field(type=str, required=True, mutable=False)
    dialed_number: str = Field(type=str, required=False, mutable=False)
    called_number: str = Field(type=str, required=False, mutable=False)
    network_translated_address: str = Field(type=str, required=False, mutable=False)
    calling_asserted_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number_source: str = Field(type=str, required=False, mutable=False)
    calling_presentation_name: str = Field(type=str, required=False, mutable=False)
    calling_presentation_indicator: str = Field(type=str, required=True, mutable=False)
    calling_group_id: str = Field(type=str, required=False, mutable=False)
    called_directory_name: str = Field(type=str, required=False, mutable=False)
    called_group_id: str = Field(type=str, required=False, mutable=False)
    connected_number: str = Field(type=str, required=False, mutable=False)
    connected_number_source: str = Field(type=str, required=False, mutable=False)
    connected_name: str = Field(type=str, required=False, mutable=False)
    connected_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    type_of_network: str = Field(type=str, required=False, mutable=False)
    call_category: str = Field(type=str, required=False, mutable=False)
    basic_call_type: str = Field(type=str, required=True, mutable=False)
    configurable_call_type: str = Field(type=str, required=False, mutable=False)
    alternate_call_indicator: str = Field(type=str, required=False, mutable=False)
    virtual_on_net_call_type: str = Field(type=str, required=False, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)
    start_time: int = Field(type=int, required=True, mutable=False)
    answer_time: int = Field(type=int, required=False, mutable=False)
    release_time: int = Field(type=int, required=False, mutable=False)
    detached_time: int = Field(type=int, required=False, mutable=False)
    detached_answer_time: int = Field(type=int, required=False, mutable=False)
    outgoing_dnis: str = Field(type=str, required=False, mutable=False)
    service_invocation_disposition: str = Field(type=str, required=False, mutable=False)
    service_invocation_dialed_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_called_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_network_translated_address: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_type_of_network: str = Field(type=str, required=False, mutable=False)
    service_invocation_call_category: str = Field(type=str, required=False, mutable=False)
    service_invocation_basic_call_type: str = Field(type=str, required=False, mutable=False)
    service_invocation_configurable_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_alternate_call_indicator: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_virtual_on_net_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_directory_name: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_group_id: str = Field(type=str, required=False, mutable=False)
    redirecting_number: str = Field(type=str, required=False, mutable=False)
    redirecting_name: str = Field(type=str, required=False, mutable=False)
    redirecting_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    redirecting_reason: str = Field(type=str, required=False, mutable=False)
    account_authorization_code: str = Field(type=str, required=False, mutable=False)
    user_group_id: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)
    user_primary_dn: str = Field(type=str, required=False, mutable=False)
    user_primary_extension: str = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry17sp4(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode

    Attributes:
        call_log_type: callLogType
        country_code: countryCode
        call_log_id: callLogId
        call_id: callId
        subscriber_type: subscriberType
        dialed_number: dialedNumber
        called_number: calledNumber
        network_translated_address: networkTranslatedAddress
        calling_asserted_number: callingAssertedNumber
        calling_presentation_number: callingPresentationNumber
        calling_presentation_number_source: callingPresentationNumberSource
        calling_presentation_name: callingPresentationName
        calling_presentation_indicator: callingPresentationIndicator
        calling_group_id: callingGroupId
        called_directory_name: calledDirectoryName
        called_group_id: calledGroupId
        connected_number: connectedNumber
        connected_number_source: connectedNumberSource
        connected_name: connectedName
        connected_presentation_indicator: connectedPresentationIndicator
        type_of_network: typeOfNetwork
        call_category: callCategory
        basic_call_type: basicCallType
        configurable_call_type: configurableCallType
        alternate_call_indicator: alternateCallIndicator
        virtual_on_net_call_type: virtualOnNetCallType
        time: time
        start_time: startTime
        answer_time: answerTime
        release_time: releaseTime
        detached_time: detachedTime
        detached_answer_time: detachedAnswerTime
        outgoing_dnis: outgoingDnis
        service_invocation_disposition: serviceInvocationDisposition
        service_invocation_dialed_number: serviceInvocationDialedNumber
        service_invocation_called_number: serviceInvocationCalledNumber
        service_invocation_network_translated_address:
            serviceInvocationNetworkTranslatedAddress
        service_invocation_type_of_network: serviceInvocationTypeOfNetwork
        service_invocation_call_category: serviceInvocationCallCategory
        service_invocation_basic_call_type: serviceInvocationBasicCallType
        service_invocation_configurable_call_type: serviceInvocationConfigurableCallType
        service_invocation_alternate_call_indicator:
            serviceInvocationAlternateCallIndicator
        service_invocation_virtual_on_net_call_type: serviceInvocationVirtualOnNetCallType
        service_invocation_called_directory_name: serviceInvocationCalledDirectoryName
        service_invocation_called_group_id: serviceInvocationCalledGroupId
        redirecting_number: redirectingNumber
        redirecting_name: redirectingName
        redirecting_presentation_indicator: redirectingPresentationIndicator
        redirecting_reason: RedirectingReason
        account_authorization_code: accountAuthorizationCode
        call_authorization_code: callAuthorizationCode
        user_group_id: userGroupId
        user_id: userId
        user_primary_dn: userPrimaryDn
        user_primary_extension: userPrimaryExtension
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("call_authorization_code", "callAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
    )

    call_log_type: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    call_log_id: str = Field(type=str, required=True, mutable=False)
    call_id: str = Field(type=str, required=True, mutable=False)
    subscriber_type: str = Field(type=str, required=True, mutable=False)
    dialed_number: str = Field(type=str, required=False, mutable=False)
    called_number: str = Field(type=str, required=False, mutable=False)
    network_translated_address: str = Field(type=str, required=False, mutable=False)
    calling_asserted_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number_source: str = Field(type=str, required=False, mutable=False)
    calling_presentation_name: str = Field(type=str, required=False, mutable=False)
    calling_presentation_indicator: str = Field(type=str, required=True, mutable=False)
    calling_group_id: str = Field(type=str, required=False, mutable=False)
    called_directory_name: str = Field(type=str, required=False, mutable=False)
    called_group_id: str = Field(type=str, required=False, mutable=False)
    connected_number: str = Field(type=str, required=False, mutable=False)
    connected_number_source: str = Field(type=str, required=False, mutable=False)
    connected_name: str = Field(type=str, required=False, mutable=False)
    connected_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    type_of_network: str = Field(type=str, required=False, mutable=False)
    call_category: str = Field(type=str, required=False, mutable=False)
    basic_call_type: str = Field(type=str, required=True, mutable=False)
    configurable_call_type: str = Field(type=str, required=False, mutable=False)
    alternate_call_indicator: str = Field(type=str, required=False, mutable=False)
    virtual_on_net_call_type: str = Field(type=str, required=False, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)
    start_time: int = Field(type=int, required=True, mutable=False)
    answer_time: int = Field(type=int, required=False, mutable=False)
    release_time: int = Field(type=int, required=False, mutable=False)
    detached_time: int = Field(type=int, required=False, mutable=False)
    detached_answer_time: int = Field(type=int, required=False, mutable=False)
    outgoing_dnis: str = Field(type=str, required=False, mutable=False)
    service_invocation_disposition: str = Field(type=str, required=False, mutable=False)
    service_invocation_dialed_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_called_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_network_translated_address: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_type_of_network: str = Field(type=str, required=False, mutable=False)
    service_invocation_call_category: str = Field(type=str, required=False, mutable=False)
    service_invocation_basic_call_type: str = Field(type=str, required=False, mutable=False)
    service_invocation_configurable_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_alternate_call_indicator: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_virtual_on_net_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_directory_name: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_group_id: str = Field(type=str, required=False, mutable=False)
    redirecting_number: str = Field(type=str, required=False, mutable=False)
    redirecting_name: str = Field(type=str, required=False, mutable=False)
    redirecting_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    redirecting_reason: str = Field(type=str, required=False, mutable=False)
    account_authorization_code: str = Field(type=str, required=False, mutable=False)
    call_authorization_code: str = Field(type=str, required=False, mutable=False)
    user_group_id: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)
    user_primary_dn: str = Field(type=str, required=False, mutable=False)
    user_primary_extension: str = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry20(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode callSecurityClassification

    Attributes:
        call_log_type: callLogType
        country_code: countryCode
        call_log_id: callLogId
        call_id: callId
        subscriber_type: subscriberType
        dialed_number: dialedNumber
        called_number: calledNumber
        network_translated_address: networkTranslatedAddress
        calling_asserted_number: callingAssertedNumber
        calling_presentation_number: callingPresentationNumber
        calling_presentation_number_source: callingPresentationNumberSource
        calling_presentation_name: callingPresentationName
        calling_presentation_indicator: callingPresentationIndicator
        calling_group_id: callingGroupId
        called_directory_name: calledDirectoryName
        called_group_id: calledGroupId
        connected_number: connectedNumber
        connected_number_source: connectedNumberSource
        connected_name: connectedName
        connected_presentation_indicator: connectedPresentationIndicator
        type_of_network: typeOfNetwork
        call_category: callCategory
        basic_call_type: basicCallType
        configurable_call_type: configurableCallType
        alternate_call_indicator: alternateCallIndicator
        virtual_on_net_call_type: virtualOnNetCallType
        time: time
        start_time: startTime
        answer_time: answerTime
        release_time: releaseTime
        detached_time: detachedTime
        detached_answer_time: detachedAnswerTime
        outgoing_dnis: outgoingDnis
        service_invocation_disposition: serviceInvocationDisposition
        service_invocation_dialed_number: serviceInvocationDialedNumber
        service_invocation_called_number: serviceInvocationCalledNumber
        service_invocation_network_translated_address:
            serviceInvocationNetworkTranslatedAddress
        service_invocation_type_of_network: serviceInvocationTypeOfNetwork
        service_invocation_call_category: serviceInvocationCallCategory
        service_invocation_basic_call_type: serviceInvocationBasicCallType
        service_invocation_configurable_call_type: serviceInvocationConfigurableCallType
        service_invocation_alternate_call_indicator:
            serviceInvocationAlternateCallIndicator
        service_invocation_virtual_on_net_call_type: serviceInvocationVirtualOnNetCallType
        service_invocation_called_directory_name: serviceInvocationCalledDirectoryName
        service_invocation_called_group_id: serviceInvocationCalledGroupId
        redirecting_number: redirectingNumber
        redirecting_name: redirectingName
        redirecting_presentation_indicator: redirectingPresentationIndicator
        redirecting_reason: RedirectingReason
        account_authorization_code: accountAuthorizationCode
        call_authorization_code: callAuthorizationCode
        user_group_id: userGroupId
        user_id: userId
        user_primary_dn: userPrimaryDn
        user_primary_extension: userPrimaryExtension
        security_classification: securityClassification
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("call_authorization_code", "callAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
        E("security_classification", "securityClassification", str),
    )

    call_log_type: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    call_log_id: str = Field(type=str, required=True, mutable=False)
    call_id: str = Field(type=str, required=True, mutable=False)
    subscriber_type: str = Field(type=str, required=True, mutable=False)
    dialed_number: str = Field(type=str, required=False, mutable=False)
    called_number: str = Field(type=str, required=False, mutable=False)
    network_translated_address: str = Field(type=str, required=False, mutable=False)
    calling_asserted_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number_source: str = Field(type=str, required=False, mutable=False)
    calling_presentation_name: str = Field(type=str, required=False, mutable=False)
    calling_presentation_indicator: str = Field(type=str, required=True, mutable=False)
    calling_group_id: str = Field(type=str, required=False, mutable=False)
    called_directory_name: str = Field(type=str, required=False, mutable=False)
    called_group_id: str = Field(type=str, required=False, mutable=False)
    connected_number: str = Field(type=str, required=False, mutable=False)
    connected_number_source: str = Field(type=str, required=False, mutable=False)
    connected_name: str = Field(type=str, required=False, mutable=False)
    connected_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    type_of_network: str = Field(type=str, required=False, mutable=False)
    call_category: str = Field(type=str, required=False, mutable=False)
    basic_call_type: str = Field(type=str, required=True, mutable=False)
    configurable_call_type: str = Field(type=str, required=False, mutable=False)
    alternate_call_indicator: str = Field(type=str, required=False, mutable=False)
    virtual_on_net_call_type: str = Field(type=str, required=False, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)
    start_time: int = Field(type=int, required=True, mutable=False)
    answer_time: int = Field(type=int, required=False, mutable=False)
    release_time: int = Field(type=int, required=False, mutable=False)
    detached_time: int = Field(type=int, required=False, mutable=False)
    detached_answer_time: int = Field(type=int, required=False, mutable=False)
    outgoing_dnis: str = Field(type=str, required=False, mutable=False)
    service_invocation_disposition: str = Field(type=str, required=False, mutable=False)
    service_invocation_dialed_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_called_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_network_translated_address: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_type_of_network: str = Field(type=str, required=False, mutable=False)
    service_invocation_call_category: str = Field(type=str, required=False, mutable=False)
    service_invocation_basic_call_type: str = Field(type=str, required=False, mutable=False)
    service_invocation_configurable_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_alternate_call_indicator: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_virtual_on_net_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_directory_name: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_group_id: str = Field(type=str, required=False, mutable=False)
    redirecting_number: str = Field(type=str, required=False, mutable=False)
    redirecting_name: str = Field(type=str, required=False, mutable=False)
    redirecting_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    redirecting_reason: str = Field(type=str, required=False, mutable=False)
    account_authorization_code: str = Field(type=str, required=False, mutable=False)
    call_authorization_code: str = Field(type=str, required=False, mutable=False)
    user_group_id: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)
    user_primary_dn: str = Field(type=str, required=False, mutable=False)
    user_primary_extension: str = Field(type=str, required=False, mutable=False)
    security_classification: str = Field(type=str, required=False, mutable=False)


class ExtendedMixedCallLogsEntry21(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode securityClassification

    Attributes:
        call_log_type: callLogType
        country_code: countryCode
        call_log_id: callLogId
        call_id: callId
        subscriber_type: subscriberType
        dialed_number: dialedNumber
        called_number: calledNumber
        network_translated_address: networkTranslatedAddress
        calling_asserted_number: callingAssertedNumber
        calling_presentation_number: callingPresentationNumber
        calling_presentation_number_source: callingPresentationNumberSource
        calling_presentation_name: callingPresentationName
        calling_presentation_indicator: callingPresentationIndicator
        calling_group_id: callingGroupId
        called_directory_name: calledDirectoryName
        called_group_id: calledGroupId
        connected_number: connectedNumber
        connected_number_source: connectedNumberSource
        connected_name: connectedName
        connected_presentation_indicator: connectedPresentationIndicator
        type_of_network: typeOfNetwork
        call_category: callCategory
        basic_call_type: basicCallType
        configurable_call_type: configurableCallType
        alternate_call_indicator: alternateCallIndicator
        virtual_on_net_call_type: virtualOnNetCallType
        time: time
        start_time: startTime
        answer_time: answerTime
        release_time: releaseTime
        detached_time: detachedTime
        detached_answer_time: detachedAnswerTime
        outgoing_dnis: outgoingDnis
        service_invocation_disposition: serviceInvocationDisposition
        service_invocation_dialed_number: serviceInvocationDialedNumber
        service_invocation_called_number: serviceInvocationCalledNumber
        service_invocation_network_translated_address:
            serviceInvocationNetworkTranslatedAddress
        service_invocation_type_of_network: serviceInvocationTypeOfNetwork
        service_invocation_call_category: serviceInvocationCallCategory
        service_invocation_basic_call_type: serviceInvocationBasicCallType
        service_invocation_configurable_call_type: serviceInvocationConfigurableCallType
        service_invocation_alternate_call_indicator:
            serviceInvocationAlternateCallIndicator
        service_invocation_virtual_on_net_call_type: serviceInvocationVirtualOnNetCallType
        service_invocation_called_directory_name: serviceInvocationCalledDirectoryName
        service_invocation_called_group_id: serviceInvocationCalledGroupId
        redirecting_number: redirectingNumber
        redirecting_name: redirectingName
        redirecting_presentation_indicator: redirectingPresentationIndicator
        redirecting_reason: RedirectingReason
        account_authorization_code: accountAuthorizationCode
        call_authorization_code: callAuthorizationCode
        user_group_id: userGroupId
        user_id: userId
        user_primary_dn: userPrimaryDn
        user_primary_extension: userPrimaryExtension
        security_classification: securityClassification
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("call_log_id", "callLogId", str, is_required=True),
        E("call_id", "callId", str, is_required=True),
        E("subscriber_type", "subscriberType", str, is_required=True),
        E("dialed_number", "dialedNumber", str),
        E("called_number", "calledNumber", str),
        E("network_translated_address", "networkTranslatedAddress", str),
        E("calling_asserted_number", "callingAssertedNumber", str),
        E("calling_presentation_number", "callingPresentationNumber", str),
        E("calling_presentation_number_source", "callingPresentationNumberSource", str),
        E("calling_presentation_name", "callingPresentationName", str),
        E(
            "calling_presentation_indicator", "callingPresentationIndicator", str,
            is_required=True,
        ),
        E("calling_group_id", "callingGroupId", str),
        E("called_directory_name", "calledDirectoryName", str),
        E("called_group_id", "calledGroupId", str),
        E("connected_number", "connectedNumber", str),
        E("connected_number_source", "connectedNumberSource", str),
        E("connected_name", "connectedName", str),
        E("connected_presentation_indicator", "connectedPresentationIndicator", str),
        E("type_of_network", "typeOfNetwork", str),
        E("call_category", "callCategory", str),
        E("basic_call_type", "basicCallType", str, is_required=True),
        E("configurable_call_type", "configurableCallType", str),
        E("alternate_call_indicator", "alternateCallIndicator", str),
        E("virtual_on_net_call_type", "virtualOnNetCallType", str),
        E("time", "time", str, is_required=True),
        E("start_time", "startTime", int, is_required=True),
        E("answer_time", "answerTime", int),
        E("release_time", "releaseTime", int),
        E("detached_time", "detachedTime", int),
        E("detached_answer_time", "detachedAnswerTime", int),
        E("outgoing_dnis", "outgoingDnis", str),
        E("service_invocation_disposition", "serviceInvocationDisposition", str),
        E("service_invocation_dialed_number", "serviceInvocationDialedNumber", str),
        E("service_invocation_called_number", "serviceInvocationCalledNumber", str),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress", str,
        ),
        E("service_invocation_type_of_network", "serviceInvocationTypeOfNetwork", str),
        E("service_invocation_call_category", "serviceInvocationCallCategory", str),
        E("service_invocation_basic_call_type", "serviceInvocationBasicCallType", str),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType", str,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator", str,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType", str,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName", str,
        ),
        E("service_invocation_called_group_id", "serviceInvocationCalledGroupId", str),
        E("redirecting_number", "redirectingNumber", str),
        E("redirecting_name", "redirectingName", str),
        E("redirecting_presentation_indicator", "redirectingPresentationIndicator", str),
        E("redirecting_reason", "RedirectingReason", str),
        E("account_authorization_code", "accountAuthorizationCode", str),
        E("call_authorization_code", "callAuthorizationCode", str),
        E("user_group_id", "userGroupId", str),
        E("user_id", "userId", str),
        E("user_primary_dn", "userPrimaryDn", str),
        E("user_primary_extension", "userPrimaryExtension", str),
        E("security_classification", "securityClassification", str),
    )

    call_log_type: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    call_log_id: str = Field(type=str, required=True, mutable=False)
    call_id: str = Field(type=str, required=True, mutable=False)
    subscriber_type: str = Field(type=str, required=True, mutable=False)
    dialed_number: str = Field(type=str, required=False, mutable=False)
    called_number: str = Field(type=str, required=False, mutable=False)
    network_translated_address: str = Field(type=str, required=False, mutable=False)
    calling_asserted_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number: str = Field(type=str, required=False, mutable=False)
    calling_presentation_number_source: str = Field(type=str, required=False, mutable=False)
    calling_presentation_name: str = Field(type=str, required=False, mutable=False)
    calling_presentation_indicator: str = Field(type=str, required=True, mutable=False)
    calling_group_id: str = Field(type=str, required=False, mutable=False)
    called_directory_name: str = Field(type=str, required=False, mutable=False)
    called_group_id: str = Field(type=str, required=False, mutable=False)
    connected_number: str = Field(type=str, required=False, mutable=False)
    connected_number_source: str = Field(type=str, required=False, mutable=False)
    connected_name: str = Field(type=str, required=False, mutable=False)
    connected_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    type_of_network: str = Field(type=str, required=False, mutable=False)
    call_category: str = Field(type=str, required=False, mutable=False)
    basic_call_type: str = Field(type=str, required=True, mutable=False)
    configurable_call_type: str = Field(type=str, required=False, mutable=False)
    alternate_call_indicator: str = Field(type=str, required=False, mutable=False)
    virtual_on_net_call_type: str = Field(type=str, required=False, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)
    start_time: int = Field(type=int, required=True, mutable=False)
    answer_time: int = Field(type=int, required=False, mutable=False)
    release_time: int = Field(type=int, required=False, mutable=False)
    detached_time: int = Field(type=int, required=False, mutable=False)
    detached_answer_time: int = Field(type=int, required=False, mutable=False)
    outgoing_dnis: str = Field(type=str, required=False, mutable=False)
    service_invocation_disposition: str = Field(type=str, required=False, mutable=False)
    service_invocation_dialed_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_called_number: str = Field(type=str, required=False, mutable=False)
    service_invocation_network_translated_address: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_type_of_network: str = Field(type=str, required=False, mutable=False)
    service_invocation_call_category: str = Field(type=str, required=False, mutable=False)
    service_invocation_basic_call_type: str = Field(type=str, required=False, mutable=False)
    service_invocation_configurable_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_alternate_call_indicator: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_virtual_on_net_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_directory_name: str = Field(
        type=str, required=False, mutable=False,
    )
    service_invocation_called_group_id: str = Field(type=str, required=False, mutable=False)
    redirecting_number: str = Field(type=str, required=False, mutable=False)
    redirecting_name: str = Field(type=str, required=False, mutable=False)
    redirecting_presentation_indicator: str = Field(type=str, required=False, mutable=False)
    redirecting_reason: str = Field(type=str, required=False, mutable=False)
    account_authorization_code: str = Field(type=str, required=False, mutable=False)
    call_authorization_code: str = Field(type=str, required=False, mutable=False)
    user_group_id: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)
    user_primary_dn: str = Field(type=str, required=False, mutable=False)
    user_primary_extension: str = Field(type=str, required=False, mutable=False)
    security_classification: str = Field(type=str, required=False, mutable=False)


class ExtensionRange(OCIType):
    """
    Extension range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_extension: minExtension
        max_extension: maxExtension
    """

    _ELEMENTS = (
        E("min_extension", "minExtension", str, is_required=True),
        E("max_extension", "maxExtension", str, is_required=True),
    )

    min_extension: str = Field(type=str, required=True, mutable=False)
    max_extension: str = Field(type=str, required=True, mutable=False)


class ExtensionRange17(OCIType):
    """
    Extension range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_extension: minExtension
        max_extension: maxExtension
    """

    _ELEMENTS = (
        E("min_extension", "minExtension", str, is_required=True),
        E("max_extension", "maxExtension", str, is_required=True),
    )

    min_extension: str = Field(type=str, required=True, mutable=False)
    max_extension: str = Field(type=str, required=True, mutable=False)


class FeatureAccessCodeEntry(OCIType):
    """
    Feature Access Code Entry

    Attributes:
        feature_access_code_name: featureAccessCodeName
        main_code: mainCode
        alternate_code: alternateCode
    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("main_code", "mainCode", str),
        E("alternate_code", "alternateCode", str),
    )

    feature_access_code_name: str = Field(type=str, required=True, mutable=False)
    main_code: str = Field(type=str, required=False, mutable=False)
    alternate_code: str = Field(type=str, required=False, mutable=False)


class FeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all the system, service provider and group
    modify commands.


    Attributes:
        feature_access_code_name: featureAccessCodeName
        main_code: mainCode
        alternate_code: alternateCode
        enable_fac: enableFAC
    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("main_code", "mainCode", str),
        E("alternate_code", "alternateCode", str),
        E("enable_fac", "enableFAC", bool),
    )

    feature_access_code_name: str = Field(type=str, required=True, mutable=False)
    main_code: str = Field(type=str, required=False, mutable=False)
    alternate_code: str = Field(type=str, required=False, mutable=False)
    enable_fac: bool = Field(type=bool, required=False, mutable=False)


class FeatureAccessCodeReadEntry(OCIType):
    """
    Feature Access Code Entry to be used in all GET commands.


    Attributes:
        feature_access_code_name: featureAccessCodeName
        main_code: mainCode
        alternate_code: alternateCode
        enable_fac: enableFAC
    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("main_code", "mainCode", str),
        E("alternate_code", "alternateCode", str),
        E("enable_fac", "enableFAC", bool),
    )

    feature_access_code_name: str = Field(type=str, required=True, mutable=False)
    main_code: str = Field(type=str, required=False, mutable=False)
    alternate_code: str = Field(type=str, required=False, mutable=False)
    enable_fac: bool = Field(type=bool, required=False, mutable=False)


class FileRepositoryProtocolFTP(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.


    Attributes:
        ftp_passive: ftpPassive
        net_address: netAddress
    """

    _ELEMENTS = (
        E("ftp_passive", "ftpPassive", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
    )

    ftp_passive: bool = Field(type=bool, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)


class FileRepositoryProtocolFTP16(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.


    Attributes:
        ftp_passive: ftpPassive
        net_address: netAddress
        ftp_remote_verification: ftpRemoteVerification
    """

    _ELEMENTS = (
        E("ftp_passive", "ftpPassive", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("ftp_remote_verification", "ftpRemoteVerification", bool, is_required=True),
    )

    ftp_passive: bool = Field(type=bool, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)
    ftp_remote_verification: bool = Field(type=bool, required=True, mutable=False)


class FileRepositoryProtocolWebDAV(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.


    Attributes:
        secure: secure
        net_address: netAddress
    """

    _ELEMENTS = (
        E("secure", "secure", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
    )

    secure: bool = Field(type=bool, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)


class FileRepositoryProtocolWebDAV20(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.


    Attributes:
        secure: secure
        net_address: netAddress
        extended_file_capture_support: extendedFileCaptureSupport
    """

    _ELEMENTS = (
        E("secure", "secure", bool, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E(
            "extended_file_capture_support", "extendedFileCaptureSupport", bool,
            is_required=True,
        ),
    )

    secure: bool = Field(type=bool, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)
    extended_file_capture_support: bool = Field(type=bool, required=True, mutable=False)


class FileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer.


    Attributes:
        source_file_name: sourceFileName
        file_content: fileContent
    """

    _ELEMENTS = (
        E("source_file_name", "sourceFileName", str),
        E("file_content", "fileContent", str),
    )

    source_file_name: str = Field(type=str, required=False, mutable=False)
    file_content: str = Field(type=str, required=False, mutable=False)


class FindMeFollowMeAlertingGroupReplacementOutgoingDNSIPURIorUserIdList(OCIType):
    """
    A list of phone numbers/sipuris or user ids that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number: phoneNumber
        user_id: userId
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("user_id", "userId", str),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)


class GroupDepartmentKey(OCIType):
    """
    Uniquely identifies a department defined within a group.

    To uniquely identify a group department, we must know the department name and which
    group contains the department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group

    Attributes:
        trunk_group: trunkGroup
        priority: priority
        weight: weight
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_required=True),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    trunk_group: str = Field(type=str, required=True, mutable=False)
    priority: int = Field(type=int, required=True, mutable=False)
    weight: int = Field(type=int, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17sp1V1(OCIType):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either GroupHuntGroupGetInstanceResponse17sp1V1 or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupPreferredCarrierName(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's
    own.

    The group carrier name is exposed if it was previously configured.

    Attributes:
        use_service_provider_preferred_carrier: useServiceProviderPreferredCarrier
        carrier: carrier
    """

    _ELEMENTS = (
        E(
            "use_service_provider_preferred_carrier",
            "useServiceProviderPreferredCarrier", bool, is_required=True,
        ),
        E("carrier", "carrier", str),
    )

    use_service_provider_preferred_carrier: bool = Field(
        type=bool, required=True, mutable=False,
    )
    carrier: str = Field(type=str, required=False, mutable=False)


class GroupPreferredCarrierNameModify(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's
    own.

    You can use the Service Provider preferred carrier without clearing the group carrier
    name -- in this case, the group carrier name is retained.

    Attributes:
        use_service_provider_preferred_carrier: useServiceProviderPreferredCarrier
        carrier: carrier
    """

    _ELEMENTS = (
        E(
            "use_service_provider_preferred_carrier",
            "useServiceProviderPreferredCarrier", bool, is_required=True,
        ),
        E("carrier", "carrier", str),
    )

    use_service_provider_preferred_carrier: bool = Field(
        type=bool, required=True, mutable=False,
    )
    carrier: str = Field(type=str, required=False, mutable=False)


class Holiday(OCIType):
    """
    Holiday entry.


    Attributes:
        holiday_name: holidayName
        start_date: startDate
        end_date: endDate
    """

    _ELEMENTS = (
        E("holiday_name", "holidayName", str, is_required=True),
        E("start_date", "startDate", str, is_required=True),
        E("end_date", "endDate", str),
    )

    holiday_name: str = Field(type=str, required=True, mutable=False)
    start_date: str = Field(type=str, required=True, mutable=False)
    end_date: str = Field(type=str, required=False, mutable=False)


class HolidaySchedule(OCIType):
    """
    Holiday Schedule.


    Attributes:
        type: type
        name: name
    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    type: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class HourMinute(OCIType):
    """
    Represents a specific time with hour and minute granularity

    Attributes:
        hour: hour
        minute: minute
    """

    _ELEMENTS = (
        E("hour", "hour", int, is_required=True),
        E("minute", "minute", int, is_required=True),
    )

    hour: int = Field(type=int, required=True, mutable=False)
    minute: int = Field(type=int, required=True, mutable=False)


class HuntAgentWeight(OCIType):
    """
    The weighted call distribution weight for an agent.


    Attributes:
        agent_user_id: agentUserId
        weight: weight
    """

    _ELEMENTS = (
        E("agent_user_id", "agentUserId", str, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    agent_user_id: str = Field(type=str, required=True, mutable=False)
    weight: int = Field(type=int, required=True, mutable=False)


class IPAddressRange(OCIType):
    """
    IP Address Range.


    Attributes:
        min_ip_address: minIpAddress
        max_ip_address: maxIpAddress
    """

    _ELEMENTS = (
        E("min_ip_address", "minIpAddress", str, is_required=True),
        E("max_ip_address", "maxIpAddress", str, is_required=True),
    )

    min_ip_address: str = Field(type=str, required=True, mutable=False)
    max_ip_address: str = Field(type=str, required=True, mutable=False)


class IncomingCallingPlanDigitPatternPermission(OCIType):
    """
    Indicates whether calls from specified digit patterns are permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        allow: allow
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("allow", "allow", bool, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    allow: bool = Field(type=bool, required=True, mutable=False)


class InterceptDNListEntry(OCIType):
    """
    Intercept User Entry containing the phone number and a Description.


    Attributes:
        phone_number: phoneNumber
        description: description
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
        E("description", "description", str),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class LDAPEntryField(OCIType):
    """
    One name value pair for a LDAP entry.


    Attributes:
        attribute_name: attributeName
        attribute_value: attributeValue
    """

    _ELEMENTS = (
        E("attribute_name", "attributeName", str, is_required=True),
        E("attribute_value", "attributeValue", str),
    )

    attribute_name: str = Field(type=str, required=True, mutable=False)
    attribute_value: str = Field(type=str, required=False, mutable=False)


class LDAPPage(OCIType):
    """
    Type to retrieve a particular page or the last page.


    Attributes:
        last_page: lastPage
        number: number
    """

    _ELEMENTS = (
        E("last_page", "lastPage", bool),
        E("number", "number", int),
    )

    last_page: bool = Field(type=bool, required=False, mutable=False)
    number: int = Field(type=int, required=False, mutable=False)


class LabeledFileNameResource(OCIType):
    """
    Represents an existing file for the application server to use, along with a
    description and mediaType.


    Attributes:
        description: description
        media_type: mediaType
        source_file_name: sourceFileName
    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("media_type", "mediaType", str, is_required=True),
        E("source_file_name", "sourceFileName", str, is_required=True),
    )

    description: str = Field(type=str, required=True, mutable=False)
    media_type: str = Field(type=str, required=True, mutable=False)
    source_file_name: str = Field(type=str, required=True, mutable=False)


class LabeledFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer with a description.


    Attributes:
        description: description
        source_file_name: sourceFileName
        content: content
    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("source_file_name", "sourceFileName", str),
        E("content", "content", str),
    )

    description: str = Field(type=str, required=True, mutable=False)
    source_file_name: str = Field(type=str, required=False, mutable=False)
    content: str = Field(type=str, required=False, mutable=False)


class LabeledMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer with a description.


    Attributes:
        description: description
        media_type: mediaType
        source_file_name: sourceFileName
        content: content
    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("media_type", "mediaType", str, is_required=True),
        E("source_file_name", "sourceFileName", str),
        E("content", "content", str),
    )

    description: str = Field(type=str, required=True, mutable=False)
    media_type: str = Field(type=str, required=True, mutable=False)
    source_file_name: str = Field(type=str, required=False, mutable=False)
    content: str = Field(type=str, required=False, mutable=False)


class MWIDeliveryToMobileEndpointTemplateActivation(OCIType):
    """
    MWI Delivery To Mobile Endpoint enabled status indicator

    Attributes:
        language: language
        type: type
        is_enabled: isEnabled
    """

    _ELEMENTS = (
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
    )

    language: str = Field(type=str, required=True, mutable=False)
    type: str = Field(type=str, required=True, mutable=False)
    is_enabled: bool = Field(type=bool, required=True, mutable=False)


class MWIDeliveryToMobileEndpointTemplateLine(OCIType):
    """
    MWI Delivery To Mobile Endpoint template section associated with a specific tag.


    Attributes:
        prefix: prefix
        tag: tag
        postfix: postfix
    """

    _ELEMENTS = (
        E("prefix", "prefix", str),
        E("tag", "tag", str),
        E("postfix", "postfix", str),
    )

    prefix: str = Field(type=str, required=False, mutable=False)
    tag: str = Field(type=str, required=False, mutable=False)
    postfix: str = Field(type=str, required=False, mutable=False)


class MaliciousCallTraceTimePeriod(OCIType):
    """
    Modify the user level data associated with Malicious Call Trace.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        start_date_time: startDateTime
        stop_date_time: stopDateTime
    """

    _ELEMENTS = (
        E("start_date_time", "startDateTime", str, is_required=True),
        E("stop_date_time", "stopDateTime", str, is_required=True),
    )

    start_date_time: str = Field(type=str, required=True, mutable=False)
    stop_date_time: str = Field(type=str, required=True, mutable=False)


class MeetMeConferencingConferenceDuration(OCIType):
    """
    Conference duration.


    Attributes:
        hours: hours
        minutes: minutes
    """

    _ELEMENTS = (
        E("hours", "hours", int, is_required=True),
        E("minutes", "minutes", int, is_required=True),
    )

    hours: int = Field(type=int, required=True, mutable=False)
    minutes: int = Field(type=int, required=True, mutable=False)


class MeetMeConferencingConferenceKey(OCIType):
    """
    Identifier for conference.


    Attributes:
        bridge_id: bridgeId
        conference_id: conferenceId
    """

    _ELEMENTS = (
        E("bridge_id", "bridgeId", str, is_required=True),
        E("conference_id", "conferenceId", str, is_required=True),
    )

    bridge_id: str = Field(type=str, required=True, mutable=False)
    conference_id: str = Field(type=str, required=True, mutable=False)


class MeetMeConferencingConferencePorts(OCIType):
    """
    Number of conference ports.

    Can either be unlimited or limited to a value between 0 and 999999.

    Attributes:
        unlimited: unlimited
        quantity: quantity
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    unlimited: bool = Field(type=bool, required=False, mutable=False)
    quantity: int = Field(type=int, required=False, mutable=False)


class MeetMeConferencingConferenceRecordingKey(OCIType):
    """
    Identifier for conference recording.

    startTime is the recording start timestamp.

    Attributes:
        bridge_id: bridgeId
        conference_id: conferenceId
        start_time: startTime
    """

    _ELEMENTS = (
        E("bridge_id", "bridgeId", str, is_required=True),
        E("conference_id", "conferenceId", str, is_required=True),
        E("start_time", "startTime", str, is_required=True),
    )

    bridge_id: str = Field(type=str, required=True, mutable=False)
    conference_id: str = Field(type=str, required=True, mutable=False)
    start_time: str = Field(type=str, required=True, mutable=False)


class MeetMeConferencingConferenceSchedule(OCIType):
    """
    Conference schedule.


    Attributes:
        schedule_reservationless: scheduleReservationless
        schedule_one_time: scheduleOneTime
        schedule_recurring: scheduleRecurring
    """

    _ELEMENTS = (
        E(
            "schedule_reservationless", "scheduleReservationless", str, is_complex=True,
        ),  # unknown
        E("schedule_one_time", "scheduleOneTime", str, is_complex=True),  # unknown
        E("schedule_recurring", "scheduleRecurring", str, is_complex=True),  # unknown
    )

    schedule_reservationless: str = Field(type=str, required=False, mutable=False)
    schedule_one_time: str = Field(type=str, required=False, mutable=False)
    schedule_recurring: str = Field(type=str, required=False, mutable=False)


class MixedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.


    Attributes:
        call_log_type: callLogType
        country_code: countryCode
        call_log_id: callLogId
        phone_number: phoneNumber
        name: name
        time: time
    """

    _ELEMENTS = (
        E("call_log_type", "callLogType", str, is_required=True),
        E("country_code", "countryCode", str),
        E("call_log_id", "callLogId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("time", "time", str, is_required=True),
    )

    call_log_type: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=False, mutable=False)
    call_log_id: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    time: str = Field(type=str, required=True, mutable=False)


class MusicOnHoldSourceAdd(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceAdd16(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceAdd20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceAdd21

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceAdd21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        labeled_custom_source_media_files: labeledCustomSourceMediaFiles
        announcement_custom_source_media_files: announcementCustomSourceMediaFiles
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E(
            "labeled_custom_source_media_files", "labeledCustomSourceMediaFiles", str,
            is_complex=True,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles", str, is_complex=True,
        ),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    labeled_custom_source_media_files: str = Field(type=str, required=False, mutable=False)
    announcement_custom_source_media_files: str = Field(
        type=str, required=False, mutable=False,
    )
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=False, mutable=False)
    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify16(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=False, mutable=False)
    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceModify21

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=False, mutable=False)
    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceModify21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        labeled_custom_source_media_files: labeledCustomSourceMediaFiles
        announcement_custom_source_media_files: announcementCustomSourceMediaFiles
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str),
        E("message_source_selection", "messageSourceSelection", str),
        E(
            "labeled_custom_source_media_files", "labeledCustomSourceMediaFiles", str,
            is_complex=True,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles", str, is_complex=True,
        ),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=False, mutable=False)
    message_source_selection: str = Field(type=str, required=False, mutable=False)
    labeled_custom_source_media_files: str = Field(type=str, required=False, mutable=False)
    announcement_custom_source_media_files: str = Field(
        type=str, required=False, mutable=False,
    )
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead16(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceRead19.

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead19(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceRead21

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        custom_source: customSource
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldSourceRead21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and not returned in AS data
    mode: labeledCustomSourceMediaFiles The following elements are only used in AS data
    mode and not returned in HSS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec: audioFilePreferredCodec
        message_source_selection: messageSourceSelection
        labeled_custom_source_media_files: labeledCustomSourceMediaFiles
        announcement_custom_source_media_files: announcementCustomSourceMediaFiles
        external_source: externalSource
    """

    _ELEMENTS = (
        E("audio_file_preferred_codec", "audioFilePreferredCodec", str, is_required=True),
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E(
            "labeled_custom_source_media_files", "labeledCustomSourceMediaFiles", str,
            is_complex=True,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles", str, is_complex=True,
        ),  # unknown
        E("external_source", "externalSource", str, is_complex=True),  # unknown
    )

    audio_file_preferred_codec: str = Field(type=str, required=True, mutable=False)
    message_source_selection: str = Field(type=str, required=True, mutable=False)
    labeled_custom_source_media_files: str = Field(type=str, required=False, mutable=False)
    announcement_custom_source_media_files: str = Field(
        type=str, required=False, mutable=False,
    )
    external_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceModify(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceModify16(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceModify20(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    message_source_selection: str = Field(type=str, required=False, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceRead(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceRead16(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class MusicOnHoldUserSourceRead20(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection: messageSourceSelection
        custom_source: customSource
    """

    _ELEMENTS = (
        E("message_source_selection", "messageSourceSelection", str, is_required=True),
        E("custom_source", "customSource", str, is_complex=True),  # unknown
    )

    message_source_selection: str = Field(type=str, required=True, mutable=False)
    custom_source: str = Field(type=str, required=False, mutable=False)


class NameDialingName(OCIType):
    """
    Name dialing last and first names.


    Attributes:
        name_dialing_last_name: nameDialingLastName
        name_dialing_first_name: nameDialingFirstName
    """

    _ELEMENTS = (
        E("name_dialing_last_name", "nameDialingLastName", str, is_required=True),
        E("name_dialing_first_name", "nameDialingFirstName", str, is_required=True),
    )

    name_dialing_last_name: str = Field(type=str, required=True, mutable=False)
    name_dialing_first_name: str = Field(type=str, required=True, mutable=False)


class NetworkClassOfServiceCommunicationBarringProfile(OCIType):
    """
    Communication Barring Profile defined as part of the Network Class Of Service.

    There can be only one primary profile within a Network Class Of Service.

    Attributes:
        name: name
        is_primary: isPrimary
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("is_primary", "isPrimary", bool, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    is_primary: bool = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanAuthorizationCodeEntry(OCIType):
    """
    Outgoing Calling Plan Authorization Code.


    Attributes:
        code: code
        description: description
    """

    _ELEMENTS = (
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class OutgoingCallingPlanCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions.


    Attributes:
        group: group
        local: local
        toll_free: tollFree
        toll: toll
        international: international
        operator_assisted: operatorAssisted
        chargeable_directory_assisted: chargeableDirectoryAssisted
        special_services_i: specialServicesI
        special_services_ii: specialServicesII
        premium_services_i: premiumServicesI
        premium_services_ii: premiumServicesII
        casual: casual
        url_dialing: urlDialing
        unknown: unknown
    """

    _ELEMENTS = (
        E("group", "group", bool, is_required=True),
        E("local", "local", bool, is_required=True),
        E("toll_free", "tollFree", bool, is_required=True),
        E("toll", "toll", bool, is_required=True),
        E("international", "international", bool, is_required=True),
        E("operator_assisted", "operatorAssisted", bool, is_required=True),
        E(
            "chargeable_directory_assisted", "chargeableDirectoryAssisted", bool,
            is_required=True,
        ),
        E("special_services_i", "specialServicesI", bool, is_required=True),
        E("special_services_ii", "specialServicesII", bool, is_required=True),
        E("premium_services_i", "premiumServicesI", bool, is_required=True),
        E("premium_services_ii", "premiumServicesII", bool, is_required=True),
        E("casual", "casual", bool, is_required=True),
        E("url_dialing", "urlDialing", bool, is_required=True),
        E("unknown", "unknown", bool, is_required=True),
    )

    group: bool = Field(type=bool, required=True, mutable=False)
    local: bool = Field(type=bool, required=True, mutable=False)
    toll_free: bool = Field(type=bool, required=True, mutable=False)
    toll: bool = Field(type=bool, required=True, mutable=False)
    international: bool = Field(type=bool, required=True, mutable=False)
    operator_assisted: bool = Field(type=bool, required=True, mutable=False)
    chargeable_directory_assisted: bool = Field(type=bool, required=True, mutable=False)
    special_services_i: bool = Field(type=bool, required=True, mutable=False)
    special_services_ii: bool = Field(type=bool, required=True, mutable=False)
    premium_services_i: bool = Field(type=bool, required=True, mutable=False)
    premium_services_ii: bool = Field(type=bool, required=True, mutable=False)
    casual: bool = Field(type=bool, required=True, mutable=False)
    url_dialing: bool = Field(type=bool, required=True, mutable=False)
    unknown: bool = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanCallMeNowPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions.


    Attributes:
        group: group
        local: local
        toll_free: tollFree
        toll: toll
        international: international
        operator_assisted: operatorAssisted
        chargeable_directory_assisted: chargeableDirectoryAssisted
        special_services_i: specialServicesI
        special_services_ii: specialServicesII
        premium_services_i: premiumServicesI
        premium_services_ii: premiumServicesII
        casual: casual
        url_dialing: urlDialing
        unknown: unknown
    """

    _ELEMENTS = (
        E("group", "group", bool),
        E("local", "local", bool),
        E("toll_free", "tollFree", bool),
        E("toll", "toll", bool),
        E("international", "international", bool),
        E("operator_assisted", "operatorAssisted", bool),
        E("chargeable_directory_assisted", "chargeableDirectoryAssisted", bool),
        E("special_services_i", "specialServicesI", bool),
        E("special_services_ii", "specialServicesII", bool),
        E("premium_services_i", "premiumServicesI", bool),
        E("premium_services_ii", "premiumServicesII", bool),
        E("casual", "casual", bool),
        E("url_dialing", "urlDialing", bool),
        E("unknown", "unknown", bool),
    )

    group: bool = Field(type=bool, required=False, mutable=False)
    local: bool = Field(type=bool, required=False, mutable=False)
    toll_free: bool = Field(type=bool, required=False, mutable=False)
    toll: bool = Field(type=bool, required=False, mutable=False)
    international: bool = Field(type=bool, required=False, mutable=False)
    operator_assisted: bool = Field(type=bool, required=False, mutable=False)
    chargeable_directory_assisted: bool = Field(type=bool, required=False, mutable=False)
    special_services_i: bool = Field(type=bool, required=False, mutable=False)
    special_services_ii: bool = Field(type=bool, required=False, mutable=False)
    premium_services_i: bool = Field(type=bool, required=False, mutable=False)
    premium_services_ii: bool = Field(type=bool, required=False, mutable=False)
    casual: bool = Field(type=bool, required=False, mutable=False)
    url_dialing: bool = Field(type=bool, required=False, mutable=False)
    unknown: bool = Field(type=bool, required=False, mutable=False)


class OutgoingCallingPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified digit patterns are permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        permission: permission
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", bool, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    permission: bool = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified digit patterns are permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        permission: permission
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    permission: str = Field(type=str, required=True, mutable=False)


class OutgoingCallingPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified digit patterns are permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        permission: permission
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", bool, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    permission: bool = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions.


    Attributes:
        group: group
        local: local
        toll_free: tollFree
        toll: toll
        international: international
        operator_assisted: operatorAssisted
        chargeable_directory_assisted: chargeableDirectoryAssisted
        special_services_i: specialServicesI
        special_services_ii: specialServicesII
        premium_services_i: premiumServicesI
        premium_services_ii: premiumServicesII
        casual: casual
        url_dialing: urlDialing
        unknown: unknown
    """

    _ELEMENTS = (
        E("group", "group", str, is_required=True),
        E("local", "local", str, is_required=True),
        E("toll_free", "tollFree", str, is_required=True),
        E("toll", "toll", str, is_required=True),
        E("international", "international", str, is_required=True),
        E("operator_assisted", "operatorAssisted", str, is_required=True),
        E(
            "chargeable_directory_assisted", "chargeableDirectoryAssisted", str,
            is_required=True,
        ),
        E("special_services_i", "specialServicesI", str, is_required=True),
        E("special_services_ii", "specialServicesII", str, is_required=True),
        E("premium_services_i", "premiumServicesI", str, is_required=True),
        E("premium_services_ii", "premiumServicesII", str, is_required=True),
        E("casual", "casual", str, is_required=True),
        E("url_dialing", "urlDialing", str, is_required=True),
        E("unknown", "unknown", str, is_required=True),
    )

    group: str = Field(type=str, required=True, mutable=False)
    local: str = Field(type=str, required=True, mutable=False)
    toll_free: str = Field(type=str, required=True, mutable=False)
    toll: str = Field(type=str, required=True, mutable=False)
    international: str = Field(type=str, required=True, mutable=False)
    operator_assisted: str = Field(type=str, required=True, mutable=False)
    chargeable_directory_assisted: str = Field(type=str, required=True, mutable=False)
    special_services_i: str = Field(type=str, required=True, mutable=False)
    special_services_ii: str = Field(type=str, required=True, mutable=False)
    premium_services_i: str = Field(type=str, required=True, mutable=False)
    premium_services_ii: str = Field(type=str, required=True, mutable=False)
    casual: str = Field(type=str, required=True, mutable=False)
    url_dialing: str = Field(type=str, required=True, mutable=False)
    unknown: str = Field(type=str, required=True, mutable=False)


class OutgoingCallingPlanOriginatingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions.


    Attributes:
        group: group
        local: local
        toll_free: tollFree
        toll: toll
        international: international
        operator_assisted: operatorAssisted
        chargeable_directory_assisted: chargeableDirectoryAssisted
        special_services_i: specialServicesI
        special_services_ii: specialServicesII
        premium_services_i: premiumServicesI
        premium_services_ii: premiumServicesII
        casual: casual
        url_dialing: urlDialing
        unknown: unknown
    """

    _ELEMENTS = (
        E("group", "group", str),
        E("local", "local", str),
        E("toll_free", "tollFree", str),
        E("toll", "toll", str),
        E("international", "international", str),
        E("operator_assisted", "operatorAssisted", str),
        E("chargeable_directory_assisted", "chargeableDirectoryAssisted", str),
        E("special_services_i", "specialServicesI", str),
        E("special_services_ii", "specialServicesII", str),
        E("premium_services_i", "premiumServicesI", str),
        E("premium_services_ii", "premiumServicesII", str),
        E("casual", "casual", str),
        E("url_dialing", "urlDialing", str),
        E("unknown", "unknown", str),
    )

    group: str = Field(type=str, required=False, mutable=False)
    local: str = Field(type=str, required=False, mutable=False)
    toll_free: str = Field(type=str, required=False, mutable=False)
    toll: str = Field(type=str, required=False, mutable=False)
    international: str = Field(type=str, required=False, mutable=False)
    operator_assisted: str = Field(type=str, required=False, mutable=False)
    chargeable_directory_assisted: str = Field(type=str, required=False, mutable=False)
    special_services_i: str = Field(type=str, required=False, mutable=False)
    special_services_ii: str = Field(type=str, required=False, mutable=False)
    premium_services_i: str = Field(type=str, required=False, mutable=False)
    premium_services_ii: str = Field(type=str, required=False, mutable=False)
    casual: str = Field(type=str, required=False, mutable=False)
    url_dialing: str = Field(type=str, required=False, mutable=False)
    unknown: str = Field(type=str, required=False, mutable=False)


class OutgoingCallingPlanRedirectedPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.


    Attributes:
        outside_group: outsideGroup
    """

    _ELEMENTS = (
        E("outside_group", "outsideGroup", bool, is_required=True),
    )

    outside_group: bool = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanRedirectedPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.


    Attributes:
        outside_group: outsideGroup
    """

    _ELEMENTS = (
        E("outside_group", "outsideGroup", bool),
    )

    outside_group: bool = Field(type=bool, required=False, mutable=False)


class OutgoingCallingPlanRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.


    Attributes:
        group: group
        local: local
        toll_free: tollFree
        toll: toll
        international: international
        operator_assisted: operatorAssisted
        chargeable_directory_assisted: chargeableDirectoryAssisted
        special_services_i: specialServicesI
        special_services_ii: specialServicesII
        premium_services_i: premiumServicesI
        premium_services_ii: premiumServicesII
        casual: casual
        url_dialing: urlDialing
        unknown: unknown
    """

    _ELEMENTS = (
        E("group", "group", bool, is_required=True),
        E("local", "local", bool, is_required=True),
        E("toll_free", "tollFree", bool, is_required=True),
        E("toll", "toll", bool, is_required=True),
        E("international", "international", bool, is_required=True),
        E("operator_assisted", "operatorAssisted", bool, is_required=True),
        E(
            "chargeable_directory_assisted", "chargeableDirectoryAssisted", bool,
            is_required=True,
        ),
        E("special_services_i", "specialServicesI", bool, is_required=True),
        E("special_services_ii", "specialServicesII", bool, is_required=True),
        E("premium_services_i", "premiumServicesI", bool, is_required=True),
        E("premium_services_ii", "premiumServicesII", bool, is_required=True),
        E("casual", "casual", bool, is_required=True),
        E("url_dialing", "urlDialing", bool, is_required=True),
        E("unknown", "unknown", bool, is_required=True),
    )

    group: bool = Field(type=bool, required=True, mutable=False)
    local: bool = Field(type=bool, required=True, mutable=False)
    toll_free: bool = Field(type=bool, required=True, mutable=False)
    toll: bool = Field(type=bool, required=True, mutable=False)
    international: bool = Field(type=bool, required=True, mutable=False)
    operator_assisted: bool = Field(type=bool, required=True, mutable=False)
    chargeable_directory_assisted: bool = Field(type=bool, required=True, mutable=False)
    special_services_i: bool = Field(type=bool, required=True, mutable=False)
    special_services_ii: bool = Field(type=bool, required=True, mutable=False)
    premium_services_i: bool = Field(type=bool, required=True, mutable=False)
    premium_services_ii: bool = Field(type=bool, required=True, mutable=False)
    casual: bool = Field(type=bool, required=True, mutable=False)
    url_dialing: bool = Field(type=bool, required=True, mutable=False)
    unknown: bool = Field(type=bool, required=True, mutable=False)


class OutgoingCallingPlanRedirectingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.


    Attributes:
        group: group
        local: local
        toll_free: tollFree
        toll: toll
        international: international
        operator_assisted: operatorAssisted
        chargeable_directory_assisted: chargeableDirectoryAssisted
        special_services_i: specialServicesI
        special_services_ii: specialServicesII
        premium_services_i: premiumServicesI
        premium_services_ii: premiumServicesII
        casual: casual
        url_dialing: urlDialing
        unknown: unknown
    """

    _ELEMENTS = (
        E("group", "group", bool),
        E("local", "local", bool),
        E("toll_free", "tollFree", bool),
        E("toll", "toll", bool),
        E("international", "international", bool),
        E("operator_assisted", "operatorAssisted", bool),
        E("chargeable_directory_assisted", "chargeableDirectoryAssisted", bool),
        E("special_services_i", "specialServicesI", bool),
        E("special_services_ii", "specialServicesII", bool),
        E("premium_services_i", "premiumServicesI", bool),
        E("premium_services_ii", "premiumServicesII", bool),
        E("casual", "casual", bool),
        E("url_dialing", "urlDialing", bool),
        E("unknown", "unknown", bool),
    )

    group: bool = Field(type=bool, required=False, mutable=False)
    local: bool = Field(type=bool, required=False, mutable=False)
    toll_free: bool = Field(type=bool, required=False, mutable=False)
    toll: bool = Field(type=bool, required=False, mutable=False)
    international: bool = Field(type=bool, required=False, mutable=False)
    operator_assisted: bool = Field(type=bool, required=False, mutable=False)
    chargeable_directory_assisted: bool = Field(type=bool, required=False, mutable=False)
    special_services_i: bool = Field(type=bool, required=False, mutable=False)
    special_services_ii: bool = Field(type=bool, required=False, mutable=False)
    premium_services_i: bool = Field(type=bool, required=False, mutable=False)
    premium_services_ii: bool = Field(type=bool, required=False, mutable=False)
    casual: bool = Field(type=bool, required=False, mutable=False)
    url_dialing: bool = Field(type=bool, required=False, mutable=False)
    unknown: bool = Field(type=bool, required=False, mutable=False)


class OutgoingCallingPlanTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers.


    Attributes:
        phone_number01: phoneNumber01
        phone_number02: phoneNumber02
        phone_number03: phoneNumber03
    """

    _ELEMENTS = (
        E("phone_number01", "phoneNumber01", str),
        E("phone_number02", "phoneNumber02", str),
        E("phone_number03", "phoneNumber03", str),
    )

    phone_number01: str = Field(type=str, required=False, mutable=False)
    phone_number02: str = Field(type=str, required=False, mutable=False)
    phone_number03: str = Field(type=str, required=False, mutable=False)


class OutgoingCallingPlanTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers.


    Attributes:
        phone_number01: phoneNumber01
        phone_number02: phoneNumber02
        phone_number03: phoneNumber03
    """

    _ELEMENTS = (
        E("phone_number01", "phoneNumber01", str),
        E("phone_number02", "phoneNumber02", str),
        E("phone_number03", "phoneNumber03", str),
    )

    phone_number01: str = Field(type=str, required=False, mutable=False)
    phone_number02: str = Field(type=str, required=False, mutable=False)
    phone_number03: str = Field(type=str, required=False, mutable=False)


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified Pinhole digit patterns are
    permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        permission: permission
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    permission: str = Field(type=str, required=True, mutable=False)


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified Pinhole digit patterns are
    permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        permission: permission
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    permission: str = Field(type=str, required=True, mutable=False)


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified Pinhole digit patterns are
    permitted.


    Attributes:
        digit_pattern_name: digitPatternName
        permission: permission
    """

    _ELEMENTS = (
        E("digit_pattern_name", "digitPatternName", str, is_required=True),
        E("permission", "permission", str, is_required=True),
    )

    digit_pattern_name: str = Field(type=str, required=True, mutable=False)
    permission: str = Field(type=str, required=True, mutable=False)


class PhoneListEntry(OCIType):
    """
    Phone list entry.


    Attributes:
        entry_name: entryName
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("entry_name", "entryName", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    entry_name: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)


class PriorityAlertCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    from_dn_criteria_selection: str = Field(type=str, required=True, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=True, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class PublicUserIdentity(OCIType):
    """
    Public User Identity

    Attributes:
        sip_uri: sipURI
        tel_uri: telURI
    """

    _ELEMENTS = (
        E("sip_uri", "sipURI", str),
        E("tel_uri", "telURI", str),
    )

    sip_uri: str = Field(type=str, required=False, mutable=False)
    tel_uri: str = Field(type=str, required=False, mutable=False)


class RandomPort(OCIType):
    """
    Represents either a random port number, or a specific port number.


    Attributes:
        random: random
        port: port
    """

    _ELEMENTS = (
        E("random", "random", str),
        E("port", "port", int),
    )

    random: str = Field(type=str, required=False, mutable=False)
    port: int = Field(type=int, required=False, mutable=False)


class Recurrence(OCIType):
    """
    Defines recurrence.


    Attributes:
        recur_daily: recurDaily
        recur_weekly: recurWeekly
        recur_monthly_by_day: recurMonthlyByDay
        recur_monthly_by_week: recurMonthlyByWeek
        recur_yearly_by_day: recurYearlyByDay
        recur_yearly_by_week: recurYearlyByWeek
        recur_for_ever: recurForEver
        recur_end_date: recurEndDate
        recur_end_occurrence: recurEndOccurrence
    """

    _ELEMENTS = (
        E("recur_daily", "recurDaily", str, is_complex=True),  # unknown
        E("recur_weekly", "recurWeekly", str, is_complex=True),  # unknown
        E("recur_monthly_by_day", "recurMonthlyByDay", str, is_complex=True),  # unknown
        E("recur_monthly_by_week", "recurMonthlyByWeek", str, is_complex=True),  # unknown
        E("recur_yearly_by_day", "recurYearlyByDay", str, is_complex=True),  # unknown
        E("recur_yearly_by_week", "recurYearlyByWeek", str, is_complex=True),  # unknown
        E("recur_for_ever", "recurForEver", bool),
        E("recur_end_date", "recurEndDate", str),
        E("recur_end_occurrence", "recurEndOccurrence", int),
    )

    recur_daily: str = Field(type=str, required=False, mutable=False)
    recur_weekly: str = Field(type=str, required=False, mutable=False)
    recur_monthly_by_day: str = Field(type=str, required=False, mutable=False)
    recur_monthly_by_week: str = Field(type=str, required=False, mutable=False)
    recur_yearly_by_day: str = Field(type=str, required=False, mutable=False)
    recur_yearly_by_week: str = Field(type=str, required=False, mutable=False)
    recur_for_ever: bool = Field(type=bool, required=False, mutable=False)
    recur_end_date: str = Field(type=str, required=False, mutable=False)
    recur_end_occurrence: int = Field(type=int, required=False, mutable=False)


class ReplacementCallProcessingPolicyProfileSubscriberTypeList(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType.

    The list replaces a previously configured list.

    Attributes:
        subscriber_type: subscriberType
    """

    _ELEMENTS = (
        E("subscriber_type", "subscriberType", str, is_required=True),
    )

    subscriber_type: str = Field(type=str, required=True, mutable=False)


class ReplacementCallProcessingPolicyProfileSubscriberTypeList20(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType20.

    The list replaces a previously configured list.

    Attributes:
        subscriber_type: subscriberType
    """

    _ELEMENTS = (
        E("subscriber_type", "subscriberType", str, is_required=True),
    )

    subscriber_type: str = Field(type=str, required=True, mutable=False)


class ReplacementCallProcessingPolicyProfileSubscriberTypeList21(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType21.

    The list replaces a previously configured list.

    Attributes:
        subscriber_type: subscriberType
    """

    _ELEMENTS = (
        E("subscriber_type", "subscriberType", str, is_required=True),
    )

    subscriber_type: str = Field(type=str, required=True, mutable=False)


class ReplacementCommunicationBarringAlternateCallIndicatorList(OCIType):
    """
    A list of Communication Barring Alternate Call Indicator that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        alternate_call_indicator: alternateCallIndicator
    """

    _ELEMENTS = (
        E("alternate_call_indicator", "alternateCallIndicator", str, is_required=True),
    )

    alternate_call_indicator: str = Field(type=str, required=True, mutable=False)


class ReplacementCommunicationBarringCallTypeList(OCIType):
    """
    A list of Communication Barring Call Types that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        call_type: callType
    """

    _ELEMENTS = (
        E("call_type", "callType", str, is_required=True),
    )

    call_type: str = Field(type=str, required=True, mutable=False)


class ReplacementContactList(OCIType):
    """
    A list of SIP contacts that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        contact: contact
    """

    _ELEMENTS = (
        E("contact", "contact", str, is_required=True),
    )

    contact: str = Field(type=str, required=True, mutable=False)


class ReplacementDNList(OCIType):
    """
    A list of dns that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)


class ReplacementEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group: trunkGroup
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_required=True),
    )

    trunk_group: str = Field(type=str, required=True, mutable=False)


class ReplacementGroupEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group: trunkGroup
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_required=True),
    )

    trunk_group: str = Field(type=str, required=True, mutable=False)


class ReplacementMediaNameList(OCIType):
    """
    A list of media that replaces a previously configured list.


    Attributes:
        media_name: mediaName
    """

    _ELEMENTS = (
        E("media_name", "mediaName", str, is_required=True),
    )

    media_name: str = Field(type=str, required=True, mutable=False)


class ReplacementNumberPortabilityStatusList(OCIType):
    """
    A list of Number Portability Query Statuses that replaces a previously configured
    list.

    By convention, an element of this type may be set to nill to clear the list.

    Attributes:
        status: status
    """

    _ELEMENTS = (
        E("status", "status", str, is_required=True),
    )

    status: str = Field(type=str, required=True, mutable=False)


class ReplacementOCICallControlApplicationIdList(OCIType):
    """
    A list of applicationIds that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        application_id: applicationId
    """

    _ELEMENTS = (
        E("application_id", "applicationId", str, is_required=True),
    )

    application_id: str = Field(type=str, required=True, mutable=False)


class ReplacementOutgoingDNList(OCIType):
    """
    A list of outgoing dns that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)


class ReplacementOutgoingDNorSIPURIList(OCIType):
    """
    A list of phone numbers or sipuris that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)


class ReplacementSIPAliasList(OCIType):
    """
    A list of SIP aliases that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        sip_alias: sipAlias
    """

    _ELEMENTS = (
        E("sip_alias", "sipAlias", str, is_required=True),
    )

    sip_alias: str = Field(type=str, required=True, mutable=False)


class ReplacementServicePackNameList(OCIType):
    """
    A list of service packs that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_required=True),
    )

    service_pack_name: str = Field(type=str, required=True, mutable=False)


class ReplacementUserIdList(OCIType):
    """
    A list of userIds that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ReplacementUserServiceList(OCIType):
    """
    A list of user services that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
    )

    service_name: str = Field(type=str, required=True, mutable=False)


class ReplacementVirtualOnNetCallTypeNameList(OCIType):
    """
    A list of Virtual On-Net Call Types that replaces a previously configured list.

    By convention, an element of this type may be set to nill to clear the list.

    Attributes:
        virtual_on_net_call_type_name: virtualOnNetCallTypeName
    """

    _ELEMENTS = (
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    virtual_on_net_call_type_name: str = Field(type=str, required=True, mutable=False)


class ReplacementZoneList(OCIType):
    """
    Contains an ordered list of zones to use to replace the current list of zones in an
    Office Zone.


    Attributes:
        zone_name: zoneName
    """

    _ELEMENTS = (
        E("zone_name", "zoneName", str, is_required=True),
    )

    zone_name: str = Field(type=str, required=True, mutable=False)


class ResponsePagingControl(OCIType):
    """
    Used in queries to restrict the set of result rows when making a request that can
    result in a large dataset.

    The client specifies the starting row and the number of rows requested.  The server
    only provides those rows in results, if available.

    Attributes:
        response_start_index: responseStartIndex
        response_page_size: responsePageSize
    """

    _ELEMENTS = (
        E("response_start_index", "responseStartIndex", int, is_required=True),
        E("response_page_size", "responsePageSize", int, is_required=True),
    )

    response_start_index: int = Field(type=int, required=True, mutable=False)
    response_page_size: int = Field(type=int, required=True, mutable=False)


class ScheduleKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules within a level(System, Service
    Provider, Group or User level).


    Attributes:
        schedule_name: scheduleName
        schedule_type: scheduleType
    """

    _ELEMENTS = (
        E("schedule_name", "scheduleName", str, is_required=True),
        E("schedule_type", "scheduleType", str, is_required=True),
    )

    schedule_name: str = Field(type=str, required=True, mutable=False)
    schedule_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteria(OCIType):
    """
    Abstract base type for specifying search criteria.

    A search criteria is an optional element used to restrict the number of rows returned
    when requesting a potentially large set of data from the provisioning server.
    """

    _ELEMENTS = ()


class SearchCriteriaAccessDeviceEndpointPrivateIdentity(OCIType):
    """
    Criteria for searching for a private identity.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAccessDeviceVersion(OCIType):
    """
    Criteria for searching for an Access Device Version.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAgentThresholdProfile(OCIType):
    """
    Criteria for searching a Call Center Agent Threshold Profile.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAlternateTrunkIdentity(OCIType):
    """
    Criteria for searching for a particular fully specified alternate trunk identity.

    In IMS mode, it only applies to the user part of alternate trunk identity.

    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAlternateTrunkIdentityDomain(OCIType):
    """
    Criteria for searching for alternate trunk identity domain part.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaAnnouncementFileName(OCIType):
    """
    Criteria for searching for an Announcement File Name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaCallCenterName(OCIType):
    """
    Criteria for searching for a call center

    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaCallCenterReportTemplateName(OCIType):
    """
    Criteria for searching for a particular call center enhanced reporting report
    template.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaCallCenterScheduledReportName(OCIType):
    """
    Criteria for searching for a call center enhanced reporting scheduled report name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDepartmentName(OCIType):
    """
    Criteria for searching for a user's department.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceMACAddress(OCIType):
    """
    Criteria for searching for device MAC address.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceManagementEventAdditionalInfo(OCIType):
    """
    Criteria for searching for a particular additional info of a DeviceManagement event.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceManagementEventLoginId(OCIType):
    """
    Criteria for searching for a particular login id.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceName(OCIType):
    """
    Criteria for searching for device name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceNetAddress(OCIType):
    """
    Criteria for searching for device network address.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceSerialNumber(OCIType):
    """
    Criteria for searching for device serial number.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDeviceType(OCIType):
    """
    Criteria for searching for device type.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaDn(OCIType):
    """
    Criteria for searching for a DN.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEmailAddress(OCIType):
    """
    Criteria for searching for a email address.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEnterpriseCommonPhoneListName(OCIType):
    """
    Criteria for searching for a name in an enterprise common phone list.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEnterpriseCommonPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in an enterprise common phone list.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaEnterpriseTrunkName(OCIType):
    """
    Criteria for searching for an Enterprise Trunk name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactCallCenterScheduledReportCreatedBySupervisor(OCIType):
    """
    Criteria for searching for call center scheduled report created by a supervisor or
    administrator.


    Attributes:
        created_by_supervisor: createdBySupervisor
    """

    _ELEMENTS = (
        E("created_by_supervisor", "createdBySupervisor", bool, is_required=True),
    )

    created_by_supervisor: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactCallCenterScheduledReportGroup(OCIType):
    """
    Criteria for searching for a particular fully specified call center scheduled report's
    group.


    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactCallCenterScheduledReportServiceProvider(OCIType):
    """
    Criteria for searching for a particular call center scheduled report's service
    provider.


    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactCustomContactDirectory(OCIType):
    """
    Criteria for searching for a particular fully specified custom contact directory.


    Attributes:
        custom_contact_directory_name: customContactDirectoryName
    """

    _ELEMENTS = (
        E(
            "custom_contact_directory_name", "customContactDirectoryName", str,
            is_required=True,
        ),
    )

    custom_contact_directory_name: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceLevel(OCIType):
    """
    Criteria for searching for a particular device level.


    Attributes:
        device_level: deviceLevel
    """

    _ELEMENTS = (
        E("device_level", "deviceLevel", str, is_required=True),
    )

    device_level: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventAction(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event action.


    Attributes:
        dm_event_action: dmEventAction
    """

    _ELEMENTS = (
        E("dm_event_action", "dmEventAction", str, is_required=True),
    )

    dm_event_action: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventLevel(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event level.


    Attributes:
        dm_event_level: dmEventLevel
    """

    _ELEMENTS = (
        E("dm_event_level", "dmEventLevel", str, is_required=True),
    )

    dm_event_level: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventStatusCompleted(OCIType):
    """
    Criteria for searching for a particular fully specified Device Management completed
    event status.


    Attributes:
        dm_event_status_completed: dmEventStatusCompleted
    """

    _ELEMENTS = (
        E("dm_event_status_completed", "dmEventStatusCompleted", str, is_required=True),
    )

    dm_event_status_completed: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceManagementEventStatusInProgressOrPending(OCIType):
    """
    Criteria for searching for a particular fully specified Device Management event in
    progress or pending status.


    Attributes:
        dm_event_status_in_progress_or_pending: dmEventStatusInProgressOrPending
    """

    _ELEMENTS = (
        E(
            "dm_event_status_in_progress_or_pending", "dmEventStatusInProgressOrPending",
            str, is_required=True,
        ),
    )

    dm_event_status_in_progress_or_pending: str = Field(
        type=str, required=True, mutable=False,
    )


class SearchCriteriaExactDeviceManagementEventType(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event type.


    Attributes:
        dm_event_type: dmEventType
    """

    _ELEMENTS = (
        E("dm_event_type", "dmEventType", str, is_required=True),
    )

    dm_event_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceServiceProvider(OCIType):
    """
    Criteria for searching for a particular fully specified service provider associated
    with a device.


    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDeviceType(OCIType):
    """
    Criteria for searching for a particular fully specified device type.


    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    device_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactDnActivation(OCIType):
    """
    Criteria for searching for a particular Dn activation state.


    Attributes:
        activated: activated
    """

    _ELEMENTS = (
        E("activated", "activated", bool, is_required=True),
    )

    activated: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactEndpointType(OCIType):
    """
    Criteria for searching for a particular endpoint type.


    Attributes:
        endpoint_type: endpointType
    """

    _ELEMENTS = (
        E("endpoint_type", "endpointType", str, is_required=True),
    )

    endpoint_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactMobileNetwork(OCIType):
    """
    Criteria for searching for a particular BroadWorks Mobility Mobile Network.


    Attributes:
        mobile_network_name: mobileNetworkName
    """

    _ELEMENTS = (
        E("mobile_network_name", "mobileNetworkName", str, is_required=True),
    )

    mobile_network_name: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactOrganizationType(OCIType):
    """
    Criteria for searching for an organization type.


    Attributes:
        organization_type: organizationType
    """

    _ELEMENTS = (
        E("organization_type", "organizationType", str, is_required=True),
    )

    organization_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactPolicySelection(OCIType):
    """
    Criteria for searching for a particular Voice VPN policy selection.


    Attributes:
        policy_selection: policySelection
    """

    _ELEMENTS = (
        E("policy_selection", "policySelection", str, is_required=True),
    )

    policy_selection: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactPortNumber(OCIType):
    """
    Criteria for searching for a port number.


    Attributes:
        port: port
    """

    _ELEMENTS = (
        E("port", "port", int, is_required=True),
    )

    port: int = Field(type=int, required=True, mutable=False)


class SearchCriteriaExactServiceProvider(OCIType):
    """
    Criteria for searching for a particular fully specified service provider.


    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactServiceType(OCIType):
    """
    Criteria for searching for a particular fully specified service type.


    Attributes:
        service_type: serviceType
    """

    _ELEMENTS = (
        E("service_type", "serviceType", str, is_required=True),
    )

    service_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactSignalingAddressType(OCIType):
    """
    Criteria for searching for a particular fully specified SignalingAddressType.


    Attributes:
        profile: profile
    """

    _ELEMENTS = (
        E("profile", "profile", str, is_required=True),
    )

    profile: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactSkillLevel(OCIType):
    """
    Criteria for searching for a skill Level.


    Attributes:
        skill_level: skillLevel
    """

    _ELEMENTS = (
        E("skill_level", "skillLevel", int, is_required=True),
    )

    skill_level: int = Field(type=int, required=True, mutable=False)


class SearchCriteriaExactUserGroup(OCIType):
    """
    Criteria for searching for a particular fully specified user's group.


    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactUserInTrunkGroup(OCIType):
    """
    Criteria for searching for user in/not in a trunk group.


    Attributes:
        user_in_trunk_group: userInTrunkGroup
    """

    _ELEMENTS = (
        E("user_in_trunk_group", "userInTrunkGroup", bool, is_required=True),
    )

    user_in_trunk_group: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactUserNetworkClassOfService(OCIType):
    """
    Criteria for searching for users with a specified network class of service.


    Attributes:
        network_class_of_service: networkClassOfService
    """

    _ELEMENTS = (
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    network_class_of_service: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactUserRouteListAssigned(OCIType):
    """
    Criteria for searching for users with/without Route List feature assigned.


    Attributes:
        route_list_assigned: routeListAssigned
    """

    _ELEMENTS = (
        E("route_list_assigned", "routeListAssigned", bool, is_required=True),
    )

    route_list_assigned: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactUserRouteListAssignment(OCIType):
    """
    Criteria for searching for users with Route List feature assignment.


    Attributes:
        assigned: assigned
    """

    _ELEMENTS = (
        E("assigned", "assigned", bool, is_required=True),
    )

    assigned: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaExactUserType(OCIType):
    """
    Criteria for searching for a particular User Type.


    Attributes:
        user_type: userType
    """

    _ELEMENTS = (
        E("user_type", "userType", str, is_required=True),
    )

    user_type: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactVirtualOnNetCallTypeName(OCIType):
    """
    Criteria for searching for a particular fully specified Virtual On-Net Call Type Name.


    Attributes:
        virtual_on_net_call_type_name: virtualOnNetCallTypeName
    """

    _ELEMENTS = (
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    virtual_on_net_call_type_name: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExtension(OCIType):
    """
    Criteria for searching for an extension.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupCommonPhoneListName(OCIType):
    """
    Criteria for searching for a name in a group common phone list.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupCommonPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in a group common phone list.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupId(OCIType):
    """
    Criteria for searching for a group ID.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupLocationCode(OCIType):
    """
    Criteria for searching for a group location dialing code.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaGroupName(OCIType):
    """
    Criteria for searching for a group name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaHomeMscAddress(OCIType):
    """
    Criteria for searching for a system Home Network Msc Address.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaIMRN(OCIType):
    """
    Criteria for searching for an IMRN Number.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaImpId(OCIType):
    """
    Criteria for searching for a user's IMP Id.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaLinePortDomain(OCIType):
    """
    Criteria for searching for device line/port, or SIPURI domain part.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaLinePortUserPart(OCIType):
    """
    Criteria for searching for device line/port, or SIPURI user part.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaLoginId(OCIType):
    """
    Criteria for searching for a Login Id.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaMobilePhoneNumber(OCIType):
    """
    Criteria for searching for a user's mobile phone number.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaMobileSubscriberDirectoryNumber(OCIType):
    """
    Criteria for searching for a BroadWorks Mobility Mobile Subscriber Directory Number.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaNumberPortabilityQueryDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaNumberPortabilityStatus(OCIType):
    """
    Criteria for searching for number portability status.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaOutgoingDNorSIPURI(OCIType):
    """
    Criteria for searching for a phone number or SIPURI.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaPersonalAssistantExclusionNumber(OCIType):
    """
    Criteria for searching for Personal Assistant Exclusion Number.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaPersonalAssistantExclusionNumberDescription(OCIType):
    """
    Criteria for searching Personal Assistant Exclusion Number's Description.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaPhysicalLocation(OCIType):
    """
    Criteria for searching for a Physical Location.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaRegistrationURI(OCIType):
    """
    Criteria for searching for a RegistrationURI.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaRoamingMscAddress(OCIType):
    """
    Criteria for searching for a system Roaming Network Msc Address.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaRoutePointName(OCIType):
    """
    Criteria for searching for a route point

    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaSIPContact(OCIType):
    """
    Criteria for searching for a SIP Contact.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceCode(OCIType):
    """
    Criteria for searching for a Service Code.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceCodeDescription(OCIType):
    """
    Criteria for searching for a Service Code description.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceInstanceName(OCIType):
    """
    Criteria for searching for a service instance name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceProviderId(OCIType):
    """
    Criteria for searching for a service provider ID.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceProviderName(OCIType):
    """
    Criteria for searching for a service provider name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaServiceProviderNumberPortabilityQueryDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaSystemServiceDn(OCIType):
    """
    Criteria for searching for a system service DN.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaTrunkGroupName(OCIType):
    """
    Criteria for searching for a trunk group

    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserFirstName(OCIType):
    """
    Criteria for searching for a user's first name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserId(OCIType):
    """
    Criteria for searching for a user's userId.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserLastName(OCIType):
    """
    Criteria for searching for a user's last name.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserPersonalPhoneListName(OCIType):
    """
    Criteria for searching for a name in a user personal phone list.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaUserPersonalPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in a user personal phone list.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaYahooId(OCIType):
    """
    Criteria for searching for a user's yahoo id.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SearchCriteriaZoneIPAddress(OCIType):
    """
    Criteria for searching for a system zone's IP Address.


    Attributes:
        mode: mode
        value: value
        is_case_insensitive: isCaseInsensitive
    """

    _ELEMENTS = (
        E("mode", "mode", str, is_required=True),
        E("value", "value", str, is_required=True),
        E("is_case_insensitive", "isCaseInsensitive", bool, is_required=True),
    )

    mode: str = Field(type=str, required=True, mutable=False)
    value: str = Field(type=str, required=True, mutable=False)
    is_case_insensitive: bool = Field(type=bool, required=True, mutable=False)


class SelectiveCallRejectionCriteriaCallType(OCIType):
    """
    The call type criteria used within an add/get request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str, is_required=True),
        E("include_anonymous_callers", "includeAnonymousCallers", bool, is_required=True),
        E("include_unavailable_callers", "includeUnavailableCallers", bool, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    from_dn_criteria_selection: str = Field(type=str, required=True, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=True, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class SequentialRingLocation(OCIType):
    """
    Sequential Ring Location.

    Replaced By: SequentialRingLocation14sp4

    Attributes:
        phone_number: phoneNumber
        number_of_rings: numberOfRings
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_rings", "numberOfRings", int, is_required=True),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    number_of_rings: int = Field(type=int, required=True, mutable=False)


class SequentialRingLocation14sp4(OCIType):
    """
    Sequential Ring Location.


    Attributes:
        phone_number: phoneNumber
        number_of_rings: numberOfRings
        answer_confirmation_required: answerConfirmationRequired
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_rings", "numberOfRings", int, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    number_of_rings: int = Field(type=int, required=True, mutable=False)
    answer_confirmation_required: bool = Field(type=bool, required=True, mutable=False)


class SequentialRingLocationModify(OCIType):
    """
    Sequential Ring Location.


    Attributes:
        phone_number: phoneNumber
        number_of_rings: numberOfRings
        answer_confirmation_required: answerConfirmationRequired
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str),
        E("number_of_rings", "numberOfRings", int),
        E("answer_confirmation_required", "answerConfirmationRequired", bool),
    )

    phone_number: str = Field(type=str, required=False, mutable=False)
    number_of_rings: int = Field(type=int, required=False, mutable=False)
    answer_confirmation_required: bool = Field(type=bool, required=False, mutable=False)


class ServiceActivation(OCIType):
    """
    Service Instance active status indicator

    Attributes:
        service_user_id: serviceUserId
        is_active: isActive
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderCommunicationBarringHierarchicalCallMeNowRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Call Me Now Rule

    Attributes:
        criteria: criteria
        digit_pattern_criteria: digitPatternCriteria
        action: action
        call_timeout_seconds: callTimeoutSeconds
        time_schedule: timeSchedule
        holiday_schedule: holidaySchedule
        priority: priority
    """

    _ELEMENTS = (
        E("criteria", "criteria", str),
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    criteria: str = Field(type=str, required=False, mutable=False)
    digit_pattern_criteria: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    time_schedule: str = Field(type=str, required=False, mutable=False)
    holiday_schedule: str = Field(type=str, required=False, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringHierarchicalOriginatingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Originating Rule

    Attributes:
        criteria: criteria
        digit_pattern_criteria: digitPatternCriteria
        action: action
        treatment_id: treatmentId
        transfer_number: transferNumber
        call_timeout_seconds: callTimeoutSeconds
        time_schedule: timeSchedule
        holiday_schedule: holidaySchedule
        priority: priority
    """

    _ELEMENTS = (
        E("criteria", "criteria", str),
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("action", "action", str, is_required=True),
        E("treatment_id", "treatmentId", str),
        E("transfer_number", "transferNumber", str),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    criteria: str = Field(type=str, required=False, mutable=False)
    digit_pattern_criteria: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    treatment_id: str = Field(type=str, required=False, mutable=False)
    transfer_number: str = Field(type=str, required=False, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    time_schedule: str = Field(type=str, required=False, mutable=False)
    holiday_schedule: str = Field(type=str, required=False, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringHierarchicalRedirectingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Redirecting Rule

    Attributes:
        criteria: criteria
        digit_pattern_criteria: digitPatternCriteria
        action: action
        call_timeout_seconds: callTimeoutSeconds
        time_schedule: timeSchedule
        holiday_schedule: holidaySchedule
        priority: priority
    """

    _ELEMENTS = (
        E("criteria", "criteria", str),
        E("digit_pattern_criteria", "digitPatternCriteria", str),
        E("action", "action", str, is_required=True),
        E("call_timeout_seconds", "callTimeoutSeconds", int),
        E("time_schedule", "timeSchedule", str),
        E("holiday_schedule", "holidaySchedule", str),
        E("priority", "priority", str, is_required=True),
    )

    criteria: str = Field(type=str, required=False, mutable=False)
    digit_pattern_criteria: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    call_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    time_schedule: str = Field(type=str, required=False, mutable=False)
    holiday_schedule: str = Field(type=str, required=False, mutable=False)
    priority: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.

    The response is either a ServiceProviderCommunicationBarringProfileGetResponse19sp1V2
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceScriptsFileResource(OCIType):
    """
    Service Scripts File Resource for uploading file content.


    Attributes:
        file_name: fileName
        script_content: scriptContent
    """

    _ELEMENTS = (
        E("file_name", "fileName", str, is_required=True),
        E("script_content", "scriptContent", str, is_required=True),
    )

    file_name: str = Field(type=str, required=True, mutable=False)
    script_content: str = Field(type=str, required=True, mutable=False)


class SimultaneousRingNumber(OCIType):
    """
    Simultaneous Ring number entry.


    Attributes:
        phone_number: phoneNumber
        answer_confirmation_required: answerConfirmationRequired
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)
    answer_confirmation_required: bool = Field(type=bool, required=True, mutable=False)


class SortByEnterpriseCommonPhoneListName(OCIType):
    """
    The sort criteria specifies the enterprise common phone list name as the column for
    the sort, whether sort is ascending or descending, and whether the sort is case
    sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByEnterpriseCommonPhoneListNumber(OCIType):
    """
    The sort criteria specifies the enterprise common phone list number as as the column
    for the sort, whether sort is ascending or descending, and whether the sort is case
    sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByGroupCommonPhoneListName(OCIType):
    """
    The sort criteria specifies the group common phone list name as the column for the
    sort, whether the sort is ascending or descending, and whether the sort is case
    sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByGroupCommonPhoneListNumber(OCIType):
    """
    The sort criteria specifies the group common phone list number as the column for the
    sort, whether sort is ascending or descending, and whether the sort is case sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByUserDepartment(OCIType):
    """
    The sort criteria specifies the user department name as the column for the sort,
    whether the sort is ascending or descending, and whether the sort is case sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByUserFirstName(OCIType):
    """
    The sort criteria specifies the user first name as the column for the sort, whether
    the sort is ascending or descending, and whether the sort is case sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByUserLastName(OCIType):
    """
    The sort criteria specifies the user last name as the column for the sort, whether the
    sort is ascending or descending, and whether the sort is case sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByUserPersonalPhoneListName(OCIType):
    """
    The sort criteria specifies the user personal phone list name as the column for the
    sort, whether sort is ascending or descending, and whether the sort is case sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortByUserPersonalPhoneListNumber(OCIType):
    """
    The sort criteria specifies the user personal phone list number as the column for the
    sort, whether the sort is ascending or descending, and whether the sort is case
    sensitive.


    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SortCriteria(OCIType):
    """
    The sort criteria specifies whether sort is ascending or descending, and whether the
    sort is case sensitive.

    Sort order defaults to ascending and case sensitive.

    Attributes:
        is_ascending: isAscending
        is_case_sensitive: isCaseSensitive
    """

    _ELEMENTS = (
        E("is_ascending", "isAscending", bool, is_required=True),
        E("is_case_sensitive", "isCaseSensitive", bool, is_required=True),
    )

    is_ascending: bool = Field(type=bool, required=True, mutable=False)
    is_case_sensitive: bool = Field(type=bool, required=True, mutable=False)


class SpeedDial100Entry(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        speed_code: speedCode
        phone_number: phoneNumber
        description: description
    """

    _ELEMENTS = (
        E("speed_code", "speedCode", int, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("description", "description", str),
    )

    speed_code: int = Field(type=int, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SpeedDial100EntryModify(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        speed_code: speedCode
        phone_number: phoneNumber
        description: description
    """

    _ELEMENTS = (
        E("speed_code", "speedCode", int, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("description", "description", str),
    )

    speed_code: int = Field(type=int, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SpeedDial8Entry(OCIType):
    """
    Modify the speed dial 8 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        speed_code: speedCode
        phone_number: phoneNumber
        description: description
    """

    _ELEMENTS = (
        E("speed_code", "speedCode", int, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("description", "description", str),
    )

    speed_code: int = Field(type=int, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class StreetAddress(OCIType):
    """
    Street address information.


    Attributes:
        address_line1: addressLine1
        address_line2: addressLine2
        city: city
        state_or_province: stateOrProvince
        state_or_province_display_name: stateOrProvinceDisplayName
        zip_or_postal_code: zipOrPostalCode
        country: country
    """

    _ELEMENTS = (
        E("address_line1", "addressLine1", str),
        E("address_line2", "addressLine2", str),
        E("city", "city", str),
        E("state_or_province", "stateOrProvince", str),
        E("state_or_province_display_name", "stateOrProvinceDisplayName", str),
        E("zip_or_postal_code", "zipOrPostalCode", str),
        E("country", "country", str),
    )

    address_line1: str = Field(type=str, required=False, mutable=False)
    address_line2: str = Field(type=str, required=False, mutable=False)
    city: str = Field(type=str, required=False, mutable=False)
    state_or_province: str = Field(type=str, required=False, mutable=False)
    state_or_province_display_name: str = Field(type=str, required=False, mutable=False)
    zip_or_postal_code: str = Field(type=str, required=False, mutable=False)
    country: str = Field(type=str, required=False, mutable=False)


class SystemCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.

    The response is either a SystemCommunicationBarringProfileGetResponse19sp1V2 or an
    ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemSIPDeviceTypeGetRequest18sp1V2(OCIType):
    """
    Request to get a sip device type.

    See Also: ``SystemDeviceTypeGetRequest()``

    The response is either ``SystemSIPDeviceTypeGetResponse19()`` or ``ErrorResponse()``.
    Replaced by: ``SystemSIPDeviceTypeGetRequest19()``.

    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    device_type: str = Field(type=str, required=True, mutable=False)


class TimeInterval(OCIType):
    """
    Time Interval.


    Attributes:
        start_day_of_week: startDayOfWeek
        start_hour: startHour
        start_minute: startMinute
        end_day_of_week: endDayOfWeek
        end_hour: endHour
        end_minute: endMinute
    """

    _ELEMENTS = (
        E("start_day_of_week", "startDayOfWeek", str, is_required=True),
        E("start_hour", "startHour", int, is_required=True),
        E("start_minute", "startMinute", int, is_required=True),
        E("end_day_of_week", "endDayOfWeek", str, is_required=True),
        E("end_hour", "endHour", int, is_required=True),
        E("end_minute", "endMinute", int, is_required=True),
    )

    start_day_of_week: str = Field(type=str, required=True, mutable=False)
    start_hour: int = Field(type=int, required=True, mutable=False)
    start_minute: int = Field(type=int, required=True, mutable=False)
    end_day_of_week: str = Field(type=str, required=True, mutable=False)
    end_hour: int = Field(type=int, required=True, mutable=False)
    end_minute: int = Field(type=int, required=True, mutable=False)


class TimeSchedule(OCIType):
    """
    The from dn criteria.


    Attributes:
        type: type
        name: name
    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    type: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class TrunkGroupDeviceEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify.


    Attributes:
        name: name
        line_port: linePort
        contact: contact
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify.


    Attributes:
        name: name
        line_port: linePort
        contact: contact
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceEndpointRead(OCIType):
    """
    Trunk group device endpoint.


    Attributes:
        service_user_id: serviceUserId
        name: name
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)


class TrunkGroupDeviceEndpointRead14sp4(OCIType):
    """
    Trunk group device endpoint.


    Attributes:
        name: name
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
        is_pilot_user: isPilotUser
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("is_pilot_user", "isPilotUser", bool, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)
    is_pilot_user: bool = Field(type=bool, required=True, mutable=False)


class TrunkGroupDeviceMultipleContactEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple
    contacts.


    Attributes:
        name: name
        line_port: linePort
        contact: contact
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceMultipleContactEndpointRead(OCIType):
    """
    Trunk group device endpoint that can have multiple contacts.


    Attributes:
        name: name
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
        is_pilot_user: isPilotUser
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("is_pilot_user", "isPilotUser", bool, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)
    is_pilot_user: bool = Field(type=bool, required=True, mutable=False)


class TrunkGroupKey(OCIType):
    """
    Uniquely identifies a Trunk Group system-wide.

    The trunkGroupName is unique within a group, but not unique system-wide.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class UnboundedNonNegativeInt(OCIType):
    """
    Unbounded Quantity.

    Can either be unlimited or a non-negative int quantity.

    Attributes:
        unlimited: unlimited
        quantity: quantity
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    unlimited: bool = Field(type=bool, required=False, mutable=False)
    quantity: int = Field(type=int, required=False, mutable=False)


class UnboundedPositiveInt(OCIType):
    """
    Unbounded Quantity.

    Can either be unlimited or a positive int quantity.

    Attributes:
        unlimited: unlimited
        quantity: quantity
    """

    _ELEMENTS = (
        E("unlimited", "unlimited", bool),
        E("quantity", "quantity", int),
    )

    unlimited: bool = Field(type=bool, required=False, mutable=False)
    quantity: int = Field(type=int, required=False, mutable=False)


class UserDisplayNames(OCIType):
    """
    The parts of a user's display name that a client can display in whatever way is
    appropriate for the client application.


    Attributes:
        last_name: lastName
        first_name: firstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
    """

    _ELEMENTS = (
        E("last_name", "lastName", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
    )

    last_name: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)


class UserEndpointKey(OCIType):
    """
    Key to uniquely identify a user endpoint.


    Attributes:
        user_id: userId
        line_port: linePort
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)


class UserEnhancedCallLogsGetListResponse17sp4V2(OCIType):
    """
    Response to UserEnhancedCallLogsGetListRequest17sp4V2.

    Total numbers of rows is: - the total number of retrievable logs of the call log type
    that was specified in the UserEnhancedCallLogsGetListRequest17sp4V2, if a call log
    type was specified in the request.  - the total number of retrievable logs, if no call
    log type was specified in the request.  A list of MixedCallLogsEntry will be returned
    if the call logs are stored on CDS A list of ExtendedMixedCallLogsEntry17sp4 will be
    returned if the call logs are stored on DBS The logs are sorted by date/time of the
    call.

    Attributes:
        total_number_of_rows: totalNumberOfRows
        legacy_entry: legacyEntry
        extended_entry: extendedEntry
    """

    _ELEMENTS = (
        E("total_number_of_rows", "totalNumberOfRows", int, is_required=True),
        E("legacy_entry", "legacyEntry", str, is_complex=True),  # unknown
        E("extended_entry", "extendedEntry", str, is_complex=True),  # unknown
    )

    total_number_of_rows: int = Field(type=int, required=True, mutable=False)
    legacy_entry: str = Field(type=str, required=False, mutable=False)
    extended_entry: str = Field(type=str, required=False, mutable=False)


class UserFeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all user modify command.


    Attributes:
        feature_access_code_name: featureAccessCodeName
        enable_fac: enableFAC
    """

    _ELEMENTS = (
        E("feature_access_code_name", "featureAccessCodeName", str, is_required=True),
        E("enable_fac", "enableFAC", bool),
    )

    feature_access_code_name: str = Field(type=str, required=True, mutable=False)
    enable_fac: bool = Field(type=bool, required=False, mutable=False)


class UserPreferredCarrierName(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.

    The user carrier name is exposed if it was previously configured.

    Attributes:
        use_group_preferred_carrier: useGroupPreferredCarrier
        carrier: carrier
    """

    _ELEMENTS = (
        E("use_group_preferred_carrier", "useGroupPreferredCarrier", bool, is_required=True),
        E("carrier", "carrier", str),
    )

    use_group_preferred_carrier: bool = Field(type=bool, required=True, mutable=False)
    carrier: str = Field(type=str, required=False, mutable=False)


class UserPreferredCarrierNameModify(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.

    You can use the group's preferred carrier without clearing the user carrier name -- in
    this case, the user carrier name is retained.

    Attributes:
        use_group_preferred_carrier: useGroupPreferredCarrier
        carrier: carrier
    """

    _ELEMENTS = (
        E("use_group_preferred_carrier", "useGroupPreferredCarrier", bool, is_required=True),
        E("carrier", "carrier", str),
    )

    use_group_preferred_carrier: bool = Field(type=bool, required=True, mutable=False)
    carrier: str = Field(type=str, required=False, mutable=False)


class UserTwoStageDialingGetRequest13Mp20(OCIType):
    """
    Request the user level data associated with Two Stage Dialing.

    The response is either a UserTwoStageDialingGetResponse13Mp20 or an
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class UserTwoStageDialingGetResponse13Mp20(OCIType):
    """
    Response to UserTwoStageDialingGetRequest13Mp20.


    Attributes:
        is_active: isActive
        allow_activation_with_user_addresses: allowActivationWithUserAddresses
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "allow_activation_with_user_addresses", "allowActivationWithUserAddresses",
            bool, is_required=True,
        ),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    allow_activation_with_user_addresses: bool = Field(
        type=bool, required=True, mutable=False,
    )


class VerifyTranslationAndRoutingOrigination(OCIType):
    """
    Verification Translation and Routing origination value.


    Attributes:
        line_port: linePort
        phone: phone
        user_id: userId
        url: url
    """

    _ELEMENTS = (
        E("line_port", "linePort", str),
        E("phone", "phone", str),
        E("user_id", "userId", str),
        E("url", "url", str),
    )

    line_port: str = Field(type=str, required=False, mutable=False)
    phone: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)
    url: str = Field(type=str, required=False, mutable=False)


class VirtualOnNetUser(OCIType):
    """
    Virtual On-Net User.


    Attributes:
        phone_number: phoneNumber
        extension: extension
        first_name: firstName
        last_name: lastName
        calling_line_id_first_name: callingLineIdFirstName
        calling_line_id_last_name: callingLineIdLastName
        virtual_on_net_call_type_name: virtualOnNetCallTypeName
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_required=True),
        E("extension", "extension", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    phone_number: str = Field(type=str, required=True, mutable=False)
    extension: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=True, mutable=False)
    last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    virtual_on_net_call_type_name: str = Field(type=str, required=True, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingRead(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.

    Attributes:
        name: name
        audio_file: audioFile
        video_file: videoFile
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("audio_file", "audioFile", str),
        E("video_file", "videoFile", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    audio_file: str = Field(type=str, required=False, mutable=False)
    video_file: str = Field(type=str, required=False, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingRead16(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.

    Attributes:
        name: name
        audio_file: audioFile
        audio_media_type: audioMediaType
        video_file: videoFile
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("audio_file", "audioFile", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file", "videoFile", str),
        E("video_media_type", "videoMediaType", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    audio_file: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class AccessDeviceEndpointAdd(OCIType):
    """
    Access device end point used in the context of add.

    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        port_number: portNumber
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("port_number", "portNumber", int),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)


class AccessDeviceEndpointKey(OCIType):
    """
    Access device end point in the context of a modify or delete command.


    Attributes:
        access_device: accessDevice
        line_port: linePort
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)


class AccessDeviceEndpointModify(OCIType):
    """
    Access device end point used in the context of modify.

    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        port_number: portNumber
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("port_number", "portNumber", int),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)


class AccessDeviceEndpointRead14(OCIType):
    """
    Access device end point.


    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)


class AccessDeviceEndpointWithPortNumberRead(OCIType):
    """
    Access device end point.

    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
        port_number: portNumber
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointAdd(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        port_number: portNumber
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("port_number", "portNumber", int),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointModify(OCIType):
    """
    Access device end point used in the context of modify that can have more than one
    contact defined.

    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact_list: contactList
        port_number: portNumber
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("line_port", "linePort", str),
        E("contact_list", "contactList", ReplacementContactList, is_complex=True),
        E("port_number", "portNumber", int),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=False, mutable=False)
    line_port: str = Field(type=str, required=False, mutable=False)
    contact_list: "ReplacementContactList" = Field(
        type=ReplacementContactList, required=False, mutable=False,
    )
    port_number: int = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    Replaced by AccessDeviceMultipleContactEndpointRead19.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)


class AccessDeviceMultipleContactEndpointRead19(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.  Replaced by
    AccessDeviceMultipleContactEndpointRead20.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
        port_number: portNumber
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)


class AccessDeviceMultipleContactEndpointRead20(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device: accessDevice
        line_port: linePort
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
        port_number: portNumber
        support_visual_device_management: supportVisualDeviceManagement
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
        E(
            "support_visual_device_management", "supportVisualDeviceManagement", bool,
            is_required=True,
        ),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)
    support_visual_device_management: bool = Field(type=bool, required=True, mutable=False)


class AccessDeviceMultipleIdentityAndContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in HSS data mode and not returned in AS data mode:
    privateIdentity The following elements are only used in AS data mode and a value false
    is returned in the HSS mode: supportVisualDeviceManagement

    Attributes:
        access_device: accessDevice
        line_port: linePort
        private_identity: privateIdentity
        contact: contact
        static_registration_capable: staticRegistrationCapable
        use_domain: useDomain
        port_number: portNumber
        support_visual_device_management: supportVisualDeviceManagement
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("contact", "contact", str),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("use_domain", "useDomain", bool, is_required=True),
        E("port_number", "portNumber", int),
        E(
            "support_visual_device_management", "supportVisualDeviceManagement", bool,
            is_required=True,
        ),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    private_identity: str = Field(type=str, required=False, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    use_domain: bool = Field(type=bool, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)
    support_visual_device_management: bool = Field(type=bool, required=True, mutable=False)


class AutoAttendantKeyConfigurationEntry(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file: audioFile
        video_file: videoFile
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )


class AutoAttendantKeyConfigurationEntry19(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file: audioFile
        video_file: videoFile
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    submenu_id: str = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationEntry20(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file: audioFile
        video_file: videoFile
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    submenu_id: str = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationModifyEntry(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file: audioFile
        video_file: videoFile
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    submenu_id: str = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationModifyEntry20(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file: audioFile
        video_file: videoFile
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    submenu_id: str = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyConfigurationReadEntry20(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: submenuId The following
    data elements are only valid for Standard Auto Attendants: submenuId

    Attributes:
        description: description
        action: action
        phone_number: phoneNumber
        audio_file: audioFile
        video_file: videoFile
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("action", "action", str, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E("submenu_id", "submenuId", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    action: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    submenu_id: str = Field(type=str, required=False, mutable=False)


class AutoAttendantKeyReadConfiguration(OCIType):
    """
    The read configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationReadEntry, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationReadEntry" = Field(
        type=AutoAttendantKeyConfigurationReadEntry, required=True, mutable=False,
    )


class AutoAttendantKeyReadConfiguration19(OCIType):
    """
    The read configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationReadEntry19, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationReadEntry19" = Field(
        type=AutoAttendantKeyConfigurationReadEntry19, required=True, mutable=False,
    )


class CPEDeviceOptionsRead(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    config_type: str = Field(type=str, required=True, mutable=False)
    system_file_name: str = Field(type=str, required=False, mutable=False)
    device_file_format: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeOptionsRead" = Field(
        type=DeviceManagementDeviceTypeOptionsRead, required=False, mutable=False,
    )


class CPEDeviceOptionsRead16(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead16, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    config_type: str = Field(type=str, required=True, mutable=False)
    system_file_name: str = Field(type=str, required=False, mutable=False)
    device_file_format: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeOptionsRead16" = Field(
        type=DeviceManagementDeviceTypeOptionsRead16, required=False, mutable=False,
    )


class CPEDeviceOptionsRead16sp1(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring: enableMonitoring
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("config_type", "configType", str),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead16, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    config_type: str = Field(type=str, required=False, mutable=False)
    system_file_name: str = Field(type=str, required=False, mutable=False)
    device_file_format: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeOptionsRead16" = Field(
        type=DeviceManagementDeviceTypeOptionsRead16, required=False, mutable=False,
    )


class CallCenterAgentStatistics13mp8(OCIType):
    """
    Contains Call Center statistics for a specified agent.


    Attributes:
        agent_user_id: agentUserId
        agent_display_names: agentDisplayNames
        available: available
        statistics_yesterday: statisticsYesterday
        statistics_today: statisticsToday
    """

    _ELEMENTS = (
        E("agent_user_id", "agentUserId", str, is_required=True),
        E(
            "agent_display_names", "agentDisplayNames", UserDisplayNames, is_complex=True,
            is_required=True,
        ),
        E("available", "available", bool, is_required=True),
        E(
            "statistics_yesterday", "statisticsYesterday",
            CallCenterAgentDailyStatistics13mp8, is_complex=True, is_required=True,
        ),
        E(
            "statistics_today", "statisticsToday", CallCenterAgentDailyStatistics13mp8,
            is_complex=True, is_required=True,
        ),
    )

    agent_user_id: str = Field(type=str, required=True, mutable=False)
    agent_display_names: "UserDisplayNames" = Field(
        type=UserDisplayNames, required=True, mutable=False,
    )
    available: bool = Field(type=bool, required=True, mutable=False)
    statistics_yesterday: "CallCenterAgentDailyStatistics13mp8" = Field(
        type=CallCenterAgentDailyStatistics13mp8, required=True, mutable=False,
    )
    statistics_today: "CallCenterAgentDailyStatistics13mp8" = Field(
        type=CallCenterAgentDailyStatistics13mp8, required=True, mutable=False,
    )


class CallCenterAgentStatistics14sp9(OCIType):
    """
    Contains Call Center statistics for a specified agent.


    Attributes:
        agent_user_id: agentUserId
        agent_display_names: agentDisplayNames
        available: available
        statistics: statistics
    """

    _ELEMENTS = (
        E("agent_user_id", "agentUserId", str, is_required=True),
        E(
            "agent_display_names", "agentDisplayNames", UserDisplayNames, is_complex=True,
            is_required=True,
        ),
        E("available", "available", bool, is_required=True),
        E("statistics", "statistics", AgentStatistics, is_complex=True, is_required=True),
    )

    agent_user_id: str = Field(type=str, required=True, mutable=False)
    agent_display_names: "UserDisplayNames" = Field(
        type=UserDisplayNames, required=True, mutable=False,
    )
    available: bool = Field(type=bool, required=True, mutable=False)
    statistics: "AgentStatistics" = Field(type=AgentStatistics, required=True, mutable=False)


class CallCenterAnnouncementFileListModify(OCIType):
    """
    Contains a list of audio or video files to modify.


    Attributes:
        file1: file1
        file2: file2
        file3: file3
        file4: file4
    """

    _ELEMENTS = (
        E("file1", "file1", LabeledMediaFileResource, is_complex=True),
        E("file2", "file2", LabeledMediaFileResource, is_complex=True),
        E("file3", "file3", LabeledMediaFileResource, is_complex=True),
        E("file4", "file4", LabeledMediaFileResource, is_complex=True),
    )

    file1: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    file2: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    file3: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    file4: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )


class CallCenterAnnouncementFileListModify20(OCIType):
    """
    Contains a list of announcement repository files

    Attributes:
        file1: file1
        file2: file2
        file3: file3
        file4: file4
    """

    _ELEMENTS = (
        E("file1", "file1", AnnouncementFileLevelKey, is_complex=True),
        E("file2", "file2", AnnouncementFileLevelKey, is_complex=True),
        E("file3", "file3", AnnouncementFileLevelKey, is_complex=True),
        E("file4", "file4", AnnouncementFileLevelKey, is_complex=True),
    )

    file1: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    file2: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    file3: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    file4: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )


class CallCenterAnnouncementFileListRead20(OCIType):
    """
    Contains a list of announcement repository files

    Attributes:
        file1: file1
        file2: file2
        file3: file3
        file4: file4
    """

    _ELEMENTS = (
        E("file1", "file1", AnnouncementFileLevelKey, is_complex=True),
        E("file2", "file2", AnnouncementFileLevelKey, is_complex=True),
        E("file3", "file3", AnnouncementFileLevelKey, is_complex=True),
        E("file4", "file4", AnnouncementFileLevelKey, is_complex=True),
    )

    file1: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    file2: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    file3: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    file4: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )


class CallCenterReplacementSkilledAgents(OCIType):
    """
    A list of agents grouped by skill levels.


    Attributes:
        skill_level: skillLevel
        agents: agents
    """

    _ELEMENTS = (
        E("skill_level", "skillLevel", int, is_required=True),
        E("agents", "agents", ReplacementUserIdList, is_complex=True, is_required=True),
    )

    skill_level: int = Field(type=int, required=True, mutable=False)
    agents: "ReplacementUserIdList" = Field(
        type=ReplacementUserIdList, required=True, mutable=False,
    )


class CallCenterReportIntervalDates(OCIType):
    """
    The call center enhanced reporting report interval, using dates.


    Attributes:
        start_date: startDate
        start_time: startTime
        end_date: endDate
        end_time: endTime
    """

    _ELEMENTS = (
        E("start_date", "startDate", str, is_required=True),
        E("start_time", "startTime", HourMinute, is_complex=True, is_required=True),
        E("end_date", "endDate", str, is_required=True),
        E("end_time", "endTime", HourMinute, is_complex=True, is_required=True),
    )

    start_date: str = Field(type=str, required=True, mutable=False)
    start_time: "HourMinute" = Field(type=HourMinute, required=True, mutable=False)
    end_date: str = Field(type=str, required=True, mutable=False)
    end_time: "HourMinute" = Field(type=HourMinute, required=True, mutable=False)


class CallCenterReportScheduleRecurrence(OCIType):
    """
    A recurring schedule for call center enhanced reporting scheduled report.


    Attributes:
        time_zone: timeZone
        start_date: startDate
        schedule_time: scheduleTime
        recurrence: recurrence
    """

    _ELEMENTS = (
        E("time_zone", "timeZone", str, is_required=True),
        E("start_date", "startDate", str, is_required=True),
        E("schedule_time", "scheduleTime", HourMinute, is_complex=True, is_required=True),
        E("recurrence", "recurrence", Recurrence, is_complex=True, is_required=True),
    )

    time_zone: str = Field(type=str, required=True, mutable=False)
    start_date: str = Field(type=str, required=True, mutable=False)
    schedule_time: "HourMinute" = Field(type=HourMinute, required=True, mutable=False)
    recurrence: "Recurrence" = Field(type=Recurrence, required=True, mutable=False)


class CallCenterReportScheduleTime(OCIType):
    """
    A scheduled time for call center enhanced reporting scheduled report.


    Attributes:
        time_zone: timeZone
        schedule_date: scheduleDate
        schedule_time: scheduleTime
    """

    _ELEMENTS = (
        E("time_zone", "timeZone", str, is_required=True),
        E("schedule_date", "scheduleDate", str, is_required=True),
        E("schedule_time", "scheduleTime", HourMinute, is_complex=True, is_required=True),
    )

    time_zone: str = Field(type=str, required=True, mutable=False)
    schedule_date: str = Field(type=str, required=True, mutable=False)
    schedule_time: "HourMinute" = Field(type=HourMinute, required=True, mutable=False)


class CallMeNowToDnCriteriaModify(OCIType):
    """
    The To dn criteria used on the call me now external number to be modified.


    Attributes:
        to_dn_criteria_selection: toDnCriteriaSelection
        phone_number_list: phoneNumberList
    """

    _ELEMENTS = (
        E("to_dn_criteria_selection", "toDnCriteriaSelection", str),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    to_dn_criteria_selection: str = Field(type=str, required=False, mutable=False)
    phone_number_list: "CriteriaReplacementDNList" = Field(
        type=CriteriaReplacementDNList, required=False, mutable=False,
    )


class CommPilotExpressAvailableInOffice(OCIType):
    """
    CommPilot Express Available In Office Settings.


    Attributes:
        additional_phone_number_to_ring: additionalPhoneNumberToRing
        busy_setting: busySetting
        no_answer_setting: noAnswerSetting
    """

    _ELEMENTS = (
        E("additional_phone_number_to_ring", "additionalPhoneNumberToRing", str),
        E(
            "busy_setting", "busySetting", CommPilotExpressRedirection, is_complex=True,
            is_required=True,
        ),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressRedirection,
            is_complex=True, is_required=True,
        ),
    )

    additional_phone_number_to_ring: str = Field(type=str, required=False, mutable=False)
    busy_setting: "CommPilotExpressRedirection" = Field(
        type=CommPilotExpressRedirection, required=True, mutable=False,
    )
    no_answer_setting: "CommPilotExpressRedirection" = Field(
        type=CommPilotExpressRedirection, required=True, mutable=False,
    )


class CommPilotExpressAvailableInOfficeModify(OCIType):
    """
    CommPilot Express Available In Office Settings.


    Attributes:
        additional_phone_number_to_ring: additionalPhoneNumberToRing
        busy_setting: busySetting
        no_answer_setting: noAnswerSetting
    """

    _ELEMENTS = (
        E("additional_phone_number_to_ring", "additionalPhoneNumberToRing", str),
        E("busy_setting", "busySetting", CommPilotExpressRedirectionModify, is_complex=True),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressRedirectionModify,
            is_complex=True,
        ),
    )

    additional_phone_number_to_ring: str = Field(type=str, required=False, mutable=False)
    busy_setting: "CommPilotExpressRedirectionModify" = Field(
        type=CommPilotExpressRedirectionModify, required=False, mutable=False,
    )
    no_answer_setting: "CommPilotExpressRedirectionModify" = Field(
        type=CommPilotExpressRedirectionModify, required=False, mutable=False,
    )


class CommPilotExpressAvailableOutOfOffice(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a get.


    Attributes:
        incoming_calls: incomingCalls
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirection,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressEmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    incoming_calls: "CommPilotExpressRedirection" = Field(
        type=CommPilotExpressRedirection, required=True, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressEmailNotify" = Field(
        type=CommPilotExpressEmailNotify, required=True, mutable=False,
    )


class CommPilotExpressAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a
    modify.


    Attributes:
        incoming_calls: incomingCalls
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirectionModify,
            is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressEmailNotifyModify, is_complex=True,
        ),
    )

    incoming_calls: "CommPilotExpressRedirectionModify" = Field(
        type=CommPilotExpressRedirectionModify, required=False, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressEmailNotifyModify" = Field(
        type=CommPilotExpressEmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressBusy(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a get.


    Attributes:
        incoming_calls: incomingCalls
        voice_mail_notify: voiceMailNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E(
            "voice_mail_notify", "voiceMailNotify", CommPilotExpressEmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    incoming_calls: "CommPilotExpressRedirectionWithException" = Field(
        type=CommPilotExpressRedirectionWithException, required=True, mutable=False,
    )
    voice_mail_notify: "CommPilotExpressEmailNotify" = Field(
        type=CommPilotExpressEmailNotify, required=True, mutable=False,
    )


class CommPilotExpressBusyModify(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a modify.


    Attributes:
        incoming_calls: incomingCalls
        voice_mail_notify: voiceMailNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressRedirectionWithExceptionModify, is_complex=True,
        ),
        E(
            "voice_mail_notify", "voiceMailNotify", CommPilotExpressEmailNotifyModify,
            is_complex=True,
        ),
    )

    incoming_calls: "CommPilotExpressRedirectionWithExceptionModify" = Field(
        type=CommPilotExpressRedirectionWithExceptionModify, required=False, mutable=False,
    )
    voice_mail_notify: "CommPilotExpressEmailNotifyModify" = Field(
        type=CommPilotExpressEmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressSRBusy(OCIType):
    """
    CommPilot Express SR Available In Office Configuration used in the context of a get.


    Attributes:
        incoming_calls: incomingCalls
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressSRRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    incoming_calls: "CommPilotExpressSRRedirectionWithException" = Field(
        type=CommPilotExpressSRRedirectionWithException, required=True, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotify" = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRBusyModify(OCIType):
    """
    CommPilot Express SR Available In Office Configuration used in the context of a
    modify.


    Attributes:
        incoming_calls: incomingCalls
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressSRRedirectionWithExceptionModify, is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    incoming_calls: "CommPilotExpressSRRedirectionWithExceptionModify" = Field(
        type=CommPilotExpressSRRedirectionWithExceptionModify, required=False,
        mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotifyModify" = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressSRRedirectionWithRingList(OCIType):
    """
    CommPilot Express SR Forward Numbers with number of times to ring.


    Attributes:
        number_entry: numberEntry
    """

    _ELEMENTS = (
        E(
            "number_entry", "numberEntry", CommPilotExpressSRRedirectionWithRing,
            is_complex=True,
        ),
    )

    number_entry: "CommPilotExpressSRRedirectionWithRing" = Field(
        type=CommPilotExpressSRRedirectionWithRing, required=False, mutable=False,
    )


class CommPilotExpressSRUnavailable(OCIType):
    """
    CommPilot Express SR Unavailable Configuration used in the context of a get.


    Attributes:
        incoming_calls: incomingCalls
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressSRRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    incoming_calls: "CommPilotExpressSRRedirectionWithException" = Field(
        type=CommPilotExpressSRRedirectionWithException, required=True, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotify" = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRUnavailableModify(OCIType):
    """
    CommPilot Express SR Unavailable Configuration used in the context of a modify.


    Attributes:
        incoming_calls: incomingCalls
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressSRRedirectionWithExceptionModify, is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    incoming_calls: "CommPilotExpressSRRedirectionWithExceptionModify" = Field(
        type=CommPilotExpressSRRedirectionWithExceptionModify, required=False,
        mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotifyModify" = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressUnavailable(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a get.


    Attributes:
        incoming_calls: incomingCalls
        voice_mail_greeting: voiceMailGreeting
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls", CommPilotExpressRedirectionWithException,
            is_complex=True, is_required=True,
        ),
        E("voice_mail_greeting", "voiceMailGreeting", str, is_required=True),
    )

    incoming_calls: "CommPilotExpressRedirectionWithException" = Field(
        type=CommPilotExpressRedirectionWithException, required=True, mutable=False,
    )
    voice_mail_greeting: str = Field(type=str, required=True, mutable=False)


class CommPilotExpressUnavailableModify(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a modify.


    Attributes:
        incoming_calls: incomingCalls
        voice_mail_greeting: voiceMailGreeting
    """

    _ELEMENTS = (
        E(
            "incoming_calls", "incomingCalls",
            CommPilotExpressRedirectionWithExceptionModify, is_complex=True,
        ),
        E("voice_mail_greeting", "voiceMailGreeting", str),
    )

    incoming_calls: "CommPilotExpressRedirectionWithExceptionModify" = Field(
        type=CommPilotExpressRedirectionWithExceptionModify, required=False, mutable=False,
    )
    voice_mail_greeting: str = Field(type=str, required=False, mutable=False)


class CriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number_list: phoneNumberList
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    from_dn_criteria_selection: str = Field(type=str, required=False, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=False, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=False, mutable=False)
    phone_number_list: "CriteriaReplacementDNList" = Field(
        type=CriteriaReplacementDNList, required=False, mutable=False,
    )


class DeviceManagementDeviceTypeModifyOptions(OCIType):
    """
    Device Management System device type options during a modify request.


    Attributes:
        device_access_protocol: deviceAccessProtocol
        tag_mode: tagMode
        tag_set: tagSet
        allow_device_profile_custom_tag_set: allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set: allowGroupCustomTagSet
        send_email_upon_reset_failure: sendEmailUponResetFailure
        device_access_net_address: deviceAccessNetAddress
        device_access_port: deviceAccessPort
        device_access_context: deviceAccessContext
        default_device_language: defaultDeviceLanguage
        default_device_encoding: defaultDeviceEncoding
        access_device_credentials: accessDeviceCredentials
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str),
        E("tag_mode", "tagMode", str),
        E("tag_set", "tagSet", str),
        E("allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool),
        E("send_email_upon_reset_failure", "sendEmailUponResetFailure", bool),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword, is_complex=True,
        ),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    device_access_protocol: str = Field(type=str, required=False, mutable=False)
    tag_mode: str = Field(type=str, required=False, mutable=False)
    tag_set: str = Field(type=str, required=False, mutable=False)
    allow_device_profile_custom_tag_set: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_group_custom_tag_set: bool = Field(type=bool, required=False, mutable=False)
    send_email_upon_reset_failure: bool = Field(type=bool, required=False, mutable=False)
    device_access_net_address: str = Field(type=str, required=False, mutable=False)
    device_access_port: int = Field(type=int, required=False, mutable=False)
    device_access_context: str = Field(type=str, required=False, mutable=False)
    default_device_language: str = Field(type=str, required=False, mutable=False)
    default_device_encoding: str = Field(type=str, required=False, mutable=False)
    access_device_credentials: "DeviceManagementUserNamePassword" = Field(
        type=DeviceManagementUserNamePassword, required=False, mutable=False,
    )
    use_http_digest_authentication: bool = Field(type=bool, required=False, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=False, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=False, mutable=False,
    )
    mac_in_non_request_uri: bool = Field(type=bool, required=False, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeModifyOptions16(OCIType):
    """
    Device Management System device type options during a modify request.


    Attributes:
        device_access_protocol: deviceAccessProtocol
        tag_mode: tagMode
        tag_set: tagSet
        allow_device_profile_custom_tag_set: allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set: allowGroupCustomTagSet
        send_email_upon_reset_failure: sendEmailUponResetFailure
        device_access_net_address: deviceAccessNetAddress
        device_access_port: deviceAccessPort
        device_access_context: deviceAccessContext
        default_device_language: defaultDeviceLanguage
        default_device_encoding: defaultDeviceEncoding
        access_device_credentials: accessDeviceCredentials
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str),
        E("tag_mode", "tagMode", str),
        E("tag_set", "tagSet", str),
        E("allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool),
        E("send_email_upon_reset_failure", "sendEmailUponResetFailure", bool),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword16, is_complex=True,
        ),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    device_access_protocol: str = Field(type=str, required=False, mutable=False)
    tag_mode: str = Field(type=str, required=False, mutable=False)
    tag_set: str = Field(type=str, required=False, mutable=False)
    allow_device_profile_custom_tag_set: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_group_custom_tag_set: bool = Field(type=bool, required=False, mutable=False)
    send_email_upon_reset_failure: bool = Field(type=bool, required=False, mutable=False)
    device_access_net_address: str = Field(type=str, required=False, mutable=False)
    device_access_port: int = Field(type=int, required=False, mutable=False)
    device_access_context: str = Field(type=str, required=False, mutable=False)
    default_device_language: str = Field(type=str, required=False, mutable=False)
    default_device_encoding: str = Field(type=str, required=False, mutable=False)
    access_device_credentials: "DeviceManagementUserNamePassword16" = Field(
        type=DeviceManagementUserNamePassword16, required=False, mutable=False,
    )
    use_http_digest_authentication: bool = Field(type=bool, required=False, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=False, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=False, mutable=False,
    )
    mac_in_non_request_uri: bool = Field(type=bool, required=False, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeOptions(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol: deviceAccessProtocol
        tag_mode: tagMode
        tag_set: tagSet
        allow_device_profile_custom_tag_set: allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set: allowGroupCustomTagSet
        send_email_upon_reset_failure: sendEmailUponResetFailure
        device_access_net_address: deviceAccessNetAddress
        device_access_port: deviceAccessPort
        device_access_context: deviceAccessContext
        device_access_uri: deviceAccessURI
        default_device_language: defaultDeviceLanguage
        default_device_encoding: defaultDeviceEncoding
        access_device_credentials: accessDeviceCredentials
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword, is_complex=True,
        ),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    tag_mode: str = Field(type=str, required=True, mutable=False)
    tag_set: str = Field(type=str, required=False, mutable=False)
    allow_device_profile_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    allow_group_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    send_email_upon_reset_failure: bool = Field(type=bool, required=True, mutable=False)
    device_access_net_address: str = Field(type=str, required=False, mutable=False)
    device_access_port: int = Field(type=int, required=False, mutable=False)
    device_access_context: str = Field(type=str, required=False, mutable=False)
    device_access_uri: str = Field(type=str, required=False, mutable=False)
    default_device_language: str = Field(type=str, required=False, mutable=False)
    default_device_encoding: str = Field(type=str, required=False, mutable=False)
    access_device_credentials: "DeviceManagementUserNamePassword" = Field(
        type=DeviceManagementUserNamePassword, required=False, mutable=False,
    )
    use_http_digest_authentication: bool = Field(type=bool, required=True, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=True, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=True, mutable=False,
    )
    mac_in_non_request_uri: bool = Field(type=bool, required=True, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)


class DeviceManagementDeviceTypeOptions16(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol: deviceAccessProtocol
        tag_mode: tagMode
        tag_set: tagSet
        allow_device_profile_custom_tag_set: allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set: allowGroupCustomTagSet
        send_email_upon_reset_failure: sendEmailUponResetFailure
        device_access_net_address: deviceAccessNetAddress
        device_access_port: deviceAccessPort
        device_access_context: deviceAccessContext
        device_access_uri: deviceAccessURI
        default_device_language: defaultDeviceLanguage
        default_device_encoding: defaultDeviceEncoding
        access_device_credentials: accessDeviceCredentials
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("tag_mode", "tagMode", str, is_required=True),
        E("tag_set", "tagSet", str),
        E(
            "allow_device_profile_custom_tag_set", "allowDeviceProfileCustomTagSet", bool,
            is_required=True,
        ),
        E("allow_group_custom_tag_set", "allowGroupCustomTagSet", bool, is_required=True),
        E(
            "send_email_upon_reset_failure", "sendEmailUponResetFailure", bool,
            is_required=True,
        ),
        E("device_access_net_address", "deviceAccessNetAddress", str),
        E("device_access_port", "deviceAccessPort", int),
        E("device_access_context", "deviceAccessContext", str),
        E("device_access_uri", "deviceAccessURI", str),
        E("default_device_language", "defaultDeviceLanguage", str),
        E("default_device_encoding", "defaultDeviceEncoding", str),
        E(
            "access_device_credentials", "accessDeviceCredentials",
            DeviceManagementUserNamePassword16, is_complex=True,
        ),
        E(
            "use_http_digest_authentication", "useHttpDigestAuthentication", bool,
            is_required=True,
        ),
        E(
            "mac_based_file_authentication", "macBasedFileAuthentication", bool,
            is_required=True,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool, is_required=True,
        ),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool, is_required=True),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    tag_mode: str = Field(type=str, required=True, mutable=False)
    tag_set: str = Field(type=str, required=False, mutable=False)
    allow_device_profile_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    allow_group_custom_tag_set: bool = Field(type=bool, required=True, mutable=False)
    send_email_upon_reset_failure: bool = Field(type=bool, required=True, mutable=False)
    device_access_net_address: str = Field(type=str, required=False, mutable=False)
    device_access_port: int = Field(type=int, required=False, mutable=False)
    device_access_context: str = Field(type=str, required=False, mutable=False)
    device_access_uri: str = Field(type=str, required=False, mutable=False)
    default_device_language: str = Field(type=str, required=False, mutable=False)
    default_device_encoding: str = Field(type=str, required=False, mutable=False)
    access_device_credentials: "DeviceManagementUserNamePassword16" = Field(
        type=DeviceManagementUserNamePassword16, required=False, mutable=False,
    )
    use_http_digest_authentication: bool = Field(type=bool, required=True, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=True, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=True, mutable=False,
    )
    mac_in_non_request_uri: bool = Field(type=bool, required=True, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)


class EnhancedCallLogsNumberFilter(OCIType):
    """
    Filter criteria based on the called number or number called.


    Attributes:
        include_basic_call_type: includeBasicCallType
        include_call_category: includeCallCategory
        include_configurable_call_type: includeConfigurableCallType
        search_criteria_dialed_number: searchCriteriaDialedNumber
        search_criteria_called_number: searchCriteriaCalledNumber
        search_criteria_network_translated_number: searchCriteriaNetworkTranslatedNumber
        search_criteria_calling_presentation_number:
            searchCriteriaCallingPresentationNumber
    """

    _ELEMENTS = (
        E("include_basic_call_type", "includeBasicCallType", str),
        E("include_call_category", "includeCallCategory", str),
        E("include_configurable_call_type", "includeConfigurableCallType", str),
        E(
            "search_criteria_dialed_number", "searchCriteriaDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_called_number", "searchCriteriaCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_network_translated_number",
            "searchCriteriaNetworkTranslatedNumber", SearchCriteriaOutgoingDNorSIPURI,
            is_complex=True,
        ),
        E(
            "search_criteria_calling_presentation_number",
            "searchCriteriaCallingPresentationNumber", SearchCriteriaOutgoingDNorSIPURI,
            is_complex=True,
        ),
    )

    include_basic_call_type: str = Field(type=str, required=False, mutable=False)
    include_call_category: str = Field(type=str, required=False, mutable=False)
    include_configurable_call_type: str = Field(type=str, required=False, mutable=False)
    search_criteria_dialed_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_called_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_network_translated_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_calling_presentation_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )


class EnhancedCallLogsRedirectedNumberFilter(OCIType):
    """
    Filter criteria based on the transferred/forwarded number.


    Attributes:
        redirected_call: redirectedCall
        include_service_invocation_basic_call_type: includeServiceInvocationBasicCallType
        include_service_invocation_call_category: includeServiceInvocationCallCategory
        include_service_invocation_configurable_call_type:
            includeServiceInvocationConfigurableCallType
        search_criteria_service_invocation_dialed_number:
            searchCriteriaServiceInvocationDialedNumber
        search_criteria_service_invocation_called_number:
            searchCriteriaServiceInvocationCalledNumber
        search_criteria_service_invocation_network_translated_number:
            searchCriteriaServiceInvocationNetworkTranslatedNumber
    """

    _ELEMENTS = (
        E(
            "redirected_call", "redirectedCall", EnhancedCallLogsRedirectedCallSelection,
            is_complex=True,
        ),
        E(
            "include_service_invocation_basic_call_type",
            "includeServiceInvocationBasicCallType", str,
        ),
        E(
            "include_service_invocation_call_category",
            "includeServiceInvocationCallCategory", str,
        ),
        E(
            "include_service_invocation_configurable_call_type",
            "includeServiceInvocationConfigurableCallType", str,
        ),
        E(
            "search_criteria_service_invocation_dialed_number",
            "searchCriteriaServiceInvocationDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_called_number",
            "searchCriteriaServiceInvocationCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_network_translated_number",
            "searchCriteriaServiceInvocationNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
    )

    redirected_call: "EnhancedCallLogsRedirectedCallSelection" = Field(
        type=EnhancedCallLogsRedirectedCallSelection, required=False, mutable=False,
    )
    include_service_invocation_basic_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    include_service_invocation_call_category: str = Field(
        type=str, required=False, mutable=False,
    )
    include_service_invocation_configurable_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    search_criteria_service_invocation_dialed_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_service_invocation_called_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_service_invocation_network_translated_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )


class EnhancedCallLogsRedirectedNumberFilter21(OCIType):
    """
    Filter criteria based on the transferred/forwarded number.


    Attributes:
        redirected_call: redirectedCall
        include_service_invocation_basic_call_type: includeServiceInvocationBasicCallType
        include_service_invocation_call_category: includeServiceInvocationCallCategory
        include_service_invocation_configurable_call_type:
            includeServiceInvocationConfigurableCallType
        search_criteria_service_invocation_dialed_number:
            searchCriteriaServiceInvocationDialedNumber
        search_criteria_service_invocation_called_number:
            searchCriteriaServiceInvocationCalledNumber
        search_criteria_service_invocation_network_translated_number:
            searchCriteriaServiceInvocationNetworkTranslatedNumber
    """

    _ELEMENTS = (
        E(
            "redirected_call", "redirectedCall",
            EnhancedCallLogsRedirectedCallSelection21, is_complex=True,
        ),
        E(
            "include_service_invocation_basic_call_type",
            "includeServiceInvocationBasicCallType", str,
        ),
        E(
            "include_service_invocation_call_category",
            "includeServiceInvocationCallCategory", str,
        ),
        E(
            "include_service_invocation_configurable_call_type",
            "includeServiceInvocationConfigurableCallType", str,
        ),
        E(
            "search_criteria_service_invocation_dialed_number",
            "searchCriteriaServiceInvocationDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_called_number",
            "searchCriteriaServiceInvocationCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
        E(
            "search_criteria_service_invocation_network_translated_number",
            "searchCriteriaServiceInvocationNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI, is_complex=True,
        ),
    )

    redirected_call: "EnhancedCallLogsRedirectedCallSelection21" = Field(
        type=EnhancedCallLogsRedirectedCallSelection21, required=False, mutable=False,
    )
    include_service_invocation_basic_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    include_service_invocation_call_category: str = Field(
        type=str, required=False, mutable=False,
    )
    include_service_invocation_configurable_call_type: str = Field(
        type=str, required=False, mutable=False,
    )
    search_criteria_service_invocation_dialed_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_service_invocation_called_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )
    search_criteria_service_invocation_network_translated_number: "SearchCriteriaOutgoingDNorSIPURI" = Field(
        type=SearchCriteriaOutgoingDNorSIPURI, required=False, mutable=False,
    )


class EnterpriseAccessDevice(OCIType):
    """
    Uniquely identifies an access device accessible for an enterprise.

    It could be a system level device, an enterprise level device or a group level device.

    Attributes:
        access_device: accessDevice
        group_id: groupId
    """

    _ELEMENTS = (
        E("access_device", "accessDevice", AccessDevice, is_complex=True, is_required=True),
        E("group_id", "groupId", str),
    )

    access_device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)
    group_id: str = Field(type=str, required=False, mutable=False)


class EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group

    Attributes:
        trunk_group: trunkGroup
        priority: priority
        weight: weight
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", EnterpriseTrunkTrunkGroupKey, is_complex=True,
            is_required=True,
        ),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    trunk_group: "EnterpriseTrunkTrunkGroupKey" = Field(
        type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False,
    )
    priority: int = Field(type=int, required=True, mutable=False)
    weight: int = Field(type=int, required=True, mutable=False)


class EnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group

    Attributes:
        trunk_group: trunkGroup
        priority: priority
        weight: weight
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", EnterpriseTrunkTrunkGroupKey, is_complex=True,
            is_required=True,
        ),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    trunk_group: "EnterpriseTrunkTrunkGroupKey" = Field(
        type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False,
    )
    priority: int = Field(type=int, required=True, mutable=False)
    weight: int = Field(type=int, required=True, mutable=False)


class ExecutiveCallFilteringCriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria modify request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number_list: phoneNumberList
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    from_dn_criteria_selection: str = Field(type=str, required=False, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=False, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=False, mutable=False)
    phone_number_list: "CriteriaReplacementDNList" = Field(
        type=CriteriaReplacementDNList, required=False, mutable=False,
    )


class ExtendedFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.


    Attributes:
        file: file
        url: url
    """

    _ELEMENTS = (
        E("file", "file", LabeledFileResource, is_complex=True),
        E("url", "url", str),
    )

    file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )
    url: str = Field(type=str, required=False, mutable=False)


class ExtendedMediaFileLevelResource20(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.


    Attributes:
        file: file
        url: url
    """

    _ELEMENTS = (
        E("file", "file", AnnouncementFileLevelKey, is_complex=True),
        E("url", "url", str),
    )

    file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    url: str = Field(type=str, required=False, mutable=False)


class ExtendedMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.


    Attributes:
        file: file
        url: url
    """

    _ELEMENTS = (
        E("file", "file", LabeledMediaFileResource, is_complex=True),
        E("url", "url", str),
    )

    file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    url: str = Field(type=str, required=False, mutable=False)


class ExtendedMediaFileResource20(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer and an URL.


    Attributes:
        file: file
        url: url
    """

    _ELEMENTS = (
        E("file", "file", AnnouncementFileKey, is_complex=True),
        E("url", "url", str),
    )

    file: "AnnouncementFileKey" = Field(
        type=AnnouncementFileKey, required=False, mutable=False,
    )
    url: str = Field(type=str, required=False, mutable=False)


class GroupServiceAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a group service.


    Attributes:
        service_name: serviceName
        authorized_quantity: authorizedQuantity
        unauthorized: unauthorized
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("authorized_quantity", "authorizedQuantity", UnboundedPositiveInt, is_complex=True),
        E("unauthorized", "unauthorized", bool),
    )

    service_name: str = Field(type=str, required=True, mutable=False)
    authorized_quantity: "UnboundedPositiveInt" = Field(
        type=UnboundedPositiveInt, required=False, mutable=False,
    )
    unauthorized: bool = Field(type=bool, required=False, mutable=False)


class GroupTrunkGroupGetInstanceRequest14sp9A(OCIType):
    """
    Get a Trunk Group Instance's profile.

    The response is either a GroupTrunkGroupGetInstanceResponse14sp9A or an
    ``ErrorResponse()``. The response contains a hosted user table with column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name".

    Attributes:
        trunk_group_key: trunkGroupKey
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    trunk_group_key: "TrunkGroupKey" = Field(type=TrunkGroupKey, required=True, mutable=False)


class GroupTrunkGroupGetInstanceRequest17sp4V2(OCIType):
    """
    Get a Trunk Group Instance's profile.

    The response is either a GroupTrunkGroupGetInstanceResponse17sp4V2 or an
    ``ErrorResponse()``. The response contains a hosted user table with column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name".
    Replaced by: ``GroupTrunkGroupGetInstanceRequest19V2()``

    Attributes:
        trunk_group_key: trunkGroupKey
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    trunk_group_key: "TrunkGroupKey" = Field(type=TrunkGroupKey, required=True, mutable=False)


class GroupTrunkGroupGetInstanceRequest19sp1V2(OCIType):
    """
    Get a Trunk Group Instance's profile.

    The response is either a GroupTrunkGroupGetInstanceResponse19sp1V2 or an
    ``ErrorResponse()``. The response contains a hosted user table with column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address". Replaced by:
    ``GroupTrunkGroupGetInstanceRequest20sp1()``

    Attributes:
        trunk_group_key: trunkGroupKey
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    trunk_group_key: "TrunkGroupKey" = Field(type=TrunkGroupKey, required=True, mutable=False)


class GroupTrunkGroupGetInstanceResponse14sp9A(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest14sp9A.

    Returns the profile information for the Trunk Group.  Contains a hosted user table
    with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name".

    Attributes:
        pilot_user_id: pilotUserId
        department: department
        access_device: accessDevice
        max_active_calls: maxActiveCalls
        max_incoming_calls: maxIncomingCalls
        max_outgoing_calls: maxOutgoingCalls
        enable_bursting: enableBursting
        bursting_max_active_calls: burstingMaxActiveCalls
        bursting_max_incoming_calls: burstingMaxIncomingCalls
        bursting_max_outgoing_calls: burstingMaxOutgoingCalls
        capacity_exceeded_action: capacityExceededAction
        capacity_exceeded_forward_address: capacityExceededForwardAddress
        capacity_exceeded_reroute_trunk_group_key: capacityExceededRerouteTrunkGroupKey
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
        unreachable_destination_action: unreachableDestinationAction
        unreachable_destination_forward_address: unreachableDestinationForwardAddress
        unreachable_destination_reroute_trunk_group_key:
            unreachableDestinationRerouteTrunkGroupKey
        unreachable_destination_trap_initial_calls: unreachableDestinationTrapInitialCalls
        unreachable_destination_trap_offset_calls: unreachableDestinationTrapOffsetCalls
        invitation_timeout: invitationTimeout
        require_authentication: requireAuthentication
        sip_authentication_user_name: sipAuthenticationUserName
        hosted_user_table: hostedUserTable
        trunk_group_identity: trunkGroupIdentity
        otg_dtg_identity: otgDtgIdentity
        include_trunk_group_identity: includeTrunkGroupIdentity
        include_dtg_identity: includeDtgIdentity
        enable_network_address_identity: enableNetworkAddressIdentity
        allow_unscreened_calls: allowUnscreenedCalls
        allow_unscreened_emergency_calls: allowUnscreenedEmergencyCalls
        pilot_user_calling_line_identity_policy: pilotUserCallingLineIdentityPolicy
        pilot_user_charge_number_policy: pilotUserChargeNumberPolicy
        call_forwarding_always_action: callForwardingAlwaysAction
        call_forwarding_always_forward_address: callForwardingAlwaysForwardAddress
        call_forwarding_always_reroute_trunk_group_key:
            callForwardingAlwaysRerouteTrunkGroupKey
    """

    _ELEMENTS = (
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls", int, is_required=True,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls", int, is_required=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("hosted_user_table", "hostedUserTable", list, is_complex=True, is_table=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
    )

    pilot_user_id: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    access_device: "AccessDevice" = Field(type=AccessDevice, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=True, mutable=False)
    max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    enable_bursting: bool = Field(type=bool, required=True, mutable=False)
    bursting_max_active_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_action: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_forward_address: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=True, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=True, mutable=False)
    unreachable_destination_action: str = Field(type=str, required=False, mutable=False)
    unreachable_destination_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    unreachable_destination_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    unreachable_destination_trap_initial_calls: int = Field(
        type=int, required=True, mutable=False,
    )
    unreachable_destination_trap_offset_calls: int = Field(
        type=int, required=True, mutable=False,
    )
    invitation_timeout: int = Field(type=int, required=True, mutable=False)
    require_authentication: bool = Field(type=bool, required=True, mutable=False)
    sip_authentication_user_name: str = Field(type=str, required=False, mutable=False)
    hosted_user_table: "list" = Field(type=list, required=False, mutable=False)
    trunk_group_identity: str = Field(type=str, required=False, mutable=False)
    otg_dtg_identity: str = Field(type=str, required=False, mutable=False)
    include_trunk_group_identity: bool = Field(type=bool, required=True, mutable=False)
    include_dtg_identity: bool = Field(type=bool, required=True, mutable=False)
    enable_network_address_identity: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_calls: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_emergency_calls: bool = Field(type=bool, required=True, mutable=False)
    pilot_user_calling_line_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    pilot_user_charge_number_policy: str = Field(type=str, required=True, mutable=False)
    call_forwarding_always_action: str = Field(type=str, required=False, mutable=False)
    call_forwarding_always_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    call_forwarding_always_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )


class GroupTrunkGroupGetInstanceResponse17sp4V2(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest17sp4V2.

    Returns the profile information for the Trunk Group.  Contains a hosted user table
    with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name". Replaced by: ``GroupTrunkGroupGetInstanceResponse19V2()``

    Attributes:
        pilot_user_id: pilotUserId
        department: department
        access_device: accessDevice
        max_active_calls: maxActiveCalls
        max_incoming_calls: maxIncomingCalls
        max_outgoing_calls: maxOutgoingCalls
        enable_bursting: enableBursting
        bursting_max_active_calls: burstingMaxActiveCalls
        bursting_max_incoming_calls: burstingMaxIncomingCalls
        bursting_max_outgoing_calls: burstingMaxOutgoingCalls
        capacity_exceeded_action: capacityExceededAction
        capacity_exceeded_forward_address: capacityExceededForwardAddress
        capacity_exceeded_reroute_trunk_group_key: capacityExceededRerouteTrunkGroupKey
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
        unreachable_destination_action: unreachableDestinationAction
        unreachable_destination_forward_address: unreachableDestinationForwardAddress
        unreachable_destination_reroute_trunk_group_key:
            unreachableDestinationRerouteTrunkGroupKey
        invitation_timeout: invitationTimeout
        require_authentication: requireAuthentication
        sip_authentication_user_name: sipAuthenticationUserName
        hosted_user_table: hostedUserTable
        trunk_group_identity: trunkGroupIdentity
        otg_dtg_identity: otgDtgIdentity
        allow_termination_to_trunk_group_identity: allowTerminationToTrunkGroupIdentity
        allow_termination_to_dtg_identity: allowTerminationToDtgIdentity
        include_trunk_group_identity: includeTrunkGroupIdentity
        include_dtg_identity: includeDtgIdentity
        include_trunk_group_identity_for_network_calls:
            includeTrunkGroupIdentityForNetworkCalls
        include_otg_identity_for_network_calls: includeOtgIdentityForNetworkCalls
        enable_network_address_identity: enableNetworkAddressIdentity
        allow_unscreened_calls: allowUnscreenedCalls
        allow_unscreened_emergency_calls: allowUnscreenedEmergencyCalls
        pilot_user_calling_line_identity_policy: pilotUserCallingLineIdentityPolicy
        pilot_user_charge_number_policy: pilotUserChargeNumberPolicy
        call_forwarding_always_action: callForwardingAlwaysAction
        call_forwarding_always_forward_address: callForwardingAlwaysForwardAddress
        call_forwarding_always_reroute_trunk_group_key:
            callForwardingAlwaysRerouteTrunkGroupKey
        peering_domain: peeringDomain
        route_to_peering_domain: routeToPeeringDomain
        prefix_enabled: prefixEnabled
        prefix: prefix
        stateful_rerouting_enabled: statefulReroutingEnabled
        send_continuous_options_message: sendContinuousOptionsMessage
        continuous_options_sending_interval_seconds:
            continuousOptionsSendingIntervalSeconds
        failure_options_sending_interval_seconds: failureOptionsSendingIntervalSeconds
        failure_threshold_counter: failureThresholdCounter
        success_threshold_counter: successThresholdCounter
        invite_failure_threshold_counter: inviteFailureThresholdCounter
        invite_failure_threshold_window_seconds: inviteFailureThresholdWindowSeconds
        trunk_group_state: trunkGroupState
        pilot_user_calling_line_asserted_identity_policy:
            pilotUserCallingLineAssertedIdentityPolicy
        use_system_calling_line_asserted_identity_policy:
            useSystemCallingLineAssertedIdentityPolicy
    """

    _ELEMENTS = (
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("hosted_user_table", "hostedUserTable", list, is_complex=True, is_table=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "allow_termination_to_trunk_group_identity",
            "allowTerminationToTrunkGroupIdentity", bool, is_required=True,
        ),
        E(
            "allow_termination_to_dtg_identity", "allowTerminationToDtgIdentity", bool,
            is_required=True,
        ),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "include_trunk_group_identity_for_network_calls",
            "includeTrunkGroupIdentityForNetworkCalls", bool, is_required=True,
        ),
        E(
            "include_otg_identity_for_network_calls", "includeOtgIdentityForNetworkCalls",
            bool, is_required=True,
        ),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("peering_domain", "peeringDomain", str),
        E("route_to_peering_domain", "routeToPeeringDomain", bool, is_required=True),
        E("prefix_enabled", "prefixEnabled", bool, is_required=True),
        E("prefix", "prefix", str),
        E("stateful_rerouting_enabled", "statefulReroutingEnabled", bool, is_required=True),
        E(
            "send_continuous_options_message", "sendContinuousOptionsMessage", bool,
            is_required=True,
        ),
        E(
            "continuous_options_sending_interval_seconds",
            "continuousOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E(
            "failure_options_sending_interval_seconds",
            "failureOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E("failure_threshold_counter", "failureThresholdCounter", int, is_required=True),
        E("success_threshold_counter", "successThresholdCounter", int, is_required=True),
        E(
            "invite_failure_threshold_counter", "inviteFailureThresholdCounter", int,
            is_required=True,
        ),
        E(
            "invite_failure_threshold_window_seconds",
            "inviteFailureThresholdWindowSeconds", int, is_required=True,
        ),
        E("trunk_group_state", "trunkGroupState", str, is_required=True),
        E(
            "pilot_user_calling_line_asserted_identity_policy",
            "pilotUserCallingLineAssertedIdentityPolicy", str, is_required=True,
        ),
        E(
            "use_system_calling_line_asserted_identity_policy",
            "useSystemCallingLineAssertedIdentityPolicy", bool, is_required=True,
        ),
    )

    pilot_user_id: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    access_device: "AccessDevice" = Field(type=AccessDevice, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=True, mutable=False)
    max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    enable_bursting: bool = Field(type=bool, required=True, mutable=False)
    bursting_max_active_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_action: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_forward_address: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=True, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=True, mutable=False)
    unreachable_destination_action: str = Field(type=str, required=False, mutable=False)
    unreachable_destination_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    unreachable_destination_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    invitation_timeout: int = Field(type=int, required=True, mutable=False)
    require_authentication: bool = Field(type=bool, required=True, mutable=False)
    sip_authentication_user_name: str = Field(type=str, required=False, mutable=False)
    hosted_user_table: "list" = Field(type=list, required=False, mutable=False)
    trunk_group_identity: str = Field(type=str, required=False, mutable=False)
    otg_dtg_identity: str = Field(type=str, required=False, mutable=False)
    allow_termination_to_trunk_group_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_termination_to_dtg_identity: bool = Field(type=bool, required=True, mutable=False)
    include_trunk_group_identity: bool = Field(type=bool, required=True, mutable=False)
    include_dtg_identity: bool = Field(type=bool, required=True, mutable=False)
    include_trunk_group_identity_for_network_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_otg_identity_for_network_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_network_address_identity: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_calls: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_emergency_calls: bool = Field(type=bool, required=True, mutable=False)
    pilot_user_calling_line_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    pilot_user_charge_number_policy: str = Field(type=str, required=True, mutable=False)
    call_forwarding_always_action: str = Field(type=str, required=False, mutable=False)
    call_forwarding_always_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    call_forwarding_always_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    peering_domain: str = Field(type=str, required=False, mutable=False)
    route_to_peering_domain: bool = Field(type=bool, required=True, mutable=False)
    prefix_enabled: bool = Field(type=bool, required=True, mutable=False)
    prefix: str = Field(type=str, required=False, mutable=False)
    stateful_rerouting_enabled: bool = Field(type=bool, required=True, mutable=False)
    send_continuous_options_message: bool = Field(type=bool, required=True, mutable=False)
    continuous_options_sending_interval_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    failure_options_sending_interval_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    failure_threshold_counter: int = Field(type=int, required=True, mutable=False)
    success_threshold_counter: int = Field(type=int, required=True, mutable=False)
    invite_failure_threshold_counter: int = Field(type=int, required=True, mutable=False)
    invite_failure_threshold_window_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    trunk_group_state: str = Field(type=str, required=True, mutable=False)
    pilot_user_calling_line_asserted_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    use_system_calling_line_asserted_identity_policy: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupTrunkGroupGetInstanceResponse19sp1V2(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest19sp1V2.

    Returns the profile information for the Trunk Group.  Contains a hosted user table
    with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    Replaced by: ``GroupTrunkGroupGetInstanceResponse20sp1()``

    Attributes:
        pilot_user_id: pilotUserId
        department: department
        access_device: accessDevice
        max_active_calls: maxActiveCalls
        max_incoming_calls: maxIncomingCalls
        max_outgoing_calls: maxOutgoingCalls
        enable_bursting: enableBursting
        bursting_max_active_calls: burstingMaxActiveCalls
        bursting_max_incoming_calls: burstingMaxIncomingCalls
        bursting_max_outgoing_calls: burstingMaxOutgoingCalls
        capacity_exceeded_action: capacityExceededAction
        capacity_exceeded_forward_address: capacityExceededForwardAddress
        capacity_exceeded_reroute_trunk_group_key: capacityExceededRerouteTrunkGroupKey
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
        unreachable_destination_action: unreachableDestinationAction
        unreachable_destination_forward_address: unreachableDestinationForwardAddress
        unreachable_destination_reroute_trunk_group_key:
            unreachableDestinationRerouteTrunkGroupKey
        invitation_timeout: invitationTimeout
        require_authentication: requireAuthentication
        sip_authentication_user_name: sipAuthenticationUserName
        hosted_user_table: hostedUserTable
        trunk_group_identity: trunkGroupIdentity
        otg_dtg_identity: otgDtgIdentity
        allow_termination_to_trunk_group_identity: allowTerminationToTrunkGroupIdentity
        allow_termination_to_dtg_identity: allowTerminationToDtgIdentity
        include_trunk_group_identity: includeTrunkGroupIdentity
        include_dtg_identity: includeDtgIdentity
        include_trunk_group_identity_for_network_calls:
            includeTrunkGroupIdentityForNetworkCalls
        include_otg_identity_for_network_calls: includeOtgIdentityForNetworkCalls
        enable_network_address_identity: enableNetworkAddressIdentity
        allow_unscreened_calls: allowUnscreenedCalls
        allow_unscreened_emergency_calls: allowUnscreenedEmergencyCalls
        pilot_user_calling_line_identity_for_external_calls_policy:
            pilotUserCallingLineIdentityForExternalCallsPolicy
        pilot_user_charge_number_policy: pilotUserChargeNumberPolicy
        call_forwarding_always_action: callForwardingAlwaysAction
        call_forwarding_always_forward_address: callForwardingAlwaysForwardAddress
        call_forwarding_always_reroute_trunk_group_key:
            callForwardingAlwaysRerouteTrunkGroupKey
        peering_domain: peeringDomain
        route_to_peering_domain: routeToPeeringDomain
        prefix_enabled: prefixEnabled
        prefix: prefix
        stateful_rerouting_enabled: statefulReroutingEnabled
        send_continuous_options_message: sendContinuousOptionsMessage
        continuous_options_sending_interval_seconds:
            continuousOptionsSendingIntervalSeconds
        failure_options_sending_interval_seconds: failureOptionsSendingIntervalSeconds
        failure_threshold_counter: failureThresholdCounter
        success_threshold_counter: successThresholdCounter
        invite_failure_threshold_counter: inviteFailureThresholdCounter
        invite_failure_threshold_window_seconds: inviteFailureThresholdWindowSeconds
        trunk_group_state: trunkGroupState
        pilot_user_calling_line_asserted_identity_policy:
            pilotUserCallingLineAssertedIdentityPolicy
        use_system_calling_line_asserted_identity_policy:
            useSystemCallingLineAssertedIdentityPolicy
        total_active_incoming_calls: totalActiveIncomingCalls
        total_active_outgoing_calls: totalActiveOutgoingCalls
        pilot_user_call_optimization_policy: pilotUserCallOptimizationPolicy
        clid_source_for_screened_calls_policy: clidSourceForScreenedCallsPolicy
        use_system_clid_source_for_screened_calls_policy:
            useSystemCLIDSourceForScreenedCallsPolicy
        user_lookup_policy: userLookupPolicy
        use_system_user_lookup_policy: useSystemUserLookupPolicy
        pilot_user_calling_line_identity_for_emergency_calls_policy:
            pilotUserCallingLineIdentityForEmergencyCallsPolicy
    """

    _ELEMENTS = (
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("hosted_user_table", "hostedUserTable", list, is_complex=True, is_table=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "allow_termination_to_trunk_group_identity",
            "allowTerminationToTrunkGroupIdentity", bool, is_required=True,
        ),
        E(
            "allow_termination_to_dtg_identity", "allowTerminationToDtgIdentity", bool,
            is_required=True,
        ),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "include_trunk_group_identity_for_network_calls",
            "includeTrunkGroupIdentityForNetworkCalls", bool, is_required=True,
        ),
        E(
            "include_otg_identity_for_network_calls", "includeOtgIdentityForNetworkCalls",
            bool, is_required=True,
        ),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_for_external_calls_policy",
            "pilotUserCallingLineIdentityForExternalCallsPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("peering_domain", "peeringDomain", str),
        E("route_to_peering_domain", "routeToPeeringDomain", bool, is_required=True),
        E("prefix_enabled", "prefixEnabled", bool, is_required=True),
        E("prefix", "prefix", str),
        E("stateful_rerouting_enabled", "statefulReroutingEnabled", bool, is_required=True),
        E(
            "send_continuous_options_message", "sendContinuousOptionsMessage", bool,
            is_required=True,
        ),
        E(
            "continuous_options_sending_interval_seconds",
            "continuousOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E(
            "failure_options_sending_interval_seconds",
            "failureOptionsSendingIntervalSeconds", int, is_required=True,
        ),
        E("failure_threshold_counter", "failureThresholdCounter", int, is_required=True),
        E("success_threshold_counter", "successThresholdCounter", int, is_required=True),
        E(
            "invite_failure_threshold_counter", "inviteFailureThresholdCounter", int,
            is_required=True,
        ),
        E(
            "invite_failure_threshold_window_seconds",
            "inviteFailureThresholdWindowSeconds", int, is_required=True,
        ),
        E("trunk_group_state", "trunkGroupState", str, is_required=True),
        E(
            "pilot_user_calling_line_asserted_identity_policy",
            "pilotUserCallingLineAssertedIdentityPolicy", str, is_required=True,
        ),
        E(
            "use_system_calling_line_asserted_identity_policy",
            "useSystemCallingLineAssertedIdentityPolicy", bool, is_required=True,
        ),
        E("total_active_incoming_calls", "totalActiveIncomingCalls", int, is_required=True),
        E("total_active_outgoing_calls", "totalActiveOutgoingCalls", int, is_required=True),
        E(
            "pilot_user_call_optimization_policy", "pilotUserCallOptimizationPolicy", str,
            is_required=True,
        ),
        E(
            "clid_source_for_screened_calls_policy", "clidSourceForScreenedCallsPolicy",
            str, is_required=True,
        ),
        E(
            "use_system_clid_source_for_screened_calls_policy",
            "useSystemCLIDSourceForScreenedCallsPolicy", bool, is_required=True,
        ),
        E("user_lookup_policy", "userLookupPolicy", str, is_required=True),
        E(
            "use_system_user_lookup_policy", "useSystemUserLookupPolicy", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_for_emergency_calls_policy",
            "pilotUserCallingLineIdentityForEmergencyCallsPolicy", str, is_required=True,
        ),
    )

    pilot_user_id: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    access_device: "AccessDevice" = Field(type=AccessDevice, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=True, mutable=False)
    max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    enable_bursting: bool = Field(type=bool, required=True, mutable=False)
    bursting_max_active_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_action: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_forward_address: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=True, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=True, mutable=False)
    unreachable_destination_action: str = Field(type=str, required=False, mutable=False)
    unreachable_destination_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    unreachable_destination_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    invitation_timeout: int = Field(type=int, required=True, mutable=False)
    require_authentication: bool = Field(type=bool, required=True, mutable=False)
    sip_authentication_user_name: str = Field(type=str, required=False, mutable=False)
    hosted_user_table: "list" = Field(type=list, required=False, mutable=False)
    trunk_group_identity: str = Field(type=str, required=False, mutable=False)
    otg_dtg_identity: str = Field(type=str, required=False, mutable=False)
    allow_termination_to_trunk_group_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_termination_to_dtg_identity: bool = Field(type=bool, required=True, mutable=False)
    include_trunk_group_identity: bool = Field(type=bool, required=True, mutable=False)
    include_dtg_identity: bool = Field(type=bool, required=True, mutable=False)
    include_trunk_group_identity_for_network_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_otg_identity_for_network_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_network_address_identity: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_calls: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_emergency_calls: bool = Field(type=bool, required=True, mutable=False)
    pilot_user_calling_line_identity_for_external_calls_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    pilot_user_charge_number_policy: str = Field(type=str, required=True, mutable=False)
    call_forwarding_always_action: str = Field(type=str, required=False, mutable=False)
    call_forwarding_always_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    call_forwarding_always_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    peering_domain: str = Field(type=str, required=False, mutable=False)
    route_to_peering_domain: bool = Field(type=bool, required=True, mutable=False)
    prefix_enabled: bool = Field(type=bool, required=True, mutable=False)
    prefix: str = Field(type=str, required=False, mutable=False)
    stateful_rerouting_enabled: bool = Field(type=bool, required=True, mutable=False)
    send_continuous_options_message: bool = Field(type=bool, required=True, mutable=False)
    continuous_options_sending_interval_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    failure_options_sending_interval_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    failure_threshold_counter: int = Field(type=int, required=True, mutable=False)
    success_threshold_counter: int = Field(type=int, required=True, mutable=False)
    invite_failure_threshold_counter: int = Field(type=int, required=True, mutable=False)
    invite_failure_threshold_window_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    trunk_group_state: str = Field(type=str, required=True, mutable=False)
    pilot_user_calling_line_asserted_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    use_system_calling_line_asserted_identity_policy: bool = Field(
        type=bool, required=True, mutable=False,
    )
    total_active_incoming_calls: int = Field(type=int, required=True, mutable=False)
    total_active_outgoing_calls: int = Field(type=int, required=True, mutable=False)
    pilot_user_call_optimization_policy: str = Field(type=str, required=True, mutable=False)
    clid_source_for_screened_calls_policy: str = Field(type=str, required=True, mutable=False)
    use_system_clid_source_for_screened_calls_policy: bool = Field(
        type=bool, required=True, mutable=False,
    )
    user_lookup_policy: str = Field(type=str, required=True, mutable=False)
    use_system_user_lookup_policy: bool = Field(type=bool, required=True, mutable=False)
    pilot_user_calling_line_identity_for_emergency_calls_policy: str = Field(
        type=str, required=True, mutable=False,
    )


class GroupTrunkGroupModifyInstanceRequest14sp9A(OCIType):
    """
    Modify a Trunk Group Instance in a group.

    The access device cannot be modified or cleared if there are any users assigned to the
    Trunk Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        trunk_group_key: trunkGroupKey
        new_name: newName
        pilot_user_id: pilotUserId
        department: department
        access_device: accessDevice
        max_active_calls: maxActiveCalls
        max_incoming_calls: maxIncomingCalls
        max_outgoing_calls: maxOutgoingCalls
        enable_bursting: enableBursting
        bursting_max_active_calls: burstingMaxActiveCalls
        bursting_max_incoming_calls: burstingMaxIncomingCalls
        bursting_max_outgoing_calls: burstingMaxOutgoingCalls
        capacity_exceeded_action: capacityExceededAction
        capacity_exceeded_forward_address: capacityExceededForwardAddress
        capacity_exceeded_reroute_trunk_group_key: capacityExceededRerouteTrunkGroupKey
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
        unreachable_destination_action: unreachableDestinationAction
        unreachable_destination_forward_address: unreachableDestinationForwardAddress
        unreachable_destination_reroute_trunk_group_key:
            unreachableDestinationRerouteTrunkGroupKey
        unreachable_destination_trap_initial_calls: unreachableDestinationTrapInitialCalls
        unreachable_destination_trap_offset_calls: unreachableDestinationTrapOffsetCalls
        invitation_timeout: invitationTimeout
        require_authentication: requireAuthentication
        sip_authentication_user_name: sipAuthenticationUserName
        sip_authentication_password: sipAuthenticationPassword
        hosted_user_id_list: hostedUserIdList
        trunk_group_identity: trunkGroupIdentity
        otg_dtg_identity: otgDtgIdentity
        include_trunk_group_identity: includeTrunkGroupIdentity
        include_dtg_identity: includeDtgIdentity
        enable_network_address_identity: enableNetworkAddressIdentity
        allow_unscreened_calls: allowUnscreenedCalls
        allow_unscreened_emergency_calls: allowUnscreenedEmergencyCalls
        pilot_user_calling_line_identity_policy: pilotUserCallingLineIdentityPolicy
        pilot_user_charge_number_policy: pilotUserChargeNumberPolicy
        call_forwarding_always_action: callForwardingAlwaysAction
        call_forwarding_always_forward_address: callForwardingAlwaysForwardAddress
        call_forwarding_always_reroute_trunk_group_key:
            callForwardingAlwaysRerouteTrunkGroupKey
    """

    _ELEMENTS = (
        E(
            "trunk_group_key", "trunkGroupKey", TrunkGroupKey, is_complex=True,
            is_required=True,
        ),
        E("new_name", "newName", str),
        E("pilot_user_id", "pilotUserId", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls", int,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls", int,
        ),
        E("invitation_timeout", "invitationTimeout", int),
        E("require_authentication", "requireAuthentication", bool),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("sip_authentication_password", "sipAuthenticationPassword", str),
        E("hosted_user_id_list", "hostedUserIdList", ReplacementUserIdList, is_complex=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E("include_trunk_group_identity", "includeTrunkGroupIdentity", bool),
        E("include_dtg_identity", "includeDtgIdentity", bool),
        E("enable_network_address_identity", "enableNetworkAddressIdentity", bool),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool),
        E("allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str,
        ),
        E("pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
    )

    trunk_group_key: "TrunkGroupKey" = Field(type=TrunkGroupKey, required=True, mutable=False)
    new_name: str = Field(type=str, required=False, mutable=False)
    pilot_user_id: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    access_device: "AccessDevice" = Field(type=AccessDevice, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    enable_bursting: bool = Field(type=bool, required=False, mutable=False)
    bursting_max_active_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_action: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_forward_address: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)
    unreachable_destination_action: str = Field(type=str, required=False, mutable=False)
    unreachable_destination_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    unreachable_destination_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    unreachable_destination_trap_initial_calls: int = Field(
        type=int, required=False, mutable=False,
    )
    unreachable_destination_trap_offset_calls: int = Field(
        type=int, required=False, mutable=False,
    )
    invitation_timeout: int = Field(type=int, required=False, mutable=False)
    require_authentication: bool = Field(type=bool, required=False, mutable=False)
    sip_authentication_user_name: str = Field(type=str, required=False, mutable=False)
    sip_authentication_password: str = Field(type=str, required=False, mutable=False)
    hosted_user_id_list: "ReplacementUserIdList" = Field(
        type=ReplacementUserIdList, required=False, mutable=False,
    )
    trunk_group_identity: str = Field(type=str, required=False, mutable=False)
    otg_dtg_identity: str = Field(type=str, required=False, mutable=False)
    include_trunk_group_identity: bool = Field(type=bool, required=False, mutable=False)
    include_dtg_identity: bool = Field(type=bool, required=False, mutable=False)
    enable_network_address_identity: bool = Field(type=bool, required=False, mutable=False)
    allow_unscreened_calls: bool = Field(type=bool, required=False, mutable=False)
    allow_unscreened_emergency_calls: bool = Field(type=bool, required=False, mutable=False)
    pilot_user_calling_line_identity_policy: str = Field(
        type=str, required=False, mutable=False,
    )
    pilot_user_charge_number_policy: str = Field(type=str, required=False, mutable=False)
    call_forwarding_always_action: str = Field(type=str, required=False, mutable=False)
    call_forwarding_always_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    call_forwarding_always_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )


class IncomingCallingPlanDepartmentPermissions(OCIType):
    """
    Allows or disallows various types of incoming calls for a specified department.


    Attributes:
        department_key: departmentKey
        department_full_path_name: departmentFullPathName
        allow_from_within_group: allowFromWithinGroup
        allow_from_outside_group: allowFromOutsideGroup
        allow_collect_calls: allowCollectCalls
        digit_pattern_permission: digitPatternPermission
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_full_path_name", "departmentFullPathName", str, is_required=True),
        E("allow_from_within_group", "allowFromWithinGroup", bool, is_required=True),
        E("allow_from_outside_group", "allowFromOutsideGroup", str, is_required=True),
        E("allow_collect_calls", "allowCollectCalls", bool, is_required=True),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_full_path_name: str = Field(type=str, required=True, mutable=False)
    allow_from_within_group: bool = Field(type=bool, required=True, mutable=False)
    allow_from_outside_group: str = Field(type=str, required=True, mutable=False)
    allow_collect_calls: bool = Field(type=bool, required=True, mutable=False)
    digit_pattern_permission: "List[IncomingCallingPlanDigitPatternPermission]" = Field(
        type=list, required=False, mutable=False,
    )


class IncomingCallingPlanDepartmentPermissionsModify(OCIType):
    """
    Allows or disallows various types of incoming calls for a specified department.

    For use when modifing settings.

    Attributes:
        department_key: departmentKey
        allow_from_within_group: allowFromWithinGroup
        allow_from_outside_group: allowFromOutsideGroup
        allow_collect_calls: allowCollectCalls
        digit_pattern_permission: digitPatternPermission
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("allow_from_within_group", "allowFromWithinGroup", bool),
        E("allow_from_outside_group", "allowFromOutsideGroup", str),
        E("allow_collect_calls", "allowCollectCalls", bool),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    allow_from_within_group: bool = Field(type=bool, required=False, mutable=False)
    allow_from_outside_group: str = Field(type=str, required=False, mutable=False)
    allow_collect_calls: bool = Field(type=bool, required=False, mutable=False)
    digit_pattern_permission: "List[IncomingCallingPlanDigitPatternPermission]" = Field(
        type=list, required=False, mutable=False,
    )


class IncomingCallingPlanPermissions(OCIType):
    """
    Allows or disallows various types of incoming calls for a user or group -- not any
    particular department.


    Attributes:
        allow_from_within_group: allowFromWithinGroup
        allow_from_outside_group: allowFromOutsideGroup
        allow_collect_calls: allowCollectCalls
        digit_pattern_permission: digitPatternPermission
    """

    _ELEMENTS = (
        E("allow_from_within_group", "allowFromWithinGroup", bool, is_required=True),
        E("allow_from_outside_group", "allowFromOutsideGroup", str, is_required=True),
        E("allow_collect_calls", "allowCollectCalls", bool, is_required=True),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    allow_from_within_group: bool = Field(type=bool, required=True, mutable=False)
    allow_from_outside_group: str = Field(type=str, required=True, mutable=False)
    allow_collect_calls: bool = Field(type=bool, required=True, mutable=False)
    digit_pattern_permission: "List[IncomingCallingPlanDigitPatternPermission]" = Field(
        type=list, required=False, mutable=False,
    )


class IncomingCallingPlanPermissionsModify(OCIType):
    """
    Allows or disallows various types of incoming calls for a user or group -- not any
    particular department.

    For use when modifing settings.

    Attributes:
        allow_from_within_group: allowFromWithinGroup
        allow_from_outside_group: allowFromOutsideGroup
        allow_collect_calls: allowCollectCalls
        digit_pattern_permission: digitPatternPermission
    """

    _ELEMENTS = (
        E("allow_from_within_group", "allowFromWithinGroup", bool),
        E("allow_from_outside_group", "allowFromOutsideGroup", str),
        E("allow_collect_calls", "allowCollectCalls", bool),
        E(
            "digit_pattern_permission", "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission, is_complex=True, is_array=True,
        ),
    )

    allow_from_within_group: bool = Field(type=bool, required=False, mutable=False)
    allow_from_outside_group: str = Field(type=str, required=False, mutable=False)
    allow_collect_calls: bool = Field(type=bool, required=False, mutable=False)
    digit_pattern_permission: "List[IncomingCallingPlanDigitPatternPermission]" = Field(
        type=list, required=False, mutable=False,
    )


class MWIDeliveryToMobileEndpointTemplateBody(OCIType):
    """
    MWI Delivery To Mobile Endpoint template body.


    Attributes:
        line: line
    """

    _ELEMENTS = (
        E(
            "line", "line", MWIDeliveryToMobileEndpointTemplateLine, is_complex=True,
            is_required=True,
        ),
    )

    line: "MWIDeliveryToMobileEndpointTemplateLine" = Field(
        type=MWIDeliveryToMobileEndpointTemplateLine, required=True, mutable=False,
    )


class OutgoingCallingPlanCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanCallMeNowPermissions,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    permissions: "OutgoingCallingPlanCallMeNowPermissions" = Field(
        type=OutgoingCallingPlanCallMeNowPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions for a department.


    Attributes:
        department_key: departmentKey
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanCallMeNowPermissionsModify,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    permissions: "OutgoingCallingPlanCallMeNowPermissionsModify" = Field(
        type=OutgoingCallingPlanCallMeNowPermissionsModify, required=True, mutable=False,
    )


class OutgoingCallingPlanDepartmentAuthorizationCodes(OCIType):
    """
    Outgoing Calling Plan Authorization Code for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        code_entry: codeEntry
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "code_entry", "codeEntry", OutgoingCallingPlanAuthorizationCodeEntry,
            is_complex=True, is_array=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    code_entry: "List[OutgoingCallingPlanAuthorizationCodeEntry]" = Field(
        type=list, required=False, mutable=False,
    )


class OutgoingCallingPlanDepartmentTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        transfer_numbers: transferNumbers
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "transfer_numbers", "transferNumbers", OutgoingCallingPlanTransferNumbers,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    transfer_numbers: "OutgoingCallingPlanTransferNumbers" = Field(
        type=OutgoingCallingPlanTransferNumbers, required=True, mutable=False,
    )


class OutgoingCallingPlanDepartmentTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers for a department.


    Attributes:
        department_key: departmentKey
        transfer_numbers: transferNumbers
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "transfer_numbers", "transferNumbers",
            OutgoingCallingPlanTransferNumbersModify, is_complex=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    transfer_numbers: "OutgoingCallingPlanTransferNumbersModify" = Field(
        type=OutgoingCallingPlanTransferNumbersModify, required=False, mutable=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.


    Attributes:
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermission, is_complex=True,
            is_required=True,
        ),
    )

    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternCallMeNowPermission" = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermission, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for specified digit patterns.


    Attributes:
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermission, is_complex=True,
            is_required=True,
        ),
    )

    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternOriginatingPermission" = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermission, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan redirecting call permissions for specified digit patterns.


    Attributes:
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermission, is_complex=True,
            is_required=True,
        ),
    )

    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternRedirectingPermission" = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermission, required=True,
        mutable=False,
    )


class OutgoingCallingPlanGroupAuthorizationCodes(OCIType):
    """
    Outgoing Calling Plan Authorization Code for the group default.


    Attributes:
        code_entry: codeEntry
    """

    _ELEMENTS = (
        E(
            "code_entry", "codeEntry", OutgoingCallingPlanAuthorizationCodeEntry,
            is_complex=True, is_array=True,
        ),
    )

    code_entry: "List[OutgoingCallingPlanAuthorizationCodeEntry]" = Field(
        type=list, required=False, mutable=False,
    )


class OutgoingCallingPlanOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanOriginatingPermissions,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    permissions: "OutgoingCallingPlanOriginatingPermissions" = Field(
        type=OutgoingCallingPlanOriginatingPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanOriginatingDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions for a department.


    Attributes:
        department_key: departmentKey
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanOriginatingPermissionsModify,
            is_complex=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    permissions: "OutgoingCallingPlanOriginatingPermissionsModify" = Field(
        type=OutgoingCallingPlanOriginatingPermissionsModify, required=False,
        mutable=False,
    )


class OutgoingCallingPlanRedirectedDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectedPermissions,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    permissions: "OutgoingCallingPlanRedirectedPermissions" = Field(
        type=OutgoingCallingPlanRedirectedPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanRedirectedDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions for a department.


    Attributes:
        department_key: departmentKey
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectedPermissionsModify,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    permissions: "OutgoingCallingPlanRedirectedPermissionsModify" = Field(
        type=OutgoingCallingPlanRedirectedPermissionsModify, required=True, mutable=False,
    )


class OutgoingCallingPlanRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectingPermissions,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    permissions: "OutgoingCallingPlanRedirectingPermissions" = Field(
        type=OutgoingCallingPlanRedirectingPermissions, required=True, mutable=False,
    )


class OutgoingCallingPlanRedirectingDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions for a department.


    Attributes:
        department_key: departmentKey
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "permissions", "permissions", OutgoingCallingPlanRedirectingPermissionsModify,
            is_complex=True, is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    permissions: "OutgoingCallingPlanRedirectingPermissionsModify" = Field(
        type=OutgoingCallingPlanRedirectingPermissionsModify, required=True, mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit patterns.


    Attributes:
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission, is_complex=True,
            is_required=True,
        ),
    )

    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan originating call permissions for specified digit patterns.


    Attributes:
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermission, is_complex=True,
            is_required=True,
        ),
    )

    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternOriginatingPermission" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermission, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan redirecting call permissions for specified digit patterns.


    Attributes:
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermission, is_complex=True,
            is_required=True,
        ),
    )

    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternRedirectingPermission" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermission, required=True,
        mutable=False,
    )


class PriorityAlertCriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number_list: phoneNumberList
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    from_dn_criteria_selection: str = Field(type=str, required=False, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=False, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=False, mutable=False)
    phone_number_list: "CriteriaReplacementDNList" = Field(
        type=CriteriaReplacementDNList, required=False, mutable=False,
    )


class ReplacementCallToNumberList(OCIType):
    """
    A list of Call to Numbers that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.  For the
    callToNumbers, the extension element is not used and the number element is only used
    when the type is BroadWorks Mobility.

    Attributes:
        call_to_number: callToNumber
    """

    _ELEMENTS = (
        E("call_to_number", "callToNumber", CallToNumber, is_complex=True, is_required=True),
    )

    call_to_number: "CallToNumber" = Field(type=CallToNumber, required=True, mutable=False)


class ReplacementCommunicationBarringCallMeNowRuleList(OCIType):
    """
    A list of Communication Barring CallMeNow Rules that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringCallMeNowRule, is_complex=True,
            is_required=True,
        ),
    )

    rule: "CommunicationBarringCallMeNowRule" = Field(
        type=CommunicationBarringCallMeNowRule, required=True, mutable=False,
    )


class ReplacementCommunicationBarringIncomingRuleList(OCIType):
    """
    A list of Communication Barring Incoming Rules that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringIncomingRule, is_complex=True,
            is_required=True,
        ),
    )

    rule: "CommunicationBarringIncomingRule" = Field(
        type=CommunicationBarringIncomingRule, required=True, mutable=False,
    )


class ReplacementCommunicationBarringIncomingRuleList19sp1(OCIType):
    """
    A list of Communication Barring Incoming Rules that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringIncomingRule19sp1, is_complex=True,
            is_required=True,
        ),
    )

    rule: "CommunicationBarringIncomingRule19sp1" = Field(
        type=CommunicationBarringIncomingRule19sp1, required=True, mutable=False,
    )


class ReplacementCommunicationBarringOriginatingRuleList(OCIType):
    """
    A list of Communication Barring Originating Rules that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringOriginatingRule, is_complex=True,
            is_required=True,
        ),
    )

    rule: "CommunicationBarringOriginatingRule" = Field(
        type=CommunicationBarringOriginatingRule, required=True, mutable=False,
    )


class ReplacementCommunicationBarringRedirectingRuleList(OCIType):
    """
    A list of Communication Barring Redirecting Rules that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule", CommunicationBarringRedirectingRule, is_complex=True,
            is_required=True,
        ),
    )

    rule: "CommunicationBarringRedirectingRule" = Field(
        type=CommunicationBarringRedirectingRule, required=True, mutable=False,
    )


class ReplacementCustomContactDirectoryEntryList(OCIType):
    """
    A list of userIds and/or Virtual On-Net user DNs that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        entry: entry
    """

    _ELEMENTS = (
        E("entry", "entry", CustomContactDirectoryEntry, is_complex=True, is_required=True),
    )

    entry: "CustomContactDirectoryEntry" = Field(
        type=CustomContactDirectoryEntry, required=True, mutable=False,
    )


class ReplacementDeviceList(OCIType):
    """
    A list of devices that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        device: device
    """

    _ELEMENTS = (
        E("device", "device", AccessDevice, is_complex=True, is_required=True),
    )

    device: "AccessDevice" = Field(type=AccessDevice, required=True, mutable=False)


class ReplacementEnterpriseEnterpriseTrunkTrunkGroupKeyList(OCIType):
    """
    A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group: trunkGroup
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", EnterpriseTrunkTrunkGroupKey, is_complex=True,
            is_required=True,
        ),
    )

    trunk_group: "EnterpriseTrunkTrunkGroupKey" = Field(
        type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False,
    )


class ReplacementEnterpriseTrunkTrunkGroupKeyList(OCIType):
    """
    A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group_list: trunkGroupList
    """

    _ELEMENTS = (
        E(
            "trunk_group_list", "trunkGroupList", EnterpriseTrunkTrunkGroupKey,
            is_complex=True, is_required=True,
        ),
    )

    trunk_group_list: "EnterpriseTrunkTrunkGroupKey" = Field(
        type=EnterpriseTrunkTrunkGroupKey, required=True, mutable=False,
    )


class ReplacementGroupEnterpriseTrunkPriorityWeightedTrunkGroupList(OCIType):
    """
    A list of enterprise trunk priority weighted trunk groups in a group that replaces a
    previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group: trunkGroup
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup", GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
            is_complex=True, is_required=True,
        ),
    )

    trunk_group: "GroupEnterpriseTrunkPriorityWeightedTrunkGroup" = Field(
        type=GroupEnterpriseTrunkPriorityWeightedTrunkGroup, required=True, mutable=False,
    )


class ScheduleEvents(OCIType):
    """
    Retrives all Holiday or Time Event details for a given schedulel Level.


    Attributes:
        eventname: eventname
        start_date: startDate
        all_day_event: allDayEvent
        start_time: startTime
        end_time: endTime
        end_date: endDate
        recurrence: recurrence
    """

    _ELEMENTS = (
        E("eventname", "eventname", str, is_required=True),
        E("start_date", "startDate", str, is_required=True),
        E("all_day_event", "allDayEvent", bool),
        E("start_time", "startTime", HourMinute, is_complex=True, is_required=True),
        E("end_time", "endTime", HourMinute, is_complex=True, is_required=True),
        E("end_date", "endDate", str, is_required=True),
        E("recurrence", "recurrence", Recurrence, is_complex=True),
    )

    eventname: str = Field(type=str, required=True, mutable=False)
    start_date: str = Field(type=str, required=True, mutable=False)
    all_day_event: bool = Field(type=bool, required=False, mutable=False)
    start_time: "HourMinute" = Field(type=HourMinute, required=True, mutable=False)
    end_time: "HourMinute" = Field(type=HourMinute, required=True, mutable=False)
    end_date: str = Field(type=str, required=True, mutable=False)
    recurrence: "Recurrence" = Field(type=Recurrence, required=False, mutable=False)


class ScheduleGlobalKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules throughout all System, Service
    Provider, Group and User level.


    Attributes:
        schedule_key: scheduleKey
        schedule_level: scheduleLevel
    """

    _ELEMENTS = (
        E("schedule_key", "scheduleKey", ScheduleKey, is_complex=True, is_required=True),
        E("schedule_level", "scheduleLevel", str, is_required=True),
    )

    schedule_key: "ScheduleKey" = Field(type=ScheduleKey, required=True, mutable=False)
    schedule_level: str = Field(type=str, required=True, mutable=False)


class SearchCriteriaExactCallCenterReportTemplateKey(OCIType):
    """
    Criteria for searching for a particular call center enhanced reporting report
    template.


    Attributes:
        report_template: reportTemplate
    """

    _ELEMENTS = (
        E(
            "report_template", "reportTemplate", CallCenterReportTemplateKey,
            is_complex=True, is_required=True,
        ),
    )

    report_template: "CallCenterReportTemplateKey" = Field(
        type=CallCenterReportTemplateKey, required=True, mutable=False,
    )


class SearchCriteriaExactDnDepartment(OCIType):
    """
    Criteria for searching for a particular fully specified DN's department.


    Attributes:
        department_key: departmentKey
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)


class SearchCriteriaExactUserDepartment(OCIType):
    """
    Criteria for searching for a particular fully specified user's department.


    Attributes:
        department_key: departmentKey
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)


class SelectiveCallRejectionCriteriaCallTypeModify(OCIType):
    """
    The call type criteria used within a modify request.


    Attributes:
        from_dn_criteria_selection: fromDnCriteriaSelection
        include_anonymous_callers: includeAnonymousCallers
        include_unavailable_callers: includeUnavailableCallers
        phone_number_list: phoneNumberList
    """

    _ELEMENTS = (
        E("from_dn_criteria_selection", "fromDnCriteriaSelection", str),
        E("include_anonymous_callers", "includeAnonymousCallers", bool),
        E("include_unavailable_callers", "includeUnavailableCallers", bool),
        E("phone_number_list", "phoneNumberList", CriteriaReplacementDNList, is_complex=True),
    )

    from_dn_criteria_selection: str = Field(type=str, required=False, mutable=False)
    include_anonymous_callers: bool = Field(type=bool, required=False, mutable=False)
    include_unavailable_callers: bool = Field(type=bool, required=False, mutable=False)
    phone_number_list: "CriteriaReplacementDNList" = Field(
        type=CriteriaReplacementDNList, required=False, mutable=False,
    )


class ServiceInstanceAddProfile(OCIType):
    """
    Service Profile Information for group service.


    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        alias: alias
        public_user_identity: publicUserIdentity
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    public_user_identity: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceAddProfileCallCenter(OCIType):
    """
    Service Profile Information for a call center.

    Password is required.

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        alias: alias
        public_user_identity: publicUserIdentity
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str, is_required=True),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    public_user_identity: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceAddProfileFlexibleSeatingHost(OCIType):
    """
    Service Profile Information for a flexible seating host.


    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceAddProfileTrunkGroup(OCIType):
    """
    Service Profile Information for a trunk group.

    The publicUserIdentity element is not part of ServiceInstanceAddProfileTrunkGroup.

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        alias: alias
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("alias", "alias", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceModifyProfile(OCIType):
    """
    Service Profile Information for group service used when modifying an existing service
    instance.


    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        sip_alias_list: sipAliasList
        public_user_identity: publicUserIdentity
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("sip_alias_list", "sipAliasList", ReplacementSIPAliasList, is_complex=True),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=False, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    sip_alias_list: "ReplacementSIPAliasList" = Field(
        type=ReplacementSIPAliasList, required=False, mutable=False,
    )
    public_user_identity: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceModifyProfileFlexibleSeatingHost(OCIType):
    """
    Service Profile Information for a flexible seating host

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=False, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceModifyProfileTrunkGroup(OCIType):
    """
    Service Profile Information for a trunk group used when modifying an existing service
    instance.


    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        password: password
        department: department
        language: language
        time_zone: timeZone
        sip_alias_list: sipAliasList
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("sip_alias_list", "sipAliasList", ReplacementSIPAliasList, is_complex=True),
    )

    name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=False, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    sip_alias_list: "ReplacementSIPAliasList" = Field(
        type=ReplacementSIPAliasList, required=False, mutable=False,
    )


class ServiceInstanceReadProfile(OCIType):
    """
    Service Profile Information for group service.

    It is identical to the ServiceInstanceAddProfile, but without the password.  Prior to
    release 14 this was called ServiceInstanceProfile.

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        department: department
        language: language
        time_zone: timeZone
        time_zone_display_name: timeZoneDisplayName
        alias: alias
        public_user_identity: publicUserIdentity
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    time_zone_display_name: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    public_user_identity: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceReadProfile17(OCIType):
    """
    Service Profile Information for group service.

    It is identical to the ServiceInstanceAddProfile, but without the password.  Replaced
    by: ServiceInstanceReadProfile17sp4

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        department: department
        language: language
        time_zone: timeZone
        time_zone_display_name: timeZoneDisplayName
        alias: alias
        public_user_identity: publicUserIdentity
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    time_zone_display_name: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    public_user_identity: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceReadProfile17sp4(OCIType):
    """
    Service Profile Information for group service.

    Replaced by: ServiceInstanceReadProfile19sp1

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        country_code: countryCode
        national_prefix: nationalPrefix
        department: department
        language: language
        time_zone: timeZone
        time_zone_display_name: timeZoneDisplayName
        alias: alias
        public_user_identity: publicUserIdentity
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("country_code", "countryCode", str),
        E("national_prefix", "nationalPrefix", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    country_code: str = Field(type=str, required=False, mutable=False)
    national_prefix: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    time_zone_display_name: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    public_user_identity: str = Field(type=str, required=False, mutable=False)


class ServiceInstanceReadProfile19sp1(OCIType):
    """
    Service Profile Information for group service.

    The callingLineIdPhoneNumber is no longer being formatted for display purpose.  The
    value is returned exactly the same as being stored.

    Attributes:
        name: name
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        phone_number: phoneNumber
        extension: extension
        country_code: countryCode
        national_prefix: nationalPrefix
        department: department
        language: language
        time_zone: timeZone
        time_zone_display_name: timeZoneDisplayName
        alias: alias
        public_user_identity: publicUserIdentity
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("phone_number", "phoneNumber", str),
        E("extension", "extension", str),
        E("country_code", "countryCode", str),
        E("national_prefix", "nationalPrefix", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("time_zone_display_name", "timeZoneDisplayName", str),
        E("alias", "alias", str),
        E("public_user_identity", "publicUserIdentity", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    country_code: str = Field(type=str, required=False, mutable=False)
    national_prefix: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    time_zone_display_name: str = Field(type=str, required=False, mutable=False)
    alias: str = Field(type=str, required=False, mutable=False)
    public_user_identity: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class ServicePackAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a service pack.


    Attributes:
        service_pack_name: servicePackName
        authorized_quantity: authorizedQuantity
        unauthorized: unauthorized
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_required=True),
        E("authorized_quantity", "authorizedQuantity", UnboundedPositiveInt, is_complex=True),
        E("unauthorized", "unauthorized", bool),
    )

    service_pack_name: str = Field(type=str, required=True, mutable=False)
    authorized_quantity: "UnboundedPositiveInt" = Field(
        type=UnboundedPositiveInt, required=False, mutable=False,
    )
    unauthorized: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderCommunicationBarringProfileGetResponse19sp1V2(OCIType):
    """
    Response to the ServiceProviderCommunicationBarringProfileGetRequest19sp1V2.

    The response contains the Communication Barring Profile information.  The incoming,
    originating, redirecting and call me now rules are returned in ascending priority
    order.  The following elements are only used in AS data mode: callMeNowDefaultAction
    callMeNowDefaultCallTimeout callMeNowRule applyToAttendedCallTransfers

    Attributes:
        description: description
        originating_default_action: originatingDefaultAction
        originating_default_treatment_id: originatingDefaultTreatmentId
        originating_default_transfer_number: originatingDefaultTransferNumber
        originating_default_call_timeout: originatingDefaultCallTimeout
        originating_rule: originatingRule
        redirecting_default_action: redirectingDefaultAction
        redirecting_default_call_timeout: redirectingDefaultCallTimeout
        redirecting_rule: redirectingRule
        call_me_now_default_action: callMeNowDefaultAction
        call_me_now_default_call_timeout: callMeNowDefaultCallTimeout
        call_me_now_rule: callMeNowRule
        incoming_default_action: incomingDefaultAction
        incoming_default_call_timeout: incomingDefaultCallTimeout
        incoming_rule: incomingRule
        is_default: isDefault
        apply_to_attended_call_transfers: applyToAttendedCallTransfers
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("originating_default_action", "originatingDefaultAction", str, is_required=True),
        E("originating_default_treatment_id", "originatingDefaultTreatmentId", str),
        E("originating_default_transfer_number", "originatingDefaultTransferNumber", str),
        E("originating_default_call_timeout", "originatingDefaultCallTimeout", int),
        E(
            "originating_rule", "originatingRule",
            ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
            is_complex=True, is_array=True,
        ),
        E("redirecting_default_action", "redirectingDefaultAction", str, is_required=True),
        E("redirecting_default_call_timeout", "redirectingDefaultCallTimeout", int),
        E(
            "redirecting_rule", "redirectingRule",
            ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
            is_complex=True, is_array=True,
        ),
        E("call_me_now_default_action", "callMeNowDefaultAction", str, is_required=True),
        E("call_me_now_default_call_timeout", "callMeNowDefaultCallTimeout", int),
        E(
            "call_me_now_rule", "callMeNowRule",
            ServiceProviderCommunicationBarringHierarchicalCallMeNowRule, is_complex=True,
            is_array=True,
        ),
        E("incoming_default_action", "incomingDefaultAction", str, is_required=True),
        E("incoming_default_call_timeout", "incomingDefaultCallTimeout", int),
        E(
            "incoming_rule", "incomingRule", CommunicationBarringIncomingRule19sp1,
            is_complex=True, is_array=True,
        ),
        E("is_default", "isDefault", bool, is_required=True),
        E(
            "apply_to_attended_call_transfers", "applyToAttendedCallTransfers", bool,
            is_required=True,
        ),
    )

    description: str = Field(type=str, required=False, mutable=False)
    originating_default_action: str = Field(type=str, required=True, mutable=False)
    originating_default_treatment_id: str = Field(type=str, required=False, mutable=False)
    originating_default_transfer_number: str = Field(type=str, required=False, mutable=False)
    originating_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    originating_rule: "List[ServiceProviderCommunicationBarringHierarchicalOriginatingRule]" = Field(
        type=list, required=False, mutable=False,
    )
    redirecting_default_action: str = Field(type=str, required=True, mutable=False)
    redirecting_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    redirecting_rule: "List[ServiceProviderCommunicationBarringHierarchicalRedirectingRule]" = Field(
        type=list, required=False, mutable=False,
    )
    call_me_now_default_action: str = Field(type=str, required=True, mutable=False)
    call_me_now_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    call_me_now_rule: "List[ServiceProviderCommunicationBarringHierarchicalCallMeNowRule]" = Field(
        type=list, required=False, mutable=False,
    )
    incoming_default_action: str = Field(type=str, required=True, mutable=False)
    incoming_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    incoming_rule: "List[CommunicationBarringIncomingRule19sp1]" = Field(
        type=list, required=False, mutable=False,
    )
    is_default: bool = Field(type=bool, required=True, mutable=False)
    apply_to_attended_call_transfers: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderReplacementCommunicationBarringHierarchicalCallMeNowRuleList(OCIType):
    """
    A list of Service Provider Communication Barring Hierarchical Call Me Now Rules that
    replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule", ServiceProviderCommunicationBarringHierarchicalCallMeNowRule,
            is_complex=True, is_required=True,
        ),
    )

    rule: "ServiceProviderCommunicationBarringHierarchicalCallMeNowRule" = Field(
        type=ServiceProviderCommunicationBarringHierarchicalCallMeNowRule, required=True,
        mutable=False,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalOriginatingRuleList(OCIType):
    """
    A list of Service Provider Communication Barring Hierarchical Originating Rules that
    replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule",
            ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
            is_complex=True, is_required=True,
        ),
    )

    rule: "ServiceProviderCommunicationBarringHierarchicalOriginatingRule" = Field(
        type=ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
        required=True, mutable=False,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalRedirectingRuleList(OCIType):
    """
    A list of Service Provider Communication Barring Hierarchical Redirecting Rules that
    replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        rule: rule
    """

    _ELEMENTS = (
        E(
            "rule", "rule",
            ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
            is_complex=True, is_required=True,
        ),
    )

    rule: "ServiceProviderCommunicationBarringHierarchicalRedirectingRule" = Field(
        type=ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
        required=True, mutable=False,
    )


class ShInterfaceUserIdDataEntry(OCIType):
    """
    ShInterface User Id Data Entry.


    Attributes:
        user_type: userType
        public_user_identity: publicUserIdentity
        endpoint_type: endpointType
        scscf_name: SCSCFName
        ims_user_state: IMSUserState
    """

    _ELEMENTS = (
        E("user_type", "userType", str, is_required=True),
        E(
            "public_user_identity", "publicUserIdentity", PublicUserIdentity,
            is_complex=True, is_required=True,
        ),
        E("endpoint_type", "endpointType", str, is_required=True),
        E("scscf_name", "SCSCFName", str),
        E("ims_user_state", "IMSUserState", str, is_required=True),
    )

    user_type: str = Field(type=str, required=True, mutable=False)
    public_user_identity: "PublicUserIdentity" = Field(
        type=PublicUserIdentity, required=True, mutable=False,
    )
    endpoint_type: str = Field(type=str, required=True, mutable=False)
    scscf_name: str = Field(type=str, required=False, mutable=False)
    ims_user_state: str = Field(type=str, required=True, mutable=False)


class ShInterfaceUserListEntry(OCIType):
    """
    ShInterface User List Entry.


    Attributes:
        user_id: userId
        user_type: userType
        public_user_identity: publicUserIdentity
        endpoint_type: endpointType
        scscf_name: SCSCFName
        ims_user_state: IMSUserState
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("user_type", "userType", str, is_required=True),
        E(
            "public_user_identity", "publicUserIdentity", PublicUserIdentity,
            is_complex=True, is_required=True,
        ),
        E("endpoint_type", "endpointType", str, is_required=True),
        E("scscf_name", "SCSCFName", str),
        E("ims_user_state", "IMSUserState", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    user_type: str = Field(type=str, required=True, mutable=False)
    public_user_identity: "PublicUserIdentity" = Field(
        type=PublicUserIdentity, required=True, mutable=False,
    )
    endpoint_type: str = Field(type=str, required=True, mutable=False)
    scscf_name: str = Field(type=str, required=False, mutable=False)
    ims_user_state: str = Field(type=str, required=True, mutable=False)


class SimultaneousRingReplacementNumberList(OCIType):
    """
    A list of Simultaneous Ring numbers that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        simultaneous_ring_number: simultaneousRingNumber
    """

    _ELEMENTS = (
        E(
            "simultaneous_ring_number", "simultaneousRingNumber", SimultaneousRingNumber,
            is_complex=True, is_required=True,
        ),
    )

    simultaneous_ring_number: "SimultaneousRingNumber" = Field(
        type=SimultaneousRingNumber, required=True, mutable=False,
    )


class SystemCommunicationBarringProfileGetResponse19sp1V2(OCIType):
    """
    Response to the SystemCommunicationBarringProfileGetRequest19sp1V2.

    The response contains the Communication Barring Profile information.  The incoming
    rules are returned in ascending priority order.  The following elements are only used
    in AS data mode: callMeNowDefaultAction callMeNowDefaultCallTimeout callMeNowRule
    applyToAttendedCallTransfers

    Attributes:
        description: description
        originating_default_action: originatingDefaultAction
        originating_default_treatment_id: originatingDefaultTreatmentId
        originating_default_transfer_number: originatingDefaultTransferNumber
        originating_default_call_timeout: originatingDefaultCallTimeout
        originating_rule: originatingRule
        redirecting_default_action: redirectingDefaultAction
        redirecting_default_call_timeout: redirectingDefaultCallTimeout
        redirecting_rule: redirectingRule
        incoming_default_action: incomingDefaultAction
        incoming_default_call_timeout: incomingDefaultCallTimeout
        incoming_rule: incomingRule
        call_me_now_default_action: callMeNowDefaultAction
        call_me_now_default_call_timeout: callMeNowDefaultCallTimeout
        call_me_now_rule: callMeNowRule
        apply_to_attended_call_transfers: applyToAttendedCallTransfers
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("originating_default_action", "originatingDefaultAction", str, is_required=True),
        E("originating_default_treatment_id", "originatingDefaultTreatmentId", str),
        E("originating_default_transfer_number", "originatingDefaultTransferNumber", str),
        E("originating_default_call_timeout", "originatingDefaultCallTimeout", int),
        E(
            "originating_rule", "originatingRule", CommunicationBarringOriginatingRule,
            is_complex=True, is_array=True,
        ),
        E("redirecting_default_action", "redirectingDefaultAction", str, is_required=True),
        E("redirecting_default_call_timeout", "redirectingDefaultCallTimeout", int),
        E(
            "redirecting_rule", "redirectingRule", CommunicationBarringRedirectingRule,
            is_complex=True, is_array=True,
        ),
        E("incoming_default_action", "incomingDefaultAction", str, is_required=True),
        E("incoming_default_call_timeout", "incomingDefaultCallTimeout", int),
        E(
            "incoming_rule", "incomingRule", CommunicationBarringIncomingRule19sp1,
            is_complex=True, is_array=True,
        ),
        E("call_me_now_default_action", "callMeNowDefaultAction", str, is_required=True),
        E("call_me_now_default_call_timeout", "callMeNowDefaultCallTimeout", int),
        E(
            "call_me_now_rule", "callMeNowRule", CommunicationBarringCallMeNowRule,
            is_complex=True, is_array=True,
        ),
        E(
            "apply_to_attended_call_transfers", "applyToAttendedCallTransfers", bool,
            is_required=True,
        ),
    )

    description: str = Field(type=str, required=False, mutable=False)
    originating_default_action: str = Field(type=str, required=True, mutable=False)
    originating_default_treatment_id: str = Field(type=str, required=False, mutable=False)
    originating_default_transfer_number: str = Field(type=str, required=False, mutable=False)
    originating_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    originating_rule: "List[CommunicationBarringOriginatingRule]" = Field(
        type=list, required=False, mutable=False,
    )
    redirecting_default_action: str = Field(type=str, required=True, mutable=False)
    redirecting_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    redirecting_rule: "List[CommunicationBarringRedirectingRule]" = Field(
        type=list, required=False, mutable=False,
    )
    incoming_default_action: str = Field(type=str, required=True, mutable=False)
    incoming_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    incoming_rule: "List[CommunicationBarringIncomingRule19sp1]" = Field(
        type=list, required=False, mutable=False,
    )
    call_me_now_default_action: str = Field(type=str, required=True, mutable=False)
    call_me_now_default_call_timeout: int = Field(type=int, required=False, mutable=False)
    call_me_now_rule: "List[CommunicationBarringCallMeNowRule]" = Field(
        type=list, required=False, mutable=False,
    )
    apply_to_attended_call_transfers: bool = Field(type=bool, required=True, mutable=False)


class TrunkAddressingAdd(OCIType):
    """
    Trunk group endpoint.


    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointAdd, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceEndpointAdd" = Field(
        type=TrunkGroupDeviceEndpointAdd, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)


class TrunkAddressingModify(OCIType):
    """
    Trunk group endpoint.


    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointModify, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceEndpointModify" = Field(
        type=TrunkGroupDeviceEndpointModify, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)


class TrunkAddressingMultipleContactAdd(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    alternateTrunkIdentityDomain is only used in IMS mode.  Both alternateTrunkIdentity
    and AlternateTrunkIdentityDomain should be set at the same time if one is set in IMS
    mode.

    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
        alternate_trunk_identity_domain: alternateTrunkIdentityDomain
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointAdd, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
        E("alternate_trunk_identity_domain", "alternateTrunkIdentityDomain", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceMultipleContactEndpointAdd" = Field(
        type=TrunkGroupDeviceMultipleContactEndpointAdd, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity_domain: str = Field(type=str, required=False, mutable=False)


class TrunkAddressingMultipleContactRead(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    Replaced by: TrunkAddressingMultipleContactRead21

    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointRead, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceMultipleContactEndpointRead" = Field(
        type=TrunkGroupDeviceMultipleContactEndpointRead, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)


class TrunkAddressingMultipleContactRead21(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    alternateTrunkIdentityDomain is only used in IMS mode.  The following elements are
    only used in AS data mode and ignored in HSS data mode: alternateTrunkIdentityDomain

    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
        alternate_trunk_identity_domain: alternateTrunkIdentityDomain
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointRead, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
        E("alternate_trunk_identity_domain", "alternateTrunkIdentityDomain", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceMultipleContactEndpointRead" = Field(
        type=TrunkGroupDeviceMultipleContactEndpointRead, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity_domain: str = Field(type=str, required=False, mutable=False)


class TrunkAddressingRead(OCIType):
    """
    Trunk group endpoint.


    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointRead14sp4, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceEndpointRead14sp4" = Field(
        type=TrunkGroupDeviceEndpointRead14sp4, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)


class TrunkGroupDeviceMultipleContactEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple
    contacts.


    Attributes:
        name: name
        line_port: linePort
        contact_list: contactList
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("line_port", "linePort", str),
        E("contact_list", "contactList", ReplacementContactList, is_complex=True),
    )

    name: str = Field(type=str, required=False, mutable=False)
    line_port: str = Field(type=str, required=False, mutable=False)
    contact_list: "ReplacementContactList" = Field(
        type=ReplacementContactList, required=False, mutable=False,
    )


class TrunkGroupMultipleContactPilotUser(OCIType):
    """
    Trunk Group pilot user information used when adding a Trunk Group.


    Attributes:
        user_id: userId
        last_name: lastName
        first_name: firstName
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        password: password
        department: department
        language: language
        time_zone: timeZone
        line_port: linePort
        contact: contact
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    last_name: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class TrunkGroupPilotUser(OCIType):
    """
    Trunk Group pilot user information used when adding a Trunk Group.


    Attributes:
        user_id: userId
        last_name: lastName
        first_name: firstName
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        hiragana_last_name: hiraganaLastName
        hiragana_first_name: hiraganaFirstName
        password: password
        department: department
        language: language
        time_zone: timeZone
        line_port: linePort
        contact: contact
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("hiragana_last_name", "hiraganaLastName", str),
        E("hiragana_first_name", "hiraganaFirstName", str),
        E("password", "password", str),
        E("department", "department", DepartmentKey, is_complex=True),
        E("language", "language", str),
        E("time_zone", "timeZone", str),
        E("line_port", "linePort", str, is_required=True),
        E("contact", "contact", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    last_name: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    hiragana_last_name: str = Field(type=str, required=False, mutable=False)
    hiragana_first_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    time_zone: str = Field(type=str, required=False, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)


class UserServiceAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a user service.


    Attributes:
        service_name: serviceName
        authorized_quantity: authorizedQuantity
        unauthorized: unauthorized
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_required=True),
        E("authorized_quantity", "authorizedQuantity", UnboundedPositiveInt, is_complex=True),
        E("unauthorized", "unauthorized", bool),
    )

    service_name: str = Field(type=str, required=True, mutable=False)
    authorized_quantity: "UnboundedPositiveInt" = Field(
        type=UnboundedPositiveInt, required=False, mutable=False,
    )
    unauthorized: bool = Field(type=bool, required=False, mutable=False)


class VerifyTranslationAndRoutingParameters(OCIType):
    """
    Verification Translation and Routing parameters for creating a Verify Translation and
    Routing request from parameters.


    Attributes:
        origination: origination
        destination: destination
        contact: contact
        diversion: diversion
    """

    _ELEMENTS = (
        E(
            "origination", "origination", VerifyTranslationAndRoutingOrigination,
            is_complex=True, is_required=True,
        ),
        E("destination", "destination", str, is_required=True),
        E("contact", "contact", str),
        E("diversion", "diversion", str),
    )

    origination: "VerifyTranslationAndRoutingOrigination" = Field(
        type=VerifyTranslationAndRoutingOrigination, required=True, mutable=False,
    )
    destination: str = Field(type=str, required=True, mutable=False)
    contact: str = Field(type=str, required=False, mutable=False)
    diversion: str = Field(type=str, required=False, mutable=False)


class VirtualOnNetUserRange(OCIType):
    """
    Virtual On-Net User Range.


    Attributes:
        dn_range: dnRange
        extension_range: extensionRange
        first_name: firstName
        last_name: lastName
        calling_line_id_first_name: callingLineIdFirstName
        calling_line_id_last_name: callingLineIdLastName
        virtual_on_net_call_type_name: virtualOnNetCallTypeName
    """

    _ELEMENTS = (
        E("dn_range", "dnRange", DNRange, is_complex=True, is_required=True),
        E(
            "extension_range", "extensionRange", ExtensionRange17, is_complex=True,
            is_required=True,
        ),
        E("first_name", "firstName", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    dn_range: "DNRange" = Field(type=DNRange, required=True, mutable=False)
    extension_range: "ExtensionRange17" = Field(
        type=ExtensionRange17, required=True, mutable=False,
    )
    first_name: str = Field(type=str, required=True, mutable=False)
    last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    virtual_on_net_call_type_name: str = Field(type=str, required=True, mutable=False)


class VoiceMessagingAlternateNoAnswerGreetingModify(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when modifying a user's voice messaging greeting.

    Attributes:
        name: name
        audio_file: audioFile
        video_file: videoFile
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("audio_file", "audioFile", LabeledFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledFileResource, is_complex=True),
    )

    name: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )
    video_file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingModify16(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when modifying a user's voice messaging greeting.

    Attributes:
        name: name
        audio_file: audioFile
        video_file: videoFile
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
    )

    name: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingModify20(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when modifying a user's voice messaging greeting.

    Attributes:
        name: name
        audio_file: audioFile
        video_file: videoFile
    """

    _ELEMENTS = (
        E("name", "name", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
    )

    name: str = Field(type=str, required=False, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingRead20(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.

    Attributes:
        name: name
        audio_file: audioFile
        video_file: videoFile
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )


class AutoAttendantKeyConfiguration(OCIType):
    """
    The configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationEntry, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationEntry" = Field(
        type=AutoAttendantKeyConfigurationEntry, required=True, mutable=False,
    )


class AutoAttendantKeyConfiguration19(OCIType):
    """
    The configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationEntry19, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationEntry19" = Field(
        type=AutoAttendantKeyConfigurationEntry19, required=True, mutable=False,
    )


class AutoAttendantKeyConfiguration20(OCIType):
    """
    The configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationEntry20, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationEntry20" = Field(
        type=AutoAttendantKeyConfigurationEntry20, required=True, mutable=False,
    )


class AutoAttendantKeyModifyConfiguration(OCIType):
    """
    The modify configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationModifyEntry, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationModifyEntry" = Field(
        type=AutoAttendantKeyConfigurationModifyEntry, required=True, mutable=False,
    )


class AutoAttendantKeyModifyConfiguration20(OCIType):
    """
    The modify configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationModifyEntry20, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationModifyEntry20" = Field(
        type=AutoAttendantKeyConfigurationModifyEntry20, required=True, mutable=False,
    )


class AutoAttendantKeyReadConfiguration20(OCIType):
    """
    The read configuration of a key for Auto Attendant.


    Attributes:
        key: key
        entry: entry
    """

    _ELEMENTS = (
        E("key", "key", str, is_required=True),
        E(
            "entry", "entry", AutoAttendantKeyConfigurationReadEntry20, is_complex=True,
            is_required=True,
        ),
    )

    key: str = Field(type=str, required=True, mutable=False)
    entry: "AutoAttendantKeyConfigurationReadEntry20" = Field(
        type=AutoAttendantKeyConfigurationReadEntry20, required=True, mutable=False,
    )


class AutoAttendantReadMenu19(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyReadConfiguration19,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyReadConfiguration19" = Field(
        type=AutoAttendantKeyReadConfiguration19, required=False, mutable=False,
    )


class CPEDeviceModifyOptions(OCIType):
    """
    CPE device's options when used with a modify request.

    The following options are not changeable: configType systemFileName deviceFileFormat

    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool),
        E("reset_event", "resetEvent", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=False, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeModifyOptions" = Field(
        type=DeviceManagementDeviceTypeModifyOptions, required=False, mutable=False,
    )


class CPEDeviceModifyOptions16(OCIType):
    """
    CPE device's options when used with a modify request.

    The following options are not changeable: configType systemFileName deviceFileFormat

    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool),
        E("reset_event", "resetEvent", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions16, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=False, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeModifyOptions16" = Field(
        type=DeviceManagementDeviceTypeModifyOptions16, required=False, mutable=False,
    )


class CPEDeviceModifyOptions16sp1(OCIType):
    """
    CPE device's options when used with a modify request.

    The following options are not changeable: configType systemFileName deviceFileFormat

    Attributes:
        enable_monitoring: enableMonitoring
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions16, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeModifyOptions16" = Field(
        type=DeviceManagementDeviceTypeModifyOptions16, required=False, mutable=False,
    )


class CPEDeviceOptions14sp6(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    config_type: str = Field(type=str, required=True, mutable=False)
    system_file_name: str = Field(type=str, required=False, mutable=False)
    device_file_format: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeOptions" = Field(
        type=DeviceManagementDeviceTypeOptions, required=False, mutable=False,
    )


class CPEDeviceOptions16(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring: enableMonitoring
        reset_event: resetEvent
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E("config_type", "configType", str, is_required=True),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions16, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    config_type: str = Field(type=str, required=True, mutable=False)
    system_file_name: str = Field(type=str, required=False, mutable=False)
    device_file_format: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeOptions16" = Field(
        type=DeviceManagementDeviceTypeOptions16, required=False, mutable=False,
    )


class CPEDeviceOptions16sp1(OCIType):
    """
    CPE device's options.

    The field configType is optional to allow the use of field enableMonitoring for all
    device types being managed or not ie.  device configuration option equals to
    DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
    set to "Not Supported", the value of configType is forced set to "None" regardless of
    its current value.  It is not allowed to add a device type with device configuration
    option set to Device Management or Legacy when the configType is not set.

    Attributes:
        enable_monitoring: enableMonitoring
        config_type: configType
        system_file_name: systemFileName
        device_file_format: deviceFileFormat
        device_management_device_type_options: deviceManagementDeviceTypeOptions
    """

    _ELEMENTS = (
        E("enable_monitoring", "enableMonitoring", bool, is_required=True),
        E("config_type", "configType", str),
        E("system_file_name", "systemFileName", str),
        E("device_file_format", "deviceFileFormat", str),
        E(
            "device_management_device_type_options", "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions16, is_complex=True,
        ),
    )

    enable_monitoring: bool = Field(type=bool, required=True, mutable=False)
    config_type: str = Field(type=str, required=False, mutable=False)
    system_file_name: str = Field(type=str, required=False, mutable=False)
    device_file_format: str = Field(type=str, required=False, mutable=False)
    device_management_device_type_options: "DeviceManagementDeviceTypeOptions16" = Field(
        type=DeviceManagementDeviceTypeOptions16, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceModify16(OCIType):
    """
    Contains the call center media on hold source configuration.


    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_file: audioFile
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_file: videoFile
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E("audio_message_source_selection", "audioMessageSourceSelection", str),
        E("audio_file", "audioFile", ExtendedMediaFileResource, is_complex=True),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_file", "videoFile", ExtendedMediaFileResource, is_complex=True),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=False, mutable=False)
    audio_file: "ExtendedMediaFileResource" = Field(
        type=ExtendedMediaFileResource, required=False, mutable=False,
    )
    external_audio_source: "AccessDeviceEndpointModify" = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_file: "ExtendedMediaFileResource" = Field(
        type=ExtendedMediaFileResource, required=False, mutable=False,
    )
    external_video_source: "AccessDeviceEndpointModify" = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceModify17(OCIType):
    """
    Contains the call center media on hold source configuration.


    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_url_list: audioUrlList
        audio_file_list: audioFileList
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_url_list: videoUrlList
        video_file_list: videoFileList
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E("audio_message_source_selection", "audioMessageSourceSelection", str),
        E(
            "audio_url_list", "audioUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementFileListModify,
            is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E(
            "video_url_list", "videoUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementFileListModify,
            is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=False, mutable=False)
    audio_url_list: "CallCenterAnnouncementURLListModify" = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    audio_file_list: "CallCenterAnnouncementFileListModify" = Field(
        type=CallCenterAnnouncementFileListModify, required=False, mutable=False,
    )
    external_audio_source: "AccessDeviceEndpointModify" = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_url_list: "CallCenterAnnouncementURLListModify" = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    video_file_list: "CallCenterAnnouncementFileListModify" = Field(
        type=CallCenterAnnouncementFileListModify, required=False, mutable=False,
    )
    external_video_source: "AccessDeviceEndpointModify" = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceModify20(OCIType):
    """
    Contains the call center media on hold source configuration.


    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_url_list: audioUrlList
        audio_file_list: audioFileList
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_url_list: videoUrlList
        video_file_list: videoFileList
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E("audio_message_source_selection", "audioMessageSourceSelection", str),
        E(
            "audio_url_list", "audioUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementFileListModify20,
            is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E(
            "video_url_list", "videoUrlList", CallCenterAnnouncementURLListModify,
            is_complex=True,
        ),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementFileListModify20,
            is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointModify,
            is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=False, mutable=False)
    audio_url_list: "CallCenterAnnouncementURLListModify" = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    audio_file_list: "CallCenterAnnouncementFileListModify20" = Field(
        type=CallCenterAnnouncementFileListModify20, required=False, mutable=False,
    )
    external_audio_source: "AccessDeviceEndpointModify" = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_url_list: "CallCenterAnnouncementURLListModify" = Field(
        type=CallCenterAnnouncementURLListModify, required=False, mutable=False,
    )
    video_file_list: "CallCenterAnnouncementFileListModify20" = Field(
        type=CallCenterAnnouncementFileListModify20, required=False, mutable=False,
    )
    external_video_source: "AccessDeviceEndpointModify" = Field(
        type=AccessDeviceEndpointModify, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead16(OCIType):
    """
    Contains the call center media on hold source configuration.


    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_file_media_type: audioFileMediaType
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_file_media_type: videoFileMediaType
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_file_media_type", "audioFileMediaType", str),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_file_media_type", "videoFileMediaType", str),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_file_media_type: str = Field(type=str, required=False, mutable=False)
    external_audio_source: "AccessDeviceEndpointRead14" = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_file_media_type: str = Field(type=str, required=False, mutable=False)
    external_video_source: "AccessDeviceEndpointRead14" = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead17(OCIType):
    """
    Contains the call center media on hold source configuration.

    Replaced by: CallCenterMediaOnHoldSourceRead19.

    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_url_list: audioUrlList
        audio_file_list: audioFileList
        audio_media_type_list: audioMediaTypeList
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_url_list: videoUrlList
        video_file_list: videoFileList
        video_media_type_list: videoMediaTypeList
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_url_list", "audioUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "audio_media_type_list", "audioMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_url_list", "videoUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "video_media_type_list", "videoMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource", AccessDeviceEndpointRead14,
            is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=True, mutable=False)
    audio_url_list: "CallCenterAnnouncementURLList" = Field(
        type=CallCenterAnnouncementURLList, required=False, mutable=False,
    )
    audio_file_list: "CallCenterAnnouncementDescriptionList" = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    audio_media_type_list: "CallCenterAnnouncementMediaFileTypeList" = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    external_audio_source: "AccessDeviceEndpointRead14" = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_url_list: "CallCenterAnnouncementURLList" = Field(
        type=CallCenterAnnouncementURLList, required=False, mutable=False,
    )
    video_file_list: "CallCenterAnnouncementDescriptionList" = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    video_media_type_list: "CallCenterAnnouncementMediaFileTypeList" = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    external_video_source: "AccessDeviceEndpointRead14" = Field(
        type=AccessDeviceEndpointRead14, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead19(OCIType):
    """
    Contains the call center media on hold source configuration.


    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_url_list: audioUrlList
        audio_file_list: audioFileList
        audio_media_type_list: audioMediaTypeList
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_url_list: videoUrlList
        video_file_list: videoFileList
        video_media_type_list: videoMediaTypeList
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_url_list", "audioUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "audio_media_type_list", "audioMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_url_list", "videoUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementDescriptionList,
            is_complex=True,
        ),
        E(
            "video_media_type_list", "videoMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList, is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=True, mutable=False)
    audio_url_list: "CallCenterAnnouncementURLList" = Field(
        type=CallCenterAnnouncementURLList, required=False, mutable=False,
    )
    audio_file_list: "CallCenterAnnouncementDescriptionList" = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    audio_media_type_list: "CallCenterAnnouncementMediaFileTypeList" = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    external_audio_source: "AccessDeviceEndpointWithPortNumberRead" = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_url_list: "CallCenterAnnouncementURLList" = Field(
        type=CallCenterAnnouncementURLList, required=False, mutable=False,
    )
    video_file_list: "CallCenterAnnouncementDescriptionList" = Field(
        type=CallCenterAnnouncementDescriptionList, required=False, mutable=False,
    )
    video_media_type_list: "CallCenterAnnouncementMediaFileTypeList" = Field(
        type=CallCenterAnnouncementMediaFileTypeList, required=False, mutable=False,
    )
    external_video_source: "AccessDeviceEndpointWithPortNumberRead" = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )


class CallCenterMediaOnHoldSourceRead20(OCIType):
    """
    Contains the call center media on hold source configuration.


    Attributes:
        audio_message_source_selection: audioMessageSourceSelection
        audio_url_list: audioUrlList
        audio_file_list: audioFileList
        external_audio_source: externalAudioSource
        video_message_source_selection: videoMessageSourceSelection
        video_url_list: videoUrlList
        video_file_list: videoFileList
        external_video_source: externalVideoSource
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection", "audioMessageSourceSelection", str,
            is_required=True,
        ),
        E("audio_url_list", "audioUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "audio_file_list", "audioFileList", CallCenterAnnouncementFileListRead20,
            is_complex=True,
        ),
        E(
            "external_audio_source", "externalAudioSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
        E("video_message_source_selection", "videoMessageSourceSelection", str),
        E("video_url_list", "videoUrlList", CallCenterAnnouncementURLList, is_complex=True),
        E(
            "video_file_list", "videoFileList", CallCenterAnnouncementFileListRead20,
            is_complex=True,
        ),
        E(
            "external_video_source", "externalVideoSource",
            AccessDeviceEndpointWithPortNumberRead, is_complex=True,
        ),
    )

    audio_message_source_selection: str = Field(type=str, required=True, mutable=False)
    audio_url_list: "CallCenterAnnouncementURLList" = Field(
        type=CallCenterAnnouncementURLList, required=False, mutable=False,
    )
    audio_file_list: "CallCenterAnnouncementFileListRead20" = Field(
        type=CallCenterAnnouncementFileListRead20, required=False, mutable=False,
    )
    external_audio_source: "AccessDeviceEndpointWithPortNumberRead" = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )
    video_message_source_selection: str = Field(type=str, required=False, mutable=False)
    video_url_list: "CallCenterAnnouncementURLList" = Field(
        type=CallCenterAnnouncementURLList, required=False, mutable=False,
    )
    video_file_list: "CallCenterAnnouncementFileListRead20" = Field(
        type=CallCenterAnnouncementFileListRead20, required=False, mutable=False,
    )
    external_video_source: "AccessDeviceEndpointWithPortNumberRead" = Field(
        type=AccessDeviceEndpointWithPortNumberRead, required=False, mutable=False,
    )


class CallCenterReportInterval(OCIType):
    """
    Report interval for call center enhanced reporting scheduled reports.


    Attributes:
        dates: dates
        current: current
        past: past
    """

    _ELEMENTS = (
        E("dates", "dates", CallCenterReportIntervalDates, is_complex=True),
        E("current", "current", CallCenterReportCurrentInterval, is_complex=True),
        E("past", "past", CallCenterReportPastInterval, is_complex=True),
    )

    dates: "CallCenterReportIntervalDates" = Field(
        type=CallCenterReportIntervalDates, required=False, mutable=False,
    )
    current: "CallCenterReportCurrentInterval" = Field(
        type=CallCenterReportCurrentInterval, required=False, mutable=False,
    )
    past: "CallCenterReportPastInterval" = Field(
        type=CallCenterReportPastInterval, required=False, mutable=False,
    )


class CallCenterReportSchedule(OCIType):
    """
    A schedule for call center enhanced reporting scheduled report.

    It can either be a fixed time schedule or recurring schedule

    Attributes:
        schedule_time: scheduleTime
        recurrence: recurrence
    """

    _ELEMENTS = (
        E("schedule_time", "scheduleTime", CallCenterReportScheduleTime, is_complex=True),
        E("recurrence", "recurrence", CallCenterReportScheduleRecurrence, is_complex=True),
    )

    schedule_time: "CallCenterReportScheduleTime" = Field(
        type=CallCenterReportScheduleTime, required=False, mutable=False,
    )
    recurrence: "CallCenterReportScheduleRecurrence" = Field(
        type=CallCenterReportScheduleRecurrence, required=False, mutable=False,
    )


class CommPilotExpressSRNoAnswer(OCIType):
    """
    CommPilot Express SR No Answer Settings used in the context of a get.


    Attributes:
        ring_forward_numbers: ringForwardNumbers
        forwarding_number_list: forwardingNumberList
        still_no_answer: stillNoAnswer
    """

    _ELEMENTS = (
        E("ring_forward_numbers", "ringForwardNumbers", bool, is_required=True),
        E(
            "forwarding_number_list", "forwardingNumberList",
            CommPilotExpressSRRedirectionWithRingList, is_complex=True, is_required=True,
        ),
        E(
            "still_no_answer", "stillNoAnswer", CommPilotExpressSRRedirection,
            is_complex=True, is_required=True,
        ),
    )

    ring_forward_numbers: bool = Field(type=bool, required=True, mutable=False)
    forwarding_number_list: "CommPilotExpressSRRedirectionWithRingList" = Field(
        type=CommPilotExpressSRRedirectionWithRingList, required=True, mutable=False,
    )
    still_no_answer: "CommPilotExpressSRRedirection" = Field(
        type=CommPilotExpressSRRedirection, required=True, mutable=False,
    )


class CommPilotExpressSRNoAnswerModify(OCIType):
    """
    CommPilot Express SR No Answer Settings used in the context of a modify.


    Attributes:
        ring_foward_numbers: ringFowardNumbers
        forwarding_number_list: forwardingNumberList
        still_no_answer: stillNoAnswer
    """

    _ELEMENTS = (
        E("ring_foward_numbers", "ringFowardNumbers", bool),
        E(
            "forwarding_number_list", "forwardingNumberList",
            CommPilotExpressSRRedirectionWithRingList, is_complex=True,
        ),
        E(
            "still_no_answer", "stillNoAnswer", CommPilotExpressSRRedirectionModify,
            is_complex=True,
        ),
    )

    ring_foward_numbers: bool = Field(type=bool, required=False, mutable=False)
    forwarding_number_list: "CommPilotExpressSRRedirectionWithRingList" = Field(
        type=CommPilotExpressSRRedirectionWithRingList, required=False, mutable=False,
    )
    still_no_answer: "CommPilotExpressSRRedirectionModify" = Field(
        type=CommPilotExpressSRRedirectionModify, required=False, mutable=False,
    )


class GroupHuntGroupAddInstanceRequest17sp1V1(OCIType):
    """
    Add a Hunt Group instance to a group.

    The domain is required in the serviceUserId.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode: allowMembersToControlGroupBusy, use value
    "false" in AS data mode enableGroupBusy, use value "false" in AS data mode

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_user_id: serviceUserId
        service_instance_profile: serviceInstanceProfile
        policy: policy
        hunt_after_no_answer: huntAfterNoAnswer
        no_answer_number_of_rings: noAnswerNumberOfRings
        forward_after_timeout: forwardAfterTimeout
        forward_timeout_seconds: forwardTimeoutSeconds
        forward_to_phone_number: forwardToPhoneNumber
        agent_user_id: agentUserId
        allow_call_waiting_for_agents: allowCallWaitingForAgents
        allow_members_to_control_group_busy: allowMembersToControlGroupBusy
        enable_group_busy: enableGroupBusy
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
        E(
            "service_instance_profile", "serviceInstanceProfile",
            ServiceInstanceAddProfile, is_complex=True, is_required=True,
        ),
        E("policy", "policy", str, is_required=True),
        E("hunt_after_no_answer", "huntAfterNoAnswer", bool, is_required=True),
        E("no_answer_number_of_rings", "noAnswerNumberOfRings", int, is_required=True),
        E("forward_after_timeout", "forwardAfterTimeout", bool, is_required=True),
        E("forward_timeout_seconds", "forwardTimeoutSeconds", int, is_required=True),
        E("forward_to_phone_number", "forwardToPhoneNumber", str),
        E("agent_user_id", "agentUserId", str, is_array=True),
        E(
            "allow_call_waiting_for_agents", "allowCallWaitingForAgents", bool,
            is_required=True,
        ),
        E(
            "allow_members_to_control_group_busy", "allowMembersToControlGroupBusy", bool,
            is_required=True,
        ),
        E("enable_group_busy", "enableGroupBusy", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_user_id: str = Field(type=str, required=True, mutable=False)
    service_instance_profile: "ServiceInstanceAddProfile" = Field(
        type=ServiceInstanceAddProfile, required=True, mutable=False,
    )
    policy: str = Field(type=str, required=True, mutable=False)
    hunt_after_no_answer: bool = Field(type=bool, required=True, mutable=False)
    no_answer_number_of_rings: int = Field(type=int, required=True, mutable=False)
    forward_after_timeout: bool = Field(type=bool, required=True, mutable=False)
    forward_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    forward_to_phone_number: str = Field(type=str, required=False, mutable=False)
    agent_user_id: "List[str]" = Field(type=list, required=False, mutable=False)
    allow_call_waiting_for_agents: bool = Field(type=bool, required=True, mutable=False)
    allow_members_to_control_group_busy: bool = Field(type=bool, required=True, mutable=False)
    enable_group_busy: bool = Field(type=bool, required=True, mutable=False)


class GroupHuntGroupGetInstanceResponse17sp1V1(OCIType):
    """
    Response to GroupHuntGroupGetInstanceRequest17sp1V1.

    Contains the service profile information and a table of assigned users.  The table has
    column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Weight". The following elements are only used in HSS data mode:
    allowMembersToControlGroupBusy enableGroupBusy

    Attributes:
        service_instance_profile: serviceInstanceProfile
        policy: policy
        hunt_after_no_answer: huntAfterNoAnswer
        no_answer_number_of_rings: noAnswerNumberOfRings
        forward_after_timeout: forwardAfterTimeout
        forward_timeout_seconds: forwardTimeoutSeconds
        forward_to_phone_number: forwardToPhoneNumber
        agent_user_table: agentUserTable
        allow_call_waiting_for_agents: allowCallWaitingForAgents
        allow_members_to_control_group_busy: allowMembersToControlGroupBusy
        enable_group_busy: enableGroupBusy
    """

    _ELEMENTS = (
        E(
            "service_instance_profile", "serviceInstanceProfile",
            ServiceInstanceReadProfile17, is_complex=True, is_required=True,
        ),
        E("policy", "policy", str, is_required=True),
        E("hunt_after_no_answer", "huntAfterNoAnswer", bool, is_required=True),
        E("no_answer_number_of_rings", "noAnswerNumberOfRings", int, is_required=True),
        E("forward_after_timeout", "forwardAfterTimeout", bool, is_required=True),
        E("forward_timeout_seconds", "forwardTimeoutSeconds", int, is_required=True),
        E("forward_to_phone_number", "forwardToPhoneNumber", str),
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "allow_call_waiting_for_agents", "allowCallWaitingForAgents", bool,
            is_required=True,
        ),
        E(
            "allow_members_to_control_group_busy", "allowMembersToControlGroupBusy", bool,
            is_required=True,
        ),
        E("enable_group_busy", "enableGroupBusy", bool, is_required=True),
    )

    service_instance_profile: "ServiceInstanceReadProfile17" = Field(
        type=ServiceInstanceReadProfile17, required=True, mutable=False,
    )
    policy: str = Field(type=str, required=True, mutable=False)
    hunt_after_no_answer: bool = Field(type=bool, required=True, mutable=False)
    no_answer_number_of_rings: int = Field(type=int, required=True, mutable=False)
    forward_after_timeout: bool = Field(type=bool, required=True, mutable=False)
    forward_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    forward_to_phone_number: str = Field(type=str, required=False, mutable=False)
    agent_user_table: "list" = Field(type=list, required=True, mutable=False)
    allow_call_waiting_for_agents: bool = Field(type=bool, required=True, mutable=False)
    allow_members_to_control_group_busy: bool = Field(type=bool, required=True, mutable=False)
    enable_group_busy: bool = Field(type=bool, required=True, mutable=False)


class GroupTrunkGroupAddInstanceRequest14sp9A(OCIType):
    """
    Add a Trunk Group instance to a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        pilot_user: pilotUser
        department: department
        access_device: accessDevice
        max_active_calls: maxActiveCalls
        max_incoming_calls: maxIncomingCalls
        max_outgoing_calls: maxOutgoingCalls
        enable_bursting: enableBursting
        bursting_max_active_calls: burstingMaxActiveCalls
        bursting_max_incoming_calls: burstingMaxIncomingCalls
        bursting_max_outgoing_calls: burstingMaxOutgoingCalls
        capacity_exceeded_action: capacityExceededAction
        capacity_exceeded_forward_address: capacityExceededForwardAddress
        capacity_exceeded_reroute_trunk_group_key: capacityExceededRerouteTrunkGroupKey
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
        unreachable_destination_action: unreachableDestinationAction
        unreachable_destination_forward_address: unreachableDestinationForwardAddress
        unreachable_destination_reroute_trunk_group_key:
            unreachableDestinationRerouteTrunkGroupKey
        unreachable_destination_trap_initial_calls: unreachableDestinationTrapInitialCalls
        unreachable_destination_trap_offset_calls: unreachableDestinationTrapOffsetCalls
        invitation_timeout: invitationTimeout
        require_authentication: requireAuthentication
        sip_authentication_user_name: sipAuthenticationUserName
        sip_authentication_password: sipAuthenticationPassword
        hosted_user_id: hostedUserId
        trunk_group_identity: trunkGroupIdentity
        otg_dtg_identity: otgDtgIdentity
        include_trunk_group_identity: includeTrunkGroupIdentity
        include_dtg_identity: includeDtgIdentity
        enable_network_address_identity: enableNetworkAddressIdentity
        allow_unscreened_calls: allowUnscreenedCalls
        allow_unscreened_emergency_calls: allowUnscreenedEmergencyCalls
        pilot_user_calling_line_identity_policy: pilotUserCallingLineIdentityPolicy
        pilot_user_charge_number_policy: pilotUserChargeNumberPolicy
        call_forwarding_always_action: callForwardingAlwaysAction
        call_forwarding_always_forward_address: callForwardingAlwaysForwardAddress
        call_forwarding_always_reroute_trunk_group_key:
            callForwardingAlwaysRerouteTrunkGroupKey
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("pilot_user", "pilotUser", TrunkGroupPilotUser, is_complex=True),
        E("department", "department", DepartmentKey, is_complex=True),
        E("access_device", "accessDevice", AccessDevice, is_complex=True),
        E("max_active_calls", "maxActiveCalls", int, is_required=True),
        E("max_incoming_calls", "maxIncomingCalls", int),
        E("max_outgoing_calls", "maxOutgoingCalls", int),
        E("enable_bursting", "enableBursting", bool, is_required=True),
        E("bursting_max_active_calls", "burstingMaxActiveCalls", int),
        E("bursting_max_incoming_calls", "burstingMaxIncomingCalls", int),
        E("bursting_max_outgoing_calls", "burstingMaxOutgoingCalls", int),
        E("capacity_exceeded_action", "capacityExceededAction", str),
        E("capacity_exceeded_forward_address", "capacityExceededForwardAddress", str),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls",
            int, is_required=True,
        ),
        E(
            "capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int,
            is_required=True,
        ),
        E("unreachable_destination_action", "unreachableDestinationAction", str),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress", str,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls", int, is_required=True,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls", int, is_required=True,
        ),
        E("invitation_timeout", "invitationTimeout", int, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str),
        E("sip_authentication_password", "sipAuthenticationPassword", str),
        E("hosted_user_id", "hostedUserId", str, is_array=True),
        E("trunk_group_identity", "trunkGroupIdentity", str),
        E("otg_dtg_identity", "otgDtgIdentity", str),
        E(
            "include_trunk_group_identity", "includeTrunkGroupIdentity", bool,
            is_required=True,
        ),
        E("include_dtg_identity", "includeDtgIdentity", bool, is_required=True),
        E(
            "enable_network_address_identity", "enableNetworkAddressIdentity", bool,
            is_required=True,
        ),
        E("allow_unscreened_calls", "allowUnscreenedCalls", bool, is_required=True),
        E(
            "allow_unscreened_emergency_calls", "allowUnscreenedEmergencyCalls", bool,
            is_required=True,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy", str, is_required=True,
        ),
        E(
            "pilot_user_charge_number_policy", "pilotUserChargeNumberPolicy", str,
            is_required=True,
        ),
        E("call_forwarding_always_action", "callForwardingAlwaysAction", str),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress", str,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey", TrunkGroupKey, is_complex=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    pilot_user: "TrunkGroupPilotUser" = Field(
        type=TrunkGroupPilotUser, required=False, mutable=False,
    )
    department: "DepartmentKey" = Field(type=DepartmentKey, required=False, mutable=False)
    access_device: "AccessDevice" = Field(type=AccessDevice, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=True, mutable=False)
    max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    enable_bursting: bool = Field(type=bool, required=True, mutable=False)
    bursting_max_active_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_incoming_calls: int = Field(type=int, required=False, mutable=False)
    bursting_max_outgoing_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_action: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_forward_address: str = Field(type=str, required=False, mutable=False)
    capacity_exceeded_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=True, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=True, mutable=False)
    unreachable_destination_action: str = Field(type=str, required=False, mutable=False)
    unreachable_destination_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    unreachable_destination_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )
    unreachable_destination_trap_initial_calls: int = Field(
        type=int, required=True, mutable=False,
    )
    unreachable_destination_trap_offset_calls: int = Field(
        type=int, required=True, mutable=False,
    )
    invitation_timeout: int = Field(type=int, required=True, mutable=False)
    require_authentication: bool = Field(type=bool, required=True, mutable=False)
    sip_authentication_user_name: str = Field(type=str, required=False, mutable=False)
    sip_authentication_password: str = Field(type=str, required=False, mutable=False)
    hosted_user_id: "List[str]" = Field(type=list, required=False, mutable=False)
    trunk_group_identity: str = Field(type=str, required=False, mutable=False)
    otg_dtg_identity: str = Field(type=str, required=False, mutable=False)
    include_trunk_group_identity: bool = Field(type=bool, required=True, mutable=False)
    include_dtg_identity: bool = Field(type=bool, required=True, mutable=False)
    enable_network_address_identity: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_calls: bool = Field(type=bool, required=True, mutable=False)
    allow_unscreened_emergency_calls: bool = Field(type=bool, required=True, mutable=False)
    pilot_user_calling_line_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    pilot_user_charge_number_policy: str = Field(type=str, required=True, mutable=False)
    call_forwarding_always_action: str = Field(type=str, required=False, mutable=False)
    call_forwarding_always_forward_address: str = Field(
        type=str, required=False, mutable=False,
    )
    call_forwarding_always_reroute_trunk_group_key: "TrunkGroupKey" = Field(
        type=TrunkGroupKey, required=False, mutable=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternCallMeNowPermissions" = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan Call Me Now call permissions for specified digit
    patterns.


    Attributes:
        department_key: departmentKey
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternCallMeNowPermissions" = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for specified digit patterns.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternOriginatingPermissions" = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan originating call permissions for specified digit
    patterns.


    Attributes:
        department_key: departmentKey
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternOriginatingPermissions" = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan redirecting call permissions for specified digit patterns.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternRedirectingPermissions" = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan redirecting call permissions for specified digit
    patterns.


    Attributes:
        department_key: departmentKey
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingCallingPlanDigitPatternRedirectingPermissions" = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan Call Me Now call permissions for a department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    permissions: "OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit
    patterns.


    Attributes:
        department_key: departmentKey
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan department originating call permissions for specified
    digit patterns.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan originating call permissions for specified digit
    patterns.


    Attributes:
        department_key: departmentKey
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan initiating call forwards/transfer permissions for a
    department.


    Attributes:
        department_key: departmentKey
        department_name: departmentName
        permissions: permissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E("department_name", "departmentName", str, is_required=True),
        E(
            "permissions", "permissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)
    permissions: "OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan redirecting call permissions for specified digit
    patterns.


    Attributes:
        department_key: departmentKey
        digit_pattern_permissions: digitPatternPermissions
    """

    _ELEMENTS = (
        E(
            "department_key", "departmentKey", DepartmentKey, is_complex=True,
            is_required=True,
        ),
        E(
            "digit_pattern_permissions", "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, is_complex=True,
            is_required=True,
        ),
    )

    department_key: "DepartmentKey" = Field(type=DepartmentKey, required=True, mutable=False)
    digit_pattern_permissions: "OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions" = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions, required=True,
        mutable=False,
    )


class ReplacementEnterpriseDeviceList(OCIType):
    """
    A list of enterprise accessible devices that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        device: device
    """

    _ELEMENTS = (
        E("device", "device", EnterpriseAccessDevice, is_complex=True, is_required=True),
    )

    device: "EnterpriseAccessDevice" = Field(
        type=EnterpriseAccessDevice, required=True, mutable=False,
    )


class ReplacementEnterpriseEnterpriseTrunkPriorityWeightedTrunkGroupList(OCIType):
    """
    A list of enterprise trunk priority weighted trunk groups that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group: trunkGroup
    """

    _ELEMENTS = (
        E(
            "trunk_group", "trunkGroup",
            EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup, is_complex=True,
            is_required=True,
        ),
    )

    trunk_group: "EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup" = Field(
        type=EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup, required=True,
        mutable=False,
    )


class SystemSIPDeviceTypeGetResponse18sp1V2(OCIType):
    """
    Response to SystemSIPDeviceTypeGetRequest18sp1V2.

    The following elements are only used in AS data mode: holdAnnouncementMethod
    supportRFC3398 The following elements are only used in HSS data mode:
    enable3G4GContinuity The following element values are only applicable in AS data mode:
    holdNormalization=useRfc3264Hold

    Attributes:
        is_obsolete: isObsolete
        number_of_ports: numberOfPorts
        profile: profile
        registration_capable: registrationCapable
        is_conference_device: isConferenceDevice
        is_mobility_manager_device: isMobilityManagerDevice
        is_music_on_hold_device: isMusicOnHoldDevice
        hold_normalization: holdNormalization
        hold_announcement_method: holdAnnouncementMethod
        is_trusted: isTrusted
        e164_capable: E164Capable
        route_advance: routeAdvance
        forwarding_override: forwardingOverride
        wireless_integration: wirelessIntegration
        web_based_config_url: webBasedConfigURL
        is_video_capable: isVideoCapable
        pbx_integration: PBXIntegration
        static_registration_capable: staticRegistrationCapable
        cpe_device_options: cpeDeviceOptions
        protocol_choice: protocolChoice
        early_media_support: earlyMediaSupport
        authenticate_refer: authenticateRefer
        auto_config_soft_client: autoConfigSoftClient
        authentication_mode: authenticationMode
        requires_broad_works_digit_collection: requiresBroadWorksDigitCollection
        requires_broad_works_call_waiting_tone: requiresBroadWorksCallWaitingTone
        requires_mwi_subscription: requiresMWISubscription
        use_history_info_header_on_access_side: useHistoryInfoHeaderOnAccessSide
        advice_of_charge_capable: adviceOfChargeCapable
        reset_event: resetEvent
        support_call_center_mime_type: supportCallCenterMIMEType
        trunk_mode: trunkMode
        add_p_called_party_id: addPCalledPartyId
        support_identity_in_update_and_re_invite: supportIdentityInUpdateAndReInvite
        unscreened_presentation_identity_policy: unscreenedPresentationIdentityPolicy
        enable3_g4_g_continuity: enable3G4GContinuity
        support_emergency_disconnect_control: supportEmergencyDisconnectControl
        device_type_configuration_option: deviceTypeConfigurationOption
        support_rfc3398: supportRFC3398
    """

    _ELEMENTS = (
        E("is_obsolete", "isObsolete", bool, is_required=True),
        E(
            "number_of_ports", "numberOfPorts", UnboundedPositiveInt, is_complex=True,
            is_required=True,
        ),
        E("profile", "profile", str, is_required=True),
        E("registration_capable", "registrationCapable", bool, is_required=True),
        E("is_conference_device", "isConferenceDevice", bool, is_required=True),
        E("is_mobility_manager_device", "isMobilityManagerDevice", bool, is_required=True),
        E("is_music_on_hold_device", "isMusicOnHoldDevice", bool, is_required=True),
        E("hold_normalization", "holdNormalization", str, is_required=True),
        E("hold_announcement_method", "holdAnnouncementMethod", str, is_required=True),
        E("is_trusted", "isTrusted", bool, is_required=True),
        E("e164_capable", "E164Capable", bool, is_required=True),
        E("route_advance", "routeAdvance", bool, is_required=True),
        E("forwarding_override", "forwardingOverride", bool, is_required=True),
        E("wireless_integration", "wirelessIntegration", bool, is_required=True),
        E("web_based_config_url", "webBasedConfigURL", str),
        E("is_video_capable", "isVideoCapable", bool, is_required=True),
        E("pbx_integration", "PBXIntegration", bool, is_required=True),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E(
            "cpe_device_options", "cpeDeviceOptions", CPEDeviceOptionsRead16sp1,
            is_complex=True,
        ),
        E("protocol_choice", "protocolChoice", str, is_required=True),
        E("early_media_support", "earlyMediaSupport", str, is_required=True),
        E("authenticate_refer", "authenticateRefer", bool, is_required=True),
        E("auto_config_soft_client", "autoConfigSoftClient", bool, is_required=True),
        E("authentication_mode", "authenticationMode", str, is_required=True),
        E(
            "requires_broad_works_digit_collection", "requiresBroadWorksDigitCollection",
            bool, is_required=True,
        ),
        E(
            "requires_broad_works_call_waiting_tone", "requiresBroadWorksCallWaitingTone",
            bool, is_required=True,
        ),
        E("requires_mwi_subscription", "requiresMWISubscription", bool, is_required=True),
        E(
            "use_history_info_header_on_access_side", "useHistoryInfoHeaderOnAccessSide",
            bool, is_required=True,
        ),
        E("advice_of_charge_capable", "adviceOfChargeCapable", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E(
            "support_call_center_mime_type", "supportCallCenterMIMEType", bool,
            is_required=True,
        ),
        E("trunk_mode", "trunkMode", str, is_required=True),
        E("add_p_called_party_id", "addPCalledPartyId", bool, is_required=True),
        E(
            "support_identity_in_update_and_re_invite",
            "supportIdentityInUpdateAndReInvite", bool, is_required=True,
        ),
        E(
            "unscreened_presentation_identity_policy",
            "unscreenedPresentationIdentityPolicy", str, is_required=True,
        ),
        E("enable3_g4_g_continuity", "enable3G4GContinuity", bool, is_required=True),
        E(
            "support_emergency_disconnect_control", "supportEmergencyDisconnectControl",
            bool, is_required=True,
        ),
        E(
            "device_type_configuration_option", "deviceTypeConfigurationOption", str,
            is_required=True,
        ),
        E("support_rfc3398", "supportRFC3398", bool, is_required=True),
    )

    is_obsolete: bool = Field(type=bool, required=True, mutable=False)
    number_of_ports: "UnboundedPositiveInt" = Field(
        type=UnboundedPositiveInt, required=True, mutable=False,
    )
    profile: str = Field(type=str, required=True, mutable=False)
    registration_capable: bool = Field(type=bool, required=True, mutable=False)
    is_conference_device: bool = Field(type=bool, required=True, mutable=False)
    is_mobility_manager_device: bool = Field(type=bool, required=True, mutable=False)
    is_music_on_hold_device: bool = Field(type=bool, required=True, mutable=False)
    hold_normalization: str = Field(type=str, required=True, mutable=False)
    hold_announcement_method: str = Field(type=str, required=True, mutable=False)
    is_trusted: bool = Field(type=bool, required=True, mutable=False)
    e164_capable: bool = Field(type=bool, required=True, mutable=False)
    route_advance: bool = Field(type=bool, required=True, mutable=False)
    forwarding_override: bool = Field(type=bool, required=True, mutable=False)
    wireless_integration: bool = Field(type=bool, required=True, mutable=False)
    web_based_config_url: str = Field(type=str, required=False, mutable=False)
    is_video_capable: bool = Field(type=bool, required=True, mutable=False)
    pbx_integration: bool = Field(type=bool, required=True, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    cpe_device_options: "CPEDeviceOptionsRead16sp1" = Field(
        type=CPEDeviceOptionsRead16sp1, required=False, mutable=False,
    )
    protocol_choice: str = Field(type=str, required=True, mutable=False)
    early_media_support: str = Field(type=str, required=True, mutable=False)
    authenticate_refer: bool = Field(type=bool, required=True, mutable=False)
    auto_config_soft_client: bool = Field(type=bool, required=True, mutable=False)
    authentication_mode: str = Field(type=str, required=True, mutable=False)
    requires_broad_works_digit_collection: bool = Field(
        type=bool, required=True, mutable=False,
    )
    requires_broad_works_call_waiting_tone: bool = Field(
        type=bool, required=True, mutable=False,
    )
    requires_mwi_subscription: bool = Field(type=bool, required=True, mutable=False)
    use_history_info_header_on_access_side: bool = Field(
        type=bool, required=True, mutable=False,
    )
    advice_of_charge_capable: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    support_call_center_mime_type: bool = Field(type=bool, required=True, mutable=False)
    trunk_mode: str = Field(type=str, required=True, mutable=False)
    add_p_called_party_id: bool = Field(type=bool, required=True, mutable=False)
    support_identity_in_update_and_re_invite: bool = Field(
        type=bool, required=True, mutable=False,
    )
    unscreened_presentation_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    enable3_g4_g_continuity: bool = Field(type=bool, required=True, mutable=False)
    support_emergency_disconnect_control: bool = Field(
        type=bool, required=True, mutable=False,
    )
    device_type_configuration_option: str = Field(type=str, required=True, mutable=False)
    support_rfc3398: bool = Field(type=bool, required=True, mutable=False)


class TrunkAddressingMultipleContactModify(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    alternateTrunkIdentityDomainName is only used in IMS mode.  Setting
    alternateTrunkIdentity or alternateTrunkIdentityDomain to nil in IMS mode, the other
    one paremter should be set to nil at the same time.

    Attributes:
        trunk_group_device_endpoint: trunkGroupDeviceEndpoint
        enterprise_trunk_name: enterpriseTrunkName
        alternate_trunk_identity: alternateTrunkIdentity
        alternate_trunk_identity_domain: alternateTrunkIdentityDomain
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint", "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointModify, is_complex=True,
        ),
        E("enterprise_trunk_name", "enterpriseTrunkName", str),
        E("alternate_trunk_identity", "alternateTrunkIdentity", str),
        E("alternate_trunk_identity_domain", "alternateTrunkIdentityDomain", str),
    )

    trunk_group_device_endpoint: "TrunkGroupDeviceMultipleContactEndpointModify" = Field(
        type=TrunkGroupDeviceMultipleContactEndpointModify, required=False, mutable=False,
    )
    enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity: str = Field(type=str, required=False, mutable=False)
    alternate_trunk_identity_domain: str = Field(type=str, required=False, mutable=False)


class UserEnhancedCallLogsGetListRequest17sp4V2(OCIType):
    """
    Request user's call logs.

    If the callLogType is not specified, all types of calls logs (placed, received,
    missed) are returned.  The filters "dateTimeRange", "numberFilter",
    "redirectedNumberFilter", "accountAuthorizationCodeFilter"
    "callAuthorizationCodeFilter" and "subscriberType" are ignored if call logs are stored
    in CDS. When "ReceivedOrMissed" is specified as "callLogType" and call logs are stored
    in CDS, all call logs including placed will be returned.  It is possible to restrict
    the number of rows returned using responsePagingControl.  If responsePagingControl is
    not specified, the value of Enhanced Call Logs system parameter
    maxNonPagedResponseSize will control the maximum number of call logs can be returned.

    The response is either a UserEnhancedCallLogsGetListResponse17sp4V2 or an
    ``ErrorResponse()``. The following elements are only used in AS data mode:
    callAuthorizationCodeFilter

    Attributes:
        user_id: userId
        call_log_type: callLogType
        date_time_range: dateTimeRange
        number_filter: numberFilter
        redirected_number_filter: redirectedNumberFilter
        account_authorization_code_filter: accountAuthorizationCodeFilter
        call_authorization_code_filter: callAuthorizationCodeFilter
        subscriber_type: subscriberType
        response_paging_control: responsePagingControl
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("call_log_type", "callLogType", str),
        E(
            "date_time_range", "dateTimeRange", EnhancedCallLogsTimeRange,
            is_complex=True, is_required=True,
        ),
        E("number_filter", "numberFilter", EnhancedCallLogsNumberFilter, is_complex=True),
        E(
            "redirected_number_filter", "redirectedNumberFilter",
            EnhancedCallLogsRedirectedNumberFilter, is_complex=True,
        ),
        E(
            "account_authorization_code_filter", "accountAuthorizationCodeFilter",
            EnhancedCallLogsAccountAuthorizationCodeFilter, is_complex=True,
        ),
        E(
            "call_authorization_code_filter", "callAuthorizationCodeFilter",
            EnhancedCallLogsCallAuthorizationCodeFilter, is_complex=True,
        ),
        E("subscriber_type", "subscriberType", str),
        E(
            "response_paging_control", "responsePagingControl", ResponsePagingControl,
            is_complex=True,
        ),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    call_log_type: str = Field(type=str, required=False, mutable=False)
    date_time_range: "EnhancedCallLogsTimeRange" = Field(
        type=EnhancedCallLogsTimeRange, required=True, mutable=False,
    )
    number_filter: "EnhancedCallLogsNumberFilter" = Field(
        type=EnhancedCallLogsNumberFilter, required=False, mutable=False,
    )
    redirected_number_filter: "EnhancedCallLogsRedirectedNumberFilter" = Field(
        type=EnhancedCallLogsRedirectedNumberFilter, required=False, mutable=False,
    )
    account_authorization_code_filter: "EnhancedCallLogsAccountAuthorizationCodeFilter" = Field(
        type=EnhancedCallLogsAccountAuthorizationCodeFilter, required=False, mutable=False,
    )
    call_authorization_code_filter: "EnhancedCallLogsCallAuthorizationCodeFilter" = Field(
        type=EnhancedCallLogsCallAuthorizationCodeFilter, required=False, mutable=False,
    )
    subscriber_type: str = Field(type=str, required=False, mutable=False)
    response_paging_control: "ResponsePagingControl" = Field(
        type=ResponsePagingControl, required=False, mutable=False,
    )


class AutoAttendantAddMenu(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", LabeledFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )
    video_file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyConfiguration" = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantAddMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyConfiguration" = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantAddMenu19(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration19,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyConfiguration19" = Field(
        type=AutoAttendantKeyConfiguration19, required=False, mutable=False,
    )


class AutoAttendantAddMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration20,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyConfiguration20" = Field(
        type=AutoAttendantKeyConfiguration20, required=False, mutable=False,
    )


class AutoAttendantModifyMenu(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during business hours.

    It is used when modifying an Auto Attendant group.

    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str),
        E("audio_file", "audioFile", LabeledFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyModifyConfiguration,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )
    video_file: "LabeledFileResource" = Field(
        type=LabeledFileResource, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    key_configuration: "AutoAttendantKeyModifyConfiguration" = Field(
        type=AutoAttendantKeyModifyConfiguration, required=False, mutable=False,
    )


class AutoAttendantModifyMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during business hours.

    It is used when modifying an Auto Attendant group.

    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str),
        E("audio_file", "audioFile", LabeledMediaFileResource, is_complex=True),
        E("video_file", "videoFile", LabeledMediaFileResource, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyModifyConfiguration,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=False, mutable=False)
    audio_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    video_file: "LabeledMediaFileResource" = Field(
        type=LabeledMediaFileResource, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    key_configuration: "AutoAttendantKeyModifyConfiguration" = Field(
        type=AutoAttendantKeyModifyConfiguration, required=False, mutable=False,
    )


class AutoAttendantModifyMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during business hours.

    It is used when modifying an Auto Attendant group.

    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool,
        ),
        E(
            "key_configuration", "keyConfiguration",
            AutoAttendantKeyModifyConfiguration20, is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=False, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    key_configuration: "AutoAttendantKeyModifyConfiguration20" = Field(
        type=AutoAttendantKeyModifyConfiguration20, required=False, mutable=False,
    )


class AutoAttendantReadMenu(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file_description: audioFileDescription
        video_file_description: videoFileDescription
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("video_file_description", "videoFileDescription", str),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyConfiguration" = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantReadMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyConfiguration,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyConfiguration" = Field(
        type=AutoAttendantKeyConfiguration, required=False, mutable=False,
    )


class AutoAttendantReadMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting prompt and dialing menu to be
    used during after business hours.


    Attributes:
        announcement_selection: announcementSelection
        audio_file: audioFile
        video_file: videoFile
        enable_first_menu_level_extension_dialing: enableFirstMenuLevelExtensionDialing
        key_configuration: keyConfiguration
    """

    _ELEMENTS = (
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file", "audioFile", AnnouncementFileLevelKey, is_complex=True),
        E("video_file", "videoFile", AnnouncementFileLevelKey, is_complex=True),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing", bool, is_required=True,
        ),
        E(
            "key_configuration", "keyConfiguration", AutoAttendantKeyReadConfiguration20,
            is_complex=True,
        ),
    )

    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    video_file: "AnnouncementFileLevelKey" = Field(
        type=AnnouncementFileLevelKey, required=False, mutable=False,
    )
    enable_first_menu_level_extension_dialing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    key_configuration: "AutoAttendantKeyReadConfiguration20" = Field(
        type=AutoAttendantKeyReadConfiguration20, required=False, mutable=False,
    )


class CommPilotExpressSRAvailableInOffice(OCIType):
    """
    CommPilot Express SR Available In Office Settings used in the context of a get.


    Attributes:
        busy_setting: busySetting
        no_answer_setting: noAnswerSetting
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "busy_setting", "busySetting", CommPilotExpressSRRedirection, is_complex=True,
            is_required=True,
        ),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswer,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    busy_setting: "CommPilotExpressSRRedirection" = Field(
        type=CommPilotExpressSRRedirection, required=True, mutable=False,
    )
    no_answer_setting: "CommPilotExpressSRNoAnswer" = Field(
        type=CommPilotExpressSRNoAnswer, required=True, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotify" = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRAvailableInOfficeModify(OCIType):
    """
    CommPilot Express SR Available In Office Settings used in the context of a modify.


    Attributes:
        busy_setting: busySetting
        no_answer_setting: noAnswerSetting
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E(
            "busy_setting", "busySetting", CommPilotExpressSRRedirectionModify,
            is_complex=True,
        ),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswerModify,
            is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    busy_setting: "CommPilotExpressSRRedirectionModify" = Field(
        type=CommPilotExpressSRRedirectionModify, required=False, mutable=False,
    )
    no_answer_setting: "CommPilotExpressSRNoAnswerModify" = Field(
        type=CommPilotExpressSRNoAnswerModify, required=False, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotifyModify" = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class CommPilotExpressSRAvailableOutOfOffice(OCIType):
    """
    CommPilot Express SR Available Out Of Office Configuration used in the context of a
    get.


    Attributes:
        remote_phone_number: remotePhoneNumber
        no_answer_setting: noAnswerSetting
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E("remote_phone_number", "remotePhoneNumber", str),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswer,
            is_complex=True, is_required=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify", CommPilotExpressSREmailNotify,
            is_complex=True, is_required=True,
        ),
    )

    remote_phone_number: str = Field(type=str, required=False, mutable=False)
    no_answer_setting: "CommPilotExpressSRNoAnswer" = Field(
        type=CommPilotExpressSRNoAnswer, required=True, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotify" = Field(
        type=CommPilotExpressSREmailNotify, required=True, mutable=False,
    )


class CommPilotExpressSRAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express SR Available Out Of Office Configuration used in the context of a
    modify.


    Attributes:
        remote_phone_number: remotePhoneNumber
        no_answer_setting: noAnswerSetting
        incoming_call_notify: incomingCallNotify
    """

    _ELEMENTS = (
        E("remote_phone_number", "remotePhoneNumber", str),
        E(
            "no_answer_setting", "noAnswerSetting", CommPilotExpressSRNoAnswerModify,
            is_complex=True,
        ),
        E(
            "incoming_call_notify", "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify, is_complex=True,
        ),
    )

    remote_phone_number: str = Field(type=str, required=False, mutable=False)
    no_answer_setting: "CommPilotExpressSRNoAnswerModify" = Field(
        type=CommPilotExpressSRNoAnswerModify, required=False, mutable=False,
    )
    incoming_call_notify: "CommPilotExpressSREmailNotifyModify" = Field(
        type=CommPilotExpressSREmailNotifyModify, required=False, mutable=False,
    )


class SystemSIPDeviceTypeAddRequest18sp1V2(OCIType):
    """
    Request to add a sip device type.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode: enable3G4GContinuity, use value "false" in AS
    data mode The following elements are only used in AS data mode:
    holdAnnouncementMethod, use value "useInactive" in HSS data mode supportRFC3398, use
    value "false" in HSS data mode The following element values are only applicable in AS
    data mode: holdNormalization=useRfc3264Hold will raise an error in HSS data mode
    Replaced by: ``SystemSIPDeviceTypeAddRequest19()``.

    Attributes:
        device_type: deviceType
        number_of_ports: numberOfPorts
        profile: profile
        registration_capable: registrationCapable
        is_conference_device: isConferenceDevice
        is_mobility_manager_device: isMobilityManagerDevice
        is_music_on_hold_device: isMusicOnHoldDevice
        hold_normalization: holdNormalization
        hold_announcement_method: holdAnnouncementMethod
        is_trusted: isTrusted
        e164_capable: E164Capable
        route_advance: routeAdvance
        forwarding_override: forwardingOverride
        wireless_integration: wirelessIntegration
        web_based_config_url: webBasedConfigURL
        is_video_capable: isVideoCapable
        pbx_integration: PBXIntegration
        static_registration_capable: staticRegistrationCapable
        cpe_device_options: cpeDeviceOptions
        early_media_support: earlyMediaSupport
        authenticate_refer: authenticateRefer
        auto_config_soft_client: autoConfigSoftClient
        authentication_mode: authenticationMode
        requires_broad_works_digit_collection: requiresBroadWorksDigitCollection
        requires_broad_works_call_waiting_tone: requiresBroadWorksCallWaitingTone
        requires_mwi_subscription: requiresMWISubscription
        use_history_info_header_on_access_side: useHistoryInfoHeaderOnAccessSide
        advice_of_charge_capable: adviceOfChargeCapable
        reset_event: resetEvent
        support_call_center_mime_type: supportCallCenterMIMEType
        trunk_mode: trunkMode
        add_p_called_party_id: addPCalledPartyId
        support_identity_in_update_and_re_invite: supportIdentityInUpdateAndReInvite
        unscreened_presentation_identity_policy: unscreenedPresentationIdentityPolicy
        enable3_g4_g_continuity: enable3G4GContinuity
        support_emergency_disconnect_control: supportEmergencyDisconnectControl
        device_type_configuration_option: deviceTypeConfigurationOption
        support_rfc3398: supportRFC3398
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E(
            "number_of_ports", "numberOfPorts", UnboundedPositiveInt, is_complex=True,
            is_required=True,
        ),
        E("profile", "profile", str, is_required=True),
        E("registration_capable", "registrationCapable", bool, is_required=True),
        E("is_conference_device", "isConferenceDevice", bool, is_required=True),
        E("is_mobility_manager_device", "isMobilityManagerDevice", bool, is_required=True),
        E("is_music_on_hold_device", "isMusicOnHoldDevice", bool, is_required=True),
        E("hold_normalization", "holdNormalization", str, is_required=True),
        E("hold_announcement_method", "holdAnnouncementMethod", str, is_required=True),
        E("is_trusted", "isTrusted", bool, is_required=True),
        E("e164_capable", "E164Capable", bool, is_required=True),
        E("route_advance", "routeAdvance", bool, is_required=True),
        E("forwarding_override", "forwardingOverride", bool, is_required=True),
        E("wireless_integration", "wirelessIntegration", bool, is_required=True),
        E("web_based_config_url", "webBasedConfigURL", str),
        E("is_video_capable", "isVideoCapable", bool, is_required=True),
        E("pbx_integration", "PBXIntegration", bool, is_required=True),
        E("static_registration_capable", "staticRegistrationCapable", bool, is_required=True),
        E("cpe_device_options", "cpeDeviceOptions", CPEDeviceOptions16sp1, is_complex=True),
        E("early_media_support", "earlyMediaSupport", str, is_required=True),
        E("authenticate_refer", "authenticateRefer", bool, is_required=True),
        E("auto_config_soft_client", "autoConfigSoftClient", bool, is_required=True),
        E("authentication_mode", "authenticationMode", str, is_required=True),
        E(
            "requires_broad_works_digit_collection", "requiresBroadWorksDigitCollection",
            bool, is_required=True,
        ),
        E(
            "requires_broad_works_call_waiting_tone", "requiresBroadWorksCallWaitingTone",
            bool, is_required=True,
        ),
        E("requires_mwi_subscription", "requiresMWISubscription", bool, is_required=True),
        E(
            "use_history_info_header_on_access_side", "useHistoryInfoHeaderOnAccessSide",
            bool, is_required=True,
        ),
        E("advice_of_charge_capable", "adviceOfChargeCapable", bool, is_required=True),
        E("reset_event", "resetEvent", str),
        E(
            "support_call_center_mime_type", "supportCallCenterMIMEType", bool,
            is_required=True,
        ),
        E("trunk_mode", "trunkMode", str, is_required=True),
        E("add_p_called_party_id", "addPCalledPartyId", bool, is_required=True),
        E(
            "support_identity_in_update_and_re_invite",
            "supportIdentityInUpdateAndReInvite", bool, is_required=True,
        ),
        E(
            "unscreened_presentation_identity_policy",
            "unscreenedPresentationIdentityPolicy", str, is_required=True,
        ),
        E("enable3_g4_g_continuity", "enable3G4GContinuity", bool, is_required=True),
        E(
            "support_emergency_disconnect_control", "supportEmergencyDisconnectControl",
            bool, is_required=True,
        ),
        E(
            "device_type_configuration_option", "deviceTypeConfigurationOption", str,
            is_required=True,
        ),
        E("support_rfc3398", "supportRFC3398", bool, is_required=True),
    )

    device_type: str = Field(type=str, required=True, mutable=False)
    number_of_ports: "UnboundedPositiveInt" = Field(
        type=UnboundedPositiveInt, required=True, mutable=False,
    )
    profile: str = Field(type=str, required=True, mutable=False)
    registration_capable: bool = Field(type=bool, required=True, mutable=False)
    is_conference_device: bool = Field(type=bool, required=True, mutable=False)
    is_mobility_manager_device: bool = Field(type=bool, required=True, mutable=False)
    is_music_on_hold_device: bool = Field(type=bool, required=True, mutable=False)
    hold_normalization: str = Field(type=str, required=True, mutable=False)
    hold_announcement_method: str = Field(type=str, required=True, mutable=False)
    is_trusted: bool = Field(type=bool, required=True, mutable=False)
    e164_capable: bool = Field(type=bool, required=True, mutable=False)
    route_advance: bool = Field(type=bool, required=True, mutable=False)
    forwarding_override: bool = Field(type=bool, required=True, mutable=False)
    wireless_integration: bool = Field(type=bool, required=True, mutable=False)
    web_based_config_url: str = Field(type=str, required=False, mutable=False)
    is_video_capable: bool = Field(type=bool, required=True, mutable=False)
    pbx_integration: bool = Field(type=bool, required=True, mutable=False)
    static_registration_capable: bool = Field(type=bool, required=True, mutable=False)
    cpe_device_options: "CPEDeviceOptions16sp1" = Field(
        type=CPEDeviceOptions16sp1, required=False, mutable=False,
    )
    early_media_support: str = Field(type=str, required=True, mutable=False)
    authenticate_refer: bool = Field(type=bool, required=True, mutable=False)
    auto_config_soft_client: bool = Field(type=bool, required=True, mutable=False)
    authentication_mode: str = Field(type=str, required=True, mutable=False)
    requires_broad_works_digit_collection: bool = Field(
        type=bool, required=True, mutable=False,
    )
    requires_broad_works_call_waiting_tone: bool = Field(
        type=bool, required=True, mutable=False,
    )
    requires_mwi_subscription: bool = Field(type=bool, required=True, mutable=False)
    use_history_info_header_on_access_side: bool = Field(
        type=bool, required=True, mutable=False,
    )
    advice_of_charge_capable: bool = Field(type=bool, required=True, mutable=False)
    reset_event: str = Field(type=str, required=False, mutable=False)
    support_call_center_mime_type: bool = Field(type=bool, required=True, mutable=False)
    trunk_mode: str = Field(type=str, required=True, mutable=False)
    add_p_called_party_id: bool = Field(type=bool, required=True, mutable=False)
    support_identity_in_update_and_re_invite: bool = Field(
        type=bool, required=True, mutable=False,
    )
    unscreened_presentation_identity_policy: str = Field(
        type=str, required=True, mutable=False,
    )
    enable3_g4_g_continuity: bool = Field(type=bool, required=True, mutable=False)
    support_emergency_disconnect_control: bool = Field(
        type=bool, required=True, mutable=False,
    )
    device_type_configuration_option: str = Field(type=str, required=True, mutable=False)
    support_rfc3398: bool = Field(type=bool, required=True, mutable=False)


# fmt: on
# end
