from __future__ import annotations
from collections.abc import Callable
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .speaker_info import SpeakerInfo

@dataclass
class TranscriptSpeaker(AdditionalDataHolder, Parsable):
    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: dict[str, Any] = field(default_factory=dict)

    # The OdataType property
    odata_type: Optional[str] = None
    # The room property
    room: Optional[SpeakerInfo] = None
    # The user property
    user: Optional[SpeakerInfo] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> TranscriptSpeaker:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: TranscriptSpeaker
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return TranscriptSpeaker()
    
    def get_field_deserializers(self,) -> dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: dict[str, Callable[[ParseNode], None]]
        """
        from .speaker_info import SpeakerInfo

        from .speaker_info import SpeakerInfo

        fields: dict[str, Callable[[Any], None]] = {
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "room": lambda n : setattr(self, 'room', n.get_object_value(SpeakerInfo)),
            "user": lambda n : setattr(self, 'user', n.get_object_value(SpeakerInfo)),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_object_value("room", self.room)
        writer.write_object_value("user", self.user)
        writer.write_additional_data_value(self.additional_data)
    

