# coding: utf-8

"""
    EXACT - API

    API to interact with the EXACT Server  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest

from exact_sync.v1.api_client import ApiClient as client
from exact_sync.v1.api.teams_api import TeamsApi  # noqa: E501
from exact_sync.v1.rest import ApiException
from exact_sync.v1.models.team import Team

class TestTeamsApi(unittest.TestCase):
    """TeamsApi unit test stubs"""

    def setUp(self):
        self.api = TeamsApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_team(self):
        """Test case for create_team

        """
        team = Team(name="test_create_team")
        created_team = self.api.create_team(body=team) 
        self.api.destroy_team(id=created_team.id)
        pass

    def test_destroy_team(self):
        """Test case for destroy_team

        """
        team = Team(name="test_destroy_team")
        created_team = self.api.create_team(body=team) 
        self.api.destroy_team(id=created_team.id)
        pass

    def test_list_teams(self):
        """Test case for list_teams

        """
        teams = self.api.list_teams()
        pass

    def test_partial_update_team(self):
        """Test case for partial_update_team

        """
        team = Team(name="p_update_team")
        created_team = self.api.create_team(body=team) 

        new_name = team.name + "PartialUpdate"
        updated_team = self.api.partial_update_team(id=created_team.id, name=new_name)
        
        assert new_name == updated_team.name
        self.api.destroy_team(id=updated_team.id)
        pass

    def test_retrieve_team(self):
        """Test case for retrieve_team

        """
        teams = self.api.list_teams()
        team = teams.results[0]
        team = self.api.retrieve_team(id=team.id)
        pass

    def test_update_team(self):
        """Test case for update_team

        """
        team = Team(name="update_team")
        created_team = self.api.create_team(body=team) 

        created_team.name = team.name + "Update"
        updated_team = self.api.update_team(id=created_team.id, body=created_team)

        assert created_team.name == updated_team.name
        self.api.destroy_team(id=updated_team.id)
        pass


if __name__ == '__main__':
    unittest.main()
