from setuptools import setup

import sys
from os.path import dirname, exists, join
import subprocess

base_package = "dslogparser"

setup_dir = dirname(__file__)
git_dir = join(setup_dir, ".git")
version_file = join(setup_dir, base_package, "version.py")

# Automatically generate a version.py based on the git version
if exists(git_dir):
    p = subprocess.Popen(
        ["git", "describe", "--tags", "--long", "--dirty=-dirty"],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
    )
    out, err = p.communicate()
    # Make sure the git version has at least one tag
    if err:
        print("Error: You need to create a tag for this repo to use the builder")
        sys.exit(1)

    # Convert git version to PEP440 compliant version
    # - Older versions of pip choke on local identifiers, so we can't include the git commit
    v, commits, local = out.decode("utf-8").rstrip().split("-", 2)
    if commits != "0" or "-dirty" in local:
        v = "%s.post0.dev%s" % (v, commits)

    # Create the version.py file
    with open(version_file, "w") as fp:
        fp.write("# Autogenerated by setup.py\n__version__ = '{0}'\n".format(v))

if exists(version_file):
    with open(join(setup_dir, base_package, "version.py"), "r") as fp:
        exec(fp.read(), globals())
else:
    __version__ = "master"

# read the contents of your README file
with open(join(setup_dir, 'README-dslogparser.md'), encoding='utf-8') as f:
    long_description = f.read()


setup(
    name=base_package,
    version=__version__,
    description='FIRST FRC Driver Station logs parser',
    author='Paul Rensing',
    author_email='prensing@ligerbots.org',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='http://github.com/ligerbots/dslogparser',
    license='MIT',
    packages=['dslogparser'],
    scripts=['dslog2csv.py'],
    install_requires=['bitstring'],
    keywords=['FRC', 'logfiles'],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: Education',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
    ]
)
