# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr
from luminesce.models.available_field import AvailableField
from luminesce.models.field_design import FieldDesign
from luminesce.models.order_by_term_design import OrderByTermDesign

class QueryDesign(BaseModel):
    """
    Representation of a \"designable Query\" suitable for formatting to SQL or being built from compliant SQL.  # noqa: E501
    """
    table_name: constr(strict=True, max_length=256, min_length=0) = Field(..., alias="tableName", description="Name of the table being designed")
    alias: Optional[constr(strict=True, max_length=256, min_length=0)] = Field(None, description="Alias for the table in the generated SQL, if any")
    fields: conlist(FieldDesign) = Field(..., description="Fields to be selected, aggregated over and/or filtered on")
    order_by: Optional[conlist(OrderByTermDesign)] = Field(None, alias="orderBy", description="Order By clauses to apply")
    limit: Optional[StrictInt] = Field(None, description="Row limit to apply, if any")
    warnings: Optional[conlist(StrictStr)] = Field(None, description="Any warnings to show the user when converting from SQL to this representation")
    available_fields: Optional[conlist(AvailableField)] = Field(None, alias="availableFields", description="Fields that are known to be available for design when parsing SQL")
    __properties = ["tableName", "alias", "fields", "orderBy", "limit", "warnings", "availableFields"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QueryDesign:
        """Create an instance of QueryDesign from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item in self.fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in order_by (list)
        _items = []
        if self.order_by:
            for _item in self.order_by:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orderBy'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in available_fields (list)
        _items = []
        if self.available_fields:
            for _item in self.available_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['availableFields'] = _items
        # set to None if alias (nullable) is None
        # and __fields_set__ contains the field
        if self.alias is None and "alias" in self.__fields_set__:
            _dict['alias'] = None

        # set to None if order_by (nullable) is None
        # and __fields_set__ contains the field
        if self.order_by is None and "order_by" in self.__fields_set__:
            _dict['orderBy'] = None

        # set to None if limit (nullable) is None
        # and __fields_set__ contains the field
        if self.limit is None and "limit" in self.__fields_set__:
            _dict['limit'] = None

        # set to None if warnings (nullable) is None
        # and __fields_set__ contains the field
        if self.warnings is None and "warnings" in self.__fields_set__:
            _dict['warnings'] = None

        # set to None if available_fields (nullable) is None
        # and __fields_set__ contains the field
        if self.available_fields is None and "available_fields" in self.__fields_set__:
            _dict['availableFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QueryDesign:
        """Create an instance of QueryDesign from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QueryDesign.parse_obj(obj)

        _obj = QueryDesign.parse_obj({
            "table_name": obj.get("tableName"),
            "alias": obj.get("alias"),
            "fields": [FieldDesign.from_dict(_item) for _item in obj.get("fields")] if obj.get("fields") is not None else None,
            "order_by": [OrderByTermDesign.from_dict(_item) for _item in obj.get("orderBy")] if obj.get("orderBy") is not None else None,
            "limit": obj.get("limit"),
            "warnings": obj.get("warnings"),
            "available_fields": [AvailableField.from_dict(_item) for _item in obj.get("availableFields")] if obj.get("availableFields") is not None else None
        })
        return _obj
