# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr

class LusidProblemDetails(BaseModel):
    """
    LusidProblemDetails
    """
    name: constr(strict=True, min_length=1) = Field(...)
    error_details: Optional[conlist(Dict[str, StrictStr])] = Field(None, alias="errorDetails")
    code: StrictInt = Field(...)
    type: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    status: Optional[StrictInt] = None
    detail: Optional[StrictStr] = None
    instance: Optional[StrictStr] = None
    __properties = ["name", "errorDetails", "code", "type", "title", "status", "detail", "instance"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LusidProblemDetails:
        """Create an instance of LusidProblemDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if error_details (nullable) is None
        # and __fields_set__ contains the field
        if self.error_details is None and "error_details" in self.__fields_set__:
            _dict['errorDetails'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if title (nullable) is None
        # and __fields_set__ contains the field
        if self.title is None and "title" in self.__fields_set__:
            _dict['title'] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict['status'] = None

        # set to None if detail (nullable) is None
        # and __fields_set__ contains the field
        if self.detail is None and "detail" in self.__fields_set__:
            _dict['detail'] = None

        # set to None if instance (nullable) is None
        # and __fields_set__ contains the field
        if self.instance is None and "instance" in self.__fields_set__:
            _dict['instance'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LusidProblemDetails:
        """Create an instance of LusidProblemDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LusidProblemDetails.parse_obj(obj)

        _obj = LusidProblemDetails.parse_obj({
            "name": obj.get("name"),
            "error_details": obj.get("errorDetails"),
            "code": obj.get("code"),
            "type": obj.get("type"),
            "title": obj.get("title"),
            "status": obj.get("status"),
            "detail": obj.get("detail"),
            "instance": obj.get("instance")
        })
        return _obj
