# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import BaseModel, Field, StrictBool, conlist, constr
from luminesce.models.cursor_position import CursorPosition
from luminesce.models.intellisense_item import IntellisenseItem

class IntellisenseResponse(BaseModel):
    """
    Available intellisense response information  # noqa: E501
    """
    auto_complete_list: conlist(IntellisenseItem) = Field(..., alias="autoCompleteList", description="The available items at this point")
    try_again_soon_for_more: StrictBool = Field(..., alias="tryAgainSoonForMore", description="Should the caller try again soon? (true means a cache is being built and this is a preliminary response!)")
    sql_with_marker: constr(strict=True, min_length=1) = Field(..., alias="sqlWithMarker", description="The SQL this is for with characters indicating the location the pop-up is for")
    start_replacement_position: CursorPosition = Field(..., alias="startReplacementPosition")
    end_replacement_position: CursorPosition = Field(..., alias="endReplacementPosition")
    __properties = ["autoCompleteList", "tryAgainSoonForMore", "sqlWithMarker", "startReplacementPosition", "endReplacementPosition"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IntellisenseResponse:
        """Create an instance of IntellisenseResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in auto_complete_list (list)
        _items = []
        if self.auto_complete_list:
            for _item in self.auto_complete_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['autoCompleteList'] = _items
        # override the default output from pydantic by calling `to_dict()` of start_replacement_position
        if self.start_replacement_position:
            _dict['startReplacementPosition'] = self.start_replacement_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of end_replacement_position
        if self.end_replacement_position:
            _dict['endReplacementPosition'] = self.end_replacement_position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IntellisenseResponse:
        """Create an instance of IntellisenseResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IntellisenseResponse.parse_obj(obj)

        _obj = IntellisenseResponse.parse_obj({
            "auto_complete_list": [IntellisenseItem.from_dict(_item) for _item in obj.get("autoCompleteList")] if obj.get("autoCompleteList") is not None else None,
            "try_again_soon_for_more": obj.get("tryAgainSoonForMore"),
            "sql_with_marker": obj.get("sqlWithMarker"),
            "start_replacement_position": CursorPosition.from_dict(obj.get("startReplacementPosition")) if obj.get("startReplacementPosition") is not None else None,
            "end_replacement_position": CursorPosition.from_dict(obj.get("endReplacementPosition")) if obj.get("endReplacementPosition") is not None else None
        })
        return _obj
