# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import BaseModel, Field, conlist, constr
from luminesce.models.mappable_field import MappableField

class AvailableParameter(BaseModel):
    """
    Information about a field that can be designed on (regardless if it currently is)  Kind of a \"mini-available catalog entry\"  # noqa: E501
    """
    provider_name: constr(strict=True, min_length=1) = Field(..., alias="providerName", description="Name of the Provider with a TableParameter")
    parameter_name: constr(strict=True, min_length=1) = Field(..., alias="parameterName", description="Name of the TableParameter on the Provider")
    fields: conlist(MappableField) = Field(..., description="Fields that can be mapped to")
    __properties = ["providerName", "parameterName", "fields"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AvailableParameter:
        """Create an instance of AvailableParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item in self.fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AvailableParameter:
        """Create an instance of AvailableParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AvailableParameter.parse_obj(obj)

        _obj = AvailableParameter.parse_obj({
            "provider_name": obj.get("providerName"),
            "parameter_name": obj.get("parameterName"),
            "fields": [MappableField.from_dict(_item) for _item in obj.get("fields")] if obj.get("fields") is not None else None
        })
        return _obj
