# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr

from typing import Optional, Union


from luminesce.api_client import ApiClient
from luminesce.api_response import ApiResponse
from luminesce.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SqlExecutionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @overload
    async def get_by_query_csv(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_csv(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_csv(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryCsv: Executes Sql, returned in CSV format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_csv(query, query_name, download, timeout, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_csv_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_csv_with_http_info(query, query_name, download, timeout, delimiter, escape, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_csv_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryCsv: Executes Sql, returned in CSV format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_csv_with_http_info(query, query_name, download, timeout, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'download',
            'timeout',
            'delimiter',
            'escape'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_csv" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        if _params.get('delimiter') is not None:  # noqa: E501
            _query_params.append(('delimiter', _params['delimiter']))

        if _params.get('escape') is not None:  # noqa: E501
            _query_params.append(('escape', _params['escape']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/csv/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_excel(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def get_by_query_excel(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_excel(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """GetByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_excel(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_excel_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_excel_with_http_info(query, query_name, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_excel_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_excel_with_http_info(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_excel" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/excel/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_json(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_json(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_json(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryJson: Executes Sql, returned in JSON format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_json(query, query_name, timeout, json_proper, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_json_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_json_with_http_info(query, query_name, timeout, json_proper, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_json_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryJson: Executes Sql, returned in JSON format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_json_with_http_info(query, query_name, timeout, json_proper, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout',
            'json_proper'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_json" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        if _params.get('json_proper') is not None:  # noqa: E501
            _query_params.append(('jsonProper', _params['json_proper']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/json/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_parquet(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def get_by_query_parquet(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_parquet(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """GetByQueryParquet: Executes Sql, returned in Parquet (.parquet) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_parquet(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_parquet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_parquet_with_http_info(query, query_name, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_parquet_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryParquet: Executes Sql, returned in Parquet (.parquet) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_parquet_with_http_info(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_parquet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/parquet/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_pipe(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_pipe(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_pipe(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_pipe(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_pipe_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_pipe_with_http_info(query, query_name, download, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_pipe_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_pipe_with_http_info(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'download',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_pipe" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/pipe/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_sqlite(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def get_by_query_sqlite(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_sqlite(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """GetByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_sqlite(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_sqlite_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_sqlite_with_http_info(query, query_name, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_sqlite_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_sqlite_with_http_info(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_sqlite" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/sqlite/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_xml(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_xml(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_xml(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryXml: Executes Sql, returned in Xml format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_xml(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_xml_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_xml_with_http_info(query, query_name, download, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_xml_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryXml: Executes Sql, returned in Xml format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_xml_with_http_info(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'download',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_xml" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/xml/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_csv(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_csv(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_csv(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryCsv: Executes Sql, returned in CSV format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_csv(body, query_name, download, timeout_seconds, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_csv_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_csv_with_http_info(body, query_name, download, timeout_seconds, delimiter, escape, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_csv_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryCsv: Executes Sql, returned in CSV format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_csv_with_http_info(body, query_name, download, timeout_seconds, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'download',
            'timeout_seconds',
            'delimiter',
            'escape'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_csv" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        if _params.get('delimiter') is not None:  # noqa: E501
            _query_params.append(('delimiter', _params['delimiter']))

        if _params.get('escape') is not None:  # noqa: E501
            _query_params.append(('escape', _params['escape']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/csv', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_excel(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def put_by_query_excel(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_excel(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """PutByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_excel(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_excel_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_excel_with_http_info(body, query_name, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_excel_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_excel_with_http_info(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_excel" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/excel', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_json(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_json(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_json(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryJson: Executes Sql, returned in JSON format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_json(body, query_name, timeout_seconds, json_proper, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_json_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_json_with_http_info(body, query_name, timeout_seconds, json_proper, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_json_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryJson: Executes Sql, returned in JSON format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_json_with_http_info(body, query_name, timeout_seconds, json_proper, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds',
            'json_proper'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_json" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        if _params.get('json_proper') is not None:  # noqa: E501
            _query_params.append(('jsonProper', _params['json_proper']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/json', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_parquet(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def put_by_query_parquet(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_parquet(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """PutByQueryParquet: Executes Sql, returned in Parquet format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_parquet(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_parquet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_parquet_with_http_info(body, query_name, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_parquet_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryParquet: Executes Sql, returned in Parquet format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_parquet_with_http_info(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_parquet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/parquet', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_pipe(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_pipe(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_pipe(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_pipe(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_pipe_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_pipe_with_http_info(body, query_name, download, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_pipe_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_pipe_with_http_info(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'download',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_pipe" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/pipe', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_sqlite(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def put_by_query_sqlite(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_sqlite(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """PutByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_sqlite(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_sqlite_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_sqlite_with_http_info(body, query_name, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_sqlite_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_sqlite_with_http_info(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_sqlite" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/sqlite', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_xml(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_xml(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_xml(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryXml: Executes Sql, returned in Xml format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_xml(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_xml_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_xml_with_http_info(body, query_name, download, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_xml_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryXml: Executes Sql, returned in Xml format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized - 403 Forbidden   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_xml_with_http_info(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'download',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_xml" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
            '403': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/xml', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
