# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class JourneyWebEventsNotificationWebActionMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        JourneyWebEventsNotificationWebActionMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'JourneyWebEventsNotificationEventAction',
            'action_target': 'JourneyWebEventsNotificationActionTarget',
            'action_map': 'JourneyWebEventsNotificationActionMap',
            'error_code': 'str',
            'error_message': 'str',
            'user_agent_string': 'str',
            'ip_address': 'str',
            'ip_organization': 'str',
            'browser': 'JourneyWebEventsNotificationBrowser',
            'device': 'JourneyWebEventsNotificationDevice',
            'geolocation': 'JourneyWebEventsNotificationGeoLocation',
            'mkt_campaign': 'JourneyWebEventsNotificationMktCampaign',
            'visit_referrer': 'JourneyWebEventsNotificationReferrer'
        }

        self.attribute_map = {
            'action': 'action',
            'action_target': 'actionTarget',
            'action_map': 'actionMap',
            'error_code': 'errorCode',
            'error_message': 'errorMessage',
            'user_agent_string': 'userAgentString',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'browser': 'browser',
            'device': 'device',
            'geolocation': 'geolocation',
            'mkt_campaign': 'mktCampaign',
            'visit_referrer': 'visitReferrer'
        }

        self._action = None
        self._action_target = None
        self._action_map = None
        self._error_code = None
        self._error_message = None
        self._user_agent_string = None
        self._ip_address = None
        self._ip_organization = None
        self._browser = None
        self._device = None
        self._geolocation = None
        self._mkt_campaign = None
        self._visit_referrer = None

    @property
    def action(self):
        """
        Gets the action of this JourneyWebEventsNotificationWebActionMessage.


        :return: The action of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationEventAction
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this JourneyWebEventsNotificationWebActionMessage.


        :param action: The action of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationEventAction
        """
        
        self._action = action

    @property
    def action_target(self):
        """
        Gets the action_target of this JourneyWebEventsNotificationWebActionMessage.


        :return: The action_target of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationActionTarget
        """
        return self._action_target

    @action_target.setter
    def action_target(self, action_target):
        """
        Sets the action_target of this JourneyWebEventsNotificationWebActionMessage.


        :param action_target: The action_target of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationActionTarget
        """
        
        self._action_target = action_target

    @property
    def action_map(self):
        """
        Gets the action_map of this JourneyWebEventsNotificationWebActionMessage.


        :return: The action_map of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationActionMap
        """
        return self._action_map

    @action_map.setter
    def action_map(self, action_map):
        """
        Sets the action_map of this JourneyWebEventsNotificationWebActionMessage.


        :param action_map: The action_map of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationActionMap
        """
        
        self._action_map = action_map

    @property
    def error_code(self):
        """
        Gets the error_code of this JourneyWebEventsNotificationWebActionMessage.


        :return: The error_code of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this JourneyWebEventsNotificationWebActionMessage.


        :param error_code: The error_code of this JourneyWebEventsNotificationWebActionMessage.
        :type: str
        """
        
        self._error_code = error_code

    @property
    def error_message(self):
        """
        Gets the error_message of this JourneyWebEventsNotificationWebActionMessage.


        :return: The error_message of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this JourneyWebEventsNotificationWebActionMessage.


        :param error_message: The error_message of this JourneyWebEventsNotificationWebActionMessage.
        :type: str
        """
        
        self._error_message = error_message

    @property
    def user_agent_string(self):
        """
        Gets the user_agent_string of this JourneyWebEventsNotificationWebActionMessage.


        :return: The user_agent_string of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string):
        """
        Sets the user_agent_string of this JourneyWebEventsNotificationWebActionMessage.


        :param user_agent_string: The user_agent_string of this JourneyWebEventsNotificationWebActionMessage.
        :type: str
        """
        
        self._user_agent_string = user_agent_string

    @property
    def ip_address(self):
        """
        Gets the ip_address of this JourneyWebEventsNotificationWebActionMessage.


        :return: The ip_address of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this JourneyWebEventsNotificationWebActionMessage.


        :param ip_address: The ip_address of this JourneyWebEventsNotificationWebActionMessage.
        :type: str
        """
        
        self._ip_address = ip_address

    @property
    def ip_organization(self):
        """
        Gets the ip_organization of this JourneyWebEventsNotificationWebActionMessage.


        :return: The ip_organization of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization):
        """
        Sets the ip_organization of this JourneyWebEventsNotificationWebActionMessage.


        :param ip_organization: The ip_organization of this JourneyWebEventsNotificationWebActionMessage.
        :type: str
        """
        
        self._ip_organization = ip_organization

    @property
    def browser(self):
        """
        Gets the browser of this JourneyWebEventsNotificationWebActionMessage.


        :return: The browser of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationBrowser
        """
        return self._browser

    @browser.setter
    def browser(self, browser):
        """
        Sets the browser of this JourneyWebEventsNotificationWebActionMessage.


        :param browser: The browser of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationBrowser
        """
        
        self._browser = browser

    @property
    def device(self):
        """
        Gets the device of this JourneyWebEventsNotificationWebActionMessage.


        :return: The device of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationDevice
        """
        return self._device

    @device.setter
    def device(self, device):
        """
        Sets the device of this JourneyWebEventsNotificationWebActionMessage.


        :param device: The device of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationDevice
        """
        
        self._device = device

    @property
    def geolocation(self):
        """
        Gets the geolocation of this JourneyWebEventsNotificationWebActionMessage.


        :return: The geolocation of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationGeoLocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation):
        """
        Sets the geolocation of this JourneyWebEventsNotificationWebActionMessage.


        :param geolocation: The geolocation of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationGeoLocation
        """
        
        self._geolocation = geolocation

    @property
    def mkt_campaign(self):
        """
        Gets the mkt_campaign of this JourneyWebEventsNotificationWebActionMessage.


        :return: The mkt_campaign of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationMktCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign):
        """
        Sets the mkt_campaign of this JourneyWebEventsNotificationWebActionMessage.


        :param mkt_campaign: The mkt_campaign of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationMktCampaign
        """
        
        self._mkt_campaign = mkt_campaign

    @property
    def visit_referrer(self):
        """
        Gets the visit_referrer of this JourneyWebEventsNotificationWebActionMessage.


        :return: The visit_referrer of this JourneyWebEventsNotificationWebActionMessage.
        :rtype: JourneyWebEventsNotificationReferrer
        """
        return self._visit_referrer

    @visit_referrer.setter
    def visit_referrer(self, visit_referrer):
        """
        Sets the visit_referrer of this JourneyWebEventsNotificationWebActionMessage.


        :param visit_referrer: The visit_referrer of this JourneyWebEventsNotificationWebActionMessage.
        :type: JourneyWebEventsNotificationReferrer
        """
        
        self._visit_referrer = visit_referrer

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

