# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class BotConnectorBotVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BotConnectorBotVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'version': 'str',
            'supported_languages': 'list[str]',
            'intents': 'list[BotIntent]'
        }

        self.attribute_map = {
            'version': 'version',
            'supported_languages': 'supportedLanguages',
            'intents': 'intents'
        }

        self._version = None
        self._supported_languages = None
        self._intents = None

    @property
    def version(self):
        """
        Gets the version of this BotConnectorBotVersion.
        The name of the version. This can be up to 100 characters long and must be comprised of displayable characters without leading or trailing whitespace

        :return: The version of this BotConnectorBotVersion.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this BotConnectorBotVersion.
        The name of the version. This can be up to 100 characters long and must be comprised of displayable characters without leading or trailing whitespace

        :param version: The version of this BotConnectorBotVersion.
        :type: str
        """
        
        self._version = version

    @property
    def supported_languages(self):
        """
        Gets the supported_languages of this BotConnectorBotVersion.
        The supported languages for this bot. EG 'en-us' or 'es', etc; These language codes are W3C language identification tags (ISO 639-1 for the language name and ISO 3166 for the country code)

        :return: The supported_languages of this BotConnectorBotVersion.
        :rtype: list[str]
        """
        return self._supported_languages

    @supported_languages.setter
    def supported_languages(self, supported_languages):
        """
        Sets the supported_languages of this BotConnectorBotVersion.
        The supported languages for this bot. EG 'en-us' or 'es', etc; These language codes are W3C language identification tags (ISO 639-1 for the language name and ISO 3166 for the country code)

        :param supported_languages: The supported_languages of this BotConnectorBotVersion.
        :type: list[str]
        """
        
        self._supported_languages = supported_languages

    @property
    def intents(self):
        """
        Gets the intents of this BotConnectorBotVersion.
        A list of potential intents this bot will return, limit of 50

        :return: The intents of this BotConnectorBotVersion.
        :rtype: list[BotIntent]
        """
        return self._intents

    @intents.setter
    def intents(self, intents):
        """
        Sets the intents of this BotConnectorBotVersion.
        A list of potential intents this bot will return, limit of 50

        :param intents: The intents of this BotConnectorBotVersion.
        :type: list[BotIntent]
        """
        
        self._intents = intents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

