/*
 * Decompiled with CFR 0.152.
 */
package psf.gibsonlanni;

import bilib.commons.math.bessel.Bessel;
import psf.gibsonlanni.GibsonLanniParameters;

public class KirchhoffDiffractionRiemann {
    private GibsonLanniParameters p;
    private double TOL = 0.1;
    private int K;
    private double NA = 1.4;
    private double lambda = 610.0;

    public KirchhoffDiffractionRiemann(GibsonLanniParameters p, int accuracy, double NA, double lambda) {
        this.NA = NA;
        this.lambda = lambda;
        this.p = p;
        this.K = accuracy == 0 ? 3 : (accuracy == 1 ? 5 : (accuracy == 2 ? 7 : 3));
    }

    double calculate(double r) {
        double a = 0.0;
        double b = 1.0;
        double[] value = new double[2];
        double curI = 0.0;
        double prevI = 0.0;
        int N = 1;
        double del = 1.0;
        int k = 0;
        int iteration = 1;
        double rho = 0.0;
        value = this.integrand(rho, r);
        double realSum = value[0];
        double imagSum = value[1];
        prevI = curI = realSum * realSum + imagSum * imagSum;
        double curDifference = this.TOL;
        while (k < this.K && iteration < 10000) {
            ++iteration;
            del = (b - a) / (double)(N *= 2);
            int n = 1;
            while (n < N) {
                rho = (double)n * del;
                value = this.integrand(rho, r);
                realSum += value[0];
                imagSum += value[1];
                n += 2;
            }
            curI = (realSum * realSum + imagSum * imagSum) * del * del;
            curDifference = prevI == 0.0 ? Math.abs((prevI - curI) / 1.0E-5) : Math.abs((prevI - curI) / curI);
            k = curDifference <= this.TOL ? ++k : 0;
            prevI = curI;
        }
        return curI;
    }

    double[] integrand(double rho, double r) {
        double k0 = Math.PI * 2 / this.lambda;
        double BesselValue = Bessel.J0(k0 * this.NA * r * rho);
        double[] I = new double[2];
        double OPD1 = this.p.ns * this.p.particleAxialPosition * Math.sqrt(1.0 - this.NA * rho / this.p.ns * (this.NA * rho / this.p.ns));
        double OPD3 = this.p.ni * (this.p.ti - this.p.ti0) * Math.sqrt(1.0 - this.NA * rho / this.p.ni * (this.NA * rho / this.p.ni));
        double OPD = OPD1 + OPD3;
        double W = k0 * OPD;
        I[0] = BesselValue * Math.cos(W) * rho;
        I[1] = BesselValue * Math.sin(W) * rho;
        return I;
    }
}

