"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractClassificationConfigurator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const cfnCustomResourceConfiguratorPrefill_1 = require("./cfnCustomResourceConfiguratorPrefill");
/**
 * Looks for a matching DOCYMENT_TYPE in the configurationTableName
 * and sets the CONFIG value (when found) to the context, so subsequent calls to
 * Textract use those values.
 *
 * This is an entry from the default config
 * AWS_PAYSTUBS,"{""queriesConfig"": [{""alias"": ""PAYSTUB_PERIOD_START_DATE"", ""text"": ""What is the Pay Period Start Date?""}, {""alias"": ""PAYSTUB_PERIOD_END_DATE"", ""text"": ""What is the Pay Period End Date?""}, {""alias"": ""PAYSTUB_PERIOD_PAY_DATE"", ""text"": ""What is the Pay Date?""}, {""alias"": ""PAYSTUB_PERIOD_EMPLOYEE_NAME"", ""text"": ""What is the Employee Name?""}, {""alias"": ""PAYSTUB_PERIOD_COMPANY_NAME"", ""text"": ""What is the company Name?""}, {""alias"": ""PAYSTUB_PERIOD_CURRENT_GROSS_PAY"", ""text"": ""What is the Current Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_YTD_GROSS_PAY"", ""text"": ""What is the YTD Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_REGULAR_HOURLY_RATE"", ""text"": ""What is the regular hourly rate?""}, {""alias"": ""PAYSTUB_PERIOD_HOLIDAY_RATE"", ""text"": ""What is the holiday rate?""}], ""textractFeatures"": [""QUERIES""]}"
 *
 * So, if the "classification"."documentType" in the Step Function Input is AWS_PAYSTUBS
 * then it will set the queriesConfig in the manifest for the subsequent Textract Calls in the Step Function flow
 *
 * Input: "classification"."documentType"
 * Output: config set to manifest
 *
 * Example (Python)
 * ```
    configurator_task = tcdk.TextractClassificationConfigurator(
        self, f"{workflow_name}-Configurator",
    )

 * ```
 */
class TextractClassificationConfigurator extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        if (props.configurationTable === undefined) {
            this.configurationTable = new dynamodb.Table(this, 'TextractConfigurationTable', {
                partitionKey: {
                    name: 'DOCUMENT_TYPE',
                    type: dynamodb.AttributeType.STRING,
                },
                removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            });
            this.configurationTableName = this.configurationTable.tableName;
            const configurationInitFunction = new cfnCustomResourceConfiguratorPrefill_1.TextractConfiguration(this, 'DocTypeConfig', {
                configurationTableName: this.configurationTable.tableName,
                configurationTableArn: this.configurationTable.tableArn,
            });
            configurationInitFunction.node.addDependency(this.configurationTable);
        }
        else {
            this.configurationTable = props.configurationTable;
            this.configurationTableName = props.configurationTable.tableName;
        }
        this.configuratorFunction = new lambda.DockerImageFunction(this, 'ClassificationConfigurator', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/configurator/')),
            memorySize: lambdaMemoryMB,
            architecture: lambda.Architecture.X86_64,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
            environment: {
                CONFIGURATION_TABLE: this.configurationTable.tableName,
                LOG_LEVEL: lambdaLogLevel,
            },
        });
        this.configuratorFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: [this.configurationTable.tableArn],
        }));
        const configuratorLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: this.configuratorFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = configuratorLambdaInvoke;
        this.endStates = [configuratorLambdaInvoke];
    }
}
exports.TextractClassificationConfigurator = TextractClassificationConfigurator;
_a = JSII_RTTI_SYMBOL_1;
TextractClassificationConfigurator[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractClassificationConfigurator", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,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