# Python Language Bindings

This repository is part of the Isilon SDK, which is an evolving package of
documents and files. This README describes how to install and configure Python
language bindings in order to access the OneFS API on an Isilon cluster from a
Python script. You can use the OneFS API to automate the configuration,
maintenance, and monitoring of your Isilon cluster.

* For OneFS API reference documents, discussions, and blog posts, refer to the
[OneFS SDK Info Hub](https://community.emc.com/docs/DOC-48273).
* To browse the Isilon InsightIQ statistics API, refer to the
[Stat Key Browser](https://github.com/isilon/isilon_stat_browser.git)
GitHub repository.

# isi-sdk-8-2-1
Isilon SDK - Language bindings for the OneFS API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 8
- Package version: 0.2.10
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/Isilon/isilon_sdk](https://github.com/Isilon/isilon_sdk)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

Install the package from the Python Package Index

```sh
pip install isi_sdk_8_2_1
```

Then import the package:
```python
import isi_sdk_8_2_1
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
from pprint import pprint
import time
import urllib3

import isi_sdk_8_2_1
from isi_sdk_8_2_1.rest import ApiException

urllib3.disable_warnings()


# configure cluster connection: basicAuth
configuration = isi_sdk_8_2_1.Configuration()
configuration.host = 'https://YOUR_CLUSTER_HOSTNAME_OR_NODE_IP:8080'
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'
configuration.verify_ssl = False

# create an instance of the API class
api_client = isi_sdk_8_2_1.ApiClient(configuration)
api_instance = isi_sdk_8_2_1.ProtocolsApi(api_client)

# get all exports
sort = 'description'
limit = 50
dir = 'ASC'
try:
    api_response = api_instance.list_nfs_exports(sort=sort, limit=limit, dir=dir)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ProtocolsApi->list_nfs_exports: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://YOUR_CLUSTER_HOSTNAME_OR_NODE_IP:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AntivirusApi* | [**create_antivirus_policy**](docs/AntivirusApi.md#create_antivirus_policy) | **POST** /platform/3/antivirus/policies | 
*AntivirusApi* | [**create_antivirus_scan_item**](docs/AntivirusApi.md#create_antivirus_scan_item) | **POST** /platform/3/antivirus/scan | 
*AntivirusApi* | [**create_antivirus_server**](docs/AntivirusApi.md#create_antivirus_server) | **POST** /platform/3/antivirus/servers | 
*AntivirusApi* | [**delete_antivirus_policies**](docs/AntivirusApi.md#delete_antivirus_policies) | **DELETE** /platform/3/antivirus/policies | 
*AntivirusApi* | [**delete_antivirus_policy**](docs/AntivirusApi.md#delete_antivirus_policy) | **DELETE** /platform/3/antivirus/policies/{AntivirusPolicyId} | 
*AntivirusApi* | [**delete_antivirus_server**](docs/AntivirusApi.md#delete_antivirus_server) | **DELETE** /platform/3/antivirus/servers/{AntivirusServerId} | 
*AntivirusApi* | [**delete_antivirus_servers**](docs/AntivirusApi.md#delete_antivirus_servers) | **DELETE** /platform/3/antivirus/servers | 
*AntivirusApi* | [**delete_reports_scan**](docs/AntivirusApi.md#delete_reports_scan) | **DELETE** /platform/3/antivirus/reports/scans/{ReportsScanId} | 
*AntivirusApi* | [**delete_reports_scans**](docs/AntivirusApi.md#delete_reports_scans) | **DELETE** /platform/3/antivirus/reports/scans | 
*AntivirusApi* | [**get_antivirus_policy**](docs/AntivirusApi.md#get_antivirus_policy) | **GET** /platform/3/antivirus/policies/{AntivirusPolicyId} | 
*AntivirusApi* | [**get_antivirus_quarantine_path**](docs/AntivirusApi.md#get_antivirus_quarantine_path) | **GET** /platform/3/antivirus/quarantine/{AntivirusQuarantinePath} | 
*AntivirusApi* | [**get_antivirus_server**](docs/AntivirusApi.md#get_antivirus_server) | **GET** /platform/3/antivirus/servers/{AntivirusServerId} | 
*AntivirusApi* | [**get_antivirus_settings**](docs/AntivirusApi.md#get_antivirus_settings) | **GET** /platform/7/antivirus/settings | 
*AntivirusApi* | [**get_reports_scan**](docs/AntivirusApi.md#get_reports_scan) | **GET** /platform/3/antivirus/reports/scans/{ReportsScanId} | 
*AntivirusApi* | [**get_reports_scans**](docs/AntivirusApi.md#get_reports_scans) | **GET** /platform/3/antivirus/reports/scans | 
*AntivirusApi* | [**get_reports_threat**](docs/AntivirusApi.md#get_reports_threat) | **GET** /platform/3/antivirus/reports/threats/{ReportsThreatId} | 
*AntivirusApi* | [**get_reports_threats**](docs/AntivirusApi.md#get_reports_threats) | **GET** /platform/3/antivirus/reports/threats | 
*AntivirusApi* | [**list_antivirus_policies**](docs/AntivirusApi.md#list_antivirus_policies) | **GET** /platform/3/antivirus/policies | 
*AntivirusApi* | [**list_antivirus_servers**](docs/AntivirusApi.md#list_antivirus_servers) | **GET** /platform/3/antivirus/servers | 
*AntivirusApi* | [**update_antivirus_policy**](docs/AntivirusApi.md#update_antivirus_policy) | **PUT** /platform/3/antivirus/policies/{AntivirusPolicyId} | 
*AntivirusApi* | [**update_antivirus_quarantine_path**](docs/AntivirusApi.md#update_antivirus_quarantine_path) | **PUT** /platform/3/antivirus/quarantine/{AntivirusQuarantinePath} | 
*AntivirusApi* | [**update_antivirus_server**](docs/AntivirusApi.md#update_antivirus_server) | **PUT** /platform/3/antivirus/servers/{AntivirusServerId} | 
*AntivirusApi* | [**update_antivirus_settings**](docs/AntivirusApi.md#update_antivirus_settings) | **PUT** /platform/7/antivirus/settings | 
*AuditApi* | [**create_audit_topic**](docs/AuditApi.md#create_audit_topic) | **POST** /platform/1/audit/topics | 
*AuditApi* | [**delete_audit_topic**](docs/AuditApi.md#delete_audit_topic) | **DELETE** /platform/1/audit/topics/{AuditTopicId} | 
*AuditApi* | [**get_audit_progress**](docs/AuditApi.md#get_audit_progress) | **GET** /platform/4/audit/progress | 
*AuditApi* | [**get_audit_settings**](docs/AuditApi.md#get_audit_settings) | **GET** /platform/7/audit/settings | 
*AuditApi* | [**get_audit_topic**](docs/AuditApi.md#get_audit_topic) | **GET** /platform/1/audit/topics/{AuditTopicId} | 
*AuditApi* | [**get_progress_global**](docs/AuditApi.md#get_progress_global) | **GET** /platform/4/audit/progress/global | 
*AuditApi* | [**get_settings_global**](docs/AuditApi.md#get_settings_global) | **GET** /platform/7/audit/settings/global | 
*AuditApi* | [**list_audit_topics**](docs/AuditApi.md#list_audit_topics) | **GET** /platform/1/audit/topics | 
*AuditApi* | [**update_audit_settings**](docs/AuditApi.md#update_audit_settings) | **PUT** /platform/7/audit/settings | 
*AuditApi* | [**update_audit_topic**](docs/AuditApi.md#update_audit_topic) | **PUT** /platform/1/audit/topics/{AuditTopicId} | 
*AuditApi* | [**update_settings_global**](docs/AuditApi.md#update_settings_global) | **PUT** /platform/7/audit/settings/global | 
*AuthApi* | [**create_auth_cache_item**](docs/AuthApi.md#create_auth_cache_item) | **POST** /platform/4/auth/cache | 
*AuthApi* | [**create_auth_group**](docs/AuthApi.md#create_auth_group) | **POST** /platform/1/auth/groups | 
*AuthApi* | [**create_auth_refresh_item**](docs/AuthApi.md#create_auth_refresh_item) | **POST** /platform/3/auth/refresh | 
*AuthApi* | [**create_auth_role**](docs/AuthApi.md#create_auth_role) | **POST** /platform/7/auth/roles | 
*AuthApi* | [**create_auth_user**](docs/AuthApi.md#create_auth_user) | **POST** /platform/7/auth/users | 
*AuthApi* | [**create_mapping_identities**](docs/AuthApi.md#create_mapping_identities) | **POST** /platform/1/auth/mapping/identities | 
*AuthApi* | [**create_mapping_identity**](docs/AuthApi.md#create_mapping_identity) | **POST** /platform/1/auth/mapping/identities/{MappingIdentityId} | 
*AuthApi* | [**create_providers_ads_item**](docs/AuthApi.md#create_providers_ads_item) | **POST** /platform/7/auth/providers/ads | 
*AuthApi* | [**create_providers_file_item**](docs/AuthApi.md#create_providers_file_item) | **POST** /platform/7/auth/providers/file | 
*AuthApi* | [**create_providers_krb5_item**](docs/AuthApi.md#create_providers_krb5_item) | **POST** /platform/7/auth/providers/krb5 | 
*AuthApi* | [**create_providers_ldap_item**](docs/AuthApi.md#create_providers_ldap_item) | **POST** /platform/7/auth/providers/ldap | 
*AuthApi* | [**create_providers_nis_item**](docs/AuthApi.md#create_providers_nis_item) | **POST** /platform/7/auth/providers/nis | 
*AuthApi* | [**create_settings_krb5_domain**](docs/AuthApi.md#create_settings_krb5_domain) | **POST** /platform/1/auth/settings/krb5/domains | 
*AuthApi* | [**create_settings_krb5_realm**](docs/AuthApi.md#create_settings_krb5_realm) | **POST** /platform/1/auth/settings/krb5/realms | 
*AuthApi* | [**delete_auth_group**](docs/AuthApi.md#delete_auth_group) | **DELETE** /platform/1/auth/groups/{AuthGroupId} | 
*AuthApi* | [**delete_auth_groups**](docs/AuthApi.md#delete_auth_groups) | **DELETE** /platform/1/auth/groups | 
*AuthApi* | [**delete_auth_role**](docs/AuthApi.md#delete_auth_role) | **DELETE** /platform/7/auth/roles/{AuthRoleId} | 
*AuthApi* | [**delete_auth_user**](docs/AuthApi.md#delete_auth_user) | **DELETE** /platform/7/auth/users/{AuthUserId} | 
*AuthApi* | [**delete_auth_users**](docs/AuthApi.md#delete_auth_users) | **DELETE** /platform/7/auth/users | 
*AuthApi* | [**delete_mapping_identities**](docs/AuthApi.md#delete_mapping_identities) | **DELETE** /platform/1/auth/mapping/identities | 
*AuthApi* | [**delete_mapping_identity**](docs/AuthApi.md#delete_mapping_identity) | **DELETE** /platform/1/auth/mapping/identities/{MappingIdentityId} | 
*AuthApi* | [**delete_providers_ads_by_id**](docs/AuthApi.md#delete_providers_ads_by_id) | **DELETE** /platform/7/auth/providers/ads/{ProvidersAdsId} | 
*AuthApi* | [**delete_providers_file_by_id**](docs/AuthApi.md#delete_providers_file_by_id) | **DELETE** /platform/7/auth/providers/file/{ProvidersFileId} | 
*AuthApi* | [**delete_providers_krb5_by_id**](docs/AuthApi.md#delete_providers_krb5_by_id) | **DELETE** /platform/7/auth/providers/krb5/{ProvidersKrb5Id} | 
*AuthApi* | [**delete_providers_ldap_by_id**](docs/AuthApi.md#delete_providers_ldap_by_id) | **DELETE** /platform/7/auth/providers/ldap/{ProvidersLdapId} | 
*AuthApi* | [**delete_providers_local_by_id**](docs/AuthApi.md#delete_providers_local_by_id) | **DELETE** /platform/7/auth/providers/local/{ProvidersLocalId} | 
*AuthApi* | [**delete_providers_nis_by_id**](docs/AuthApi.md#delete_providers_nis_by_id) | **DELETE** /platform/7/auth/providers/nis/{ProvidersNisId} | 
*AuthApi* | [**delete_settings_krb5_domain**](docs/AuthApi.md#delete_settings_krb5_domain) | **DELETE** /platform/1/auth/settings/krb5/domains/{SettingsKrb5DomainId} | 
*AuthApi* | [**delete_settings_krb5_realm**](docs/AuthApi.md#delete_settings_krb5_realm) | **DELETE** /platform/1/auth/settings/krb5/realms/{SettingsKrb5RealmId} | 
*AuthApi* | [**get_auth_access_user**](docs/AuthApi.md#get_auth_access_user) | **GET** /platform/1/auth/access/{AuthAccessUser} | 
*AuthApi* | [**get_auth_error_error**](docs/AuthApi.md#get_auth_error_error) | **GET** /platform/7/auth/error/{AuthErrorError} | 
*AuthApi* | [**get_auth_group**](docs/AuthApi.md#get_auth_group) | **GET** /platform/1/auth/groups/{AuthGroupId} | 
*AuthApi* | [**get_auth_id**](docs/AuthApi.md#get_auth_id) | **GET** /platform/1/auth/id | 
*AuthApi* | [**get_auth_ldap_template**](docs/AuthApi.md#get_auth_ldap_template) | **GET** /platform/7/auth/ldap-templates/{AuthLdapTemplateId} | 
*AuthApi* | [**get_auth_ldap_templates**](docs/AuthApi.md#get_auth_ldap_templates) | **GET** /platform/7/auth/ldap-templates | 
*AuthApi* | [**get_auth_log_level**](docs/AuthApi.md#get_auth_log_level) | **GET** /platform/3/auth/log-level | 
*AuthApi* | [**get_auth_netgroup**](docs/AuthApi.md#get_auth_netgroup) | **GET** /platform/1/auth/netgroups/{AuthNetgroupId} | 
*AuthApi* | [**get_auth_privileges**](docs/AuthApi.md#get_auth_privileges) | **GET** /platform/7/auth/privileges | 
*AuthApi* | [**get_auth_role**](docs/AuthApi.md#get_auth_role) | **GET** /platform/7/auth/roles/{AuthRoleId} | 
*AuthApi* | [**get_auth_shells**](docs/AuthApi.md#get_auth_shells) | **GET** /platform/1/auth/shells | 
*AuthApi* | [**get_auth_user**](docs/AuthApi.md#get_auth_user) | **GET** /platform/7/auth/users/{AuthUserId} | 
*AuthApi* | [**get_auth_wellknown**](docs/AuthApi.md#get_auth_wellknown) | **GET** /platform/1/auth/wellknowns/{AuthWellknownId} | 
*AuthApi* | [**get_auth_wellknowns**](docs/AuthApi.md#get_auth_wellknowns) | **GET** /platform/1/auth/wellknowns | 
*AuthApi* | [**get_mapping_dump**](docs/AuthApi.md#get_mapping_dump) | **GET** /platform/3/auth/mapping/dump | 
*AuthApi* | [**get_mapping_identity**](docs/AuthApi.md#get_mapping_identity) | **GET** /platform/1/auth/mapping/identities/{MappingIdentityId} | 
*AuthApi* | [**get_mapping_users_lookup**](docs/AuthApi.md#get_mapping_users_lookup) | **GET** /platform/1/auth/mapping/users/lookup | 
*AuthApi* | [**get_mapping_users_rules**](docs/AuthApi.md#get_mapping_users_rules) | **GET** /platform/1/auth/mapping/users/rules | 
*AuthApi* | [**get_providers_ads_by_id**](docs/AuthApi.md#get_providers_ads_by_id) | **GET** /platform/7/auth/providers/ads/{ProvidersAdsId} | 
*AuthApi* | [**get_providers_duo**](docs/AuthApi.md#get_providers_duo) | **GET** /platform/7/auth/providers/duo | 
*AuthApi* | [**get_providers_file_by_id**](docs/AuthApi.md#get_providers_file_by_id) | **GET** /platform/7/auth/providers/file/{ProvidersFileId} | 
*AuthApi* | [**get_providers_krb5_by_id**](docs/AuthApi.md#get_providers_krb5_by_id) | **GET** /platform/7/auth/providers/krb5/{ProvidersKrb5Id} | 
*AuthApi* | [**get_providers_ldap_by_id**](docs/AuthApi.md#get_providers_ldap_by_id) | **GET** /platform/7/auth/providers/ldap/{ProvidersLdapId} | 
*AuthApi* | [**get_providers_local**](docs/AuthApi.md#get_providers_local) | **GET** /platform/7/auth/providers/local | 
*AuthApi* | [**get_providers_local_by_id**](docs/AuthApi.md#get_providers_local_by_id) | **GET** /platform/7/auth/providers/local/{ProvidersLocalId} | 
*AuthApi* | [**get_providers_nis_by_id**](docs/AuthApi.md#get_providers_nis_by_id) | **GET** /platform/7/auth/providers/nis/{ProvidersNisId} | 
*AuthApi* | [**get_providers_summary**](docs/AuthApi.md#get_providers_summary) | **GET** /platform/3/auth/providers/summary | 
*AuthApi* | [**get_settings_acls**](docs/AuthApi.md#get_settings_acls) | **GET** /platform/7/auth/settings/acls | 
*AuthApi* | [**get_settings_global**](docs/AuthApi.md#get_settings_global) | **GET** /platform/1/auth/settings/global | 
*AuthApi* | [**get_settings_krb5_defaults**](docs/AuthApi.md#get_settings_krb5_defaults) | **GET** /platform/1/auth/settings/krb5/defaults | 
*AuthApi* | [**get_settings_krb5_domain**](docs/AuthApi.md#get_settings_krb5_domain) | **GET** /platform/1/auth/settings/krb5/domains/{SettingsKrb5DomainId} | 
*AuthApi* | [**get_settings_krb5_realm**](docs/AuthApi.md#get_settings_krb5_realm) | **GET** /platform/1/auth/settings/krb5/realms/{SettingsKrb5RealmId} | 
*AuthApi* | [**get_settings_mapping**](docs/AuthApi.md#get_settings_mapping) | **GET** /platform/1/auth/settings/mapping | 
*AuthApi* | [**list_auth_groups**](docs/AuthApi.md#list_auth_groups) | **GET** /platform/1/auth/groups | 
*AuthApi* | [**list_auth_roles**](docs/AuthApi.md#list_auth_roles) | **GET** /platform/7/auth/roles | 
*AuthApi* | [**list_auth_users**](docs/AuthApi.md#list_auth_users) | **GET** /platform/7/auth/users | 
*AuthApi* | [**list_providers_ads**](docs/AuthApi.md#list_providers_ads) | **GET** /platform/7/auth/providers/ads | 
*AuthApi* | [**list_providers_file**](docs/AuthApi.md#list_providers_file) | **GET** /platform/7/auth/providers/file | 
*AuthApi* | [**list_providers_krb5**](docs/AuthApi.md#list_providers_krb5) | **GET** /platform/7/auth/providers/krb5 | 
*AuthApi* | [**list_providers_ldap**](docs/AuthApi.md#list_providers_ldap) | **GET** /platform/7/auth/providers/ldap | 
*AuthApi* | [**list_providers_nis**](docs/AuthApi.md#list_providers_nis) | **GET** /platform/7/auth/providers/nis | 
*AuthApi* | [**list_settings_krb5_domains**](docs/AuthApi.md#list_settings_krb5_domains) | **GET** /platform/1/auth/settings/krb5/domains | 
*AuthApi* | [**list_settings_krb5_realms**](docs/AuthApi.md#list_settings_krb5_realms) | **GET** /platform/1/auth/settings/krb5/realms | 
*AuthApi* | [**update_auth_group**](docs/AuthApi.md#update_auth_group) | **PUT** /platform/1/auth/groups/{AuthGroupId} | 
*AuthApi* | [**update_auth_log_level**](docs/AuthApi.md#update_auth_log_level) | **PUT** /platform/3/auth/log-level | 
*AuthApi* | [**update_auth_role**](docs/AuthApi.md#update_auth_role) | **PUT** /platform/7/auth/roles/{AuthRoleId} | 
*AuthApi* | [**update_auth_user**](docs/AuthApi.md#update_auth_user) | **PUT** /platform/7/auth/users/{AuthUserId} | 
*AuthApi* | [**update_mapping_import**](docs/AuthApi.md#update_mapping_import) | **PUT** /platform/3/auth/mapping/import | 
*AuthApi* | [**update_mapping_users_rules**](docs/AuthApi.md#update_mapping_users_rules) | **PUT** /platform/1/auth/mapping/users/rules | 
*AuthApi* | [**update_providers_ads_by_id**](docs/AuthApi.md#update_providers_ads_by_id) | **PUT** /platform/7/auth/providers/ads/{ProvidersAdsId} | 
*AuthApi* | [**update_providers_duo**](docs/AuthApi.md#update_providers_duo) | **PUT** /platform/7/auth/providers/duo | 
*AuthApi* | [**update_providers_file_by_id**](docs/AuthApi.md#update_providers_file_by_id) | **PUT** /platform/7/auth/providers/file/{ProvidersFileId} | 
*AuthApi* | [**update_providers_krb5_by_id**](docs/AuthApi.md#update_providers_krb5_by_id) | **PUT** /platform/7/auth/providers/krb5/{ProvidersKrb5Id} | 
*AuthApi* | [**update_providers_ldap_by_id**](docs/AuthApi.md#update_providers_ldap_by_id) | **PUT** /platform/7/auth/providers/ldap/{ProvidersLdapId} | 
*AuthApi* | [**update_providers_local_by_id**](docs/AuthApi.md#update_providers_local_by_id) | **PUT** /platform/7/auth/providers/local/{ProvidersLocalId} | 
*AuthApi* | [**update_providers_nis_by_id**](docs/AuthApi.md#update_providers_nis_by_id) | **PUT** /platform/7/auth/providers/nis/{ProvidersNisId} | 
*AuthApi* | [**update_settings_acls**](docs/AuthApi.md#update_settings_acls) | **PUT** /platform/7/auth/settings/acls | 
*AuthApi* | [**update_settings_global**](docs/AuthApi.md#update_settings_global) | **PUT** /platform/1/auth/settings/global | 
*AuthApi* | [**update_settings_krb5_defaults**](docs/AuthApi.md#update_settings_krb5_defaults) | **PUT** /platform/1/auth/settings/krb5/defaults | 
*AuthApi* | [**update_settings_krb5_domain**](docs/AuthApi.md#update_settings_krb5_domain) | **PUT** /platform/1/auth/settings/krb5/domains/{SettingsKrb5DomainId} | 
*AuthApi* | [**update_settings_krb5_realm**](docs/AuthApi.md#update_settings_krb5_realm) | **PUT** /platform/1/auth/settings/krb5/realms/{SettingsKrb5RealmId} | 
*AuthApi* | [**update_settings_mapping**](docs/AuthApi.md#update_settings_mapping) | **PUT** /platform/1/auth/settings/mapping | 
*AuthGroupsApi* | [**create_group_member**](docs/AuthGroupsApi.md#create_group_member) | **POST** /platform/1/auth/groups/{Group}/members | 
*AuthGroupsApi* | [**delete_group_member**](docs/AuthGroupsApi.md#delete_group_member) | **DELETE** /platform/1/auth/groups/{Group}/members/{GroupMemberId} | 
*AuthGroupsApi* | [**list_group_members**](docs/AuthGroupsApi.md#list_group_members) | **GET** /platform/1/auth/groups/{Group}/members | 
*AuthProvidersApi* | [**get_ads_provider_controllers**](docs/AuthProvidersApi.md#get_ads_provider_controllers) | **GET** /platform/7/auth/providers/ads/{Id}/controllers | 
*AuthProvidersApi* | [**get_ads_provider_domain**](docs/AuthProvidersApi.md#get_ads_provider_domain) | **GET** /platform/7/auth/providers/ads/{Id}/domains/{AdsProviderDomainId} | 
*AuthProvidersApi* | [**get_ads_provider_domains**](docs/AuthProvidersApi.md#get_ads_provider_domains) | **GET** /platform/7/auth/providers/ads/{Id}/domains | 
*AuthProvidersApi* | [**get_ads_provider_search**](docs/AuthProvidersApi.md#get_ads_provider_search) | **GET** /platform/1/auth/providers/ads/{Id}/search | 
*AuthRolesApi* | [**create_role_member**](docs/AuthRolesApi.md#create_role_member) | **POST** /platform/8/auth/roles/{Role}/members | 
*AuthRolesApi* | [**create_role_privilege**](docs/AuthRolesApi.md#create_role_privilege) | **POST** /platform/7/auth/roles/{Role}/privileges | 
*AuthRolesApi* | [**delete_role_member**](docs/AuthRolesApi.md#delete_role_member) | **DELETE** /platform/8/auth/roles/{Role}/members/{RoleMemberId} | 
*AuthRolesApi* | [**delete_role_privilege**](docs/AuthRolesApi.md#delete_role_privilege) | **DELETE** /platform/7/auth/roles/{Role}/privileges/{RolePrivilegeId} | 
*AuthRolesApi* | [**list_role_members**](docs/AuthRolesApi.md#list_role_members) | **GET** /platform/8/auth/roles/{Role}/members | 
*AuthRolesApi* | [**list_role_privileges**](docs/AuthRolesApi.md#list_role_privileges) | **GET** /platform/7/auth/roles/{Role}/privileges | 
*AuthUsersApi* | [**create_user_member_of_item**](docs/AuthUsersApi.md#create_user_member_of_item) | **POST** /platform/3/auth/users/{User}/member-of | 
*AuthUsersApi* | [**delete_user_member_of_member_of**](docs/AuthUsersApi.md#delete_user_member_of_member_of) | **DELETE** /platform/3/auth/users/{User}/member-of/{UserMemberOfMemberOf} | 
*AuthUsersApi* | [**list_user_member_of**](docs/AuthUsersApi.md#list_user_member_of) | **GET** /platform/3/auth/users/{User}/member-of | 
*AuthUsersApi* | [**update_user_change_password**](docs/AuthUsersApi.md#update_user_change_password) | **PUT** /platform/3/auth/users/{User}/change-password | 
*CertificateApi* | [**create_certificate_authority_item**](docs/CertificateApi.md#create_certificate_authority_item) | **POST** /platform/7/certificate/authority | 
*CertificateApi* | [**create_certificate_server_item**](docs/CertificateApi.md#create_certificate_server_item) | **POST** /platform/4/certificate/server | 
*CertificateApi* | [**delete_certificate_authority_by_id**](docs/CertificateApi.md#delete_certificate_authority_by_id) | **DELETE** /platform/7/certificate/authority/{CertificateAuthorityId} | 
*CertificateApi* | [**delete_certificate_server_by_id**](docs/CertificateApi.md#delete_certificate_server_by_id) | **DELETE** /platform/4/certificate/server/{CertificateServerId} | 
*CertificateApi* | [**get_certificate_authority_by_id**](docs/CertificateApi.md#get_certificate_authority_by_id) | **GET** /platform/7/certificate/authority/{CertificateAuthorityId} | 
*CertificateApi* | [**get_certificate_server_by_id**](docs/CertificateApi.md#get_certificate_server_by_id) | **GET** /platform/4/certificate/server/{CertificateServerId} | 
*CertificateApi* | [**get_certificate_settings**](docs/CertificateApi.md#get_certificate_settings) | **GET** /platform/7/certificate/settings | 
*CertificateApi* | [**list_certificate_authority**](docs/CertificateApi.md#list_certificate_authority) | **GET** /platform/7/certificate/authority | 
*CertificateApi* | [**list_certificate_server**](docs/CertificateApi.md#list_certificate_server) | **GET** /platform/4/certificate/server | 
*CertificateApi* | [**update_certificate_authority_by_id**](docs/CertificateApi.md#update_certificate_authority_by_id) | **PUT** /platform/7/certificate/authority/{CertificateAuthorityId} | 
*CertificateApi* | [**update_certificate_server_by_id**](docs/CertificateApi.md#update_certificate_server_by_id) | **PUT** /platform/4/certificate/server/{CertificateServerId} | 
*CertificateApi* | [**update_certificate_settings**](docs/CertificateApi.md#update_certificate_settings) | **PUT** /platform/7/certificate/settings | 
*CloudApi* | [**create_cloud_access_item**](docs/CloudApi.md#create_cloud_access_item) | **POST** /platform/3/cloud/access | 
*CloudApi* | [**create_cloud_account**](docs/CloudApi.md#create_cloud_account) | **POST** /platform/7/cloud/accounts | 
*CloudApi* | [**create_cloud_certificate**](docs/CloudApi.md#create_cloud_certificate) | **POST** /platform/7/cloud/certificates | 
*CloudApi* | [**create_cloud_job**](docs/CloudApi.md#create_cloud_job) | **POST** /platform/3/cloud/jobs | 
*CloudApi* | [**create_cloud_pool**](docs/CloudApi.md#create_cloud_pool) | **POST** /platform/7/cloud/pools | 
*CloudApi* | [**create_cloud_proxy**](docs/CloudApi.md#create_cloud_proxy) | **POST** /platform/4/cloud/proxies | 
*CloudApi* | [**create_settings_encryption_key_item**](docs/CloudApi.md#create_settings_encryption_key_item) | **POST** /platform/3/cloud/settings/encryption-key | 
*CloudApi* | [**create_settings_reporting_eula_item**](docs/CloudApi.md#create_settings_reporting_eula_item) | **POST** /platform/3/cloud/settings/reporting-eula | 
*CloudApi* | [**delete_cloud_access_guid**](docs/CloudApi.md#delete_cloud_access_guid) | **DELETE** /platform/3/cloud/access/{CloudAccessGuid} | 
*CloudApi* | [**delete_cloud_account**](docs/CloudApi.md#delete_cloud_account) | **DELETE** /platform/7/cloud/accounts/{CloudAccountId} | 
*CloudApi* | [**delete_cloud_certificate**](docs/CloudApi.md#delete_cloud_certificate) | **DELETE** /platform/7/cloud/certificates/{CloudCertificateId} | 
*CloudApi* | [**delete_cloud_pool**](docs/CloudApi.md#delete_cloud_pool) | **DELETE** /platform/7/cloud/pools/{CloudPoolId} | 
*CloudApi* | [**delete_cloud_proxy**](docs/CloudApi.md#delete_cloud_proxy) | **DELETE** /platform/4/cloud/proxies/{CloudProxyId} | 
*CloudApi* | [**delete_settings_reporting_eula**](docs/CloudApi.md#delete_settings_reporting_eula) | **DELETE** /platform/3/cloud/settings/reporting-eula | 
*CloudApi* | [**get_cloud_access_guid**](docs/CloudApi.md#get_cloud_access_guid) | **GET** /platform/3/cloud/access/{CloudAccessGuid} | 
*CloudApi* | [**get_cloud_account**](docs/CloudApi.md#get_cloud_account) | **GET** /platform/7/cloud/accounts/{CloudAccountId} | 
*CloudApi* | [**get_cloud_certificate**](docs/CloudApi.md#get_cloud_certificate) | **GET** /platform/7/cloud/certificates/{CloudCertificateId} | 
*CloudApi* | [**get_cloud_job**](docs/CloudApi.md#get_cloud_job) | **GET** /platform/3/cloud/jobs/{CloudJobId} | 
*CloudApi* | [**get_cloud_jobs_file**](docs/CloudApi.md#get_cloud_jobs_file) | **GET** /platform/3/cloud/jobs-files/{CloudJobsFileId} | 
*CloudApi* | [**get_cloud_pool**](docs/CloudApi.md#get_cloud_pool) | **GET** /platform/7/cloud/pools/{CloudPoolId} | 
*CloudApi* | [**get_cloud_proxy**](docs/CloudApi.md#get_cloud_proxy) | **GET** /platform/4/cloud/proxies/{CloudProxyId} | 
*CloudApi* | [**get_cloud_settings**](docs/CloudApi.md#get_cloud_settings) | **GET** /platform/3/cloud/settings | 
*CloudApi* | [**list_cloud_access**](docs/CloudApi.md#list_cloud_access) | **GET** /platform/3/cloud/access | 
*CloudApi* | [**list_cloud_accounts**](docs/CloudApi.md#list_cloud_accounts) | **GET** /platform/7/cloud/accounts | 
*CloudApi* | [**list_cloud_certificates**](docs/CloudApi.md#list_cloud_certificates) | **GET** /platform/7/cloud/certificates | 
*CloudApi* | [**list_cloud_jobs**](docs/CloudApi.md#list_cloud_jobs) | **GET** /platform/3/cloud/jobs | 
*CloudApi* | [**list_cloud_pools**](docs/CloudApi.md#list_cloud_pools) | **GET** /platform/7/cloud/pools | 
*CloudApi* | [**list_cloud_proxies**](docs/CloudApi.md#list_cloud_proxies) | **GET** /platform/4/cloud/proxies | 
*CloudApi* | [**list_settings_reporting_eula**](docs/CloudApi.md#list_settings_reporting_eula) | **GET** /platform/3/cloud/settings/reporting-eula | 
*CloudApi* | [**update_cloud_account**](docs/CloudApi.md#update_cloud_account) | **PUT** /platform/7/cloud/accounts/{CloudAccountId} | 
*CloudApi* | [**update_cloud_certificate**](docs/CloudApi.md#update_cloud_certificate) | **PUT** /platform/7/cloud/certificates/{CloudCertificateId} | 
*CloudApi* | [**update_cloud_job**](docs/CloudApi.md#update_cloud_job) | **PUT** /platform/3/cloud/jobs/{CloudJobId} | 
*CloudApi* | [**update_cloud_pool**](docs/CloudApi.md#update_cloud_pool) | **PUT** /platform/7/cloud/pools/{CloudPoolId} | 
*CloudApi* | [**update_cloud_proxy**](docs/CloudApi.md#update_cloud_proxy) | **PUT** /platform/4/cloud/proxies/{CloudProxyId} | 
*CloudApi* | [**update_cloud_settings**](docs/CloudApi.md#update_cloud_settings) | **PUT** /platform/3/cloud/settings | 
*ClusterApi* | [**create_cluster_add_node_item**](docs/ClusterApi.md#create_cluster_add_node_item) | **POST** /platform/3/cluster/add-node | 
*ClusterApi* | [**create_diagnostics_gather_start_item**](docs/ClusterApi.md#create_diagnostics_gather_start_item) | **POST** /platform/3/cluster/diagnostics/gather/start | 
*ClusterApi* | [**create_diagnostics_gather_stop_item**](docs/ClusterApi.md#create_diagnostics_gather_stop_item) | **POST** /platform/3/cluster/diagnostics/gather/stop | 
*ClusterApi* | [**create_diagnostics_netlogger_start_item**](docs/ClusterApi.md#create_diagnostics_netlogger_start_item) | **POST** /platform/3/cluster/diagnostics/netlogger/start | 
*ClusterApi* | [**create_diagnostics_netlogger_stop_item**](docs/ClusterApi.md#create_diagnostics_netlogger_stop_item) | **POST** /platform/3/cluster/diagnostics/netlogger/stop | 
*ClusterApi* | [**get_cluster_config**](docs/ClusterApi.md#get_cluster_config) | **GET** /platform/3/cluster/config | 
*ClusterApi* | [**get_cluster_email**](docs/ClusterApi.md#get_cluster_email) | **GET** /platform/1/cluster/email | 
*ClusterApi* | [**get_cluster_external_ips**](docs/ClusterApi.md#get_cluster_external_ips) | **GET** /platform/2/cluster/external-ips | 
*ClusterApi* | [**get_cluster_identity**](docs/ClusterApi.md#get_cluster_identity) | **GET** /platform/5/cluster/identity | 
*ClusterApi* | [**get_cluster_internal_networks**](docs/ClusterApi.md#get_cluster_internal_networks) | **GET** /platform/7/cluster/internal-networks | 
*ClusterApi* | [**get_cluster_node**](docs/ClusterApi.md#get_cluster_node) | **GET** /platform/7/cluster/nodes/{ClusterNodeId} | 
*ClusterApi* | [**get_cluster_nodes**](docs/ClusterApi.md#get_cluster_nodes) | **GET** /platform/7/cluster/nodes | 
*ClusterApi* | [**get_cluster_nodes_available**](docs/ClusterApi.md#get_cluster_nodes_available) | **GET** /platform/3/cluster/nodes-available | 
*ClusterApi* | [**get_cluster_owner**](docs/ClusterApi.md#get_cluster_owner) | **GET** /platform/1/cluster/owner | 
*ClusterApi* | [**get_cluster_statfs**](docs/ClusterApi.md#get_cluster_statfs) | **GET** /platform/1/cluster/statfs | 
*ClusterApi* | [**get_cluster_time**](docs/ClusterApi.md#get_cluster_time) | **GET** /platform/3/cluster/time | 
*ClusterApi* | [**get_cluster_timezone**](docs/ClusterApi.md#get_cluster_timezone) | **GET** /platform/3/cluster/timezone | 
*ClusterApi* | [**get_cluster_version**](docs/ClusterApi.md#get_cluster_version) | **GET** /platform/3/cluster/version | 
*ClusterApi* | [**get_diagnostics_gather**](docs/ClusterApi.md#get_diagnostics_gather) | **GET** /platform/3/cluster/diagnostics/gather | 
*ClusterApi* | [**get_diagnostics_gather_settings**](docs/ClusterApi.md#get_diagnostics_gather_settings) | **GET** /platform/3/cluster/diagnostics/gather/settings | 
*ClusterApi* | [**get_diagnostics_gather_status**](docs/ClusterApi.md#get_diagnostics_gather_status) | **GET** /platform/3/cluster/diagnostics/gather/status | 
*ClusterApi* | [**get_diagnostics_netlogger**](docs/ClusterApi.md#get_diagnostics_netlogger) | **GET** /platform/3/cluster/diagnostics/netlogger | 
*ClusterApi* | [**get_diagnostics_netlogger_settings**](docs/ClusterApi.md#get_diagnostics_netlogger_settings) | **GET** /platform/3/cluster/diagnostics/netlogger/settings | 
*ClusterApi* | [**get_diagnostics_netlogger_status**](docs/ClusterApi.md#get_diagnostics_netlogger_status) | **GET** /platform/3/cluster/diagnostics/netlogger/status | 
*ClusterApi* | [**get_timezone_region**](docs/ClusterApi.md#get_timezone_region) | **GET** /platform/3/cluster/timezone/regions/{TimezoneRegionId} | 
*ClusterApi* | [**get_timezone_settings**](docs/ClusterApi.md#get_timezone_settings) | **GET** /platform/3/cluster/timezone/settings | 
*ClusterApi* | [**update_cluster_email**](docs/ClusterApi.md#update_cluster_email) | **PUT** /platform/1/cluster/email | 
*ClusterApi* | [**update_cluster_identity**](docs/ClusterApi.md#update_cluster_identity) | **PUT** /platform/5/cluster/identity | 
*ClusterApi* | [**update_cluster_internal_networks**](docs/ClusterApi.md#update_cluster_internal_networks) | **PUT** /platform/7/cluster/internal-networks | 
*ClusterApi* | [**update_cluster_node**](docs/ClusterApi.md#update_cluster_node) | **PUT** /platform/7/cluster/nodes/{ClusterNodeId} | 
*ClusterApi* | [**update_cluster_owner**](docs/ClusterApi.md#update_cluster_owner) | **PUT** /platform/1/cluster/owner | 
*ClusterApi* | [**update_cluster_time**](docs/ClusterApi.md#update_cluster_time) | **PUT** /platform/3/cluster/time | 
*ClusterApi* | [**update_cluster_timezone**](docs/ClusterApi.md#update_cluster_timezone) | **PUT** /platform/3/cluster/timezone | 
*ClusterApi* | [**update_cluster_update_lnns**](docs/ClusterApi.md#update_cluster_update_lnns) | **PUT** /platform/7/cluster/update-lnns | 
*ClusterApi* | [**update_diagnostics_gather_settings**](docs/ClusterApi.md#update_diagnostics_gather_settings) | **PUT** /platform/3/cluster/diagnostics/gather/settings | 
*ClusterApi* | [**update_diagnostics_netlogger_settings**](docs/ClusterApi.md#update_diagnostics_netlogger_settings) | **PUT** /platform/3/cluster/diagnostics/netlogger/settings | 
*ClusterApi* | [**update_timezone_settings**](docs/ClusterApi.md#update_timezone_settings) | **PUT** /platform/3/cluster/timezone/settings | 
*ClusterNodesApi* | [**create_drives_drive_add_item**](docs/ClusterNodesApi.md#create_drives_drive_add_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/add | 
*ClusterNodesApi* | [**create_drives_drive_firmware_update_item**](docs/ClusterNodesApi.md#create_drives_drive_firmware_update_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/firmware/update | 
*ClusterNodesApi* | [**create_drives_drive_format_item**](docs/ClusterNodesApi.md#create_drives_drive_format_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/format | 
*ClusterNodesApi* | [**create_drives_drive_purpose_item**](docs/ClusterNodesApi.md#create_drives_drive_purpose_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/purpose | 
*ClusterNodesApi* | [**create_drives_drive_smartfail_item**](docs/ClusterNodesApi.md#create_drives_drive_smartfail_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/smartfail | 
*ClusterNodesApi* | [**create_drives_drive_stopfail_item**](docs/ClusterNodesApi.md#create_drives_drive_stopfail_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/stopfail | 
*ClusterNodesApi* | [**create_drives_drive_suspend_item**](docs/ClusterNodesApi.md#create_drives_drive_suspend_item) | **POST** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/suspend | 
*ClusterNodesApi* | [**create_node_reboot_item**](docs/ClusterNodesApi.md#create_node_reboot_item) | **POST** /platform/5/cluster/nodes/{Lnn}/reboot | 
*ClusterNodesApi* | [**create_node_shutdown_item**](docs/ClusterNodesApi.md#create_node_shutdown_item) | **POST** /platform/5/cluster/nodes/{Lnn}/shutdown | 
*ClusterNodesApi* | [**get_drives_drive_firmware**](docs/ClusterNodesApi.md#get_drives_drive_firmware) | **GET** /platform/7/cluster/nodes/{Lnn}/drives/{Driveid}/firmware | 
*ClusterNodesApi* | [**get_node_drive**](docs/ClusterNodesApi.md#get_node_drive) | **GET** /platform/7/cluster/nodes/{Lnn}/drives/{NodeDriveId} | 
*ClusterNodesApi* | [**get_node_driveconfig**](docs/ClusterNodesApi.md#get_node_driveconfig) | **GET** /platform/7/cluster/nodes/{Lnn}/driveconfig | 
*ClusterNodesApi* | [**get_node_drives**](docs/ClusterNodesApi.md#get_node_drives) | **GET** /platform/7/cluster/nodes/{Lnn}/drives | 
*ClusterNodesApi* | [**get_node_drives_purposelist**](docs/ClusterNodesApi.md#get_node_drives_purposelist) | **GET** /platform/3/cluster/nodes/{Lnn}/drives-purposelist | 
*ClusterNodesApi* | [**get_node_hardware**](docs/ClusterNodesApi.md#get_node_hardware) | **GET** /platform/5/cluster/nodes/{Lnn}/hardware | 
*ClusterNodesApi* | [**get_node_hardware_fast**](docs/ClusterNodesApi.md#get_node_hardware_fast) | **GET** /platform/3/cluster/nodes/{Lnn}/hardware-fast | 
*ClusterNodesApi* | [**get_node_internal_ip_address**](docs/ClusterNodesApi.md#get_node_internal_ip_address) | **GET** /platform/7/cluster/nodes/{Lnn}/internal-ip-address | 
*ClusterNodesApi* | [**get_node_partitions**](docs/ClusterNodesApi.md#get_node_partitions) | **GET** /platform/3/cluster/nodes/{Lnn}/partitions | 
*ClusterNodesApi* | [**get_node_sensors**](docs/ClusterNodesApi.md#get_node_sensors) | **GET** /platform/3/cluster/nodes/{Lnn}/sensors | 
*ClusterNodesApi* | [**get_node_sled**](docs/ClusterNodesApi.md#get_node_sled) | **GET** /platform/5/cluster/nodes/{Lnn}/sleds/{NodeSledId} | 
*ClusterNodesApi* | [**get_node_sleds**](docs/ClusterNodesApi.md#get_node_sleds) | **GET** /platform/5/cluster/nodes/{Lnn}/sleds | 
*ClusterNodesApi* | [**get_node_state**](docs/ClusterNodesApi.md#get_node_state) | **GET** /platform/3/cluster/nodes/{Lnn}/state | 
*ClusterNodesApi* | [**get_node_state_readonly**](docs/ClusterNodesApi.md#get_node_state_readonly) | **GET** /platform/3/cluster/nodes/{Lnn}/state/readonly | 
*ClusterNodesApi* | [**get_node_state_servicelight**](docs/ClusterNodesApi.md#get_node_state_servicelight) | **GET** /platform/3/cluster/nodes/{Lnn}/state/servicelight | 
*ClusterNodesApi* | [**get_node_state_smartfail**](docs/ClusterNodesApi.md#get_node_state_smartfail) | **GET** /platform/3/cluster/nodes/{Lnn}/state/smartfail | 
*ClusterNodesApi* | [**get_node_status**](docs/ClusterNodesApi.md#get_node_status) | **GET** /platform/3/cluster/nodes/{Lnn}/status | 
*ClusterNodesApi* | [**get_node_status_batterystatus**](docs/ClusterNodesApi.md#get_node_status_batterystatus) | **GET** /platform/3/cluster/nodes/{Lnn}/status/batterystatus | 
*ClusterNodesApi* | [**list_drives_drive_firmware_update**](docs/ClusterNodesApi.md#list_drives_drive_firmware_update) | **GET** /platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/firmware/update | 
*ClusterNodesApi* | [**update_node_driveconfig**](docs/ClusterNodesApi.md#update_node_driveconfig) | **PUT** /platform/7/cluster/nodes/{Lnn}/driveconfig | 
*ClusterNodesApi* | [**update_node_state_readonly**](docs/ClusterNodesApi.md#update_node_state_readonly) | **PUT** /platform/3/cluster/nodes/{Lnn}/state/readonly | 
*ClusterNodesApi* | [**update_node_state_servicelight**](docs/ClusterNodesApi.md#update_node_state_servicelight) | **PUT** /platform/3/cluster/nodes/{Lnn}/state/servicelight | 
*ClusterNodesApi* | [**update_node_state_smartfail**](docs/ClusterNodesApi.md#update_node_state_smartfail) | **PUT** /platform/3/cluster/nodes/{Lnn}/state/smartfail | 
*DebugApi* | [**delete_debug_stats**](docs/DebugApi.md#delete_debug_stats) | **DELETE** /platform/1/debug/stats | 
*DebugApi* | [**get_debug_stats**](docs/DebugApi.md#get_debug_stats) | **GET** /platform/1/debug/stats | 
*DedupeApi* | [**get_dedupe_dedupe_summary**](docs/DedupeApi.md#get_dedupe_dedupe_summary) | **GET** /platform/1/dedupe/dedupe-summary | 
*DedupeApi* | [**get_dedupe_report**](docs/DedupeApi.md#get_dedupe_report) | **GET** /platform/1/dedupe/reports/{DedupeReportId} | 
*DedupeApi* | [**get_dedupe_reports**](docs/DedupeApi.md#get_dedupe_reports) | **GET** /platform/1/dedupe/reports | 
*DedupeApi* | [**get_dedupe_settings**](docs/DedupeApi.md#get_dedupe_settings) | **GET** /platform/1/dedupe/settings | 
*DedupeApi* | [**get_inline_settings**](docs/DedupeApi.md#get_inline_settings) | **GET** /platform/6/dedupe/inline/settings | 
*DedupeApi* | [**update_dedupe_settings**](docs/DedupeApi.md#update_dedupe_settings) | **PUT** /platform/1/dedupe/settings | 
*DedupeApi* | [**update_inline_settings**](docs/DedupeApi.md#update_inline_settings) | **PUT** /platform/6/dedupe/inline/settings | 
*EventApi* | [**create_event_alert_condition**](docs/EventApi.md#create_event_alert_condition) | **POST** /platform/4/event/alert-conditions | 
*EventApi* | [**create_event_channel**](docs/EventApi.md#create_event_channel) | **POST** /platform/7/event/channels | 
*EventApi* | [**create_event_event**](docs/EventApi.md#create_event_event) | **POST** /platform/3/event/events | 
*EventApi* | [**delete_event_alert_condition**](docs/EventApi.md#delete_event_alert_condition) | **DELETE** /platform/4/event/alert-conditions/{EventAlertConditionId} | 
*EventApi* | [**delete_event_alert_conditions**](docs/EventApi.md#delete_event_alert_conditions) | **DELETE** /platform/4/event/alert-conditions | 
*EventApi* | [**delete_event_channel**](docs/EventApi.md#delete_event_channel) | **DELETE** /platform/7/event/channels/{EventChannelId} | 
*EventApi* | [**get_event_alert_condition**](docs/EventApi.md#get_event_alert_condition) | **GET** /platform/4/event/alert-conditions/{EventAlertConditionId} | 
*EventApi* | [**get_event_categories**](docs/EventApi.md#get_event_categories) | **GET** /platform/3/event/categories | 
*EventApi* | [**get_event_category**](docs/EventApi.md#get_event_category) | **GET** /platform/3/event/categories/{EventCategoryId} | 
*EventApi* | [**get_event_channel**](docs/EventApi.md#get_event_channel) | **GET** /platform/7/event/channels/{EventChannelId} | 
*EventApi* | [**get_event_eventgroup_definition**](docs/EventApi.md#get_event_eventgroup_definition) | **GET** /platform/4/event/eventgroup-definitions/{EventEventgroupDefinitionId} | 
*EventApi* | [**get_event_eventgroup_definitions**](docs/EventApi.md#get_event_eventgroup_definitions) | **GET** /platform/4/event/eventgroup-definitions | 
*EventApi* | [**get_event_eventgroup_occurrence**](docs/EventApi.md#get_event_eventgroup_occurrence) | **GET** /platform/3/event/eventgroup-occurrences/{EventEventgroupOccurrenceId} | 
*EventApi* | [**get_event_eventgroup_occurrences**](docs/EventApi.md#get_event_eventgroup_occurrences) | **GET** /platform/3/event/eventgroup-occurrences | 
*EventApi* | [**get_event_eventlist**](docs/EventApi.md#get_event_eventlist) | **GET** /platform/7/event/eventlists/{EventEventlistId} | 
*EventApi* | [**get_event_eventlists**](docs/EventApi.md#get_event_eventlists) | **GET** /platform/7/event/eventlists | 
*EventApi* | [**get_event_settings**](docs/EventApi.md#get_event_settings) | **GET** /platform/3/event/settings | 
*EventApi* | [**list_event_alert_conditions**](docs/EventApi.md#list_event_alert_conditions) | **GET** /platform/4/event/alert-conditions | 
*EventApi* | [**list_event_channels**](docs/EventApi.md#list_event_channels) | **GET** /platform/7/event/channels | 
*EventApi* | [**update_event_alert_condition**](docs/EventApi.md#update_event_alert_condition) | **PUT** /platform/4/event/alert-conditions/{EventAlertConditionId} | 
*EventApi* | [**update_event_channel**](docs/EventApi.md#update_event_channel) | **PUT** /platform/7/event/channels/{EventChannelId} | 
*EventApi* | [**update_event_eventgroup_occurrence**](docs/EventApi.md#update_event_eventgroup_occurrence) | **PUT** /platform/3/event/eventgroup-occurrences/{EventEventgroupOccurrenceId} | 
*EventApi* | [**update_event_eventgroup_occurrences**](docs/EventApi.md#update_event_eventgroup_occurrences) | **PUT** /platform/3/event/eventgroup-occurrences | 
*EventApi* | [**update_event_settings**](docs/EventApi.md#update_event_settings) | **PUT** /platform/3/event/settings | 
*FileFilterApi* | [**get_file_filter_settings**](docs/FileFilterApi.md#get_file_filter_settings) | **GET** /platform/3/file-filter/settings | 
*FileFilterApi* | [**update_file_filter_settings**](docs/FileFilterApi.md#update_file_filter_settings) | **PUT** /platform/3/file-filter/settings | 
*FilepoolApi* | [**create_filepool_policy**](docs/FilepoolApi.md#create_filepool_policy) | **POST** /platform/4/filepool/policies | 
*FilepoolApi* | [**delete_filepool_policy**](docs/FilepoolApi.md#delete_filepool_policy) | **DELETE** /platform/4/filepool/policies/{FilepoolPolicyId} | 
*FilepoolApi* | [**get_filepool_default_policy**](docs/FilepoolApi.md#get_filepool_default_policy) | **GET** /platform/4/filepool/default-policy | 
*FilepoolApi* | [**get_filepool_policy**](docs/FilepoolApi.md#get_filepool_policy) | **GET** /platform/4/filepool/policies/{FilepoolPolicyId} | 
*FilepoolApi* | [**get_filepool_template**](docs/FilepoolApi.md#get_filepool_template) | **GET** /platform/4/filepool/templates/{FilepoolTemplateId} | 
*FilepoolApi* | [**get_filepool_templates**](docs/FilepoolApi.md#get_filepool_templates) | **GET** /platform/4/filepool/templates | 
*FilepoolApi* | [**list_filepool_policies**](docs/FilepoolApi.md#list_filepool_policies) | **GET** /platform/4/filepool/policies | 
*FilepoolApi* | [**update_filepool_default_policy**](docs/FilepoolApi.md#update_filepool_default_policy) | **PUT** /platform/4/filepool/default-policy | 
*FilepoolApi* | [**update_filepool_policy**](docs/FilepoolApi.md#update_filepool_policy) | **PUT** /platform/4/filepool/policies/{FilepoolPolicyId} | 
*FilesystemApi* | [**get_settings_access_time**](docs/FilesystemApi.md#get_settings_access_time) | **GET** /platform/1/filesystem/settings/access-time | 
*FilesystemApi* | [**get_settings_character_encodings**](docs/FilesystemApi.md#get_settings_character_encodings) | **GET** /platform/7/filesystem/settings/character-encodings | 
*FilesystemApi* | [**get_settings_compression**](docs/FilesystemApi.md#get_settings_compression) | **GET** /platform/6/filesystem/settings/compression | 
*FilesystemApi* | [**update_settings_access_time**](docs/FilesystemApi.md#update_settings_access_time) | **PUT** /platform/1/filesystem/settings/access-time | 
*FilesystemApi* | [**update_settings_character_encodings**](docs/FilesystemApi.md#update_settings_character_encodings) | **PUT** /platform/7/filesystem/settings/character-encodings | 
*FilesystemApi* | [**update_settings_compression**](docs/FilesystemApi.md#update_settings_compression) | **PUT** /platform/6/filesystem/settings/compression | 
*FsaApi* | [**delete_fsa_result**](docs/FsaApi.md#delete_fsa_result) | **DELETE** /platform/3/fsa/results/{FsaResultId} | 
*FsaApi* | [**delete_fsa_settings**](docs/FsaApi.md#delete_fsa_settings) | **DELETE** /platform/1/fsa/settings | 
*FsaApi* | [**get_fsa_index**](docs/FsaApi.md#get_fsa_index) | **GET** /platform/8/fsa/index | 
*FsaApi* | [**get_fsa_result**](docs/FsaApi.md#get_fsa_result) | **GET** /platform/3/fsa/results/{FsaResultId} | 
*FsaApi* | [**get_fsa_results**](docs/FsaApi.md#get_fsa_results) | **GET** /platform/3/fsa/results | 
*FsaApi* | [**get_fsa_settings**](docs/FsaApi.md#get_fsa_settings) | **GET** /platform/1/fsa/settings | 
*FsaApi* | [**update_fsa_result**](docs/FsaApi.md#update_fsa_result) | **PUT** /platform/3/fsa/results/{FsaResultId} | 
*FsaApi* | [**update_fsa_settings**](docs/FsaApi.md#update_fsa_settings) | **PUT** /platform/1/fsa/settings | 
*FsaIndexApi* | [**get_name_lin**](docs/FsaIndexApi.md#get_name_lin) | **GET** /platform/8/fsa/index/{Name}/lins/{NameLinId} | 
*FsaIndexApi* | [**get_name_lins**](docs/FsaIndexApi.md#get_name_lins) | **GET** /platform/8/fsa/index/{Name}/lins | 
*FsaResultsApi* | [**get_histogram_stat_by**](docs/FsaResultsApi.md#get_histogram_stat_by) | **GET** /platform/3/fsa/results/{Id}/histogram/{Stat}/by | 
*FsaResultsApi* | [**get_histogram_stat_by_breakout**](docs/FsaResultsApi.md#get_histogram_stat_by_breakout) | **GET** /platform/3/fsa/results/{Id}/histogram/{Stat}/by/{HistogramStatByBreakout} | 
*FsaResultsApi* | [**get_result_directories**](docs/FsaResultsApi.md#get_result_directories) | **GET** /platform/3/fsa/results/{Id}/directories | 
*FsaResultsApi* | [**get_result_directory**](docs/FsaResultsApi.md#get_result_directory) | **GET** /platform/3/fsa/results/{Id}/directories/{ResultDirectoryId} | 
*FsaResultsApi* | [**get_result_histogram**](docs/FsaResultsApi.md#get_result_histogram) | **GET** /platform/3/fsa/results/{Id}/histogram | 
*FsaResultsApi* | [**get_result_histogram_stat**](docs/FsaResultsApi.md#get_result_histogram_stat) | **GET** /platform/3/fsa/results/{Id}/histogram/{ResultHistogramStat} | 
*FsaResultsApi* | [**get_result_top_dir**](docs/FsaResultsApi.md#get_result_top_dir) | **GET** /platform/3/fsa/results/{Id}/top-dirs/{ResultTopDirId} | 
*FsaResultsApi* | [**get_result_top_dirs**](docs/FsaResultsApi.md#get_result_top_dirs) | **GET** /platform/3/fsa/results/{Id}/top-dirs | 
*FsaResultsApi* | [**get_result_top_file**](docs/FsaResultsApi.md#get_result_top_file) | **GET** /platform/3/fsa/results/{Id}/top-files/{ResultTopFileId} | 
*FsaResultsApi* | [**get_result_top_files**](docs/FsaResultsApi.md#get_result_top_files) | **GET** /platform/3/fsa/results/{Id}/top-files | 
*GroupnetsSummaryApi* | [**get_groupnets_summary**](docs/GroupnetsSummaryApi.md#get_groupnets_summary) | **GET** /platform/5/groupnets-summary | 
*HardeningApi* | [**create_hardening_apply_item**](docs/HardeningApi.md#create_hardening_apply_item) | **POST** /platform/3/hardening/apply | 
*HardeningApi* | [**create_hardening_resolve_item**](docs/HardeningApi.md#create_hardening_resolve_item) | **POST** /platform/3/hardening/resolve | 
*HardeningApi* | [**create_hardening_revert_item**](docs/HardeningApi.md#create_hardening_revert_item) | **POST** /platform/3/hardening/revert | 
*HardeningApi* | [**get_hardening_state**](docs/HardeningApi.md#get_hardening_state) | **GET** /platform/3/hardening/state | 
*HardeningApi* | [**get_hardening_status**](docs/HardeningApi.md#get_hardening_status) | **GET** /platform/3/hardening/status | 
*HardwareApi* | [**create_hardware_tape_name**](docs/HardwareApi.md#create_hardware_tape_name) | **POST** /platform/3/hardware/tape/{HardwareTapeName} | 
*HardwareApi* | [**delete_hardware_tape_name**](docs/HardwareApi.md#delete_hardware_tape_name) | **DELETE** /platform/3/hardware/tape/{HardwareTapeName} | 
*HardwareApi* | [**get_hardware_fcport**](docs/HardwareApi.md#get_hardware_fcport) | **GET** /platform/3/hardware/fcports/{HardwareFcportId} | 
*HardwareApi* | [**get_hardware_fcports**](docs/HardwareApi.md#get_hardware_fcports) | **GET** /platform/3/hardware/fcports | 
*HardwareApi* | [**get_hardware_tapes**](docs/HardwareApi.md#get_hardware_tapes) | **GET** /platform/3/hardware/tapes | 
*HardwareApi* | [**update_hardware_fcport**](docs/HardwareApi.md#update_hardware_fcport) | **PUT** /platform/3/hardware/fcports/{HardwareFcportId} | 
*HardwareApi* | [**update_hardware_tape_name**](docs/HardwareApi.md#update_hardware_tape_name) | **PUT** /platform/3/hardware/tape/{HardwareTapeName} | 
*HealthcheckApi* | [**create_healthcheck_evaluation**](docs/HealthcheckApi.md#create_healthcheck_evaluation) | **POST** /platform/3/healthcheck/evaluations | 
*HealthcheckApi* | [**create_healthcheck_parameter**](docs/HealthcheckApi.md#create_healthcheck_parameter) | **POST** /platform/3/healthcheck/parameters | 
*HealthcheckApi* | [**delete_healthcheck_evaluation**](docs/HealthcheckApi.md#delete_healthcheck_evaluation) | **DELETE** /platform/3/healthcheck/evaluations/{HealthcheckEvaluationId} | 
*HealthcheckApi* | [**delete_healthcheck_parameter**](docs/HealthcheckApi.md#delete_healthcheck_parameter) | **DELETE** /platform/3/healthcheck/parameters/{HealthcheckParameterId} | 
*HealthcheckApi* | [**get_healthcheck_checklist**](docs/HealthcheckApi.md#get_healthcheck_checklist) | **GET** /platform/3/healthcheck/checklists/{HealthcheckChecklistId} | 
*HealthcheckApi* | [**get_healthcheck_checklists**](docs/HealthcheckApi.md#get_healthcheck_checklists) | **GET** /platform/3/healthcheck/checklists | 
*HealthcheckApi* | [**get_healthcheck_evaluation**](docs/HealthcheckApi.md#get_healthcheck_evaluation) | **GET** /platform/3/healthcheck/evaluations/{HealthcheckEvaluationId} | 
*HealthcheckApi* | [**get_healthcheck_item**](docs/HealthcheckApi.md#get_healthcheck_item) | **GET** /platform/3/healthcheck/items/{HealthcheckItemId} | 
*HealthcheckApi* | [**get_healthcheck_items**](docs/HealthcheckApi.md#get_healthcheck_items) | **GET** /platform/3/healthcheck/items | 
*HealthcheckApi* | [**get_healthcheck_parameter**](docs/HealthcheckApi.md#get_healthcheck_parameter) | **GET** /platform/3/healthcheck/parameters/{HealthcheckParameterId} | 
*HealthcheckApi* | [**list_healthcheck_evaluations**](docs/HealthcheckApi.md#list_healthcheck_evaluations) | **GET** /platform/3/healthcheck/evaluations | 
*HealthcheckApi* | [**list_healthcheck_parameters**](docs/HealthcheckApi.md#list_healthcheck_parameters) | **GET** /platform/3/healthcheck/parameters | 
*HealthcheckApi* | [**update_healthcheck_evaluation**](docs/HealthcheckApi.md#update_healthcheck_evaluation) | **PUT** /platform/3/healthcheck/evaluations/{HealthcheckEvaluationId} | 
*HealthcheckApi* | [**update_healthcheck_parameter**](docs/HealthcheckApi.md#update_healthcheck_parameter) | **PUT** /platform/3/healthcheck/parameters/{HealthcheckParameterId} | 
*IdResolutionApi* | [**get_id_resolution_domain**](docs/IdResolutionApi.md#get_id_resolution_domain) | **GET** /platform/7/id-resolution/domains/{IdResolutionDomainId} | 
*IdResolutionApi* | [**get_id_resolution_domains**](docs/IdResolutionApi.md#get_id_resolution_domains) | **GET** /platform/7/id-resolution/domains | 
*IdResolutionApi* | [**get_id_resolution_lin**](docs/IdResolutionApi.md#get_id_resolution_lin) | **GET** /platform/7/id-resolution/lins/{IdResolutionLinId} | 
*IdResolutionApi* | [**get_id_resolution_lins**](docs/IdResolutionApi.md#get_id_resolution_lins) | **GET** /platform/7/id-resolution/lins | 
*IdResolutionApi* | [**get_id_resolution_zone**](docs/IdResolutionApi.md#get_id_resolution_zone) | **GET** /platform/7/id-resolution/zones/{IdResolutionZoneId} | 
*IdResolutionApi* | [**get_id_resolution_zones**](docs/IdResolutionApi.md#get_id_resolution_zones) | **GET** /platform/7/id-resolution/zones | 
*IdResolutionZonesApi* | [**get_zone_group**](docs/IdResolutionZonesApi.md#get_zone_group) | **GET** /platform/7/id-resolution/zones/{Zid}/groups/{ZoneGroupId} | 
*IdResolutionZonesApi* | [**get_zone_groups**](docs/IdResolutionZonesApi.md#get_zone_groups) | **GET** /platform/7/id-resolution/zones/{Zid}/groups | 
*IdResolutionZonesApi* | [**get_zone_user**](docs/IdResolutionZonesApi.md#get_zone_user) | **GET** /platform/7/id-resolution/zones/{Zid}/users/{ZoneUserId} | 
*IdResolutionZonesApi* | [**get_zone_users**](docs/IdResolutionZonesApi.md#get_zone_users) | **GET** /platform/7/id-resolution/zones/{Zid}/users | 
*JobApi* | [**create_job_job**](docs/JobApi.md#create_job_job) | **POST** /platform/7/job/jobs | 
*JobApi* | [**create_job_policy**](docs/JobApi.md#create_job_policy) | **POST** /platform/1/job/policies | 
*JobApi* | [**delete_job_policy**](docs/JobApi.md#delete_job_policy) | **DELETE** /platform/1/job/policies/{JobPolicyId} | 
*JobApi* | [**get_job_events**](docs/JobApi.md#get_job_events) | **GET** /platform/3/job/events | 
*JobApi* | [**get_job_job**](docs/JobApi.md#get_job_job) | **GET** /platform/7/job/jobs/{JobJobId} | 
*JobApi* | [**get_job_job_summary**](docs/JobApi.md#get_job_job_summary) | **GET** /platform/7/job/job-summary | 
*JobApi* | [**get_job_policy**](docs/JobApi.md#get_job_policy) | **GET** /platform/1/job/policies/{JobPolicyId} | 
*JobApi* | [**get_job_recent**](docs/JobApi.md#get_job_recent) | **GET** /platform/3/job/recent | 
*JobApi* | [**get_job_reports**](docs/JobApi.md#get_job_reports) | **GET** /platform/7/job/reports | 
*JobApi* | [**get_job_statistics**](docs/JobApi.md#get_job_statistics) | **GET** /platform/1/job/statistics | 
*JobApi* | [**get_job_type**](docs/JobApi.md#get_job_type) | **GET** /platform/1/job/types/{JobTypeId} | 
*JobApi* | [**get_job_types**](docs/JobApi.md#get_job_types) | **GET** /platform/1/job/types | 
*JobApi* | [**list_job_jobs**](docs/JobApi.md#list_job_jobs) | **GET** /platform/7/job/jobs | 
*JobApi* | [**list_job_policies**](docs/JobApi.md#list_job_policies) | **GET** /platform/1/job/policies | 
*JobApi* | [**update_job_job**](docs/JobApi.md#update_job_job) | **PUT** /platform/7/job/jobs/{JobJobId} | 
*JobApi* | [**update_job_policy**](docs/JobApi.md#update_job_policy) | **PUT** /platform/1/job/policies/{JobPolicyId} | 
*JobApi* | [**update_job_type**](docs/JobApi.md#update_job_type) | **PUT** /platform/1/job/types/{JobTypeId} | 
*LicenseApi* | [**create_license_license**](docs/LicenseApi.md#create_license_license) | **POST** /platform/5/license/licenses | 
*LicenseApi* | [**get_license_generate**](docs/LicenseApi.md#get_license_generate) | **GET** /platform/5/license/generate | 
*LicenseApi* | [**get_license_license**](docs/LicenseApi.md#get_license_license) | **GET** /platform/5/license/licenses/{LicenseLicenseId} | 
*LicenseApi* | [**list_license_licenses**](docs/LicenseApi.md#list_license_licenses) | **GET** /platform/5/license/licenses | 
*LocalApi* | [**get_cluster_time**](docs/LocalApi.md#get_cluster_time) | **GET** /platform/3/local/cluster/time | 
*LocalApi* | [**get_upgrade_cluster_firmware_status**](docs/LocalApi.md#get_upgrade_cluster_firmware_status) | **GET** /platform/3/local/upgrade/cluster/firmware/status | 
*LocalClusterApi* | [**get_nodes_node_internal_ip_address**](docs/LocalClusterApi.md#get_nodes_node_internal_ip_address) | **GET** /platform/7/local/cluster/nodes/{Lnn}/internal-ip-address | 
*NamespaceApi* | [**copy_directory**](docs/NamespaceApi.md#copy_directory) | **PUT** /namespace/{DirectoryCopyTarget} | 
*NamespaceApi* | [**copy_file**](docs/NamespaceApi.md#copy_file) | **PUT** /namespace/{FileCopyTarget} | 
*NamespaceApi* | [**create_access_point**](docs/NamespaceApi.md#create_access_point) | **PUT** /namespace/{AccessPointName} | 
*NamespaceApi* | [**create_directory**](docs/NamespaceApi.md#create_directory) | **PUT** /namespace/{DirectoryPath} | 
*NamespaceApi* | [**create_directory_with_access_point_container_path**](docs/NamespaceApi.md#create_directory_with_access_point_container_path) | **PUT** /namespace/{AccessPoint}/{ContainerPath} | 
*NamespaceApi* | [**create_file**](docs/NamespaceApi.md#create_file) | **PUT** /namespace/{FilePath} | 
*NamespaceApi* | [**delete_access_point**](docs/NamespaceApi.md#delete_access_point) | **DELETE** /namespace/{AccessPointName} | 
*NamespaceApi* | [**delete_directory**](docs/NamespaceApi.md#delete_directory) | **DELETE** /namespace/{DirectoryPath} | 
*NamespaceApi* | [**delete_directory_with_access_point_container_path**](docs/NamespaceApi.md#delete_directory_with_access_point_container_path) | **DELETE** /namespace/{AccessPoint}/{ContainerPath} | 
*NamespaceApi* | [**delete_file**](docs/NamespaceApi.md#delete_file) | **DELETE** /namespace/{FilePath} | 
*NamespaceApi* | [**get_acl**](docs/NamespaceApi.md#get_acl) | **GET** /namespace/{NamespacePath} | 
*NamespaceApi* | [**get_directory_attributes**](docs/NamespaceApi.md#get_directory_attributes) | **HEAD** /namespace/{DirectoryPath} | 
*NamespaceApi* | [**get_directory_contents**](docs/NamespaceApi.md#get_directory_contents) | **GET** /namespace/{DirectoryPath} | 
*NamespaceApi* | [**get_directory_metadata**](docs/NamespaceApi.md#get_directory_metadata) | **GET** /namespace/{DirectoryMetadataPath} | 
*NamespaceApi* | [**get_directory_with_access_point_container_path**](docs/NamespaceApi.md#get_directory_with_access_point_container_path) | **GET** /namespace/{AccessPoint}/{ContainerPath} | 
*NamespaceApi* | [**get_file_attributes**](docs/NamespaceApi.md#get_file_attributes) | **HEAD** /namespace/{FilePath} | 
*NamespaceApi* | [**get_file_contents**](docs/NamespaceApi.md#get_file_contents) | **GET** /namespace/{FilePath} | 
*NamespaceApi* | [**get_file_metadata**](docs/NamespaceApi.md#get_file_metadata) | **GET** /namespace/{FileMetadataPath} | 
*NamespaceApi* | [**get_worm_properties**](docs/NamespaceApi.md#get_worm_properties) | **GET** /namespace/{WormFilePath} | 
*NamespaceApi* | [**list_access_points**](docs/NamespaceApi.md#list_access_points) | **GET** /namespace | 
*NamespaceApi* | [**move_directory**](docs/NamespaceApi.md#move_directory) | **POST** /namespace/{DirectoryPath} | 
*NamespaceApi* | [**move_directory_with_access_point_container_path**](docs/NamespaceApi.md#move_directory_with_access_point_container_path) | **POST** /namespace/{AccessPoint}/{ContainerPath} | 
*NamespaceApi* | [**move_file**](docs/NamespaceApi.md#move_file) | **POST** /namespace/{FilePath} | 
*NamespaceApi* | [**query_directory**](docs/NamespaceApi.md#query_directory) | **POST** /namespace/{QueryPath} | 
*NamespaceApi* | [**set_acl**](docs/NamespaceApi.md#set_acl) | **PUT** /namespace/{NamespacePath} | 
*NamespaceApi* | [**set_directory_metadata**](docs/NamespaceApi.md#set_directory_metadata) | **PUT** /namespace/{DirectoryMetadataPath} | 
*NamespaceApi* | [**set_file_metadata**](docs/NamespaceApi.md#set_file_metadata) | **PUT** /namespace/{FileMetadataPath} | 
*NamespaceApi* | [**set_worm_properties**](docs/NamespaceApi.md#set_worm_properties) | **PUT** /namespace/{WormFilePath} | 
*NetworkApi* | [**create_dnscache_flush_item**](docs/NetworkApi.md#create_dnscache_flush_item) | **POST** /platform/3/network/dnscache/flush | 
*NetworkApi* | [**create_network_groupnet**](docs/NetworkApi.md#create_network_groupnet) | **POST** /platform/3/network/groupnets | 
*NetworkApi* | [**create_network_sc_rebalance_all_item**](docs/NetworkApi.md#create_network_sc_rebalance_all_item) | **POST** /platform/3/network/sc-rebalance-all | 
*NetworkApi* | [**delete_network_groupnet**](docs/NetworkApi.md#delete_network_groupnet) | **DELETE** /platform/3/network/groupnets/{NetworkGroupnetId} | 
*NetworkApi* | [**get_network_dnscache**](docs/NetworkApi.md#get_network_dnscache) | **GET** /platform/3/network/dnscache | 
*NetworkApi* | [**get_network_external**](docs/NetworkApi.md#get_network_external) | **GET** /platform/3/network/external | 
*NetworkApi* | [**get_network_groupnet**](docs/NetworkApi.md#get_network_groupnet) | **GET** /platform/3/network/groupnets/{NetworkGroupnetId} | 
*NetworkApi* | [**get_network_interfaces**](docs/NetworkApi.md#get_network_interfaces) | **GET** /platform/7/network/interfaces | 
*NetworkApi* | [**get_network_pools**](docs/NetworkApi.md#get_network_pools) | **GET** /platform/3/network/pools | 
*NetworkApi* | [**get_network_rules**](docs/NetworkApi.md#get_network_rules) | **GET** /platform/3/network/rules | 
*NetworkApi* | [**get_network_subnets**](docs/NetworkApi.md#get_network_subnets) | **GET** /platform/7/network/subnets | 
*NetworkApi* | [**list_network_groupnets**](docs/NetworkApi.md#list_network_groupnets) | **GET** /platform/3/network/groupnets | 
*NetworkApi* | [**update_network_dnscache**](docs/NetworkApi.md#update_network_dnscache) | **PUT** /platform/3/network/dnscache | 
*NetworkApi* | [**update_network_external**](docs/NetworkApi.md#update_network_external) | **PUT** /platform/3/network/external | 
*NetworkApi* | [**update_network_groupnet**](docs/NetworkApi.md#update_network_groupnet) | **PUT** /platform/3/network/groupnets/{NetworkGroupnetId} | 
*NetworkGroupnetsApi* | [**create_groupnet_subnet**](docs/NetworkGroupnetsApi.md#create_groupnet_subnet) | **POST** /platform/7/network/groupnets/{Groupnet}/subnets | 
*NetworkGroupnetsApi* | [**create_subnets_subnet_pool**](docs/NetworkGroupnetsApi.md#create_subnets_subnet_pool) | **POST** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools | 
*NetworkGroupnetsApi* | [**delete_groupnet_subnet**](docs/NetworkGroupnetsApi.md#delete_groupnet_subnet) | **DELETE** /platform/7/network/groupnets/{Groupnet}/subnets/{GroupnetSubnetId} | 
*NetworkGroupnetsApi* | [**delete_subnets_subnet_pool**](docs/NetworkGroupnetsApi.md#delete_subnets_subnet_pool) | **DELETE** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{SubnetsSubnetPoolId} | 
*NetworkGroupnetsApi* | [**get_groupnet_subnet**](docs/NetworkGroupnetsApi.md#get_groupnet_subnet) | **GET** /platform/7/network/groupnets/{Groupnet}/subnets/{GroupnetSubnetId} | 
*NetworkGroupnetsApi* | [**get_subnets_subnet_pool**](docs/NetworkGroupnetsApi.md#get_subnets_subnet_pool) | **GET** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{SubnetsSubnetPoolId} | 
*NetworkGroupnetsApi* | [**list_groupnet_subnets**](docs/NetworkGroupnetsApi.md#list_groupnet_subnets) | **GET** /platform/7/network/groupnets/{Groupnet}/subnets | 
*NetworkGroupnetsApi* | [**list_subnets_subnet_pools**](docs/NetworkGroupnetsApi.md#list_subnets_subnet_pools) | **GET** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools | 
*NetworkGroupnetsApi* | [**update_groupnet_subnet**](docs/NetworkGroupnetsApi.md#update_groupnet_subnet) | **PUT** /platform/7/network/groupnets/{Groupnet}/subnets/{GroupnetSubnetId} | 
*NetworkGroupnetsApi* | [**update_subnets_subnet_pool**](docs/NetworkGroupnetsApi.md#update_subnets_subnet_pool) | **PUT** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{SubnetsSubnetPoolId} | 
*NetworkGroupnetsSubnetsApi* | [**create_pools_pool_rebalance_ip**](docs/NetworkGroupnetsSubnetsApi.md#create_pools_pool_rebalance_ip) | **POST** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rebalance-ips | 
*NetworkGroupnetsSubnetsApi* | [**create_pools_pool_rule**](docs/NetworkGroupnetsSubnetsApi.md#create_pools_pool_rule) | **POST** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules | 
*NetworkGroupnetsSubnetsApi* | [**create_pools_pool_sc_resume_node**](docs/NetworkGroupnetsSubnetsApi.md#create_pools_pool_sc_resume_node) | **POST** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/sc-resume-nodes | 
*NetworkGroupnetsSubnetsApi* | [**create_pools_pool_sc_suspend_node**](docs/NetworkGroupnetsSubnetsApi.md#create_pools_pool_sc_suspend_node) | **POST** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/sc-suspend-nodes | 
*NetworkGroupnetsSubnetsApi* | [**delete_pools_pool_rule**](docs/NetworkGroupnetsSubnetsApi.md#delete_pools_pool_rule) | **DELETE** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules/{PoolsPoolRuleId} | 
*NetworkGroupnetsSubnetsApi* | [**get_pools_pool_interfaces**](docs/NetworkGroupnetsSubnetsApi.md#get_pools_pool_interfaces) | **GET** /platform/7/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/interfaces | 
*NetworkGroupnetsSubnetsApi* | [**get_pools_pool_rule**](docs/NetworkGroupnetsSubnetsApi.md#get_pools_pool_rule) | **GET** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules/{PoolsPoolRuleId} | 
*NetworkGroupnetsSubnetsApi* | [**list_pools_pool_rules**](docs/NetworkGroupnetsSubnetsApi.md#list_pools_pool_rules) | **GET** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules | 
*NetworkGroupnetsSubnetsApi* | [**update_pools_pool_rule**](docs/NetworkGroupnetsSubnetsApi.md#update_pools_pool_rule) | **PUT** /platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules/{PoolsPoolRuleId} | 
*PerformanceApi* | [**create_performance_dataset**](docs/PerformanceApi.md#create_performance_dataset) | **POST** /platform/7/performance/datasets | 
*PerformanceApi* | [**delete_performance_dataset**](docs/PerformanceApi.md#delete_performance_dataset) | **DELETE** /platform/7/performance/datasets/{PerformanceDatasetId} | 
*PerformanceApi* | [**get_performance_dataset**](docs/PerformanceApi.md#get_performance_dataset) | **GET** /platform/7/performance/datasets/{PerformanceDatasetId} | 
*PerformanceApi* | [**get_performance_metric**](docs/PerformanceApi.md#get_performance_metric) | **GET** /platform/7/performance/metrics/{PerformanceMetricId} | 
*PerformanceApi* | [**get_performance_metrics**](docs/PerformanceApi.md#get_performance_metrics) | **GET** /platform/7/performance/metrics | 
*PerformanceApi* | [**get_performance_settings**](docs/PerformanceApi.md#get_performance_settings) | **GET** /platform/7/performance/settings | 
*PerformanceApi* | [**list_performance_datasets**](docs/PerformanceApi.md#list_performance_datasets) | **GET** /platform/7/performance/datasets | 
*PerformanceApi* | [**update_performance_dataset**](docs/PerformanceApi.md#update_performance_dataset) | **PUT** /platform/7/performance/datasets/{PerformanceDatasetId} | 
*PerformanceApi* | [**update_performance_settings**](docs/PerformanceApi.md#update_performance_settings) | **PUT** /platform/7/performance/settings | 
*PerformanceDatasetsApi* | [**create_dataset_filter**](docs/PerformanceDatasetsApi.md#create_dataset_filter) | **POST** /platform/7/performance/datasets/{Dataset}/filters | 
*PerformanceDatasetsApi* | [**create_dataset_workload**](docs/PerformanceDatasetsApi.md#create_dataset_workload) | **POST** /platform/7/performance/datasets/{Dataset}/workloads | 
*PerformanceDatasetsApi* | [**delete_dataset_filter**](docs/PerformanceDatasetsApi.md#delete_dataset_filter) | **DELETE** /platform/7/performance/datasets/{Dataset}/filters/{DatasetFilterId} | 
*PerformanceDatasetsApi* | [**delete_dataset_filters**](docs/PerformanceDatasetsApi.md#delete_dataset_filters) | **DELETE** /platform/7/performance/datasets/{Dataset}/filters | 
*PerformanceDatasetsApi* | [**delete_dataset_workload**](docs/PerformanceDatasetsApi.md#delete_dataset_workload) | **DELETE** /platform/7/performance/datasets/{Dataset}/workloads/{DatasetWorkloadId} | 
*PerformanceDatasetsApi* | [**delete_dataset_workloads**](docs/PerformanceDatasetsApi.md#delete_dataset_workloads) | **DELETE** /platform/7/performance/datasets/{Dataset}/workloads | 
*PerformanceDatasetsApi* | [**get_dataset_filter**](docs/PerformanceDatasetsApi.md#get_dataset_filter) | **GET** /platform/7/performance/datasets/{Dataset}/filters/{DatasetFilterId} | 
*PerformanceDatasetsApi* | [**get_dataset_workload**](docs/PerformanceDatasetsApi.md#get_dataset_workload) | **GET** /platform/7/performance/datasets/{Dataset}/workloads/{DatasetWorkloadId} | 
*PerformanceDatasetsApi* | [**list_dataset_filters**](docs/PerformanceDatasetsApi.md#list_dataset_filters) | **GET** /platform/7/performance/datasets/{Dataset}/filters | 
*PerformanceDatasetsApi* | [**list_dataset_workloads**](docs/PerformanceDatasetsApi.md#list_dataset_workloads) | **GET** /platform/7/performance/datasets/{Dataset}/workloads | 
*PerformanceDatasetsApi* | [**update_dataset_filter**](docs/PerformanceDatasetsApi.md#update_dataset_filter) | **PUT** /platform/7/performance/datasets/{Dataset}/filters/{DatasetFilterId} | 
*PerformanceDatasetsApi* | [**update_dataset_workload**](docs/PerformanceDatasetsApi.md#update_dataset_workload) | **PUT** /platform/7/performance/datasets/{Dataset}/workloads/{DatasetWorkloadId} | 
*ProtocolsApi* | [**create_hdfs_crypto_encryption_zone**](docs/ProtocolsApi.md#create_hdfs_crypto_encryption_zone) | **POST** /platform/7/protocols/hdfs/crypto/encryption-zones | 
*ProtocolsApi* | [**create_hdfs_proxyuser**](docs/ProtocolsApi.md#create_hdfs_proxyuser) | **POST** /platform/1/protocols/hdfs/proxyusers | 
*ProtocolsApi* | [**create_hdfs_rack**](docs/ProtocolsApi.md#create_hdfs_rack) | **POST** /platform/1/protocols/hdfs/racks | 
*ProtocolsApi* | [**create_ndmp_settings_preferred_ip**](docs/ProtocolsApi.md#create_ndmp_settings_preferred_ip) | **POST** /platform/4/protocols/ndmp/settings/preferred-ips | 
*ProtocolsApi* | [**create_ndmp_settings_variable**](docs/ProtocolsApi.md#create_ndmp_settings_variable) | **POST** /platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId} | 
*ProtocolsApi* | [**create_ndmp_user**](docs/ProtocolsApi.md#create_ndmp_user) | **POST** /platform/3/protocols/ndmp/users | 
*ProtocolsApi* | [**create_nfs_alias**](docs/ProtocolsApi.md#create_nfs_alias) | **POST** /platform/2/protocols/nfs/aliases | 
*ProtocolsApi* | [**create_nfs_export**](docs/ProtocolsApi.md#create_nfs_export) | **POST** /platform/4/protocols/nfs/exports | 
*ProtocolsApi* | [**create_nfs_netgroup_check_item**](docs/ProtocolsApi.md#create_nfs_netgroup_check_item) | **POST** /platform/3/protocols/nfs/netgroup/check | 
*ProtocolsApi* | [**create_nfs_netgroup_flush_item**](docs/ProtocolsApi.md#create_nfs_netgroup_flush_item) | **POST** /platform/3/protocols/nfs/netgroup/flush | 
*ProtocolsApi* | [**create_nfs_nlm_sessions_check_item**](docs/ProtocolsApi.md#create_nfs_nlm_sessions_check_item) | **POST** /platform/3/protocols/nfs/nlm/sessions-check | 
*ProtocolsApi* | [**create_nfs_reload_item**](docs/ProtocolsApi.md#create_nfs_reload_item) | **POST** /platform/3/protocols/nfs/reload | 
*ProtocolsApi* | [**create_ntp_server**](docs/ProtocolsApi.md#create_ntp_server) | **POST** /platform/3/protocols/ntp/servers | 
*ProtocolsApi* | [**create_smb_log_level_filter**](docs/ProtocolsApi.md#create_smb_log_level_filter) | **POST** /platform/3/protocols/smb/log-level/filters | 
*ProtocolsApi* | [**create_smb_share**](docs/ProtocolsApi.md#create_smb_share) | **POST** /platform/7/protocols/smb/shares | 
*ProtocolsApi* | [**create_swift_account**](docs/ProtocolsApi.md#create_swift_account) | **POST** /platform/3/protocols/swift/accounts | 
*ProtocolsApi* | [**delete_hdfs_fsimage_latest**](docs/ProtocolsApi.md#delete_hdfs_fsimage_latest) | **DELETE** /platform/5/protocols/hdfs/fsimage/latest | 
*ProtocolsApi* | [**delete_hdfs_inotify_stream**](docs/ProtocolsApi.md#delete_hdfs_inotify_stream) | **DELETE** /platform/5/protocols/hdfs/inotify/stream | 
*ProtocolsApi* | [**delete_hdfs_proxyuser**](docs/ProtocolsApi.md#delete_hdfs_proxyuser) | **DELETE** /platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId} | 
*ProtocolsApi* | [**delete_hdfs_rack**](docs/ProtocolsApi.md#delete_hdfs_rack) | **DELETE** /platform/1/protocols/hdfs/racks/{HdfsRackId} | 
*ProtocolsApi* | [**delete_ndmp_contexts_backup_by_id**](docs/ProtocolsApi.md#delete_ndmp_contexts_backup_by_id) | **DELETE** /platform/3/protocols/ndmp/contexts/backup/{NdmpContextsBackupId} | 
*ProtocolsApi* | [**delete_ndmp_contexts_bre_by_id**](docs/ProtocolsApi.md#delete_ndmp_contexts_bre_by_id) | **DELETE** /platform/3/protocols/ndmp/contexts/bre/{NdmpContextsBreId} | 
*ProtocolsApi* | [**delete_ndmp_contexts_restore_by_id**](docs/ProtocolsApi.md#delete_ndmp_contexts_restore_by_id) | **DELETE** /platform/3/protocols/ndmp/contexts/restore/{NdmpContextsRestoreId} | 
*ProtocolsApi* | [**delete_ndmp_dumpdate**](docs/ProtocolsApi.md#delete_ndmp_dumpdate) | **DELETE** /platform/3/protocols/ndmp/dumpdates/{NdmpDumpdateId} | 
*ProtocolsApi* | [**delete_ndmp_session**](docs/ProtocolsApi.md#delete_ndmp_session) | **DELETE** /platform/3/protocols/ndmp/sessions/{NdmpSessionId} | 
*ProtocolsApi* | [**delete_ndmp_settings_preferred_ip**](docs/ProtocolsApi.md#delete_ndmp_settings_preferred_ip) | **DELETE** /platform/4/protocols/ndmp/settings/preferred-ips/{NdmpSettingsPreferredIpId} | 
*ProtocolsApi* | [**delete_ndmp_settings_variable**](docs/ProtocolsApi.md#delete_ndmp_settings_variable) | **DELETE** /platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId} | 
*ProtocolsApi* | [**delete_ndmp_user**](docs/ProtocolsApi.md#delete_ndmp_user) | **DELETE** /platform/3/protocols/ndmp/users/{NdmpUserId} | 
*ProtocolsApi* | [**delete_nfs_alias**](docs/ProtocolsApi.md#delete_nfs_alias) | **DELETE** /platform/2/protocols/nfs/aliases/{NfsAliasId} | 
*ProtocolsApi* | [**delete_nfs_export**](docs/ProtocolsApi.md#delete_nfs_export) | **DELETE** /platform/4/protocols/nfs/exports/{NfsExportId} | 
*ProtocolsApi* | [**delete_nfs_nlm_session**](docs/ProtocolsApi.md#delete_nfs_nlm_session) | **DELETE** /platform/3/protocols/nfs/nlm/sessions/{NfsNlmSessionId} | 
*ProtocolsApi* | [**delete_ntp_server**](docs/ProtocolsApi.md#delete_ntp_server) | **DELETE** /platform/3/protocols/ntp/servers/{NtpServerId} | 
*ProtocolsApi* | [**delete_ntp_servers**](docs/ProtocolsApi.md#delete_ntp_servers) | **DELETE** /platform/3/protocols/ntp/servers | 
*ProtocolsApi* | [**delete_smb_log_level_filter**](docs/ProtocolsApi.md#delete_smb_log_level_filter) | **DELETE** /platform/3/protocols/smb/log-level/filters/{SmbLogLevelFilterId} | 
*ProtocolsApi* | [**delete_smb_log_level_filters**](docs/ProtocolsApi.md#delete_smb_log_level_filters) | **DELETE** /platform/3/protocols/smb/log-level/filters | 
*ProtocolsApi* | [**delete_smb_openfile**](docs/ProtocolsApi.md#delete_smb_openfile) | **DELETE** /platform/1/protocols/smb/openfiles/{SmbOpenfileId} | 
*ProtocolsApi* | [**delete_smb_session**](docs/ProtocolsApi.md#delete_smb_session) | **DELETE** /platform/1/protocols/smb/sessions/{SmbSessionId} | 
*ProtocolsApi* | [**delete_smb_sessions_computer_user**](docs/ProtocolsApi.md#delete_smb_sessions_computer_user) | **DELETE** /platform/1/protocols/smb/sessions/{Computer}/{SmbSessionsComputerUser} | 
*ProtocolsApi* | [**delete_smb_share**](docs/ProtocolsApi.md#delete_smb_share) | **DELETE** /platform/7/protocols/smb/shares/{SmbShareId} | 
*ProtocolsApi* | [**delete_smb_shares**](docs/ProtocolsApi.md#delete_smb_shares) | **DELETE** /platform/7/protocols/smb/shares | 
*ProtocolsApi* | [**delete_swift_account**](docs/ProtocolsApi.md#delete_swift_account) | **DELETE** /platform/3/protocols/swift/accounts/{SwiftAccountId} | 
*ProtocolsApi* | [**get_ftp_settings**](docs/ProtocolsApi.md#get_ftp_settings) | **GET** /platform/3/protocols/ftp/settings | 
*ProtocolsApi* | [**get_hdfs_crypto_settings**](docs/ProtocolsApi.md#get_hdfs_crypto_settings) | **GET** /platform/7/protocols/hdfs/crypto/settings | 
*ProtocolsApi* | [**get_hdfs_fsimage_job**](docs/ProtocolsApi.md#get_hdfs_fsimage_job) | **GET** /platform/5/protocols/hdfs/fsimage/job | 
*ProtocolsApi* | [**get_hdfs_fsimage_job_settings**](docs/ProtocolsApi.md#get_hdfs_fsimage_job_settings) | **GET** /platform/5/protocols/hdfs/fsimage/job/settings | 
*ProtocolsApi* | [**get_hdfs_fsimage_latest**](docs/ProtocolsApi.md#get_hdfs_fsimage_latest) | **GET** /platform/5/protocols/hdfs/fsimage/latest | 
*ProtocolsApi* | [**get_hdfs_fsimage_settings**](docs/ProtocolsApi.md#get_hdfs_fsimage_settings) | **GET** /platform/5/protocols/hdfs/fsimage/settings | 
*ProtocolsApi* | [**get_hdfs_inotify_settings**](docs/ProtocolsApi.md#get_hdfs_inotify_settings) | **GET** /platform/5/protocols/hdfs/inotify/settings | 
*ProtocolsApi* | [**get_hdfs_inotify_stream**](docs/ProtocolsApi.md#get_hdfs_inotify_stream) | **GET** /platform/5/protocols/hdfs/inotify/stream | 
*ProtocolsApi* | [**get_hdfs_log_level**](docs/ProtocolsApi.md#get_hdfs_log_level) | **GET** /platform/3/protocols/hdfs/log-level | 
*ProtocolsApi* | [**get_hdfs_proxyuser**](docs/ProtocolsApi.md#get_hdfs_proxyuser) | **GET** /platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId} | 
*ProtocolsApi* | [**get_hdfs_rack**](docs/ProtocolsApi.md#get_hdfs_rack) | **GET** /platform/1/protocols/hdfs/racks/{HdfsRackId} | 
*ProtocolsApi* | [**get_hdfs_ranger_plugin_settings**](docs/ProtocolsApi.md#get_hdfs_ranger_plugin_settings) | **GET** /platform/4/protocols/hdfs/ranger-plugin/settings | 
*ProtocolsApi* | [**get_hdfs_settings**](docs/ProtocolsApi.md#get_hdfs_settings) | **GET** /platform/4/protocols/hdfs/settings | 
*ProtocolsApi* | [**get_http_settings**](docs/ProtocolsApi.md#get_http_settings) | **GET** /platform/3/protocols/http/settings | 
*ProtocolsApi* | [**get_ndmp_contexts_backup**](docs/ProtocolsApi.md#get_ndmp_contexts_backup) | **GET** /platform/3/protocols/ndmp/contexts/backup | 
*ProtocolsApi* | [**get_ndmp_contexts_backup_by_id**](docs/ProtocolsApi.md#get_ndmp_contexts_backup_by_id) | **GET** /platform/3/protocols/ndmp/contexts/backup/{NdmpContextsBackupId} | 
*ProtocolsApi* | [**get_ndmp_contexts_bre**](docs/ProtocolsApi.md#get_ndmp_contexts_bre) | **GET** /platform/3/protocols/ndmp/contexts/bre | 
*ProtocolsApi* | [**get_ndmp_contexts_bre_by_id**](docs/ProtocolsApi.md#get_ndmp_contexts_bre_by_id) | **GET** /platform/3/protocols/ndmp/contexts/bre/{NdmpContextsBreId} | 
*ProtocolsApi* | [**get_ndmp_contexts_restore**](docs/ProtocolsApi.md#get_ndmp_contexts_restore) | **GET** /platform/3/protocols/ndmp/contexts/restore | 
*ProtocolsApi* | [**get_ndmp_contexts_restore_by_id**](docs/ProtocolsApi.md#get_ndmp_contexts_restore_by_id) | **GET** /platform/3/protocols/ndmp/contexts/restore/{NdmpContextsRestoreId} | 
*ProtocolsApi* | [**get_ndmp_diagnostics**](docs/ProtocolsApi.md#get_ndmp_diagnostics) | **GET** /platform/3/protocols/ndmp/diagnostics | 
*ProtocolsApi* | [**get_ndmp_dumpdate**](docs/ProtocolsApi.md#get_ndmp_dumpdate) | **GET** /platform/3/protocols/ndmp/dumpdates/{NdmpDumpdateId} | 
*ProtocolsApi* | [**get_ndmp_logs**](docs/ProtocolsApi.md#get_ndmp_logs) | **GET** /platform/3/protocols/ndmp/logs | 
*ProtocolsApi* | [**get_ndmp_session**](docs/ProtocolsApi.md#get_ndmp_session) | **GET** /platform/3/protocols/ndmp/sessions/{NdmpSessionId} | 
*ProtocolsApi* | [**get_ndmp_sessions**](docs/ProtocolsApi.md#get_ndmp_sessions) | **GET** /platform/3/protocols/ndmp/sessions | 
*ProtocolsApi* | [**get_ndmp_settings_dmas**](docs/ProtocolsApi.md#get_ndmp_settings_dmas) | **GET** /platform/3/protocols/ndmp/settings/dmas | 
*ProtocolsApi* | [**get_ndmp_settings_global**](docs/ProtocolsApi.md#get_ndmp_settings_global) | **GET** /platform/3/protocols/ndmp/settings/global | 
*ProtocolsApi* | [**get_ndmp_settings_preferred_ip**](docs/ProtocolsApi.md#get_ndmp_settings_preferred_ip) | **GET** /platform/4/protocols/ndmp/settings/preferred-ips/{NdmpSettingsPreferredIpId} | 
*ProtocolsApi* | [**get_ndmp_settings_variable**](docs/ProtocolsApi.md#get_ndmp_settings_variable) | **GET** /platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId} | 
*ProtocolsApi* | [**get_ndmp_user**](docs/ProtocolsApi.md#get_ndmp_user) | **GET** /platform/3/protocols/ndmp/users/{NdmpUserId} | 
*ProtocolsApi* | [**get_nfs_alias**](docs/ProtocolsApi.md#get_nfs_alias) | **GET** /platform/2/protocols/nfs/aliases/{NfsAliasId} | 
*ProtocolsApi* | [**get_nfs_check**](docs/ProtocolsApi.md#get_nfs_check) | **GET** /platform/2/protocols/nfs/check | 
*ProtocolsApi* | [**get_nfs_export**](docs/ProtocolsApi.md#get_nfs_export) | **GET** /platform/4/protocols/nfs/exports/{NfsExportId} | 
*ProtocolsApi* | [**get_nfs_exports_summary**](docs/ProtocolsApi.md#get_nfs_exports_summary) | **GET** /platform/2/protocols/nfs/exports-summary | 
*ProtocolsApi* | [**get_nfs_log_level**](docs/ProtocolsApi.md#get_nfs_log_level) | **GET** /platform/3/protocols/nfs/log-level | 
*ProtocolsApi* | [**get_nfs_netgroup**](docs/ProtocolsApi.md#get_nfs_netgroup) | **GET** /platform/3/protocols/nfs/netgroup | 
*ProtocolsApi* | [**get_nfs_nlm_locks**](docs/ProtocolsApi.md#get_nfs_nlm_locks) | **GET** /platform/2/protocols/nfs/nlm/locks | 
*ProtocolsApi* | [**get_nfs_nlm_session**](docs/ProtocolsApi.md#get_nfs_nlm_session) | **GET** /platform/3/protocols/nfs/nlm/sessions/{NfsNlmSessionId} | 
*ProtocolsApi* | [**get_nfs_nlm_sessions**](docs/ProtocolsApi.md#get_nfs_nlm_sessions) | **GET** /platform/3/protocols/nfs/nlm/sessions | 
*ProtocolsApi* | [**get_nfs_nlm_waiters**](docs/ProtocolsApi.md#get_nfs_nlm_waiters) | **GET** /platform/2/protocols/nfs/nlm/waiters | 
*ProtocolsApi* | [**get_nfs_settings_export**](docs/ProtocolsApi.md#get_nfs_settings_export) | **GET** /platform/2/protocols/nfs/settings/export | 
*ProtocolsApi* | [**get_nfs_settings_global**](docs/ProtocolsApi.md#get_nfs_settings_global) | **GET** /platform/7/protocols/nfs/settings/global | 
*ProtocolsApi* | [**get_nfs_settings_zone**](docs/ProtocolsApi.md#get_nfs_settings_zone) | **GET** /platform/2/protocols/nfs/settings/zone | 
*ProtocolsApi* | [**get_ntp_server**](docs/ProtocolsApi.md#get_ntp_server) | **GET** /platform/3/protocols/ntp/servers/{NtpServerId} | 
*ProtocolsApi* | [**get_ntp_settings**](docs/ProtocolsApi.md#get_ntp_settings) | **GET** /platform/3/protocols/ntp/settings | 
*ProtocolsApi* | [**get_smb_log_level**](docs/ProtocolsApi.md#get_smb_log_level) | **GET** /platform/3/protocols/smb/log-level | 
*ProtocolsApi* | [**get_smb_log_level_filter**](docs/ProtocolsApi.md#get_smb_log_level_filter) | **GET** /platform/3/protocols/smb/log-level/filters/{SmbLogLevelFilterId} | 
*ProtocolsApi* | [**get_smb_openfiles**](docs/ProtocolsApi.md#get_smb_openfiles) | **GET** /platform/1/protocols/smb/openfiles | 
*ProtocolsApi* | [**get_smb_sessions**](docs/ProtocolsApi.md#get_smb_sessions) | **GET** /platform/1/protocols/smb/sessions | 
*ProtocolsApi* | [**get_smb_settings_global**](docs/ProtocolsApi.md#get_smb_settings_global) | **GET** /platform/7/protocols/smb/settings/global | 
*ProtocolsApi* | [**get_smb_settings_share**](docs/ProtocolsApi.md#get_smb_settings_share) | **GET** /platform/7/protocols/smb/settings/share | 
*ProtocolsApi* | [**get_smb_settings_zone**](docs/ProtocolsApi.md#get_smb_settings_zone) | **GET** /platform/6/protocols/smb/settings/zone | 
*ProtocolsApi* | [**get_smb_share**](docs/ProtocolsApi.md#get_smb_share) | **GET** /platform/7/protocols/smb/shares/{SmbShareId} | 
*ProtocolsApi* | [**get_smb_shares_summary**](docs/ProtocolsApi.md#get_smb_shares_summary) | **GET** /platform/1/protocols/smb/shares-summary | 
*ProtocolsApi* | [**get_snmp_settings**](docs/ProtocolsApi.md#get_snmp_settings) | **GET** /platform/5/protocols/snmp/settings | 
*ProtocolsApi* | [**get_ssh_settings**](docs/ProtocolsApi.md#get_ssh_settings) | **GET** /platform/8/protocols/ssh/settings | 
*ProtocolsApi* | [**get_swift_account**](docs/ProtocolsApi.md#get_swift_account) | **GET** /platform/3/protocols/swift/accounts/{SwiftAccountId} | 
*ProtocolsApi* | [**list_hdfs_crypto_encryption_zones**](docs/ProtocolsApi.md#list_hdfs_crypto_encryption_zones) | **GET** /platform/7/protocols/hdfs/crypto/encryption-zones | 
*ProtocolsApi* | [**list_hdfs_proxyusers**](docs/ProtocolsApi.md#list_hdfs_proxyusers) | **GET** /platform/1/protocols/hdfs/proxyusers | 
*ProtocolsApi* | [**list_hdfs_racks**](docs/ProtocolsApi.md#list_hdfs_racks) | **GET** /platform/1/protocols/hdfs/racks | 
*ProtocolsApi* | [**list_ndmp_settings_preferred_ips**](docs/ProtocolsApi.md#list_ndmp_settings_preferred_ips) | **GET** /platform/4/protocols/ndmp/settings/preferred-ips | 
*ProtocolsApi* | [**list_ndmp_users**](docs/ProtocolsApi.md#list_ndmp_users) | **GET** /platform/3/protocols/ndmp/users | 
*ProtocolsApi* | [**list_nfs_aliases**](docs/ProtocolsApi.md#list_nfs_aliases) | **GET** /platform/2/protocols/nfs/aliases | 
*ProtocolsApi* | [**list_nfs_exports**](docs/ProtocolsApi.md#list_nfs_exports) | **GET** /platform/4/protocols/nfs/exports | 
*ProtocolsApi* | [**list_ntp_servers**](docs/ProtocolsApi.md#list_ntp_servers) | **GET** /platform/3/protocols/ntp/servers | 
*ProtocolsApi* | [**list_smb_log_level_filters**](docs/ProtocolsApi.md#list_smb_log_level_filters) | **GET** /platform/3/protocols/smb/log-level/filters | 
*ProtocolsApi* | [**list_smb_shares**](docs/ProtocolsApi.md#list_smb_shares) | **GET** /platform/7/protocols/smb/shares | 
*ProtocolsApi* | [**list_swift_accounts**](docs/ProtocolsApi.md#list_swift_accounts) | **GET** /platform/3/protocols/swift/accounts | 
*ProtocolsApi* | [**update_ftp_settings**](docs/ProtocolsApi.md#update_ftp_settings) | **PUT** /platform/3/protocols/ftp/settings | 
*ProtocolsApi* | [**update_hdfs_crypto_settings**](docs/ProtocolsApi.md#update_hdfs_crypto_settings) | **PUT** /platform/7/protocols/hdfs/crypto/settings | 
*ProtocolsApi* | [**update_hdfs_fsimage_job_settings**](docs/ProtocolsApi.md#update_hdfs_fsimage_job_settings) | **PUT** /platform/5/protocols/hdfs/fsimage/job/settings | 
*ProtocolsApi* | [**update_hdfs_fsimage_settings**](docs/ProtocolsApi.md#update_hdfs_fsimage_settings) | **PUT** /platform/5/protocols/hdfs/fsimage/settings | 
*ProtocolsApi* | [**update_hdfs_inotify_settings**](docs/ProtocolsApi.md#update_hdfs_inotify_settings) | **PUT** /platform/5/protocols/hdfs/inotify/settings | 
*ProtocolsApi* | [**update_hdfs_log_level**](docs/ProtocolsApi.md#update_hdfs_log_level) | **PUT** /platform/3/protocols/hdfs/log-level | 
*ProtocolsApi* | [**update_hdfs_proxyuser**](docs/ProtocolsApi.md#update_hdfs_proxyuser) | **PUT** /platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId} | 
*ProtocolsApi* | [**update_hdfs_rack**](docs/ProtocolsApi.md#update_hdfs_rack) | **PUT** /platform/1/protocols/hdfs/racks/{HdfsRackId} | 
*ProtocolsApi* | [**update_hdfs_ranger_plugin_settings**](docs/ProtocolsApi.md#update_hdfs_ranger_plugin_settings) | **PUT** /platform/4/protocols/hdfs/ranger-plugin/settings | 
*ProtocolsApi* | [**update_hdfs_settings**](docs/ProtocolsApi.md#update_hdfs_settings) | **PUT** /platform/4/protocols/hdfs/settings | 
*ProtocolsApi* | [**update_http_settings**](docs/ProtocolsApi.md#update_http_settings) | **PUT** /platform/3/protocols/http/settings | 
*ProtocolsApi* | [**update_ndmp_diagnostics**](docs/ProtocolsApi.md#update_ndmp_diagnostics) | **PUT** /platform/3/protocols/ndmp/diagnostics | 
*ProtocolsApi* | [**update_ndmp_settings_global**](docs/ProtocolsApi.md#update_ndmp_settings_global) | **PUT** /platform/3/protocols/ndmp/settings/global | 
*ProtocolsApi* | [**update_ndmp_settings_preferred_ip**](docs/ProtocolsApi.md#update_ndmp_settings_preferred_ip) | **PUT** /platform/4/protocols/ndmp/settings/preferred-ips/{NdmpSettingsPreferredIpId} | 
*ProtocolsApi* | [**update_ndmp_settings_variable**](docs/ProtocolsApi.md#update_ndmp_settings_variable) | **PUT** /platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId} | 
*ProtocolsApi* | [**update_ndmp_user**](docs/ProtocolsApi.md#update_ndmp_user) | **PUT** /platform/3/protocols/ndmp/users/{NdmpUserId} | 
*ProtocolsApi* | [**update_nfs_alias**](docs/ProtocolsApi.md#update_nfs_alias) | **PUT** /platform/2/protocols/nfs/aliases/{NfsAliasId} | 
*ProtocolsApi* | [**update_nfs_export**](docs/ProtocolsApi.md#update_nfs_export) | **PUT** /platform/4/protocols/nfs/exports/{NfsExportId} | 
*ProtocolsApi* | [**update_nfs_log_level**](docs/ProtocolsApi.md#update_nfs_log_level) | **PUT** /platform/3/protocols/nfs/log-level | 
*ProtocolsApi* | [**update_nfs_netgroup**](docs/ProtocolsApi.md#update_nfs_netgroup) | **PUT** /platform/3/protocols/nfs/netgroup | 
*ProtocolsApi* | [**update_nfs_settings_export**](docs/ProtocolsApi.md#update_nfs_settings_export) | **PUT** /platform/2/protocols/nfs/settings/export | 
*ProtocolsApi* | [**update_nfs_settings_global**](docs/ProtocolsApi.md#update_nfs_settings_global) | **PUT** /platform/7/protocols/nfs/settings/global | 
*ProtocolsApi* | [**update_nfs_settings_zone**](docs/ProtocolsApi.md#update_nfs_settings_zone) | **PUT** /platform/2/protocols/nfs/settings/zone | 
*ProtocolsApi* | [**update_ntp_server**](docs/ProtocolsApi.md#update_ntp_server) | **PUT** /platform/3/protocols/ntp/servers/{NtpServerId} | 
*ProtocolsApi* | [**update_ntp_settings**](docs/ProtocolsApi.md#update_ntp_settings) | **PUT** /platform/3/protocols/ntp/settings | 
*ProtocolsApi* | [**update_smb_log_level**](docs/ProtocolsApi.md#update_smb_log_level) | **PUT** /platform/3/protocols/smb/log-level | 
*ProtocolsApi* | [**update_smb_settings_global**](docs/ProtocolsApi.md#update_smb_settings_global) | **PUT** /platform/7/protocols/smb/settings/global | 
*ProtocolsApi* | [**update_smb_settings_share**](docs/ProtocolsApi.md#update_smb_settings_share) | **PUT** /platform/7/protocols/smb/settings/share | 
*ProtocolsApi* | [**update_smb_settings_zone**](docs/ProtocolsApi.md#update_smb_settings_zone) | **PUT** /platform/6/protocols/smb/settings/zone | 
*ProtocolsApi* | [**update_smb_share**](docs/ProtocolsApi.md#update_smb_share) | **PUT** /platform/7/protocols/smb/shares/{SmbShareId} | 
*ProtocolsApi* | [**update_snmp_settings**](docs/ProtocolsApi.md#update_snmp_settings) | **PUT** /platform/5/protocols/snmp/settings | 
*ProtocolsApi* | [**update_ssh_settings**](docs/ProtocolsApi.md#update_ssh_settings) | **PUT** /platform/8/protocols/ssh/settings | 
*ProtocolsApi* | [**update_swift_account**](docs/ProtocolsApi.md#update_swift_account) | **PUT** /platform/3/protocols/swift/accounts/{SwiftAccountId} | 
*ProtocolsHdfsApi* | [**create_proxyusers_name_member**](docs/ProtocolsHdfsApi.md#create_proxyusers_name_member) | **POST** /platform/1/protocols/hdfs/proxyusers/{Name}/members | 
*ProtocolsHdfsApi* | [**delete_proxyusers_name_member**](docs/ProtocolsHdfsApi.md#delete_proxyusers_name_member) | **DELETE** /platform/1/protocols/hdfs/proxyusers/{Name}/members/{ProxyusersNameMemberId} | 
*ProtocolsHdfsApi* | [**list_proxyusers_name_members**](docs/ProtocolsHdfsApi.md#list_proxyusers_name_members) | **GET** /platform/1/protocols/hdfs/proxyusers/{Name}/members | 
*ProtocolsHdfsApi* | [**update_proxyusers_name_member**](docs/ProtocolsHdfsApi.md#update_proxyusers_name_member) | **PUT** /platform/1/protocols/hdfs/proxyusers/{Name}/members/{ProxyusersNameMemberId} | 
*QuotaApi* | [**create_quota_quota**](docs/QuotaApi.md#create_quota_quota) | **POST** /platform/8/quota/quotas | 
*QuotaApi* | [**create_quota_report**](docs/QuotaApi.md#create_quota_report) | **POST** /platform/1/quota/reports | 
*QuotaApi* | [**create_settings_mapping**](docs/QuotaApi.md#create_settings_mapping) | **POST** /platform/1/quota/settings/mappings | 
*QuotaApi* | [**create_settings_notification**](docs/QuotaApi.md#create_settings_notification) | **POST** /platform/7/quota/settings/notifications | 
*QuotaApi* | [**delete_quota_quota**](docs/QuotaApi.md#delete_quota_quota) | **DELETE** /platform/8/quota/quotas/{QuotaQuotaId} | 
*QuotaApi* | [**delete_quota_quotas**](docs/QuotaApi.md#delete_quota_quotas) | **DELETE** /platform/8/quota/quotas | 
*QuotaApi* | [**delete_quota_report**](docs/QuotaApi.md#delete_quota_report) | **DELETE** /platform/1/quota/reports/{QuotaReportId} | 
*QuotaApi* | [**delete_settings_mapping**](docs/QuotaApi.md#delete_settings_mapping) | **DELETE** /platform/1/quota/settings/mappings/{SettingsMappingId} | 
*QuotaApi* | [**delete_settings_mappings**](docs/QuotaApi.md#delete_settings_mappings) | **DELETE** /platform/1/quota/settings/mappings | 
*QuotaApi* | [**delete_settings_notification**](docs/QuotaApi.md#delete_settings_notification) | **DELETE** /platform/7/quota/settings/notifications/{SettingsNotificationId} | 
*QuotaApi* | [**delete_settings_notifications**](docs/QuotaApi.md#delete_settings_notifications) | **DELETE** /platform/7/quota/settings/notifications | 
*QuotaApi* | [**get_quota_license**](docs/QuotaApi.md#get_quota_license) | **GET** /platform/5/quota/license | 
*QuotaApi* | [**get_quota_quota**](docs/QuotaApi.md#get_quota_quota) | **GET** /platform/8/quota/quotas/{QuotaQuotaId} | 
*QuotaApi* | [**get_quota_quotas_summary**](docs/QuotaApi.md#get_quota_quotas_summary) | **GET** /platform/1/quota/quotas-summary | 
*QuotaApi* | [**get_quota_report**](docs/QuotaApi.md#get_quota_report) | **GET** /platform/1/quota/reports/{QuotaReportId} | 
*QuotaApi* | [**get_settings_mapping**](docs/QuotaApi.md#get_settings_mapping) | **GET** /platform/1/quota/settings/mappings/{SettingsMappingId} | 
*QuotaApi* | [**get_settings_notification**](docs/QuotaApi.md#get_settings_notification) | **GET** /platform/7/quota/settings/notifications/{SettingsNotificationId} | 
*QuotaApi* | [**get_settings_reports**](docs/QuotaApi.md#get_settings_reports) | **GET** /platform/1/quota/settings/reports | 
*QuotaApi* | [**list_quota_quotas**](docs/QuotaApi.md#list_quota_quotas) | **GET** /platform/8/quota/quotas | 
*QuotaApi* | [**list_quota_reports**](docs/QuotaApi.md#list_quota_reports) | **GET** /platform/1/quota/reports | 
*QuotaApi* | [**list_settings_mappings**](docs/QuotaApi.md#list_settings_mappings) | **GET** /platform/1/quota/settings/mappings | 
*QuotaApi* | [**list_settings_notifications**](docs/QuotaApi.md#list_settings_notifications) | **GET** /platform/7/quota/settings/notifications | 
*QuotaApi* | [**update_quota_quota**](docs/QuotaApi.md#update_quota_quota) | **PUT** /platform/8/quota/quotas/{QuotaQuotaId} | 
*QuotaApi* | [**update_settings_mapping**](docs/QuotaApi.md#update_settings_mapping) | **PUT** /platform/1/quota/settings/mappings/{SettingsMappingId} | 
*QuotaApi* | [**update_settings_notification**](docs/QuotaApi.md#update_settings_notification) | **PUT** /platform/7/quota/settings/notifications/{SettingsNotificationId} | 
*QuotaApi* | [**update_settings_reports**](docs/QuotaApi.md#update_settings_reports) | **PUT** /platform/1/quota/settings/reports | 
*QuotaQuotasApi* | [**create_quota_notification**](docs/QuotaQuotasApi.md#create_quota_notification) | **POST** /platform/7/quota/quotas/{Qid}/notifications | 
*QuotaQuotasApi* | [**delete_quota_notification**](docs/QuotaQuotasApi.md#delete_quota_notification) | **DELETE** /platform/7/quota/quotas/{Qid}/notifications/{QuotaNotificationId} | 
*QuotaQuotasApi* | [**delete_quota_notifications**](docs/QuotaQuotasApi.md#delete_quota_notifications) | **DELETE** /platform/7/quota/quotas/{Qid}/notifications | 
*QuotaQuotasApi* | [**get_quota_notification**](docs/QuotaQuotasApi.md#get_quota_notification) | **GET** /platform/7/quota/quotas/{Qid}/notifications/{QuotaNotificationId} | 
*QuotaQuotasApi* | [**list_quota_notifications**](docs/QuotaQuotasApi.md#list_quota_notifications) | **GET** /platform/7/quota/quotas/{Qid}/notifications | 
*QuotaQuotasApi* | [**update_quota_notification**](docs/QuotaQuotasApi.md#update_quota_notification) | **PUT** /platform/7/quota/quotas/{Qid}/notifications/{QuotaNotificationId} | 
*QuotaQuotasApi* | [**update_quota_notifications**](docs/QuotaQuotasApi.md#update_quota_notifications) | **PUT** /platform/7/quota/quotas/{Qid}/notifications | 
*QuotaReportsApi* | [**get_report_about**](docs/QuotaReportsApi.md#get_report_about) | **GET** /platform/1/quota/reports/{Rid}/about | 
*RemotesupportApi* | [**get_remotesupport_connectemc**](docs/RemotesupportApi.md#get_remotesupport_connectemc) | **GET** /platform/1/remotesupport/connectemc | 
*RemotesupportApi* | [**update_remotesupport_connectemc**](docs/RemotesupportApi.md#update_remotesupport_connectemc) | **PUT** /platform/1/remotesupport/connectemc | 
*SnapshotApi* | [**create_snapshot_alias**](docs/SnapshotApi.md#create_snapshot_alias) | **POST** /platform/1/snapshot/aliases | 
*SnapshotApi* | [**create_snapshot_schedule**](docs/SnapshotApi.md#create_snapshot_schedule) | **POST** /platform/3/snapshot/schedules | 
*SnapshotApi* | [**create_snapshot_snapshot**](docs/SnapshotApi.md#create_snapshot_snapshot) | **POST** /platform/1/snapshot/snapshots | 
*SnapshotApi* | [**delete_snapshot_alias**](docs/SnapshotApi.md#delete_snapshot_alias) | **DELETE** /platform/1/snapshot/aliases/{SnapshotAliasId} | 
*SnapshotApi* | [**delete_snapshot_aliases**](docs/SnapshotApi.md#delete_snapshot_aliases) | **DELETE** /platform/1/snapshot/aliases | 
*SnapshotApi* | [**delete_snapshot_changelist**](docs/SnapshotApi.md#delete_snapshot_changelist) | **DELETE** /platform/1/snapshot/changelists/{SnapshotChangelistId} | 
*SnapshotApi* | [**delete_snapshot_repstate**](docs/SnapshotApi.md#delete_snapshot_repstate) | **DELETE** /platform/1/snapshot/repstates/{SnapshotRepstateId} | 
*SnapshotApi* | [**delete_snapshot_schedule**](docs/SnapshotApi.md#delete_snapshot_schedule) | **DELETE** /platform/3/snapshot/schedules/{SnapshotScheduleId} | 
*SnapshotApi* | [**delete_snapshot_schedules**](docs/SnapshotApi.md#delete_snapshot_schedules) | **DELETE** /platform/3/snapshot/schedules | 
*SnapshotApi* | [**delete_snapshot_snapshot**](docs/SnapshotApi.md#delete_snapshot_snapshot) | **DELETE** /platform/1/snapshot/snapshots/{SnapshotSnapshotId} | 
*SnapshotApi* | [**delete_snapshot_snapshots**](docs/SnapshotApi.md#delete_snapshot_snapshots) | **DELETE** /platform/1/snapshot/snapshots | 
*SnapshotApi* | [**get_snapshot_alias**](docs/SnapshotApi.md#get_snapshot_alias) | **GET** /platform/1/snapshot/aliases/{SnapshotAliasId} | 
*SnapshotApi* | [**get_snapshot_changelist**](docs/SnapshotApi.md#get_snapshot_changelist) | **GET** /platform/1/snapshot/changelists/{SnapshotChangelistId} | 
*SnapshotApi* | [**get_snapshot_changelists**](docs/SnapshotApi.md#get_snapshot_changelists) | **GET** /platform/1/snapshot/changelists | 
*SnapshotApi* | [**get_snapshot_license**](docs/SnapshotApi.md#get_snapshot_license) | **GET** /platform/5/snapshot/license | 
*SnapshotApi* | [**get_snapshot_pending**](docs/SnapshotApi.md#get_snapshot_pending) | **GET** /platform/1/snapshot/pending | 
*SnapshotApi* | [**get_snapshot_repstate**](docs/SnapshotApi.md#get_snapshot_repstate) | **GET** /platform/1/snapshot/repstates/{SnapshotRepstateId} | 
*SnapshotApi* | [**get_snapshot_repstates**](docs/SnapshotApi.md#get_snapshot_repstates) | **GET** /platform/1/snapshot/repstates | 
*SnapshotApi* | [**get_snapshot_schedule**](docs/SnapshotApi.md#get_snapshot_schedule) | **GET** /platform/3/snapshot/schedules/{SnapshotScheduleId} | 
*SnapshotApi* | [**get_snapshot_settings**](docs/SnapshotApi.md#get_snapshot_settings) | **GET** /platform/1/snapshot/settings | 
*SnapshotApi* | [**get_snapshot_snapshot**](docs/SnapshotApi.md#get_snapshot_snapshot) | **GET** /platform/1/snapshot/snapshots/{SnapshotSnapshotId} | 
*SnapshotApi* | [**get_snapshot_snapshots_summary**](docs/SnapshotApi.md#get_snapshot_snapshots_summary) | **GET** /platform/1/snapshot/snapshots-summary | 
*SnapshotApi* | [**list_snapshot_aliases**](docs/SnapshotApi.md#list_snapshot_aliases) | **GET** /platform/1/snapshot/aliases | 
*SnapshotApi* | [**list_snapshot_schedules**](docs/SnapshotApi.md#list_snapshot_schedules) | **GET** /platform/3/snapshot/schedules | 
*SnapshotApi* | [**list_snapshot_snapshots**](docs/SnapshotApi.md#list_snapshot_snapshots) | **GET** /platform/1/snapshot/snapshots | 
*SnapshotApi* | [**update_snapshot_alias**](docs/SnapshotApi.md#update_snapshot_alias) | **PUT** /platform/1/snapshot/aliases/{SnapshotAliasId} | 
*SnapshotApi* | [**update_snapshot_schedule**](docs/SnapshotApi.md#update_snapshot_schedule) | **PUT** /platform/3/snapshot/schedules/{SnapshotScheduleId} | 
*SnapshotApi* | [**update_snapshot_settings**](docs/SnapshotApi.md#update_snapshot_settings) | **PUT** /platform/1/snapshot/settings | 
*SnapshotApi* | [**update_snapshot_snapshot**](docs/SnapshotApi.md#update_snapshot_snapshot) | **PUT** /platform/1/snapshot/snapshots/{SnapshotSnapshotId} | 
*SnapshotChangelistsApi* | [**get_changelist_entries**](docs/SnapshotChangelistsApi.md#get_changelist_entries) | **GET** /platform/8/snapshot/changelists/{Changelist}/entries | 
*SnapshotChangelistsApi* | [**get_changelist_entry**](docs/SnapshotChangelistsApi.md#get_changelist_entry) | **GET** /platform/8/snapshot/changelists/{Changelist}/entries/{ChangelistEntryId} | 
*SnapshotChangelistsApi* | [**get_changelist_lin**](docs/SnapshotChangelistsApi.md#get_changelist_lin) | **GET** /platform/1/snapshot/changelists/{Changelist}/lins/{ChangelistLinId} | 
*SnapshotChangelistsApi* | [**get_changelist_lins**](docs/SnapshotChangelistsApi.md#get_changelist_lins) | **GET** /platform/1/snapshot/changelists/{Changelist}/lins | 
*SnapshotSnapshotsApi* | [**create_snapshot_lock**](docs/SnapshotSnapshotsApi.md#create_snapshot_lock) | **POST** /platform/1/snapshot/snapshots/{Sid}/locks | 
*SnapshotSnapshotsApi* | [**delete_snapshot_lock**](docs/SnapshotSnapshotsApi.md#delete_snapshot_lock) | **DELETE** /platform/1/snapshot/snapshots/{Sid}/locks/{SnapshotLockId} | 
*SnapshotSnapshotsApi* | [**delete_snapshot_locks**](docs/SnapshotSnapshotsApi.md#delete_snapshot_locks) | **DELETE** /platform/1/snapshot/snapshots/{Sid}/locks | 
*SnapshotSnapshotsApi* | [**get_snapshot_lock**](docs/SnapshotSnapshotsApi.md#get_snapshot_lock) | **GET** /platform/1/snapshot/snapshots/{Sid}/locks/{SnapshotLockId} | 
*SnapshotSnapshotsApi* | [**list_snapshot_locks**](docs/SnapshotSnapshotsApi.md#list_snapshot_locks) | **GET** /platform/1/snapshot/snapshots/{Sid}/locks | 
*SnapshotSnapshotsApi* | [**update_snapshot_lock**](docs/SnapshotSnapshotsApi.md#update_snapshot_lock) | **PUT** /platform/1/snapshot/snapshots/{Sid}/locks/{SnapshotLockId} | 
*StatisticsApi* | [**get_statistics_current**](docs/StatisticsApi.md#get_statistics_current) | **GET** /platform/1/statistics/current | 
*StatisticsApi* | [**get_statistics_history**](docs/StatisticsApi.md#get_statistics_history) | **GET** /platform/1/statistics/history | 
*StatisticsApi* | [**get_statistics_key**](docs/StatisticsApi.md#get_statistics_key) | **GET** /platform/1/statistics/keys/{StatisticsKeyId} | 
*StatisticsApi* | [**get_statistics_keys**](docs/StatisticsApi.md#get_statistics_keys) | **GET** /platform/1/statistics/keys | 
*StatisticsApi* | [**get_statistics_operations**](docs/StatisticsApi.md#get_statistics_operations) | **GET** /platform/3/statistics/operations | 
*StatisticsApi* | [**get_statistics_protocols**](docs/StatisticsApi.md#get_statistics_protocols) | **GET** /platform/1/statistics/protocols | 
*StatisticsApi* | [**get_summary_client**](docs/StatisticsApi.md#get_summary_client) | **GET** /platform/3/statistics/summary/client | 
*StatisticsApi* | [**get_summary_drive**](docs/StatisticsApi.md#get_summary_drive) | **GET** /platform/3/statistics/summary/drive | 
*StatisticsApi* | [**get_summary_heat**](docs/StatisticsApi.md#get_summary_heat) | **GET** /platform/3/statistics/summary/heat | 
*StatisticsApi* | [**get_summary_protocol**](docs/StatisticsApi.md#get_summary_protocol) | **GET** /platform/3/statistics/summary/protocol | 
*StatisticsApi* | [**get_summary_protocol_stats**](docs/StatisticsApi.md#get_summary_protocol_stats) | **GET** /platform/3/statistics/summary/protocol-stats | 
*StatisticsApi* | [**get_summary_system**](docs/StatisticsApi.md#get_summary_system) | **GET** /platform/3/statistics/summary/system | 
*StatisticsApi* | [**get_summary_workload**](docs/StatisticsApi.md#get_summary_workload) | **GET** /platform/4/statistics/summary/workload | 
*StoragepoolApi* | [**create_compatibilities_class_active_item**](docs/StoragepoolApi.md#create_compatibilities_class_active_item) | **POST** /platform/1/storagepool/compatibilities/class/active | 
*StoragepoolApi* | [**create_compatibilities_ssd_active_item**](docs/StoragepoolApi.md#create_compatibilities_ssd_active_item) | **POST** /platform/3/storagepool/compatibilities/ssd/active | 
*StoragepoolApi* | [**create_storagepool_nodepool**](docs/StoragepoolApi.md#create_storagepool_nodepool) | **POST** /platform/3/storagepool/nodepools | 
*StoragepoolApi* | [**create_storagepool_tier**](docs/StoragepoolApi.md#create_storagepool_tier) | **POST** /platform/1/storagepool/tiers | 
*StoragepoolApi* | [**delete_compatibilities_class_active_by_id**](docs/StoragepoolApi.md#delete_compatibilities_class_active_by_id) | **DELETE** /platform/1/storagepool/compatibilities/class/active/{CompatibilitiesClassActiveId} | 
*StoragepoolApi* | [**delete_compatibilities_ssd_active_by_id**](docs/StoragepoolApi.md#delete_compatibilities_ssd_active_by_id) | **DELETE** /platform/3/storagepool/compatibilities/ssd/active/{CompatibilitiesSsdActiveId} | 
*StoragepoolApi* | [**delete_storagepool_nodepool**](docs/StoragepoolApi.md#delete_storagepool_nodepool) | **DELETE** /platform/3/storagepool/nodepools/{StoragepoolNodepoolId} | 
*StoragepoolApi* | [**delete_storagepool_nodepools**](docs/StoragepoolApi.md#delete_storagepool_nodepools) | **DELETE** /platform/3/storagepool/nodepools | 
*StoragepoolApi* | [**delete_storagepool_tier**](docs/StoragepoolApi.md#delete_storagepool_tier) | **DELETE** /platform/1/storagepool/tiers/{StoragepoolTierId} | 
*StoragepoolApi* | [**delete_storagepool_tiers**](docs/StoragepoolApi.md#delete_storagepool_tiers) | **DELETE** /platform/1/storagepool/tiers | 
*StoragepoolApi* | [**get_compatibilities_class_active_by_id**](docs/StoragepoolApi.md#get_compatibilities_class_active_by_id) | **GET** /platform/1/storagepool/compatibilities/class/active/{CompatibilitiesClassActiveId} | 
*StoragepoolApi* | [**get_compatibilities_class_available**](docs/StoragepoolApi.md#get_compatibilities_class_available) | **GET** /platform/1/storagepool/compatibilities/class/available | 
*StoragepoolApi* | [**get_compatibilities_ssd_active_by_id**](docs/StoragepoolApi.md#get_compatibilities_ssd_active_by_id) | **GET** /platform/3/storagepool/compatibilities/ssd/active/{CompatibilitiesSsdActiveId} | 
*StoragepoolApi* | [**get_compatibilities_ssd_available**](docs/StoragepoolApi.md#get_compatibilities_ssd_available) | **GET** /platform/1/storagepool/compatibilities/ssd/available | 
*StoragepoolApi* | [**get_storagepool_nodepool**](docs/StoragepoolApi.md#get_storagepool_nodepool) | **GET** /platform/3/storagepool/nodepools/{StoragepoolNodepoolId} | 
*StoragepoolApi* | [**get_storagepool_settings**](docs/StoragepoolApi.md#get_storagepool_settings) | **GET** /platform/5/storagepool/settings | 
*StoragepoolApi* | [**get_storagepool_status**](docs/StoragepoolApi.md#get_storagepool_status) | **GET** /platform/1/storagepool/status | 
*StoragepoolApi* | [**get_storagepool_storagepools**](docs/StoragepoolApi.md#get_storagepool_storagepools) | **GET** /platform/3/storagepool/storagepools | 
*StoragepoolApi* | [**get_storagepool_suggested_protection_nid**](docs/StoragepoolApi.md#get_storagepool_suggested_protection_nid) | **GET** /platform/3/storagepool/suggested-protection/{StoragepoolSuggestedProtectionNid} | 
*StoragepoolApi* | [**get_storagepool_tier**](docs/StoragepoolApi.md#get_storagepool_tier) | **GET** /platform/1/storagepool/tiers/{StoragepoolTierId} | 
*StoragepoolApi* | [**get_storagepool_unprovisioned**](docs/StoragepoolApi.md#get_storagepool_unprovisioned) | **GET** /platform/1/storagepool/unprovisioned | 
*StoragepoolApi* | [**list_compatibilities_class_active**](docs/StoragepoolApi.md#list_compatibilities_class_active) | **GET** /platform/1/storagepool/compatibilities/class/active | 
*StoragepoolApi* | [**list_compatibilities_ssd_active**](docs/StoragepoolApi.md#list_compatibilities_ssd_active) | **GET** /platform/3/storagepool/compatibilities/ssd/active | 
*StoragepoolApi* | [**list_storagepool_nodepools**](docs/StoragepoolApi.md#list_storagepool_nodepools) | **GET** /platform/3/storagepool/nodepools | 
*StoragepoolApi* | [**list_storagepool_tiers**](docs/StoragepoolApi.md#list_storagepool_tiers) | **GET** /platform/1/storagepool/tiers | 
*StoragepoolApi* | [**update_compatibilities_ssd_active_by_id**](docs/StoragepoolApi.md#update_compatibilities_ssd_active_by_id) | **PUT** /platform/3/storagepool/compatibilities/ssd/active/{CompatibilitiesSsdActiveId} | 
*StoragepoolApi* | [**update_storagepool_nodepool**](docs/StoragepoolApi.md#update_storagepool_nodepool) | **PUT** /platform/3/storagepool/nodepools/{StoragepoolNodepoolId} | 
*StoragepoolApi* | [**update_storagepool_settings**](docs/StoragepoolApi.md#update_storagepool_settings) | **PUT** /platform/5/storagepool/settings | 
*StoragepoolApi* | [**update_storagepool_tier**](docs/StoragepoolApi.md#update_storagepool_tier) | **PUT** /platform/1/storagepool/tiers/{StoragepoolTierId} | 
*SyncApi* | [**create_certificates_peer_item**](docs/SyncApi.md#create_certificates_peer_item) | **POST** /platform/7/sync/certificates/peer | 
*SyncApi* | [**create_certificates_server_item**](docs/SyncApi.md#create_certificates_server_item) | **POST** /platform/7/sync/certificates/server | 
*SyncApi* | [**create_service_policy**](docs/SyncApi.md#create_service_policy) | **POST** /platform/7/sync/service/policies | 
*SyncApi* | [**create_sync_job**](docs/SyncApi.md#create_sync_job) | **POST** /platform/7/sync/jobs | 
*SyncApi* | [**create_sync_policy**](docs/SyncApi.md#create_sync_policy) | **POST** /platform/7/sync/policies | 
*SyncApi* | [**create_sync_reports_rotate_item**](docs/SyncApi.md#create_sync_reports_rotate_item) | **POST** /platform/1/sync/reports-rotate | 
*SyncApi* | [**create_sync_rule**](docs/SyncApi.md#create_sync_rule) | **POST** /platform/3/sync/rules | 
*SyncApi* | [**delete_certificates_peer_by_id**](docs/SyncApi.md#delete_certificates_peer_by_id) | **DELETE** /platform/7/sync/certificates/peer/{CertificatesPeerId} | 
*SyncApi* | [**delete_certificates_server_by_id**](docs/SyncApi.md#delete_certificates_server_by_id) | **DELETE** /platform/7/sync/certificates/server/{CertificatesServerId} | 
*SyncApi* | [**delete_service_policies**](docs/SyncApi.md#delete_service_policies) | **DELETE** /platform/7/sync/service/policies | 
*SyncApi* | [**delete_service_policy**](docs/SyncApi.md#delete_service_policy) | **DELETE** /platform/7/sync/service/policies/{ServicePolicyId} | 
*SyncApi* | [**delete_service_target_policy**](docs/SyncApi.md#delete_service_target_policy) | **DELETE** /platform/7/sync/service/target/policies/{ServiceTargetPolicyId} | 
*SyncApi* | [**delete_sync_jobs**](docs/SyncApi.md#delete_sync_jobs) | **DELETE** /platform/7/sync/jobs | 
*SyncApi* | [**delete_sync_policies**](docs/SyncApi.md#delete_sync_policies) | **DELETE** /platform/7/sync/policies | 
*SyncApi* | [**delete_sync_policy**](docs/SyncApi.md#delete_sync_policy) | **DELETE** /platform/7/sync/policies/{SyncPolicyId} | 
*SyncApi* | [**delete_sync_rule**](docs/SyncApi.md#delete_sync_rule) | **DELETE** /platform/3/sync/rules/{SyncRuleId} | 
*SyncApi* | [**delete_sync_rules**](docs/SyncApi.md#delete_sync_rules) | **DELETE** /platform/3/sync/rules | 
*SyncApi* | [**delete_target_policy**](docs/SyncApi.md#delete_target_policy) | **DELETE** /platform/1/sync/target/policies/{TargetPolicyId} | 
*SyncApi* | [**get_certificates_peer_by_id**](docs/SyncApi.md#get_certificates_peer_by_id) | **GET** /platform/7/sync/certificates/peer/{CertificatesPeerId} | 
*SyncApi* | [**get_certificates_server_by_id**](docs/SyncApi.md#get_certificates_server_by_id) | **GET** /platform/7/sync/certificates/server/{CertificatesServerId} | 
*SyncApi* | [**get_history_cpu**](docs/SyncApi.md#get_history_cpu) | **GET** /platform/3/sync/history/cpu | 
*SyncApi* | [**get_history_file**](docs/SyncApi.md#get_history_file) | **GET** /platform/1/sync/history/file | 
*SyncApi* | [**get_history_network**](docs/SyncApi.md#get_history_network) | **GET** /platform/7/sync/history/network | 
*SyncApi* | [**get_history_worker**](docs/SyncApi.md#get_history_worker) | **GET** /platform/3/sync/history/worker | 
*SyncApi* | [**get_service_policy**](docs/SyncApi.md#get_service_policy) | **GET** /platform/7/sync/service/policies/{ServicePolicyId} | 
*SyncApi* | [**get_service_target_policies**](docs/SyncApi.md#get_service_target_policies) | **GET** /platform/7/sync/service/target/policies | 
*SyncApi* | [**get_service_target_policy**](docs/SyncApi.md#get_service_target_policy) | **GET** /platform/7/sync/service/target/policies/{ServiceTargetPolicyId} | 
*SyncApi* | [**get_sync_job**](docs/SyncApi.md#get_sync_job) | **GET** /platform/7/sync/jobs/{SyncJobId} | 
*SyncApi* | [**get_sync_license**](docs/SyncApi.md#get_sync_license) | **GET** /platform/5/sync/license | 
*SyncApi* | [**get_sync_policy**](docs/SyncApi.md#get_sync_policy) | **GET** /platform/7/sync/policies/{SyncPolicyId} | 
*SyncApi* | [**get_sync_report**](docs/SyncApi.md#get_sync_report) | **GET** /platform/7/sync/reports/{SyncReportId} | 
*SyncApi* | [**get_sync_reports**](docs/SyncApi.md#get_sync_reports) | **GET** /platform/7/sync/reports | 
*SyncApi* | [**get_sync_rule**](docs/SyncApi.md#get_sync_rule) | **GET** /platform/3/sync/rules/{SyncRuleId} | 
*SyncApi* | [**get_sync_settings**](docs/SyncApi.md#get_sync_settings) | **GET** /platform/7/sync/settings | 
*SyncApi* | [**get_target_policies**](docs/SyncApi.md#get_target_policies) | **GET** /platform/1/sync/target/policies | 
*SyncApi* | [**get_target_policy**](docs/SyncApi.md#get_target_policy) | **GET** /platform/1/sync/target/policies/{TargetPolicyId} | 
*SyncApi* | [**get_target_report**](docs/SyncApi.md#get_target_report) | **GET** /platform/7/sync/target/reports/{TargetReportId} | 
*SyncApi* | [**get_target_reports**](docs/SyncApi.md#get_target_reports) | **GET** /platform/7/sync/target/reports | 
*SyncApi* | [**list_certificates_peer**](docs/SyncApi.md#list_certificates_peer) | **GET** /platform/7/sync/certificates/peer | 
*SyncApi* | [**list_certificates_server**](docs/SyncApi.md#list_certificates_server) | **GET** /platform/7/sync/certificates/server | 
*SyncApi* | [**list_service_policies**](docs/SyncApi.md#list_service_policies) | **GET** /platform/7/sync/service/policies | 
*SyncApi* | [**list_sync_jobs**](docs/SyncApi.md#list_sync_jobs) | **GET** /platform/7/sync/jobs | 
*SyncApi* | [**list_sync_policies**](docs/SyncApi.md#list_sync_policies) | **GET** /platform/7/sync/policies | 
*SyncApi* | [**list_sync_reports_rotate**](docs/SyncApi.md#list_sync_reports_rotate) | **GET** /platform/1/sync/reports-rotate | 
*SyncApi* | [**list_sync_rules**](docs/SyncApi.md#list_sync_rules) | **GET** /platform/3/sync/rules | 
*SyncApi* | [**update_certificates_peer_by_id**](docs/SyncApi.md#update_certificates_peer_by_id) | **PUT** /platform/7/sync/certificates/peer/{CertificatesPeerId} | 
*SyncApi* | [**update_certificates_server_by_id**](docs/SyncApi.md#update_certificates_server_by_id) | **PUT** /platform/7/sync/certificates/server/{CertificatesServerId} | 
*SyncApi* | [**update_service_policy**](docs/SyncApi.md#update_service_policy) | **PUT** /platform/7/sync/service/policies/{ServicePolicyId} | 
*SyncApi* | [**update_sync_job**](docs/SyncApi.md#update_sync_job) | **PUT** /platform/7/sync/jobs/{SyncJobId} | 
*SyncApi* | [**update_sync_policy**](docs/SyncApi.md#update_sync_policy) | **PUT** /platform/7/sync/policies/{SyncPolicyId} | 
*SyncApi* | [**update_sync_rule**](docs/SyncApi.md#update_sync_rule) | **PUT** /platform/3/sync/rules/{SyncRuleId} | 
*SyncApi* | [**update_sync_settings**](docs/SyncApi.md#update_sync_settings) | **PUT** /platform/7/sync/settings | 
*SyncPoliciesApi* | [**create_policy_reset_item**](docs/SyncPoliciesApi.md#create_policy_reset_item) | **POST** /platform/1/sync/policies/{Policy}/reset | 
*SyncReportsApi* | [**get_report_subreport**](docs/SyncReportsApi.md#get_report_subreport) | **GET** /platform/7/sync/reports/{Rid}/subreports/{ReportSubreportId} | 
*SyncReportsApi* | [**get_report_subreports**](docs/SyncReportsApi.md#get_report_subreports) | **GET** /platform/7/sync/reports/{Rid}/subreports | 
*SyncServiceApi* | [**create_policies_policy_reset_item**](docs/SyncServiceApi.md#create_policies_policy_reset_item) | **POST** /platform/7/sync/service/policies/{Policy}/reset | 
*SyncServiceTargetApi* | [**create_policies_policy_cancel_item**](docs/SyncServiceTargetApi.md#create_policies_policy_cancel_item) | **POST** /platform/7/sync/service/target/policies/{Policy}/cancel | 
*SyncTargetApi* | [**create_policies_policy_cancel_item**](docs/SyncTargetApi.md#create_policies_policy_cancel_item) | **POST** /platform/1/sync/target/policies/{Policy}/cancel | 
*SyncTargetApi* | [**get_reports_report_subreport**](docs/SyncTargetApi.md#get_reports_report_subreport) | **GET** /platform/7/sync/target/reports/{Rid}/subreports/{ReportsReportSubreportId} | 
*SyncTargetApi* | [**get_reports_report_subreports**](docs/SyncTargetApi.md#get_reports_report_subreports) | **GET** /platform/7/sync/target/reports/{Rid}/subreports | 
*UpgradeApi* | [**create_cluster_add_remaining_node**](docs/UpgradeApi.md#create_cluster_add_remaining_node) | **POST** /platform/3/upgrade/cluster/add_remaining_nodes | 
*UpgradeApi* | [**create_cluster_archive_item**](docs/UpgradeApi.md#create_cluster_archive_item) | **POST** /platform/3/upgrade/cluster/archive | 
*UpgradeApi* | [**create_cluster_assess_item**](docs/UpgradeApi.md#create_cluster_assess_item) | **POST** /platform/5/upgrade/cluster/assess | 
*UpgradeApi* | [**create_cluster_commit_item**](docs/UpgradeApi.md#create_cluster_commit_item) | **POST** /platform/3/upgrade/cluster/commit | 
*UpgradeApi* | [**create_cluster_firmware_assess_item**](docs/UpgradeApi.md#create_cluster_firmware_assess_item) | **POST** /platform/3/upgrade/cluster/firmware/assess | 
*UpgradeApi* | [**create_cluster_firmware_upgrade_item**](docs/UpgradeApi.md#create_cluster_firmware_upgrade_item) | **POST** /platform/3/upgrade/cluster/firmware/upgrade | 
*UpgradeApi* | [**create_cluster_patch_abort_item**](docs/UpgradeApi.md#create_cluster_patch_abort_item) | **POST** /platform/3/upgrade/cluster/patch/abort | 
*UpgradeApi* | [**create_cluster_patch_patch**](docs/UpgradeApi.md#create_cluster_patch_patch) | **POST** /platform/7/upgrade/cluster/patch/patches | 
*UpgradeApi* | [**create_cluster_pause_item**](docs/UpgradeApi.md#create_cluster_pause_item) | **POST** /platform/7/upgrade/cluster/pause | 
*UpgradeApi* | [**create_cluster_resume_item**](docs/UpgradeApi.md#create_cluster_resume_item) | **POST** /platform/7/upgrade/cluster/resume | 
*UpgradeApi* | [**create_cluster_retry_last_action_item**](docs/UpgradeApi.md#create_cluster_retry_last_action_item) | **POST** /platform/3/upgrade/cluster/retry_last_action | 
*UpgradeApi* | [**create_cluster_rollback_item**](docs/UpgradeApi.md#create_cluster_rollback_item) | **POST** /platform/3/upgrade/cluster/rollback | 
*UpgradeApi* | [**create_cluster_upgrade_item**](docs/UpgradeApi.md#create_cluster_upgrade_item) | **POST** /platform/7/upgrade/cluster/upgrade | 
*UpgradeApi* | [**create_hardware_start_item**](docs/UpgradeApi.md#create_hardware_start_item) | **POST** /platform/5/upgrade/hardware/start | 
*UpgradeApi* | [**create_hardware_stop_item**](docs/UpgradeApi.md#create_hardware_stop_item) | **POST** /platform/5/upgrade/hardware/stop | 
*UpgradeApi* | [**delete_cluster_patch_patch**](docs/UpgradeApi.md#delete_cluster_patch_patch) | **DELETE** /platform/7/upgrade/cluster/patch/patches/{ClusterPatchPatchId} | 
*UpgradeApi* | [**get_cluster_firmware_progress**](docs/UpgradeApi.md#get_cluster_firmware_progress) | **GET** /platform/3/upgrade/cluster/firmware/progress | 
*UpgradeApi* | [**get_cluster_firmware_status**](docs/UpgradeApi.md#get_cluster_firmware_status) | **GET** /platform/3/upgrade/cluster/firmware/status | 
*UpgradeApi* | [**get_cluster_node**](docs/UpgradeApi.md#get_cluster_node) | **GET** /platform/3/upgrade/cluster/nodes/{ClusterNodeId} | 
*UpgradeApi* | [**get_cluster_nodes**](docs/UpgradeApi.md#get_cluster_nodes) | **GET** /platform/3/upgrade/cluster/nodes | 
*UpgradeApi* | [**get_cluster_patch_patch**](docs/UpgradeApi.md#get_cluster_patch_patch) | **GET** /platform/7/upgrade/cluster/patch/patches/{ClusterPatchPatchId} | 
*UpgradeApi* | [**get_hardware_status**](docs/UpgradeApi.md#get_hardware_status) | **GET** /platform/5/upgrade/hardware/status | 
*UpgradeApi* | [**get_upgrade_cluster**](docs/UpgradeApi.md#get_upgrade_cluster) | **GET** /platform/7/upgrade/cluster | 
*UpgradeApi* | [**list_cluster_patch_patches**](docs/UpgradeApi.md#list_cluster_patch_patches) | **GET** /platform/7/upgrade/cluster/patch/patches | 
*UpgradeApi* | [**update_cluster_upgrade**](docs/UpgradeApi.md#update_cluster_upgrade) | **PUT** /platform/7/upgrade/cluster/upgrade | 
*UpgradeClusterApi* | [**create_nodes_node_patch_sync_item**](docs/UpgradeClusterApi.md#create_nodes_node_patch_sync_item) | **POST** /platform/4/upgrade/cluster/nodes/{Lnn}/patch/sync | 
*UpgradeClusterApi* | [**get_nodes_node_firmware_status**](docs/UpgradeClusterApi.md#get_nodes_node_firmware_status) | **GET** /platform/3/upgrade/cluster/nodes/{Lnn}/firmware/status | 
*WormApi* | [**create_worm_domain**](docs/WormApi.md#create_worm_domain) | **POST** /platform/7/worm/domains | 
*WormApi* | [**get_worm_domain**](docs/WormApi.md#get_worm_domain) | **GET** /platform/7/worm/domains/{WormDomainId} | 
*WormApi* | [**get_worm_settings**](docs/WormApi.md#get_worm_settings) | **GET** /platform/1/worm/settings | 
*WormApi* | [**list_worm_domains**](docs/WormApi.md#list_worm_domains) | **GET** /platform/7/worm/domains | 
*WormApi* | [**update_worm_domain**](docs/WormApi.md#update_worm_domain) | **PUT** /platform/7/worm/domains/{WormDomainId} | 
*WormApi* | [**update_worm_settings**](docs/WormApi.md#update_worm_settings) | **PUT** /platform/1/worm/settings | 
*ZonesApi* | [**create_zone**](docs/ZonesApi.md#create_zone) | **POST** /platform/3/zones | 
*ZonesApi* | [**delete_zone**](docs/ZonesApi.md#delete_zone) | **DELETE** /platform/3/zones/{ZoneId} | 
*ZonesApi* | [**get_zone**](docs/ZonesApi.md#get_zone) | **GET** /platform/3/zones/{ZoneId} | 
*ZonesApi* | [**list_zones**](docs/ZonesApi.md#list_zones) | **GET** /platform/3/zones | 
*ZonesApi* | [**update_zone**](docs/ZonesApi.md#update_zone) | **PUT** /platform/3/zones/{ZoneId} | 
*ZonesSummaryApi* | [**get_zones_summary**](docs/ZonesSummaryApi.md#get_zones_summary) | **GET** /platform/1/zones-summary | 
*ZonesSummaryApi* | [**get_zones_summary_zone**](docs/ZonesSummaryApi.md#get_zones_summary_zone) | **GET** /platform/1/zones-summary/{ZonesSummaryZone} | 


## Documentation For Models

 - [AccessPointCreateParams](docs/AccessPointCreateParams.md)
 - [AclObject](docs/AclObject.md)
 - [AdsProviderControllers](docs/AdsProviderControllers.md)
 - [AdsProviderControllersController](docs/AdsProviderControllersController.md)
 - [AdsProviderDomains](docs/AdsProviderDomains.md)
 - [AdsProviderDomainsDomain](docs/AdsProviderDomainsDomain.md)
 - [AdsProviderSearch](docs/AdsProviderSearch.md)
 - [AdsProviderSearchObject](docs/AdsProviderSearchObject.md)
 - [AntivirusPolicies](docs/AntivirusPolicies.md)
 - [AntivirusPolicy](docs/AntivirusPolicy.md)
 - [AntivirusQuarantine](docs/AntivirusQuarantine.md)
 - [AntivirusQuarantinePathParams](docs/AntivirusQuarantinePathParams.md)
 - [AntivirusScanItem](docs/AntivirusScanItem.md)
 - [AntivirusServer](docs/AntivirusServer.md)
 - [AntivirusServers](docs/AntivirusServers.md)
 - [AntivirusSettings](docs/AntivirusSettings.md)
 - [AntivirusSettingsExtended](docs/AntivirusSettingsExtended.md)
 - [AntivirusSettingsSettings](docs/AntivirusSettingsSettings.md)
 - [AuditProgress](docs/AuditProgress.md)
 - [AuditProgressProgress](docs/AuditProgressProgress.md)
 - [AuditSettings](docs/AuditSettings.md)
 - [AuditSettingsSettings](docs/AuditSettingsSettings.md)
 - [AuditTopic](docs/AuditTopic.md)
 - [AuditTopicCreateParams](docs/AuditTopicCreateParams.md)
 - [AuditTopics](docs/AuditTopics.md)
 - [AuthAccess](docs/AuthAccess.md)
 - [AuthAccessAccessItem](docs/AuthAccessAccessItem.md)
 - [AuthAccessAccessItemFile](docs/AuthAccessAccessItemFile.md)
 - [AuthAccessAccessItemFileFilePermissions](docs/AuthAccessAccessItemFileFilePermissions.md)
 - [AuthAccessAccessItemFileGroup](docs/AuthAccessAccessItemFileGroup.md)
 - [AuthAccessAccessItemShare](docs/AuthAccessAccessItemShare.md)
 - [AuthAccessAccessItemShareEffectiveUser](docs/AuthAccessAccessItemShareEffectiveUser.md)
 - [AuthAccessAccessItemShareSharePermissions](docs/AuthAccessAccessItemShareSharePermissions.md)
 - [AuthAccessAccessItemShareSharePermissionsShareRelevantAce](docs/AuthAccessAccessItemShareSharePermissionsShareRelevantAce.md)
 - [AuthCacheItem](docs/AuthCacheItem.md)
 - [AuthError](docs/AuthError.md)
 - [AuthGroup](docs/AuthGroup.md)
 - [AuthGroupExtended](docs/AuthGroupExtended.md)
 - [AuthGroupObjectHistoryItem](docs/AuthGroupObjectHistoryItem.md)
 - [AuthGroups](docs/AuthGroups.md)
 - [AuthId](docs/AuthId.md)
 - [AuthIdNtoken](docs/AuthIdNtoken.md)
 - [AuthIdNtokenPrivilegeItem](docs/AuthIdNtokenPrivilegeItem.md)
 - [AuthLdapTemplates](docs/AuthLdapTemplates.md)
 - [AuthLdapTemplatesExtended](docs/AuthLdapTemplatesExtended.md)
 - [AuthLdapTemplatesLdapConfigurationTemplate](docs/AuthLdapTemplatesLdapConfigurationTemplate.md)
 - [AuthLdapTemplatesLdapConfigurationTemplateExtended](docs/AuthLdapTemplatesLdapConfigurationTemplateExtended.md)
 - [AuthLogLevel](docs/AuthLogLevel.md)
 - [AuthLogLevelExtended](docs/AuthLogLevelExtended.md)
 - [AuthLogLevelLevel](docs/AuthLogLevelLevel.md)
 - [AuthNetgroup](docs/AuthNetgroup.md)
 - [AuthNetgroups](docs/AuthNetgroups.md)
 - [AuthPrivilege](docs/AuthPrivilege.md)
 - [AuthPrivileges](docs/AuthPrivileges.md)
 - [AuthRole](docs/AuthRole.md)
 - [AuthRoles](docs/AuthRoles.md)
 - [AuthShells](docs/AuthShells.md)
 - [AuthUser](docs/AuthUser.md)
 - [AuthUserExtended](docs/AuthUserExtended.md)
 - [AuthUsers](docs/AuthUsers.md)
 - [AuthWellknowns](docs/AuthWellknowns.md)
 - [CertificateAuthority](docs/CertificateAuthority.md)
 - [CertificateAuthorityCertificate](docs/CertificateAuthorityCertificate.md)
 - [CertificateAuthorityItem](docs/CertificateAuthorityItem.md)
 - [CertificateServer](docs/CertificateServer.md)
 - [CertificateServerCertificate](docs/CertificateServerCertificate.md)
 - [CertificateServerCertificateFingerprint](docs/CertificateServerCertificateFingerprint.md)
 - [CertificateServerIdParams](docs/CertificateServerIdParams.md)
 - [CertificateServerItem](docs/CertificateServerItem.md)
 - [CertificateSettings](docs/CertificateSettings.md)
 - [CertificateSettingsExtended](docs/CertificateSettingsExtended.md)
 - [CertificateSettingsSettings](docs/CertificateSettingsSettings.md)
 - [ChangelistEntries](docs/ChangelistEntries.md)
 - [ChangelistEntriesExtended](docs/ChangelistEntriesExtended.md)
 - [ChangelistEntry](docs/ChangelistEntry.md)
 - [ChangelistEntryCtime](docs/ChangelistEntryCtime.md)
 - [ChangelistLins](docs/ChangelistLins.md)
 - [ChangelistLinsCtime](docs/ChangelistLinsCtime.md)
 - [ChangelistLinsExtended](docs/ChangelistLinsExtended.md)
 - [CloudAccess](docs/CloudAccess.md)
 - [CloudAccessCluster](docs/CloudAccessCluster.md)
 - [CloudAccessItem](docs/CloudAccessItem.md)
 - [CloudAccount](docs/CloudAccount.md)
 - [CloudAccountCreateParams](docs/CloudAccountCreateParams.md)
 - [CloudAccountCredentialProvider](docs/CloudAccountCredentialProvider.md)
 - [CloudAccounts](docs/CloudAccounts.md)
 - [CloudJob](docs/CloudJob.md)
 - [CloudJobCreateParams](docs/CloudJobCreateParams.md)
 - [CloudJobExtended](docs/CloudJobExtended.md)
 - [CloudJobFiles](docs/CloudJobFiles.md)
 - [CloudJobFilesName](docs/CloudJobFilesName.md)
 - [CloudJobJobEngineJob](docs/CloudJobJobEngineJob.md)
 - [CloudJobs](docs/CloudJobs.md)
 - [CloudJobsFiles](docs/CloudJobsFiles.md)
 - [CloudJobsFilesFile](docs/CloudJobsFilesFile.md)
 - [CloudPool](docs/CloudPool.md)
 - [CloudPools](docs/CloudPools.md)
 - [CloudProxies](docs/CloudProxies.md)
 - [CloudProxy](docs/CloudProxy.md)
 - [CloudSettings](docs/CloudSettings.md)
 - [CloudSettingsSettings](docs/CloudSettingsSettings.md)
 - [CloudSettingsSettingsCloudPolicyDefaults](docs/CloudSettingsSettingsCloudPolicyDefaults.md)
 - [CloudSettingsSettingsCloudPolicyDefaultsCache](docs/CloudSettingsSettingsCloudPolicyDefaultsCache.md)
 - [CloudSettingsSettingsSleepTimeoutCloudGarbageCollection](docs/CloudSettingsSettingsSleepTimeoutCloudGarbageCollection.md)
 - [ClusterAddNodeItem](docs/ClusterAddNodeItem.md)
 - [ClusterArchiveItem](docs/ClusterArchiveItem.md)
 - [ClusterAssessItem](docs/ClusterAssessItem.md)
 - [ClusterConfig](docs/ClusterConfig.md)
 - [ClusterConfigDevice](docs/ClusterConfigDevice.md)
 - [ClusterConfigOnefsVersion](docs/ClusterConfigOnefsVersion.md)
 - [ClusterConfigTimezone](docs/ClusterConfigTimezone.md)
 - [ClusterEmail](docs/ClusterEmail.md)
 - [ClusterEmailExtended](docs/ClusterEmailExtended.md)
 - [ClusterEmailSettings](docs/ClusterEmailSettings.md)
 - [ClusterFirmwareProgress](docs/ClusterFirmwareProgress.md)
 - [ClusterFirmwareStatus](docs/ClusterFirmwareStatus.md)
 - [ClusterFirmwareStatusNode](docs/ClusterFirmwareStatusNode.md)
 - [ClusterFirmwareUpgradeItem](docs/ClusterFirmwareUpgradeItem.md)
 - [ClusterIdentity](docs/ClusterIdentity.md)
 - [ClusterIdentityExtended](docs/ClusterIdentityExtended.md)
 - [ClusterIdentityLogon](docs/ClusterIdentityLogon.md)
 - [ClusterIdentityLogonExtended](docs/ClusterIdentityLogonExtended.md)
 - [ClusterInternalNetworks](docs/ClusterInternalNetworks.md)
 - [ClusterInternalNetworksExtended](docs/ClusterInternalNetworksExtended.md)
 - [ClusterInternalNetworksFailoverIpAddresse](docs/ClusterInternalNetworksFailoverIpAddresse.md)
 - [ClusterNode](docs/ClusterNode.md)
 - [ClusterNodeDrive](docs/ClusterNodeDrive.md)
 - [ClusterNodeDriveDConfig](docs/ClusterNodeDriveDConfig.md)
 - [ClusterNodeExtended](docs/ClusterNodeExtended.md)
 - [ClusterNodeHardware](docs/ClusterNodeHardware.md)
 - [ClusterNodePartitions](docs/ClusterNodePartitions.md)
 - [ClusterNodeSensors](docs/ClusterNodeSensors.md)
 - [ClusterNodeState](docs/ClusterNodeState.md)
 - [ClusterNodeStateExtended](docs/ClusterNodeStateExtended.md)
 - [ClusterNodeStateServicelight](docs/ClusterNodeStateServicelight.md)
 - [ClusterNodeStateSmartfail](docs/ClusterNodeStateSmartfail.md)
 - [ClusterNodeStatus](docs/ClusterNodeStatus.md)
 - [ClusterNodes](docs/ClusterNodes.md)
 - [ClusterNodesAvailable](docs/ClusterNodesAvailable.md)
 - [ClusterNodesAvailableNode](docs/ClusterNodesAvailableNode.md)
 - [ClusterNodesError](docs/ClusterNodesError.md)
 - [ClusterNodesExtended](docs/ClusterNodesExtended.md)
 - [ClusterNodesExtendedExtended](docs/ClusterNodesExtendedExtended.md)
 - [ClusterNodesOnefsVersion](docs/ClusterNodesOnefsVersion.md)
 - [ClusterOwner](docs/ClusterOwner.md)
 - [ClusterPatchPatch](docs/ClusterPatchPatch.md)
 - [ClusterPatchPatches](docs/ClusterPatchPatches.md)
 - [ClusterPatchPatchesPatch](docs/ClusterPatchPatchesPatch.md)
 - [ClusterPatchPatchesPatchFile](docs/ClusterPatchPatchesPatchFile.md)
 - [ClusterPatchPatchesPatchService](docs/ClusterPatchPatchesPatchService.md)
 - [ClusterRetryLastActionItem](docs/ClusterRetryLastActionItem.md)
 - [ClusterStatfs](docs/ClusterStatfs.md)
 - [ClusterTime](docs/ClusterTime.md)
 - [ClusterTimeExtended](docs/ClusterTimeExtended.md)
 - [ClusterTimeExtendedExtended](docs/ClusterTimeExtendedExtended.md)
 - [ClusterTimeNode](docs/ClusterTimeNode.md)
 - [ClusterTimezone](docs/ClusterTimezone.md)
 - [ClusterTimezoneExtended](docs/ClusterTimezoneExtended.md)
 - [ClusterTimezoneSettings](docs/ClusterTimezoneSettings.md)
 - [ClusterTimezoneSettingsExtended](docs/ClusterTimezoneSettingsExtended.md)
 - [ClusterUpdateLnns](docs/ClusterUpdateLnns.md)
 - [ClusterUpdateLnnsLnn](docs/ClusterUpdateLnnsLnn.md)
 - [ClusterUpgrade](docs/ClusterUpgrade.md)
 - [ClusterUpgradeItem](docs/ClusterUpgradeItem.md)
 - [ClusterVersion](docs/ClusterVersion.md)
 - [ClusterVersionNode](docs/ClusterVersionNode.md)
 - [CompatibilitiesClassActive](docs/CompatibilitiesClassActive.md)
 - [CompatibilitiesClassActiveActiveItem](docs/CompatibilitiesClassActiveActiveItem.md)
 - [CompatibilitiesClassActiveItem](docs/CompatibilitiesClassActiveItem.md)
 - [CompatibilitiesClassAvailable](docs/CompatibilitiesClassAvailable.md)
 - [CompatibilitiesClassAvailableAvailableItem](docs/CompatibilitiesClassAvailableAvailableItem.md)
 - [CompatibilitiesSsdActive](docs/CompatibilitiesSsdActive.md)
 - [CompatibilitiesSsdActiveActiveItem](docs/CompatibilitiesSsdActiveActiveItem.md)
 - [CompatibilitiesSsdActiveIdParams](docs/CompatibilitiesSsdActiveIdParams.md)
 - [CompatibilitiesSsdActiveItem](docs/CompatibilitiesSsdActiveItem.md)
 - [CompatibilitiesSsdAvailable](docs/CompatibilitiesSsdAvailable.md)
 - [CompatibilitiesSsdAvailableAvailableItem](docs/CompatibilitiesSsdAvailableAvailableItem.md)
 - [CopyErrors](docs/CopyErrors.md)
 - [CopyErrorsCopyErrors](docs/CopyErrorsCopyErrors.md)
 - [CreateAntivirusScanItemResponse](docs/CreateAntivirusScanItemResponse.md)
 - [CreateCloudAccountResponse](docs/CreateCloudAccountResponse.md)
 - [CreateCloudJobResponse](docs/CreateCloudJobResponse.md)
 - [CreateCloudPoolResponse](docs/CreateCloudPoolResponse.md)
 - [CreateCloudProxyResponse](docs/CreateCloudProxyResponse.md)
 - [CreateCompatibilitiesClassActiveItemResponse](docs/CreateCompatibilitiesClassActiveItemResponse.md)
 - [CreateCompatibilitiesClassActiveItemResponseMerge](docs/CreateCompatibilitiesClassActiveItemResponseMerge.md)
 - [CreateCompatibilitiesClassActiveItemResponseSplit](docs/CreateCompatibilitiesClassActiveItemResponseSplit.md)
 - [CreateDatasetFilterResponse](docs/CreateDatasetFilterResponse.md)
 - [CreateDatasetWorkloadResponse](docs/CreateDatasetWorkloadResponse.md)
 - [CreateFilepoolPolicyResponse](docs/CreateFilepoolPolicyResponse.md)
 - [CreateHardeningApplyItemResponse](docs/CreateHardeningApplyItemResponse.md)
 - [CreateHardeningResolveItemResponse](docs/CreateHardeningResolveItemResponse.md)
 - [CreateHardeningRevertItemResponse](docs/CreateHardeningRevertItemResponse.md)
 - [CreateHardwareTapeNameResponse](docs/CreateHardwareTapeNameResponse.md)
 - [CreateHardwareTapeNameResponseNode](docs/CreateHardwareTapeNameResponseNode.md)
 - [CreateHardwareTapeNameResponseNodeRescanReportItem](docs/CreateHardwareTapeNameResponseNodeRescanReportItem.md)
 - [CreateJobJobResponse](docs/CreateJobJobResponse.md)
 - [CreateNfsAliasResponse](docs/CreateNfsAliasResponse.md)
 - [CreateNfsNlmSessionsCheckItemResponse](docs/CreateNfsNlmSessionsCheckItemResponse.md)
 - [CreatePerformanceDatasetResponse](docs/CreatePerformanceDatasetResponse.md)
 - [CreateQuotaReportResponse](docs/CreateQuotaReportResponse.md)
 - [CreateResponse](docs/CreateResponse.md)
 - [CreateSmbLogLevelFilterResponse](docs/CreateSmbLogLevelFilterResponse.md)
 - [CreateSmbShareResponse](docs/CreateSmbShareResponse.md)
 - [CreateSnapshotAliasResponse](docs/CreateSnapshotAliasResponse.md)
 - [CreateSnapshotLockResponse](docs/CreateSnapshotLockResponse.md)
 - [CreateSnapshotScheduleResponse](docs/CreateSnapshotScheduleResponse.md)
 - [CreateStoragepoolTierResponse](docs/CreateStoragepoolTierResponse.md)
 - [CreateSyncReportsRotateItemResponse](docs/CreateSyncReportsRotateItemResponse.md)
 - [DatasetFilter](docs/DatasetFilter.md)
 - [DatasetFilterMetricValues](docs/DatasetFilterMetricValues.md)
 - [DatasetFilterMetricValuesCreateParams](docs/DatasetFilterMetricValuesCreateParams.md)
 - [DatasetFilters](docs/DatasetFilters.md)
 - [DatasetFiltersExtended](docs/DatasetFiltersExtended.md)
 - [DatasetWorkload](docs/DatasetWorkload.md)
 - [DatasetWorkloads](docs/DatasetWorkloads.md)
 - [DatasetWorkloadsExtended](docs/DatasetWorkloadsExtended.md)
 - [DebugStats](docs/DebugStats.md)
 - [DebugStatsHandler](docs/DebugStatsHandler.md)
 - [DebugStatsUnknown](docs/DebugStatsUnknown.md)
 - [DedupeDedupeSummary](docs/DedupeDedupeSummary.md)
 - [DedupeDedupeSummarySummary](docs/DedupeDedupeSummarySummary.md)
 - [DedupeReport](docs/DedupeReport.md)
 - [DedupeReportExtended](docs/DedupeReportExtended.md)
 - [DedupeReports](docs/DedupeReports.md)
 - [DedupeSettings](docs/DedupeSettings.md)
 - [DedupeSettingsExtended](docs/DedupeSettingsExtended.md)
 - [DedupeSettingsSettings](docs/DedupeSettingsSettings.md)
 - [DiagnosticsGatherSettings](docs/DiagnosticsGatherSettings.md)
 - [DiagnosticsGatherSettingsExtended](docs/DiagnosticsGatherSettingsExtended.md)
 - [DiagnosticsGatherSettingsSettings](docs/DiagnosticsGatherSettingsSettings.md)
 - [DiagnosticsGatherStatus](docs/DiagnosticsGatherStatus.md)
 - [DiagnosticsGatherStatusGather](docs/DiagnosticsGatherStatusGather.md)
 - [DiagnosticsGatherStatusGatherStatus](docs/DiagnosticsGatherStatusGatherStatus.md)
 - [DiagnosticsNetloggerSettings](docs/DiagnosticsNetloggerSettings.md)
 - [DiagnosticsNetloggerSettingsSettings](docs/DiagnosticsNetloggerSettingsSettings.md)
 - [DiagnosticsNetloggerStatus](docs/DiagnosticsNetloggerStatus.md)
 - [DirectoryQuery](docs/DirectoryQuery.md)
 - [DirectoryQueryScope](docs/DirectoryQueryScope.md)
 - [DirectoryQueryScopeConditions](docs/DirectoryQueryScopeConditions.md)
 - [DrivesDriveFirmware](docs/DrivesDriveFirmware.md)
 - [DrivesDriveFirmwareNode](docs/DrivesDriveFirmwareNode.md)
 - [DrivesDriveFirmwareNodeDrive](docs/DrivesDriveFirmwareNodeDrive.md)
 - [DrivesDriveFirmwareUpdate](docs/DrivesDriveFirmwareUpdate.md)
 - [DrivesDriveFirmwareUpdateItem](docs/DrivesDriveFirmwareUpdateItem.md)
 - [DrivesDriveFirmwareUpdateNode](docs/DrivesDriveFirmwareUpdateNode.md)
 - [DrivesDriveFirmwareUpdateNodeStatus](docs/DrivesDriveFirmwareUpdateNodeStatus.md)
 - [DrivesDriveFormatItem](docs/DrivesDriveFormatItem.md)
 - [DrivesDrivePurposeItem](docs/DrivesDrivePurposeItem.md)
 - [Empty](docs/Empty.md)
 - [Error](docs/Error.md)
 - [EventAlertCondition](docs/EventAlertCondition.md)
 - [EventAlertConditions](docs/EventAlertConditions.md)
 - [EventAlertConditionsAlertCondition](docs/EventAlertConditionsAlertCondition.md)
 - [EventCategories](docs/EventCategories.md)
 - [EventCategory](docs/EventCategory.md)
 - [EventChannel](docs/EventChannel.md)
 - [EventChannelExtendedExtended](docs/EventChannelExtendedExtended.md)
 - [EventChannelParameters](docs/EventChannelParameters.md)
 - [EventChannels](docs/EventChannels.md)
 - [EventChannelsExtended](docs/EventChannelsExtended.md)
 - [EventEvent](docs/EventEvent.md)
 - [EventEventgroupDefinitions](docs/EventEventgroupDefinitions.md)
 - [EventEventgroupDefinitionsEventgroupDefinition](docs/EventEventgroupDefinitionsEventgroupDefinition.md)
 - [EventEventgroupOccurrence](docs/EventEventgroupOccurrence.md)
 - [EventEventgroupOccurrences](docs/EventEventgroupOccurrences.md)
 - [EventEventgroupOccurrencesEventgroup](docs/EventEventgroupOccurrencesEventgroup.md)
 - [EventEventlist](docs/EventEventlist.md)
 - [EventEventlistEvent](docs/EventEventlistEvent.md)
 - [EventEventlists](docs/EventEventlists.md)
 - [EventSettings](docs/EventSettings.md)
 - [EventSettingsSettings](docs/EventSettingsSettings.md)
 - [EventSettingsSettingsMaintenance](docs/EventSettingsSettingsMaintenance.md)
 - [FileFilterSettings](docs/FileFilterSettings.md)
 - [FileFilterSettingsExtended](docs/FileFilterSettingsExtended.md)
 - [FileFilterSettingsSettings](docs/FileFilterSettingsSettings.md)
 - [FilepoolDefaultPolicy](docs/FilepoolDefaultPolicy.md)
 - [FilepoolDefaultPolicyDefaultPolicy](docs/FilepoolDefaultPolicyDefaultPolicy.md)
 - [FilepoolDefaultPolicyDefaultPolicyAction](docs/FilepoolDefaultPolicyDefaultPolicyAction.md)
 - [FilepoolDefaultPolicyExtended](docs/FilepoolDefaultPolicyExtended.md)
 - [FilepoolPolicies](docs/FilepoolPolicies.md)
 - [FilepoolPolicy](docs/FilepoolPolicy.md)
 - [FilepoolPolicyAction](docs/FilepoolPolicyAction.md)
 - [FilepoolPolicyCreateParams](docs/FilepoolPolicyCreateParams.md)
 - [FilepoolPolicyExtended](docs/FilepoolPolicyExtended.md)
 - [FilepoolPolicyFileMatchingPattern](docs/FilepoolPolicyFileMatchingPattern.md)
 - [FilepoolPolicyFileMatchingPatternOrCriteriaItem](docs/FilepoolPolicyFileMatchingPatternOrCriteriaItem.md)
 - [FilepoolPolicyFileMatchingPatternOrCriteriaItemAndCriteriaItem](docs/FilepoolPolicyFileMatchingPatternOrCriteriaItemAndCriteriaItem.md)
 - [FilepoolTemplates](docs/FilepoolTemplates.md)
 - [FsaIndex](docs/FsaIndex.md)
 - [FsaResult](docs/FsaResult.md)
 - [FsaResults](docs/FsaResults.md)
 - [FsaSettings](docs/FsaSettings.md)
 - [FsaSettingsSettings](docs/FsaSettingsSettings.md)
 - [FtpSettings](docs/FtpSettings.md)
 - [FtpSettingsExtended](docs/FtpSettingsExtended.md)
 - [FtpSettingsSettings](docs/FtpSettingsSettings.md)
 - [GroupMembers](docs/GroupMembers.md)
 - [GroupnetSubnet](docs/GroupnetSubnet.md)
 - [GroupnetSubnets](docs/GroupnetSubnets.md)
 - [GroupnetsSummary](docs/GroupnetsSummary.md)
 - [GroupnetsSummarySummary](docs/GroupnetsSummarySummary.md)
 - [GroupnetsSummarySummaryListItem](docs/GroupnetsSummarySummaryListItem.md)
 - [HardeningApplyItem](docs/HardeningApplyItem.md)
 - [HardeningResolveItem](docs/HardeningResolveItem.md)
 - [HardeningState](docs/HardeningState.md)
 - [HardeningStateState](docs/HardeningStateState.md)
 - [HardeningStatus](docs/HardeningStatus.md)
 - [HardeningStatusStatus](docs/HardeningStatusStatus.md)
 - [HardwareFcport](docs/HardwareFcport.md)
 - [HardwareFcports](docs/HardwareFcports.md)
 - [HardwareFcportsNode](docs/HardwareFcportsNode.md)
 - [HardwareFcportsNodeFcport](docs/HardwareFcportsNodeFcport.md)
 - [HardwareStartItem](docs/HardwareStartItem.md)
 - [HardwareStatus](docs/HardwareStatus.md)
 - [HardwareStatusStatusItem](docs/HardwareStatusStatusItem.md)
 - [HardwareStopItem](docs/HardwareStopItem.md)
 - [HardwareTapeNameParams](docs/HardwareTapeNameParams.md)
 - [HardwareTapes](docs/HardwareTapes.md)
 - [HardwareTapesDevices](docs/HardwareTapesDevices.md)
 - [HardwareTapesDevicesMediaChanger](docs/HardwareTapesDevicesMediaChanger.md)
 - [HardwareTapesDevicesMediaChangerPath](docs/HardwareTapesDevicesMediaChangerPath.md)
 - [HdfsCryptoEncryptionZone](docs/HdfsCryptoEncryptionZone.md)
 - [HdfsCryptoEncryptionZones](docs/HdfsCryptoEncryptionZones.md)
 - [HdfsCryptoEncryptionZonesEncryptionZone](docs/HdfsCryptoEncryptionZonesEncryptionZone.md)
 - [HdfsCryptoSettings](docs/HdfsCryptoSettings.md)
 - [HdfsCryptoSettingsSettings](docs/HdfsCryptoSettingsSettings.md)
 - [HdfsFsimageJob](docs/HdfsFsimageJob.md)
 - [HdfsFsimageJobJob](docs/HdfsFsimageJobJob.md)
 - [HdfsFsimageJobSettings](docs/HdfsFsimageJobSettings.md)
 - [HdfsFsimageJobSettingsSettings](docs/HdfsFsimageJobSettingsSettings.md)
 - [HdfsFsimageLatest](docs/HdfsFsimageLatest.md)
 - [HdfsFsimageLatestLatest](docs/HdfsFsimageLatestLatest.md)
 - [HdfsFsimageSettings](docs/HdfsFsimageSettings.md)
 - [HdfsFsimageSettingsSettings](docs/HdfsFsimageSettingsSettings.md)
 - [HdfsInotifySettings](docs/HdfsInotifySettings.md)
 - [HdfsInotifySettingsSettings](docs/HdfsInotifySettingsSettings.md)
 - [HdfsInotifyStream](docs/HdfsInotifyStream.md)
 - [HdfsInotifyStreamStream](docs/HdfsInotifyStreamStream.md)
 - [HdfsLogLevel](docs/HdfsLogLevel.md)
 - [HdfsProxyuser](docs/HdfsProxyuser.md)
 - [HdfsProxyuserCreateParams](docs/HdfsProxyuserCreateParams.md)
 - [HdfsProxyusers](docs/HdfsProxyusers.md)
 - [HdfsRack](docs/HdfsRack.md)
 - [HdfsRacks](docs/HdfsRacks.md)
 - [HdfsRangerPluginSettings](docs/HdfsRangerPluginSettings.md)
 - [HdfsRangerPluginSettingsSettings](docs/HdfsRangerPluginSettingsSettings.md)
 - [HdfsSettings](docs/HdfsSettings.md)
 - [HdfsSettingsSettings](docs/HdfsSettingsSettings.md)
 - [HealthcheckChecklist](docs/HealthcheckChecklist.md)
 - [HealthcheckChecklistItem](docs/HealthcheckChecklistItem.md)
 - [HealthcheckChecklistItemThresholds](docs/HealthcheckChecklistItemThresholds.md)
 - [HealthcheckChecklists](docs/HealthcheckChecklists.md)
 - [HealthcheckEvaluation](docs/HealthcheckEvaluation.md)
 - [HealthcheckEvaluationCreateParams](docs/HealthcheckEvaluationCreateParams.md)
 - [HealthcheckEvaluationDetail](docs/HealthcheckEvaluationDetail.md)
 - [HealthcheckEvaluationExtended](docs/HealthcheckEvaluationExtended.md)
 - [HealthcheckEvaluationOverride](docs/HealthcheckEvaluationOverride.md)
 - [HealthcheckEvaluations](docs/HealthcheckEvaluations.md)
 - [HealthcheckItem](docs/HealthcheckItem.md)
 - [HealthcheckItemParameter](docs/HealthcheckItemParameter.md)
 - [HealthcheckItems](docs/HealthcheckItems.md)
 - [HealthcheckParameter](docs/HealthcheckParameter.md)
 - [HealthcheckParameterExtended](docs/HealthcheckParameterExtended.md)
 - [HealthcheckParameters](docs/HealthcheckParameters.md)
 - [HealthcheckParametersExtended](docs/HealthcheckParametersExtended.md)
 - [HistogramStatBy](docs/HistogramStatBy.md)
 - [HistogramStatByBreakout](docs/HistogramStatByBreakout.md)
 - [HistoryFile](docs/HistoryFile.md)
 - [HistoryFileStatistic](docs/HistoryFileStatistic.md)
 - [HttpSettings](docs/HttpSettings.md)
 - [HttpSettingsSettings](docs/HttpSettingsSettings.md)
 - [IdResolutionDomains](docs/IdResolutionDomains.md)
 - [IdResolutionDomainsError](docs/IdResolutionDomainsError.md)
 - [IdResolutionDomainsPath](docs/IdResolutionDomainsPath.md)
 - [IdResolutionZone](docs/IdResolutionZone.md)
 - [IdResolutionZones](docs/IdResolutionZones.md)
 - [InlineSettings](docs/InlineSettings.md)
 - [InlineSettingsSettings](docs/InlineSettingsSettings.md)
 - [JobEvent](docs/JobEvent.md)
 - [JobEvents](docs/JobEvents.md)
 - [JobJob](docs/JobJob.md)
 - [JobJobAvscanParams](docs/JobJobAvscanParams.md)
 - [JobJobChangelistcreateParams](docs/JobJobChangelistcreateParams.md)
 - [JobJobCreateParams](docs/JobJobCreateParams.md)
 - [JobJobDomainmarkParams](docs/JobJobDomainmarkParams.md)
 - [JobJobEsrsmftdownloadParams](docs/JobJobEsrsmftdownloadParams.md)
 - [JobJobExtended](docs/JobJobExtended.md)
 - [JobJobFilepolicyParams](docs/JobJobFilepolicyParams.md)
 - [JobJobPrepairParams](docs/JobJobPrepairParams.md)
 - [JobJobSmartpoolstreeParams](docs/JobJobSmartpoolstreeParams.md)
 - [JobJobSnaprevertParams](docs/JobJobSnaprevertParams.md)
 - [JobJobSummary](docs/JobJobSummary.md)
 - [JobJobSummarySummary](docs/JobJobSummarySummary.md)
 - [JobJobTreedeleteParams](docs/JobJobTreedeleteParams.md)
 - [JobJobs](docs/JobJobs.md)
 - [JobPolicies](docs/JobPolicies.md)
 - [JobPolicy](docs/JobPolicy.md)
 - [JobPolicyInterval](docs/JobPolicyInterval.md)
 - [JobRecent](docs/JobRecent.md)
 - [JobRecentRecentJob](docs/JobRecentRecentJob.md)
 - [JobReport](docs/JobReport.md)
 - [JobReports](docs/JobReports.md)
 - [JobStatistics](docs/JobStatistics.md)
 - [JobStatisticsJob](docs/JobStatisticsJob.md)
 - [JobStatisticsJobNode](docs/JobStatisticsJobNode.md)
 - [JobStatisticsJobNodeCpu](docs/JobStatisticsJobNodeCpu.md)
 - [JobStatisticsJobNodeIo](docs/JobStatisticsJobNodeIo.md)
 - [JobStatisticsJobNodeIoRead](docs/JobStatisticsJobNodeIoRead.md)
 - [JobStatisticsJobNodeIoWrite](docs/JobStatisticsJobNodeIoWrite.md)
 - [JobStatisticsJobNodeMemory](docs/JobStatisticsJobNodeMemory.md)
 - [JobStatisticsJobNodeMemoryPhysical](docs/JobStatisticsJobNodeMemoryPhysical.md)
 - [JobStatisticsJobNodeMemoryVirtual](docs/JobStatisticsJobNodeMemoryVirtual.md)
 - [JobStatisticsJobNodeWorker](docs/JobStatisticsJobNodeWorker.md)
 - [JobType](docs/JobType.md)
 - [JobTypes](docs/JobTypes.md)
 - [LicenseGenerate](docs/LicenseGenerate.md)
 - [LicenseGenerateHardwareItem](docs/LicenseGenerateHardwareItem.md)
 - [LicenseLicense](docs/LicenseLicense.md)
 - [LicenseLicenseCreateParams](docs/LicenseLicenseCreateParams.md)
 - [LicenseLicenseTier](docs/LicenseLicenseTier.md)
 - [LicenseLicenseTierEntitlementsExceededAlert](docs/LicenseLicenseTierEntitlementsExceededAlert.md)
 - [LicenseLicenses](docs/LicenseLicenses.md)
 - [MappingDump](docs/MappingDump.md)
 - [MappingIdentities](docs/MappingIdentities.md)
 - [MappingIdentitiesCreateParams](docs/MappingIdentitiesCreateParams.md)
 - [MappingIdentitiesTarget](docs/MappingIdentitiesTarget.md)
 - [MappingIdentity](docs/MappingIdentity.md)
 - [MappingIdentityTarget](docs/MappingIdentityTarget.md)
 - [MappingUsersLookup](docs/MappingUsersLookup.md)
 - [MappingUsersLookupMappingItem](docs/MappingUsersLookupMappingItem.md)
 - [MappingUsersLookupMappingItemGroup](docs/MappingUsersLookupMappingItemGroup.md)
 - [MappingUsersLookupMappingItemUser](docs/MappingUsersLookupMappingItemUser.md)
 - [MappingUsersRules](docs/MappingUsersRules.md)
 - [MappingUsersRulesExtended](docs/MappingUsersRulesExtended.md)
 - [MappingUsersRulesParameters](docs/MappingUsersRulesParameters.md)
 - [MappingUsersRulesRule](docs/MappingUsersRulesRule.md)
 - [MappingUsersRulesRuleExtended](docs/MappingUsersRulesRuleExtended.md)
 - [MappingUsersRulesRuleOptions](docs/MappingUsersRulesRuleOptions.md)
 - [MappingUsersRulesRuleOptionsExtended](docs/MappingUsersRulesRuleOptionsExtended.md)
 - [MappingUsersRulesRuleUser2](docs/MappingUsersRulesRuleUser2.md)
 - [MappingUsersRulesRules](docs/MappingUsersRulesRules.md)
 - [MappingUsersRulesRulesParameters](docs/MappingUsersRulesRulesParameters.md)
 - [MemberObject](docs/MemberObject.md)
 - [NameLin](docs/NameLin.md)
 - [NameLins](docs/NameLins.md)
 - [NameLinsExtended](docs/NameLinsExtended.md)
 - [NamespaceAccessPoints](docs/NamespaceAccessPoints.md)
 - [NamespaceAccessPointsNamespaces](docs/NamespaceAccessPointsNamespaces.md)
 - [NamespaceAcl](docs/NamespaceAcl.md)
 - [NamespaceMetadata](docs/NamespaceMetadata.md)
 - [NamespaceMetadataAttrs](docs/NamespaceMetadataAttrs.md)
 - [NamespaceMetadataList](docs/NamespaceMetadataList.md)
 - [NamespaceMetadataListAttrs](docs/NamespaceMetadataListAttrs.md)
 - [NamespaceObject](docs/NamespaceObject.md)
 - [NamespaceObjects](docs/NamespaceObjects.md)
 - [NdmpContextsBackup](docs/NdmpContextsBackup.md)
 - [NdmpContextsBackupContext](docs/NdmpContextsBackupContext.md)
 - [NdmpContextsBackupContextExtended](docs/NdmpContextsBackupContextExtended.md)
 - [NdmpContextsBackupContextSession](docs/NdmpContextsBackupContextSession.md)
 - [NdmpContextsBackupExtended](docs/NdmpContextsBackupExtended.md)
 - [NdmpContextsBre](docs/NdmpContextsBre.md)
 - [NdmpContextsBreContext](docs/NdmpContextsBreContext.md)
 - [NdmpContextsBreContextEnvVariable](docs/NdmpContextsBreContextEnvVariable.md)
 - [NdmpContextsBreContextExtended](docs/NdmpContextsBreContextExtended.md)
 - [NdmpContextsBreExtended](docs/NdmpContextsBreExtended.md)
 - [NdmpDiagnostics](docs/NdmpDiagnostics.md)
 - [NdmpDiagnosticsDiagnostics](docs/NdmpDiagnosticsDiagnostics.md)
 - [NdmpDumpdate](docs/NdmpDumpdate.md)
 - [NdmpDumpdates](docs/NdmpDumpdates.md)
 - [NdmpLogs](docs/NdmpLogs.md)
 - [NdmpLogsNode](docs/NdmpLogsNode.md)
 - [NdmpSession](docs/NdmpSession.md)
 - [NdmpSessions](docs/NdmpSessions.md)
 - [NdmpSessionsExtended](docs/NdmpSessionsExtended.md)
 - [NdmpSessionsNode](docs/NdmpSessionsNode.md)
 - [NdmpSessionsNodeSession](docs/NdmpSessionsNodeSession.md)
 - [NdmpSettingsDmas](docs/NdmpSettingsDmas.md)
 - [NdmpSettingsDmasDmavendor](docs/NdmpSettingsDmasDmavendor.md)
 - [NdmpSettingsGlobal](docs/NdmpSettingsGlobal.md)
 - [NdmpSettingsGlobalGlobal](docs/NdmpSettingsGlobalGlobal.md)
 - [NdmpSettingsPreferredIp](docs/NdmpSettingsPreferredIp.md)
 - [NdmpSettingsPreferredIpDataSubnet](docs/NdmpSettingsPreferredIpDataSubnet.md)
 - [NdmpSettingsPreferredIps](docs/NdmpSettingsPreferredIps.md)
 - [NdmpSettingsPreferredIpsPreference](docs/NdmpSettingsPreferredIpsPreference.md)
 - [NdmpSettingsVariable](docs/NdmpSettingsVariable.md)
 - [NdmpSettingsVariables](docs/NdmpSettingsVariables.md)
 - [NdmpSettingsVariablesVariable](docs/NdmpSettingsVariablesVariable.md)
 - [NdmpSettingsVariablesVariablePathVariable](docs/NdmpSettingsVariablesVariablePathVariable.md)
 - [NdmpUser](docs/NdmpUser.md)
 - [NdmpUserExtended](docs/NdmpUserExtended.md)
 - [NdmpUsers](docs/NdmpUsers.md)
 - [NetworkDnscache](docs/NetworkDnscache.md)
 - [NetworkDnscacheExtended](docs/NetworkDnscacheExtended.md)
 - [NetworkDnscacheSettings](docs/NetworkDnscacheSettings.md)
 - [NetworkExternal](docs/NetworkExternal.md)
 - [NetworkExternalExtended](docs/NetworkExternalExtended.md)
 - [NetworkExternalSettings](docs/NetworkExternalSettings.md)
 - [NetworkGroupnet](docs/NetworkGroupnet.md)
 - [NetworkGroupnets](docs/NetworkGroupnets.md)
 - [NetworkPool](docs/NetworkPool.md)
 - [NetworkPools](docs/NetworkPools.md)
 - [NfsAlias](docs/NfsAlias.md)
 - [NfsAliases](docs/NfsAliases.md)
 - [NfsCheck](docs/NfsCheck.md)
 - [NfsCheckExtended](docs/NfsCheckExtended.md)
 - [NfsExport](docs/NfsExport.md)
 - [NfsExports](docs/NfsExports.md)
 - [NfsExportsSummary](docs/NfsExportsSummary.md)
 - [NfsExportsSummarySummary](docs/NfsExportsSummarySummary.md)
 - [NfsLogLevel](docs/NfsLogLevel.md)
 - [NfsNetgroup](docs/NfsNetgroup.md)
 - [NfsNetgroupSettings](docs/NfsNetgroupSettings.md)
 - [NfsNlmLocks](docs/NfsNlmLocks.md)
 - [NfsNlmLocksLock](docs/NfsNlmLocksLock.md)
 - [NfsNlmSessions](docs/NfsNlmSessions.md)
 - [NfsNlmSessionsExtended](docs/NfsNlmSessionsExtended.md)
 - [NfsNlmSessionsSession](docs/NfsNlmSessionsSession.md)
 - [NfsNlmWaiters](docs/NfsNlmWaiters.md)
 - [NfsSettingsExport](docs/NfsSettingsExport.md)
 - [NfsSettingsExportSettings](docs/NfsSettingsExportSettings.md)
 - [NfsSettingsExportSettingsMapAll](docs/NfsSettingsExportSettingsMapAll.md)
 - [NfsSettingsExportSettingsMapAllSecondaryGroups](docs/NfsSettingsExportSettingsMapAllSecondaryGroups.md)
 - [NfsSettingsGlobal](docs/NfsSettingsGlobal.md)
 - [NfsSettingsGlobalSettings](docs/NfsSettingsGlobalSettings.md)
 - [NfsSettingsZone](docs/NfsSettingsZone.md)
 - [NfsSettingsZoneSettings](docs/NfsSettingsZoneSettings.md)
 - [NodeDriveconfig](docs/NodeDriveconfig.md)
 - [NodeDriveconfigExtended](docs/NodeDriveconfigExtended.md)
 - [NodeDriveconfigNode](docs/NodeDriveconfigNode.md)
 - [NodeDriveconfigNodeAlert](docs/NodeDriveconfigNodeAlert.md)
 - [NodeDriveconfigNodeAllow](docs/NodeDriveconfigNodeAllow.md)
 - [NodeDriveconfigNodeAutomaticReplacementRecognition](docs/NodeDriveconfigNodeAutomaticReplacementRecognition.md)
 - [NodeDriveconfigNodeInstantSecureErase](docs/NodeDriveconfigNodeInstantSecureErase.md)
 - [NodeDriveconfigNodeLog](docs/NodeDriveconfigNodeLog.md)
 - [NodeDriveconfigNodeReboot](docs/NodeDriveconfigNodeReboot.md)
 - [NodeDriveconfigNodeSpinWait](docs/NodeDriveconfigNodeSpinWait.md)
 - [NodeDriveconfigNodeStall](docs/NodeDriveconfigNodeStall.md)
 - [NodeDrives](docs/NodeDrives.md)
 - [NodeDrivesNode](docs/NodeDrivesNode.md)
 - [NodeDrivesNodeDrive](docs/NodeDrivesNodeDrive.md)
 - [NodeDrivesNodeDriveFirmware](docs/NodeDrivesNodeDriveFirmware.md)
 - [NodeDrivesPurposelist](docs/NodeDrivesPurposelist.md)
 - [NodeDrivesPurposelistError](docs/NodeDrivesPurposelistError.md)
 - [NodeDrivesPurposelistNode](docs/NodeDrivesPurposelistNode.md)
 - [NodeDrivesPurposelistNodePurpose](docs/NodeDrivesPurposelistNodePurpose.md)
 - [NodeHardware](docs/NodeHardware.md)
 - [NodeHardwareFast](docs/NodeHardwareFast.md)
 - [NodeHardwareFastNode](docs/NodeHardwareFastNode.md)
 - [NodeHardwareNode](docs/NodeHardwareNode.md)
 - [NodeInternalIpAddress](docs/NodeInternalIpAddress.md)
 - [NodeInternalIpAddressNode](docs/NodeInternalIpAddressNode.md)
 - [NodePartitions](docs/NodePartitions.md)
 - [NodePartitionsNode](docs/NodePartitionsNode.md)
 - [NodePartitionsNodePartition](docs/NodePartitionsNodePartition.md)
 - [NodePartitionsNodePartitionStatfs](docs/NodePartitionsNodePartitionStatfs.md)
 - [NodeSensors](docs/NodeSensors.md)
 - [NodeSensorsNode](docs/NodeSensorsNode.md)
 - [NodeSensorsNodeSensor](docs/NodeSensorsNodeSensor.md)
 - [NodeSensorsNodeSensorValue](docs/NodeSensorsNodeSensorValue.md)
 - [NodeSleds](docs/NodeSleds.md)
 - [NodeSledsNode](docs/NodeSledsNode.md)
 - [NodeSledsNodeSled](docs/NodeSledsNodeSled.md)
 - [NodeState](docs/NodeState.md)
 - [NodeStateNode](docs/NodeStateNode.md)
 - [NodeStateReadonly](docs/NodeStateReadonly.md)
 - [NodeStateReadonlyExtended](docs/NodeStateReadonlyExtended.md)
 - [NodeStateReadonlyNode](docs/NodeStateReadonlyNode.md)
 - [NodeStateServicelight](docs/NodeStateServicelight.md)
 - [NodeStateServicelightExtended](docs/NodeStateServicelightExtended.md)
 - [NodeStateServicelightNode](docs/NodeStateServicelightNode.md)
 - [NodeStateSmartfail](docs/NodeStateSmartfail.md)
 - [NodeStateSmartfailExtended](docs/NodeStateSmartfailExtended.md)
 - [NodeStateSmartfailNode](docs/NodeStateSmartfailNode.md)
 - [NodeStatus](docs/NodeStatus.md)
 - [NodeStatusBatterystatus](docs/NodeStatusBatterystatus.md)
 - [NodeStatusBatterystatusNode](docs/NodeStatusBatterystatusNode.md)
 - [NodeStatusNode](docs/NodeStatusNode.md)
 - [NodeStatusNodeBatterystatus](docs/NodeStatusNodeBatterystatus.md)
 - [NodeStatusNodeCapacityItem](docs/NodeStatusNodeCapacityItem.md)
 - [NodeStatusNodeCpu](docs/NodeStatusNodeCpu.md)
 - [NodeStatusNodeNvram](docs/NodeStatusNodeNvram.md)
 - [NodeStatusNodeNvramBattery](docs/NodeStatusNodeNvramBattery.md)
 - [NodeStatusNodePowersupplies](docs/NodeStatusNodePowersupplies.md)
 - [NodeStatusNodePowersuppliesSupply](docs/NodeStatusNodePowersuppliesSupply.md)
 - [NodesNodeFirmwareStatus](docs/NodesNodeFirmwareStatus.md)
 - [NodesNodeInternalIpAddress](docs/NodesNodeInternalIpAddress.md)
 - [NtpServer](docs/NtpServer.md)
 - [NtpServerCreateParams](docs/NtpServerCreateParams.md)
 - [NtpServerExtended](docs/NtpServerExtended.md)
 - [NtpServers](docs/NtpServers.md)
 - [NtpSettings](docs/NtpSettings.md)
 - [NtpSettingsSettings](docs/NtpSettingsSettings.md)
 - [PerformanceDataset](docs/PerformanceDataset.md)
 - [PerformanceDatasets](docs/PerformanceDatasets.md)
 - [PerformanceDatasetsExtended](docs/PerformanceDatasetsExtended.md)
 - [PerformanceMetric](docs/PerformanceMetric.md)
 - [PerformanceMetrics](docs/PerformanceMetrics.md)
 - [PerformanceMetricsExtended](docs/PerformanceMetricsExtended.md)
 - [PerformanceSettings](docs/PerformanceSettings.md)
 - [PerformanceSettingsExtended](docs/PerformanceSettingsExtended.md)
 - [PerformanceSettingsSettings](docs/PerformanceSettingsSettings.md)
 - [PoolsPoolInterfaces](docs/PoolsPoolInterfaces.md)
 - [PoolsPoolInterfacesInterface](docs/PoolsPoolInterfacesInterface.md)
 - [PoolsPoolInterfacesInterfaceOwner](docs/PoolsPoolInterfacesInterfaceOwner.md)
 - [PoolsPoolRule](docs/PoolsPoolRule.md)
 - [PoolsPoolRuleCreateParams](docs/PoolsPoolRuleCreateParams.md)
 - [PoolsPoolRules](docs/PoolsPoolRules.md)
 - [PoolsPoolRulesRule](docs/PoolsPoolRulesRule.md)
 - [PoolsPoolScResumeNode](docs/PoolsPoolScResumeNode.md)
 - [ProgressGlobal](docs/ProgressGlobal.md)
 - [ProgressGlobalProgress](docs/ProgressGlobalProgress.md)
 - [ProvidersAds](docs/ProvidersAds.md)
 - [ProvidersAdsAdsItem](docs/ProvidersAdsAdsItem.md)
 - [ProvidersAdsAdsItemExtended](docs/ProvidersAdsAdsItemExtended.md)
 - [ProvidersAdsExtended](docs/ProvidersAdsExtended.md)
 - [ProvidersAdsIdParams](docs/ProvidersAdsIdParams.md)
 - [ProvidersAdsItem](docs/ProvidersAdsItem.md)
 - [ProvidersDuo](docs/ProvidersDuo.md)
 - [ProvidersDuoExtended](docs/ProvidersDuoExtended.md)
 - [ProvidersDuoSettings](docs/ProvidersDuoSettings.md)
 - [ProvidersFile](docs/ProvidersFile.md)
 - [ProvidersFileFileItem](docs/ProvidersFileFileItem.md)
 - [ProvidersFileIdParams](docs/ProvidersFileIdParams.md)
 - [ProvidersFileItem](docs/ProvidersFileItem.md)
 - [ProvidersKrb5](docs/ProvidersKrb5.md)
 - [ProvidersKrb5Extended](docs/ProvidersKrb5Extended.md)
 - [ProvidersKrb5IdParams](docs/ProvidersKrb5IdParams.md)
 - [ProvidersKrb5IdParamsKeytabEntry](docs/ProvidersKrb5IdParamsKeytabEntry.md)
 - [ProvidersKrb5Item](docs/ProvidersKrb5Item.md)
 - [ProvidersKrb5Krb5Item](docs/ProvidersKrb5Krb5Item.md)
 - [ProvidersLdap](docs/ProvidersLdap.md)
 - [ProvidersLdapIdParams](docs/ProvidersLdapIdParams.md)
 - [ProvidersLdapItem](docs/ProvidersLdapItem.md)
 - [ProvidersLdapLdapItem](docs/ProvidersLdapLdapItem.md)
 - [ProvidersLocal](docs/ProvidersLocal.md)
 - [ProvidersLocalIdParams](docs/ProvidersLocalIdParams.md)
 - [ProvidersLocalLocalItem](docs/ProvidersLocalLocalItem.md)
 - [ProvidersNis](docs/ProvidersNis.md)
 - [ProvidersNisIdParams](docs/ProvidersNisIdParams.md)
 - [ProvidersNisItem](docs/ProvidersNisItem.md)
 - [ProvidersNisNisItem](docs/ProvidersNisNisItem.md)
 - [ProvidersSummary](docs/ProvidersSummary.md)
 - [ProvidersSummaryProviderInstance](docs/ProvidersSummaryProviderInstance.md)
 - [ProvidersSummaryProviderInstanceConnection](docs/ProvidersSummaryProviderInstanceConnection.md)
 - [ProxyusersNameMembers](docs/ProxyusersNameMembers.md)
 - [QuotaNotification](docs/QuotaNotification.md)
 - [QuotaNotifications](docs/QuotaNotifications.md)
 - [QuotaQuota](docs/QuotaQuota.md)
 - [QuotaQuotaCreateParams](docs/QuotaQuotaCreateParams.md)
 - [QuotaQuotaExtended](docs/QuotaQuotaExtended.md)
 - [QuotaQuotaThresholds](docs/QuotaQuotaThresholds.md)
 - [QuotaQuotaThresholdsExtended](docs/QuotaQuotaThresholdsExtended.md)
 - [QuotaQuotaUsage](docs/QuotaQuotaUsage.md)
 - [QuotaQuotas](docs/QuotaQuotas.md)
 - [QuotaQuotasSummary](docs/QuotaQuotasSummary.md)
 - [QuotaQuotasSummarySummary](docs/QuotaQuotasSummarySummary.md)
 - [QuotaReports](docs/QuotaReports.md)
 - [RemotesupportConnectemc](docs/RemotesupportConnectemc.md)
 - [RemotesupportConnectemcConnectemc](docs/RemotesupportConnectemcConnectemc.md)
 - [ReportAbout](docs/ReportAbout.md)
 - [ReportAboutReport](docs/ReportAboutReport.md)
 - [ReportSubreport](docs/ReportSubreport.md)
 - [ReportSubreports](docs/ReportSubreports.md)
 - [ReportsReportSubreports](docs/ReportsReportSubreports.md)
 - [ReportsReportSubreportsSubreport](docs/ReportsReportSubreportsSubreport.md)
 - [ReportsScans](docs/ReportsScans.md)
 - [ReportsScansReport](docs/ReportsScansReport.md)
 - [ReportsThreats](docs/ReportsThreats.md)
 - [ReportsThreatsReport](docs/ReportsThreatsReport.md)
 - [ResultDirectories](docs/ResultDirectories.md)
 - [ResultDirectoriesTotalUsage](docs/ResultDirectoriesTotalUsage.md)
 - [ResultDirectoriesUsageDataItem](docs/ResultDirectoriesUsageDataItem.md)
 - [ResultHistogram](docs/ResultHistogram.md)
 - [ResultHistogramHistogramItem](docs/ResultHistogramHistogramItem.md)
 - [ResultTopDirs](docs/ResultTopDirs.md)
 - [ResultTopDirsDir](docs/ResultTopDirsDir.md)
 - [ResultTopFiles](docs/ResultTopFiles.md)
 - [ResultTopFilesFile](docs/ResultTopFilesFile.md)
 - [RolePrivileges](docs/RolePrivileges.md)
 - [ServicePolicies](docs/ServicePolicies.md)
 - [ServicePoliciesExtended](docs/ServicePoliciesExtended.md)
 - [ServicePolicy](docs/ServicePolicy.md)
 - [ServicePolicyCreateParams](docs/ServicePolicyCreateParams.md)
 - [ServicePolicyExtended](docs/ServicePolicyExtended.md)
 - [SettingsAccessTime](docs/SettingsAccessTime.md)
 - [SettingsAccessTimeExtended](docs/SettingsAccessTimeExtended.md)
 - [SettingsAccessTimeSettings](docs/SettingsAccessTimeSettings.md)
 - [SettingsAcls](docs/SettingsAcls.md)
 - [SettingsAclsAclPolicySettings](docs/SettingsAclsAclPolicySettings.md)
 - [SettingsAclsExtended](docs/SettingsAclsExtended.md)
 - [SettingsCharacterEncodings](docs/SettingsCharacterEncodings.md)
 - [SettingsCharacterEncodingsExtended](docs/SettingsCharacterEncodingsExtended.md)
 - [SettingsCharacterEncodingsSettings](docs/SettingsCharacterEncodingsSettings.md)
 - [SettingsCompression](docs/SettingsCompression.md)
 - [SettingsCompressionExtended](docs/SettingsCompressionExtended.md)
 - [SettingsCompressionSettings](docs/SettingsCompressionSettings.md)
 - [SettingsGlobal](docs/SettingsGlobal.md)
 - [SettingsGlobalExtended](docs/SettingsGlobalExtended.md)
 - [SettingsGlobalGlobalSettings](docs/SettingsGlobalGlobalSettings.md)
 - [SettingsGlobalSettings](docs/SettingsGlobalSettings.md)
 - [SettingsKrb5Defaults](docs/SettingsKrb5Defaults.md)
 - [SettingsKrb5DefaultsKrb5Settings](docs/SettingsKrb5DefaultsKrb5Settings.md)
 - [SettingsKrb5Domain](docs/SettingsKrb5Domain.md)
 - [SettingsKrb5Domains](docs/SettingsKrb5Domains.md)
 - [SettingsKrb5DomainsDomainItem](docs/SettingsKrb5DomainsDomainItem.md)
 - [SettingsKrb5Realm](docs/SettingsKrb5Realm.md)
 - [SettingsKrb5Realms](docs/SettingsKrb5Realms.md)
 - [SettingsKrb5RealmsRealmItem](docs/SettingsKrb5RealmsRealmItem.md)
 - [SettingsMapping](docs/SettingsMapping.md)
 - [SettingsMappingCreateParams](docs/SettingsMappingCreateParams.md)
 - [SettingsMappingExtended](docs/SettingsMappingExtended.md)
 - [SettingsMappingExtendedExtended](docs/SettingsMappingExtendedExtended.md)
 - [SettingsMappingMappingSettings](docs/SettingsMappingMappingSettings.md)
 - [SettingsMappings](docs/SettingsMappings.md)
 - [SettingsReportingEulaItem](docs/SettingsReportingEulaItem.md)
 - [SettingsReports](docs/SettingsReports.md)
 - [SettingsReportsExtended](docs/SettingsReportsExtended.md)
 - [SettingsReportsSettings](docs/SettingsReportsSettings.md)
 - [SmbLogLevel](docs/SmbLogLevel.md)
 - [SmbLogLevelFilter](docs/SmbLogLevelFilter.md)
 - [SmbLogLevelFilters](docs/SmbLogLevelFilters.md)
 - [SmbLogLevelFiltersFilter](docs/SmbLogLevelFiltersFilter.md)
 - [SmbOpenfile](docs/SmbOpenfile.md)
 - [SmbOpenfiles](docs/SmbOpenfiles.md)
 - [SmbSession](docs/SmbSession.md)
 - [SmbSessions](docs/SmbSessions.md)
 - [SmbSettingsGlobal](docs/SmbSettingsGlobal.md)
 - [SmbSettingsGlobalExtended](docs/SmbSettingsGlobalExtended.md)
 - [SmbSettingsGlobalSettings](docs/SmbSettingsGlobalSettings.md)
 - [SmbSettingsShare](docs/SmbSettingsShare.md)
 - [SmbSettingsShareExtended](docs/SmbSettingsShareExtended.md)
 - [SmbSettingsShareSettings](docs/SmbSettingsShareSettings.md)
 - [SmbSettingsZone](docs/SmbSettingsZone.md)
 - [SmbSettingsZoneSettings](docs/SmbSettingsZoneSettings.md)
 - [SmbShare](docs/SmbShare.md)
 - [SmbShareCreateParams](docs/SmbShareCreateParams.md)
 - [SmbShareExtended](docs/SmbShareExtended.md)
 - [SmbSharePermission](docs/SmbSharePermission.md)
 - [SmbShares](docs/SmbShares.md)
 - [SmbSharesSummary](docs/SmbSharesSummary.md)
 - [SmbSharesSummarySummary](docs/SmbSharesSummarySummary.md)
 - [SnapshotAlias](docs/SnapshotAlias.md)
 - [SnapshotAliasCreateParams](docs/SnapshotAliasCreateParams.md)
 - [SnapshotAliasExtended](docs/SnapshotAliasExtended.md)
 - [SnapshotAliases](docs/SnapshotAliases.md)
 - [SnapshotChangelists](docs/SnapshotChangelists.md)
 - [SnapshotChangelistsExtended](docs/SnapshotChangelistsExtended.md)
 - [SnapshotLock](docs/SnapshotLock.md)
 - [SnapshotLockExtended](docs/SnapshotLockExtended.md)
 - [SnapshotLocks](docs/SnapshotLocks.md)
 - [SnapshotPending](docs/SnapshotPending.md)
 - [SnapshotPendingPendingItem](docs/SnapshotPendingPendingItem.md)
 - [SnapshotRepstates](docs/SnapshotRepstates.md)
 - [SnapshotRepstatesExtended](docs/SnapshotRepstatesExtended.md)
 - [SnapshotSchedule](docs/SnapshotSchedule.md)
 - [SnapshotScheduleExtended](docs/SnapshotScheduleExtended.md)
 - [SnapshotScheduleExtendedExtended](docs/SnapshotScheduleExtendedExtended.md)
 - [SnapshotSchedules](docs/SnapshotSchedules.md)
 - [SnapshotSchedulesExtended](docs/SnapshotSchedulesExtended.md)
 - [SnapshotSettings](docs/SnapshotSettings.md)
 - [SnapshotSettingsExtended](docs/SnapshotSettingsExtended.md)
 - [SnapshotSettingsSettings](docs/SnapshotSettingsSettings.md)
 - [SnapshotSnapshot](docs/SnapshotSnapshot.md)
 - [SnapshotSnapshots](docs/SnapshotSnapshots.md)
 - [SnapshotSnapshotsSummary](docs/SnapshotSnapshotsSummary.md)
 - [SnapshotSnapshotsSummarySummary](docs/SnapshotSnapshotsSummarySummary.md)
 - [SnmpSettings](docs/SnmpSettings.md)
 - [SnmpSettingsExtended](docs/SnmpSettingsExtended.md)
 - [SnmpSettingsSettings](docs/SnmpSettingsSettings.md)
 - [SshSettings](docs/SshSettings.md)
 - [SshSettingsSettings](docs/SshSettingsSettings.md)
 - [StatisticsCurrent](docs/StatisticsCurrent.md)
 - [StatisticsCurrentStat](docs/StatisticsCurrentStat.md)
 - [StatisticsHistory](docs/StatisticsHistory.md)
 - [StatisticsHistoryStat](docs/StatisticsHistoryStat.md)
 - [StatisticsHistoryStatValue](docs/StatisticsHistoryStatValue.md)
 - [StatisticsKey](docs/StatisticsKey.md)
 - [StatisticsKeyPolicy](docs/StatisticsKeyPolicy.md)
 - [StatisticsKeys](docs/StatisticsKeys.md)
 - [StatisticsOperation](docs/StatisticsOperation.md)
 - [StatisticsOperations](docs/StatisticsOperations.md)
 - [StatisticsProtocol](docs/StatisticsProtocol.md)
 - [StatisticsProtocols](docs/StatisticsProtocols.md)
 - [StoragepoolNodepool](docs/StoragepoolNodepool.md)
 - [StoragepoolNodepoolExtended](docs/StoragepoolNodepoolExtended.md)
 - [StoragepoolNodepools](docs/StoragepoolNodepools.md)
 - [StoragepoolSettings](docs/StoragepoolSettings.md)
 - [StoragepoolSettingsExtended](docs/StoragepoolSettingsExtended.md)
 - [StoragepoolSettingsSettings](docs/StoragepoolSettingsSettings.md)
 - [StoragepoolSettingsSettingsSpilloverTarget](docs/StoragepoolSettingsSettingsSpilloverTarget.md)
 - [StoragepoolSettingsSpilloverTarget](docs/StoragepoolSettingsSpilloverTarget.md)
 - [StoragepoolStatus](docs/StoragepoolStatus.md)
 - [StoragepoolStatusUnhealthyItem](docs/StoragepoolStatusUnhealthyItem.md)
 - [StoragepoolStatusUnhealthyItemAffectedItem](docs/StoragepoolStatusUnhealthyItemAffectedItem.md)
 - [StoragepoolStatusUnhealthyItemDiskpool](docs/StoragepoolStatusUnhealthyItemDiskpool.md)
 - [StoragepoolStatusUnprovisionedItem](docs/StoragepoolStatusUnprovisionedItem.md)
 - [StoragepoolStoragepool](docs/StoragepoolStoragepool.md)
 - [StoragepoolStoragepools](docs/StoragepoolStoragepools.md)
 - [StoragepoolSuggestedProtection](docs/StoragepoolSuggestedProtection.md)
 - [StoragepoolTier](docs/StoragepoolTier.md)
 - [StoragepoolTierUsage](docs/StoragepoolTierUsage.md)
 - [StoragepoolTiers](docs/StoragepoolTiers.md)
 - [StoragepoolUnprovisioned](docs/StoragepoolUnprovisioned.md)
 - [StoragepoolUnprovisionedUnprovisioned](docs/StoragepoolUnprovisionedUnprovisioned.md)
 - [SubnetsSubnetPool](docs/SubnetsSubnetPool.md)
 - [SubnetsSubnetPoolCreateParams](docs/SubnetsSubnetPoolCreateParams.md)
 - [SubnetsSubnetPoolIface](docs/SubnetsSubnetPoolIface.md)
 - [SubnetsSubnetPoolRange](docs/SubnetsSubnetPoolRange.md)
 - [SubnetsSubnetPoolStaticRoute](docs/SubnetsSubnetPoolStaticRoute.md)
 - [SubnetsSubnetPools](docs/SubnetsSubnetPools.md)
 - [SubnetsSubnetPoolsPool](docs/SubnetsSubnetPoolsPool.md)
 - [SummaryClient](docs/SummaryClient.md)
 - [SummaryClientClientItem](docs/SummaryClientClientItem.md)
 - [SummaryDrive](docs/SummaryDrive.md)
 - [SummaryDriveDriveItem](docs/SummaryDriveDriveItem.md)
 - [SummaryHeat](docs/SummaryHeat.md)
 - [SummaryHeatHeatItem](docs/SummaryHeatHeatItem.md)
 - [SummaryProtocol](docs/SummaryProtocol.md)
 - [SummaryProtocolProtocolItem](docs/SummaryProtocolProtocolItem.md)
 - [SummaryProtocolStats](docs/SummaryProtocolStats.md)
 - [SummaryProtocolStatsProtocolStats](docs/SummaryProtocolStatsProtocolStats.md)
 - [SummaryProtocolStatsProtocolStatsCpu](docs/SummaryProtocolStatsProtocolStatsCpu.md)
 - [SummaryProtocolStatsProtocolStatsDisk](docs/SummaryProtocolStatsProtocolStatsDisk.md)
 - [SummaryProtocolStatsProtocolStatsNetwork](docs/SummaryProtocolStatsProtocolStatsNetwork.md)
 - [SummaryProtocolStatsProtocolStatsNetworkIn](docs/SummaryProtocolStatsProtocolStatsNetworkIn.md)
 - [SummaryProtocolStatsProtocolStatsNetworkOut](docs/SummaryProtocolStatsProtocolStatsNetworkOut.md)
 - [SummaryProtocolStatsProtocolStatsOnefs](docs/SummaryProtocolStatsProtocolStatsOnefs.md)
 - [SummaryProtocolStatsProtocolStatsProtocol](docs/SummaryProtocolStatsProtocolStatsProtocol.md)
 - [SummaryProtocolStatsProtocolStatsProtocolDataItem](docs/SummaryProtocolStatsProtocolStatsProtocolDataItem.md)
 - [SummarySystem](docs/SummarySystem.md)
 - [SummarySystemSystemItem](docs/SummarySystemSystemItem.md)
 - [SummaryWorkload](docs/SummaryWorkload.md)
 - [SummaryWorkloadWorkloadItem](docs/SummaryWorkloadWorkloadItem.md)
 - [SwiftAccount](docs/SwiftAccount.md)
 - [SwiftAccountExtended](docs/SwiftAccountExtended.md)
 - [SwiftAccounts](docs/SwiftAccounts.md)
 - [SyncJob](docs/SyncJob.md)
 - [SyncJobCreateParams](docs/SyncJobCreateParams.md)
 - [SyncJobExtended](docs/SyncJobExtended.md)
 - [SyncJobPhase](docs/SyncJobPhase.md)
 - [SyncJobPolicy](docs/SyncJobPolicy.md)
 - [SyncJobPolicyFileMatchingPattern](docs/SyncJobPolicyFileMatchingPattern.md)
 - [SyncJobPolicyFileMatchingPatternOrCriteriaItem](docs/SyncJobPolicyFileMatchingPatternOrCriteriaItem.md)
 - [SyncJobPolicyFileMatchingPatternOrCriteriaItemAndCriteriaItem](docs/SyncJobPolicyFileMatchingPatternOrCriteriaItemAndCriteriaItem.md)
 - [SyncJobServiceReportItem](docs/SyncJobServiceReportItem.md)
 - [SyncJobWorker](docs/SyncJobWorker.md)
 - [SyncJobs](docs/SyncJobs.md)
 - [SyncPolicies](docs/SyncPolicies.md)
 - [SyncPoliciesExtended](docs/SyncPoliciesExtended.md)
 - [SyncPolicy](docs/SyncPolicy.md)
 - [SyncPolicyCreateParams](docs/SyncPolicyCreateParams.md)
 - [SyncPolicyExtended](docs/SyncPolicyExtended.md)
 - [SyncPolicySourceNetwork](docs/SyncPolicySourceNetwork.md)
 - [SyncReport](docs/SyncReport.md)
 - [SyncReports](docs/SyncReports.md)
 - [SyncReportsRotate](docs/SyncReportsRotate.md)
 - [SyncRule](docs/SyncRule.md)
 - [SyncRuleExtendedExtended](docs/SyncRuleExtendedExtended.md)
 - [SyncRuleSchedule](docs/SyncRuleSchedule.md)
 - [SyncRules](docs/SyncRules.md)
 - [SyncRulesExtended](docs/SyncRulesExtended.md)
 - [SyncSettings](docs/SyncSettings.md)
 - [SyncSettingsExtended](docs/SyncSettingsExtended.md)
 - [SyncSettingsSettings](docs/SyncSettingsSettings.md)
 - [TargetPolicies](docs/TargetPolicies.md)
 - [TargetPolicy](docs/TargetPolicy.md)
 - [TargetReport](docs/TargetReport.md)
 - [TargetReports](docs/TargetReports.md)
 - [TimezoneRegion](docs/TimezoneRegion.md)
 - [TimezoneRegionTimezone](docs/TimezoneRegionTimezone.md)
 - [TimezoneRegions](docs/TimezoneRegions.md)
 - [TimezoneSettings](docs/TimezoneSettings.md)
 - [UpgradeCluster](docs/UpgradeCluster.md)
 - [UpgradeClusterClusterOverview](docs/UpgradeClusterClusterOverview.md)
 - [UpgradeClusterCommittedFeatures](docs/UpgradeClusterCommittedFeatures.md)
 - [UpgradeClusterCommittedFeaturesGenBit](docs/UpgradeClusterCommittedFeaturesGenBit.md)
 - [UpgradeClusterFirmwareStatus](docs/UpgradeClusterFirmwareStatus.md)
 - [UpgradeClusterFirmwareStatusNode](docs/UpgradeClusterFirmwareStatusNode.md)
 - [UpgradeClusterFirmwareStatusNodeDevice](docs/UpgradeClusterFirmwareStatusNodeDevice.md)
 - [UpgradeClusterFirmwareStatusNodePackageItem](docs/UpgradeClusterFirmwareStatusNodePackageItem.md)
 - [UpgradeClusterUpgradeSettings](docs/UpgradeClusterUpgradeSettings.md)
 - [UserChangePassword](docs/UserChangePassword.md)
 - [UserMemberOf](docs/UserMemberOf.md)
 - [WormCreateParams](docs/WormCreateParams.md)
 - [WormDomain](docs/WormDomain.md)
 - [WormDomainExclusion](docs/WormDomainExclusion.md)
 - [WormDomains](docs/WormDomains.md)
 - [WormProperties](docs/WormProperties.md)
 - [WormSettings](docs/WormSettings.md)
 - [WormSettingsExtended](docs/WormSettingsExtended.md)
 - [WormSettingsSettings](docs/WormSettingsSettings.md)
 - [Zone](docs/Zone.md)
 - [ZoneExtendedExtended](docs/ZoneExtendedExtended.md)
 - [ZoneGroup](docs/ZoneGroup.md)
 - [ZoneGroups](docs/ZoneGroups.md)
 - [ZoneUser](docs/ZoneUser.md)
 - [ZoneUsers](docs/ZoneUsers.md)
 - [Zones](docs/Zones.md)
 - [ZonesExtended](docs/ZonesExtended.md)
 - [ZonesSummary](docs/ZonesSummary.md)
 - [ZonesSummaryExtended](docs/ZonesSummaryExtended.md)
 - [ZonesSummarySummary](docs/ZonesSummarySummary.md)
 - [ZonesSummarySummaryExtended](docs/ZonesSummarySummaryExtended.md)
 - [AntivirusPoliciesExtended](docs/AntivirusPoliciesExtended.md)
 - [AntivirusPolicyCreateParams](docs/AntivirusPolicyCreateParams.md)
 - [AntivirusPolicyExtended](docs/AntivirusPolicyExtended.md)
 - [AntivirusServerCreateParams](docs/AntivirusServerCreateParams.md)
 - [AntivirusServerExtended](docs/AntivirusServerExtended.md)
 - [AntivirusServersExtended](docs/AntivirusServersExtended.md)
 - [AuditTopicExtended](docs/AuditTopicExtended.md)
 - [AuthGroupCreateParams](docs/AuthGroupCreateParams.md)
 - [AuthGroupsExtended](docs/AuthGroupsExtended.md)
 - [AuthRoleCreateParams](docs/AuthRoleCreateParams.md)
 - [AuthRoleExtended](docs/AuthRoleExtended.md)
 - [AuthRolesExtended](docs/AuthRolesExtended.md)
 - [AuthUserCreateParams](docs/AuthUserCreateParams.md)
 - [AuthUsersExtended](docs/AuthUsersExtended.md)
 - [CertificateAuthorityExtended](docs/CertificateAuthorityExtended.md)
 - [CertificateServerExtended](docs/CertificateServerExtended.md)
 - [CloudAccessExtended](docs/CloudAccessExtended.md)
 - [CloudAccountExtended](docs/CloudAccountExtended.md)
 - [CloudAccountsExtended](docs/CloudAccountsExtended.md)
 - [CloudJobsExtended](docs/CloudJobsExtended.md)
 - [CloudPoolCreateParams](docs/CloudPoolCreateParams.md)
 - [CloudPoolExtended](docs/CloudPoolExtended.md)
 - [CloudPoolsExtended](docs/CloudPoolsExtended.md)
 - [CloudProxiesExtended](docs/CloudProxiesExtended.md)
 - [CloudProxyCreateParams](docs/CloudProxyCreateParams.md)
 - [CloudProxyExtended](docs/CloudProxyExtended.md)
 - [ClusterNodeDriveExtended](docs/ClusterNodeDriveExtended.md)
 - [ClusterPatchPatchesExtended](docs/ClusterPatchPatchesExtended.md)
 - [CompatibilitiesClassActiveExtended](docs/CompatibilitiesClassActiveExtended.md)
 - [CompatibilitiesSsdActiveExtended](docs/CompatibilitiesSsdActiveExtended.md)
 - [DatasetFilterCreateParams](docs/DatasetFilterCreateParams.md)
 - [DatasetFilterExtended](docs/DatasetFilterExtended.md)
 - [DatasetWorkloadCreateParams](docs/DatasetWorkloadCreateParams.md)
 - [DatasetWorkloadExtended](docs/DatasetWorkloadExtended.md)
 - [DedupeReportsExtended](docs/DedupeReportsExtended.md)
 - [EventAlertConditionCreateParams](docs/EventAlertConditionCreateParams.md)
 - [EventAlertConditionsExtended](docs/EventAlertConditionsExtended.md)
 - [EventCategoriesExtended](docs/EventCategoriesExtended.md)
 - [EventChannelExtended](docs/EventChannelExtended.md)
 - [EventEventgroupDefinitionsExtended](docs/EventEventgroupDefinitionsExtended.md)
 - [EventEventgroupOccurrencesExtended](docs/EventEventgroupOccurrencesExtended.md)
 - [EventEventlistsExtended](docs/EventEventlistsExtended.md)
 - [FilepoolDefaultPolicyAction](docs/FilepoolDefaultPolicyAction.md)
 - [FilepoolPoliciesExtended](docs/FilepoolPoliciesExtended.md)
 - [FilepoolPolicyActionCreateParams](docs/FilepoolPolicyActionCreateParams.md)
 - [FilepoolTemplatesExtended](docs/FilepoolTemplatesExtended.md)
 - [FsaResultExtended](docs/FsaResultExtended.md)
 - [FsaResultsExtended](docs/FsaResultsExtended.md)
 - [GroupnetSubnetCreateParams](docs/GroupnetSubnetCreateParams.md)
 - [GroupnetSubnetExtended](docs/GroupnetSubnetExtended.md)
 - [GroupnetSubnetsExtended](docs/GroupnetSubnetsExtended.md)
 - [HdfsRackCreateParams](docs/HdfsRackCreateParams.md)
 - [HdfsRackExtended](docs/HdfsRackExtended.md)
 - [HdfsRacksExtended](docs/HdfsRacksExtended.md)
 - [HealthcheckChecklistsExtended](docs/HealthcheckChecklistsExtended.md)
 - [HealthcheckEvaluationsExtended](docs/HealthcheckEvaluationsExtended.md)
 - [HealthcheckItemsExtended](docs/HealthcheckItemsExtended.md)
 - [HealthcheckParameterCreateParams](docs/HealthcheckParameterCreateParams.md)
 - [IdResolutionDomainsExtended](docs/IdResolutionDomainsExtended.md)
 - [IdResolutionZonesExtended](docs/IdResolutionZonesExtended.md)
 - [JobJobsExtended](docs/JobJobsExtended.md)
 - [JobPoliciesExtended](docs/JobPoliciesExtended.md)
 - [JobPolicyCreateParams](docs/JobPolicyCreateParams.md)
 - [JobPolicyExtended](docs/JobPolicyExtended.md)
 - [JobTypeExtended](docs/JobTypeExtended.md)
 - [JobTypesExtended](docs/JobTypesExtended.md)
 - [LicenseLicensesExtended](docs/LicenseLicensesExtended.md)
 - [MappingUsersRulesParametersDefaultUnixUser](docs/MappingUsersRulesParametersDefaultUnixUser.md)
 - [MappingUsersRulesRuleOptionsDefaultUser](docs/MappingUsersRulesRuleOptionsDefaultUser.md)
 - [MappingUsersRulesRuleUser1](docs/MappingUsersRulesRuleUser1.md)
 - [MappingUsersRulesRuleUser2Extended](docs/MappingUsersRulesRuleUser2Extended.md)
 - [NdmpSettingsPreferredIpCreateParams](docs/NdmpSettingsPreferredIpCreateParams.md)
 - [NdmpSettingsPreferredIpsExtended](docs/NdmpSettingsPreferredIpsExtended.md)
 - [NdmpSettingsVariableCreateParams](docs/NdmpSettingsVariableCreateParams.md)
 - [NdmpUserCreateParams](docs/NdmpUserCreateParams.md)
 - [NdmpUsersExtended](docs/NdmpUsersExtended.md)
 - [NetworkGroupnetCreateParams](docs/NetworkGroupnetCreateParams.md)
 - [NetworkGroupnetExtended](docs/NetworkGroupnetExtended.md)
 - [NetworkGroupnetsExtended](docs/NetworkGroupnetsExtended.md)
 - [NfsAliasCreateParams](docs/NfsAliasCreateParams.md)
 - [NfsAliasExtended](docs/NfsAliasExtended.md)
 - [NfsAliasesExtended](docs/NfsAliasesExtended.md)
 - [NfsExportCreateParams](docs/NfsExportCreateParams.md)
 - [NfsExportExtended](docs/NfsExportExtended.md)
 - [NfsExportsExtended](docs/NfsExportsExtended.md)
 - [NodeStateNodeServicelight](docs/NodeStateNodeServicelight.md)
 - [NtpServersExtended](docs/NtpServersExtended.md)
 - [PerformanceDatasetCreateParams](docs/PerformanceDatasetCreateParams.md)
 - [PerformanceDatasetExtended](docs/PerformanceDatasetExtended.md)
 - [PoolsPoolRulesExtended](docs/PoolsPoolRulesExtended.md)
 - [ProvidersKrb5Krb5ItemExtended](docs/ProvidersKrb5Krb5ItemExtended.md)
 - [QuotaNotificationCreateParams](docs/QuotaNotificationCreateParams.md)
 - [QuotaNotificationExtended](docs/QuotaNotificationExtended.md)
 - [QuotaNotificationsExtended](docs/QuotaNotificationsExtended.md)
 - [QuotaQuotasExtended](docs/QuotaQuotasExtended.md)
 - [ReportSubreportsExtended](docs/ReportSubreportsExtended.md)
 - [ReportsReportSubreportsExtended](docs/ReportsReportSubreportsExtended.md)
 - [ReportsScansExtended](docs/ReportsScansExtended.md)
 - [ReportsThreatsExtended](docs/ReportsThreatsExtended.md)
 - [ServicePolicyExtendedExtended](docs/ServicePolicyExtendedExtended.md)
 - [SettingsKrb5DomainCreateParams](docs/SettingsKrb5DomainCreateParams.md)
 - [SettingsKrb5RealmCreateParams](docs/SettingsKrb5RealmCreateParams.md)
 - [SmbSharesExtended](docs/SmbSharesExtended.md)
 - [SnapshotAliasesExtended](docs/SnapshotAliasesExtended.md)
 - [SnapshotLockCreateParams](docs/SnapshotLockCreateParams.md)
 - [SnapshotLocksExtended](docs/SnapshotLocksExtended.md)
 - [SnapshotScheduleCreateParams](docs/SnapshotScheduleCreateParams.md)
 - [SnapshotSnapshotCreateParams](docs/SnapshotSnapshotCreateParams.md)
 - [SnapshotSnapshotExtended](docs/SnapshotSnapshotExtended.md)
 - [SnapshotSnapshotsExtended](docs/SnapshotSnapshotsExtended.md)
 - [StatisticsKeysExtended](docs/StatisticsKeysExtended.md)
 - [StoragepoolNodepoolCreateParams](docs/StoragepoolNodepoolCreateParams.md)
 - [StoragepoolNodepoolsExtended](docs/StoragepoolNodepoolsExtended.md)
 - [StoragepoolTierCreateParams](docs/StoragepoolTierCreateParams.md)
 - [StoragepoolTierExtended](docs/StoragepoolTierExtended.md)
 - [StoragepoolTiersExtended](docs/StoragepoolTiersExtended.md)
 - [SubnetsSubnetPoolsExtended](docs/SubnetsSubnetPoolsExtended.md)
 - [SwiftAccountsExtended](docs/SwiftAccountsExtended.md)
 - [SyncJobsExtended](docs/SyncJobsExtended.md)
 - [SyncPolicyExtendedExtended](docs/SyncPolicyExtendedExtended.md)
 - [SyncReportsExtended](docs/SyncReportsExtended.md)
 - [SyncRuleCreateParams](docs/SyncRuleCreateParams.md)
 - [SyncRuleExtended](docs/SyncRuleExtended.md)
 - [TargetPoliciesExtended](docs/TargetPoliciesExtended.md)
 - [TargetReportsExtended](docs/TargetReportsExtended.md)
 - [WormDomainCreateParams](docs/WormDomainCreateParams.md)
 - [WormDomainExtended](docs/WormDomainExtended.md)
 - [WormDomainsExtended](docs/WormDomainsExtended.md)
 - [ZoneCreateParams](docs/ZoneCreateParams.md)
 - [ZoneExtended](docs/ZoneExtended.md)
 - [ZoneGroupsExtended](docs/ZoneGroupsExtended.md)
 - [ZoneUsersExtended](docs/ZoneUsersExtended.md)
 - [EventChannelCreateParams](docs/EventChannelCreateParams.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author

sdk@isilon.com


## License

Copyright (c) 2018 Dell EMC Isilon

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
