'''
Any prevalent constants in chemistry.
'''

# BASIC

# Gravitational Constant
G = 9.81
# Avogadro's Constant
AVOGADRO = 6.02214e23
# Elementary Charge
COULOMB = 1.60e-19
# Atomic Mass Unit
M = 1.66e-27
# Speed of Light
C = 2.997925e8

# ELECTROCHEMISTRY

# Faraday's Constant
F = 96485.33289

# GASES

# Molar Gas Constant
R = 8.3144598
# Molar Gas Constant for Atmospheres
Ratm = 0.082057
# Boltzmann's Constant
kB = 1.380649e-23

# QUANTUM CHEMISTRY

# Planck Constant
h = 6.62607e-34
# Rydberg Constant
rH = 2.17987e-18

# LIBRARY CONSTANTS

# Molecule VSEPR Structures
STRUCTURES = [
   "linear",
   "bent",
   "trigonal planar",
   "trigonal pyramidal",
   "trigonal bipyramidal",
   "tetrahedral",
   "octahedral",
   "see-saw",
   "t-shaped",
]

# Ignore Parameters
REDOX = "redox"
BASEREDOX = "nredox"

# Units
PRESSURE_UNITS = [
   "torr",
   "atm",
   "mmhg",
   "psi",
   "pa",
   "kpa",
   "bar"
]

TEMP_UNITS = [
   "f",
   "c",
   "k"
]

# Element/Compound Lists.
STRONG_ACIDS = ['HCl', 'HNO3', 'H2SO4', 'HBr', 'HI', 'HClO4', 'HClO3']
STRONG_BASES = ['LiOH', 'NaOH', 'KOH', 'RbOH', 'CsOH', 'Ca(OH)2', 'Sr(OH)2', 'Ba(OH)2']