import { ExtensionStore } from '../stores/ExtensionStore';
import { METADATA_KEY } from '../const';
export class ActiveNotebookListener {
    constructor(options) {
        this.options = options;
        this.setup();
    }
    setup() {
        const { labShell } = this.options;
        ExtensionStore.subscribe(s => s.activeNotebookAttachment, (attachments, state) => {
            this.onNotebookAttachmentChanged(attachments, state);
        });
        labShell.currentChanged.connect(this.onCurrentTabChanged, this);
    }
    onNotebookAttachmentChanged(attachments, state) {
        var _a;
        const { activeNotebookPanel } = state;
        if (!attachments || !activeNotebookPanel) {
            return;
        }
        this.setJupyterNotebookFileRucioMetadata(attachments, state);
        if ((_a = activeNotebookPanel.sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel) {
            activeNotebookPanel.sessionContext.ready.then(() => {
                const { notebookListener } = this.options;
                notebookListener.injectUninjected(activeNotebookPanel);
            });
        }
    }
    setJupyterNotebookFileRucioMetadata(attachments, state) {
        const { metadata } = state.activeNotebookPanel.model;
        const current = metadata.get(METADATA_KEY);
        const rucioDidAttachments = attachments;
        if (current !== rucioDidAttachments) {
            metadata.set(METADATA_KEY, rucioDidAttachments);
        }
    }
    onCurrentTabChanged() {
        if (!this.isCurrentTabANotebook()) {
            this.setActiveNotebook(undefined);
            this.setActiveNotebookAttachments(undefined);
            return;
        }
        const { notebookTracker } = this.options;
        const nbWidget = notebookTracker.currentWidget;
        nbWidget.revealed.then(() => {
            this.setActiveNotebook(nbWidget);
            const rucioDidAttachments = nbWidget.model.metadata.get(METADATA_KEY);
            if (!rucioDidAttachments) {
                this.setActiveNotebookAttachments([]);
                return;
            }
            const attachedDIDs = rucioDidAttachments;
            this.setActiveNotebookAttachments(attachedDIDs);
        });
    }
    isCurrentTabANotebook() {
        const { labShell, notebookTracker } = this.options;
        const widget = labShell.currentWidget;
        const nbWidget = notebookTracker.currentWidget;
        return !!widget && widget === nbWidget;
    }
    setActiveNotebook(activeNotebook) {
        ExtensionStore.update(s => {
            s.activeNotebookPanel = activeNotebook;
        });
    }
    setActiveNotebookAttachments(attachments) {
        ExtensionStore.update(s => {
            s.activeNotebookAttachment = attachments;
        });
    }
}
