import React from 'react';
import { createUseStyles } from 'react-jss';
import { useStoreState } from 'pullstate';
import { ExtensionStore } from '../stores/ExtensionStore';
import { NotebookAttachmentListItem } from '../components/@Notebook/NotebookAttachmentListItem';
import { HorizontalHeading } from '../components/HorizontalHeading';
import { useNotebookResolveStatusStore } from '../utils/NotebookListener';
const useStyles = createUseStyles({
    container: {
        padding: '16px 0 16px 0'
    },
    messageContainer: {
        padding: '16px'
    }
});
export const Notebook = () => {
    const classes = useStyles();
    const activeNotebookPanel = useStoreState(ExtensionStore, s => s.activeNotebookPanel);
    const activeNotebookAttachments = useStoreState(ExtensionStore, s => s.activeNotebookAttachment);
    const notebookStatusStore = useNotebookResolveStatusStore();
    const notebookStatus = notebookStatusStore[activeNotebookPanel === null || activeNotebookPanel === void 0 ? void 0 : activeNotebookPanel.id];
    return (React.createElement(React.Fragment, null,
        !!activeNotebookPanel && !!activeNotebookAttachments && activeNotebookAttachments.length > 0 && (React.createElement("div", { className: classes.container }, activeNotebookAttachments.length > 0 && (React.createElement(React.Fragment, null,
            React.createElement(HorizontalHeading, { title: "Attached DIDs" }),
            activeNotebookAttachments.map(attachment => (React.createElement(NotebookAttachmentListItem, { key: attachment.did, attachment: attachment, status: notebookStatus ? notebookStatus[attachment.did] : null }))))))),
        !!activeNotebookPanel && !!activeNotebookAttachments && activeNotebookAttachments.length === 0 && (React.createElement("div", { className: classes.messageContainer }, "You have not attached any DID. Use the Explore menu to add a DID to this notebook.")),
        !activeNotebookPanel && React.createElement("div", { className: classes.messageContainer }, "Please open a Notebook.")));
};
