import { Store } from 'pullstate';
import { Instance, FileDIDDetails, RucioAuthCredentials, RucioAuthType } from '../types';
export interface UIState {
    activeInstance?: Instance;
    activeAuthType?: RucioAuthType;
    instances?: Instance[];
    authConfig?: {
        [instance: string]: RucioAuthCredentials;
    };
    fileDetails: {
        [did: string]: FileDIDDetails;
    };
    collectionDetails: {
        [did: string]: FileDIDDetails[];
    };
}
export declare const initialState: UIState;
export declare const UIStore: Store<UIState>;
export declare const resetRucioCaches: () => void;
