var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { createUseStyles } from 'react-jss';
const useStyles = createUseStyles({
    button: {
        background: 'none',
        padding: 0,
        border: '1px solid',
        borderColor: (props) => `${props.outlineColor || 'var(--jp-border-color1)'}`,
        color: (props) => props.color || 'var(--jp-ui-font-color1)',
        outline: 'none',
        cursor: 'pointer',
        borderRadius: '2px',
        '&:hover': {
            backgroundColor: (props) => `${props.outlineColor || 'var(--jp-layout-color2)'}`,
            borderColor: (props) => `${props.outlineColor || 'var(--jp-border-color1)'}`
        },
        '&:active': {
            backgroundColor: (props) => `${props.outlineColor || 'var(--jp-layout-color2)'}`
        },
        '&:disabled': {
            opacity: 0.5,
            cursor: 'inherit',
            '&:hover': {
                background: 'none',
                borderColor: (props) => `${props.outlineColor || 'var(--jp-border-color1)'}`
            },
            '&:active': {
                background: 'none'
            }
        }
    },
    block: {
        width: '100%',
        display: 'block'
    },
    childrenContainer: {
        margin: '8px 16px 8px 16px'
    }
});
export const Button = (_a) => {
    var { children, block, onClick, className } = _a, props = __rest(_a, ["children", "block", "onClick", "className"]);
    const classes = useStyles(props);
    const btnClasses = [classes.button, className];
    if (block) {
        btnClasses.push(classes.block);
    }
    return (React.createElement("button", Object.assign({ className: btnClasses.join(' '), onClick: onClick }, props),
        React.createElement("div", { className: classes.childrenContainer }, children)));
};
