import React from 'react';
import { VDomRenderer } from '@jupyterlab/apputils';
import { JupyterFrontEnd, ILabShell } from '@jupyterlab/application';
import { INotebookTracker } from '@jupyterlab/notebook';
import { NotebookListener } from './utils/NotebookListener';
import { ActiveNotebookListener } from './utils/ActiveNotebookListener';
import { InstanceConfig } from './types';
import { NotebookPollingListener } from './utils/NotebookPollingListener';
export interface SidebarPanelOptions {
    app: JupyterFrontEnd;
    labShell: ILabShell;
    notebookTracker: INotebookTracker;
    instanceConfig: InstanceConfig;
}
export declare class SidebarPanel extends VDomRenderer {
    error?: string;
    app: JupyterFrontEnd;
    notebookListener: NotebookListener;
    activeNotebookListener: ActiveNotebookListener;
    notebookPollingListener: NotebookPollingListener;
    instanceConfig: InstanceConfig;
    constructor(options?: SidebarPanelOptions, error?: string);
    render(): React.ReactElement;
}
