# Generated by Django 2.2.24 on 2021-07-07 17:46

from collections import defaultdict
from django.db import migrations


def create_repository_content_for_deprecation(apps, schema_editor):
    """ Create RepositoryContent for AnsibleCollectionDeprecated."""
    AnsibleCollectionDeprecated = apps.get_model('ansible', 'AnsibleCollectionDeprecated')
    RepositoryContent = apps.get_model('core', 'RepositoryContent')
    RepositoryVersionContentDetails = apps.get_model('core', 'RepositoryVersionContentDetails')
    db_alias = schema_editor.connection.alias
    repo_content = []
    counts_list = []
    count = defaultdict(int)

    for deprecation in AnsibleCollectionDeprecated.objects.using(db_alias).all():
        repo_content.append(RepositoryContent(
                content=deprecation,
                repository_id=deprecation.repository_id,
                version_added_id=deprecation.version_added_id,
            ))
        count[deprecation.version_added_id] += 1

    for repo_version_id, total in count.items():
        count_obj = RepositoryVersionContentDetails(
            content_type=deprecation.pulp_type,
            repository_version_id=repo_version_id,
            count=total,
            count_type="A", # Added
        )
        counts_list.append(count_obj)

        count_obj = RepositoryVersionContentDetails(
            content_type=deprecation.pulp_type,
            repository_version_id=repo_version_id,
            count=total,
            count_type="P", # Present
        )
        counts_list.append(count_obj)

    RepositoryContent.objects.using(db_alias).bulk_create(repo_content)
    RepositoryVersionContentDetails.objects.using(db_alias).bulk_create(counts_list)
    AnsibleCollectionDeprecated.objects.using(db_alias).filter(version_memberships__isnull=True).delete()


def create_deprecation_from_repository_content(apps, schema_editor):
    """ Create AnsibleCollectionDeprecated from RepositoryContent."""
    AnsibleCollectionDeprecated = apps.get_model('ansible', 'AnsibleCollectionDeprecated')
    Collection = apps.get_model('ansible', 'Collection')
    for deprecation in AnsibleCollectionDeprecated.objects.all():
        col = Collection.objects.get(namespace=deprecation.namespace, name=deprecation.name)
        for repo_content in deprecation.version_memberships.all():
            deprecation.collection_id = col.pk
            deprecation.repository_id = repo_content.repository_id
            deprecation.version_added_id = repo_content.version_added_id
            deprecation.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0068_add_timestamp_of_interest'),
        ('ansible', '0035_deprecation_content'),
    ]

    operations = [
        migrations.RunPython(
            code=create_repository_content_for_deprecation,
            reverse_code=create_deprecation_from_repository_content,
            atomic=True,
        ),
        migrations.AlterUniqueTogether(
            name='ansiblecollectiondeprecated',
            unique_together={('namespace', 'name')},
        ),
        migrations.RemoveField(model_name="ansiblecollectiondeprecated", name="collection_id"),
        migrations.RemoveField(model_name="ansiblecollectiondeprecated", name="repository_id"),
        migrations.RemoveField(model_name="ansiblecollectiondeprecated", name="version_added_id"),
    ]
