# auto generated by update_py.py

import json

import tlclient.trader.message_trade as message_trade

from tlclient.linker.constant import FistType
from tlclient.linker.utility import bytify
from tlclient.trader.constant import ExchangeID, MsgType, OffsetFlag, OrderType
from tlclient.trader.gateway import Gateway
from tlclient.linker.trader.message_pb2 import message_pb2

class TradeGateway(Gateway):

    def __init__(self, acc_name, gateway_name, env_name, addr):
        Gateway.__init__(self, acc_name, gateway_name, env_name, addr, FistType.TRADE_GATEWAY)
        self._req_positions = {}

    # --------- overrides ---------
    #
    def on_req_plain_order_insert(self, obj, frame_nano):
        pass

    def on_req_order_cancel(self, obj, frame_nano):
        pass

    def on_req_position(self, obj, req_id, frame_nano):
        pass

    def on_req_account(self, obj, req_id, frame_nano):
        pass

    def on_req_active_orders(self, obj, req_id, frame_nano):
        pass

    def on_req_cancel_active_orders(self, obj, req_id, frame_nano):
        pass

    def on_req_history_trades(self, obj, req_id, frame_nano):
        pass

    # --------- internals ---------
    #
    def _on_req_plain_order_insert(self, obj, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_plain_order_insert(obj, frame_nano)

    def _on_req_order_cancel(self, obj, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_order_cancel(obj, frame_nano)

    def _on_req_position(self, obj, req_id, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_position(obj, req_id, frame_nano)

    def _on_req_account(self, obj, req_id, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_account(obj, req_id, frame_nano)

    def _on_req_active_orders(self, obj, req_id, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_active_orders(obj, req_id, frame_nano)

    def _on_req_cancel_active_orders(self, obj, req_id, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_cancel_active_orders(obj, req_id, frame_nano)

    def _on_req_history_trades(self, obj, req_id, frame_nano):
        if obj.tg_name.decode() == self.fist_name:
            self.on_req_history_trades(obj, req_id, frame_nano)

    def on_pub_frame(self, f):
        msg_type = f.get_msg_type()
        frame_nano = f.get_nano()
        if msg_type == MsgType.REQ_ORDER_INSERT:
            obj = f.get_obj(message_pb2.ReqOrderInsert)
            self._on_req_plain_order_insert(obj, frame_nano)
        elif msg_type == MsgType.REQ_ORDER_CANCEL:
            obj = f.get_obj(message_pb2.ReqOrderCancel)
            self._on_req_order_cancel(obj, frame_nano)
        elif msg_type == MsgType.REQ_POSITION:
            obj = f.get_obj(message_pb2.ReqPosition)
            self._on_req_position(obj, f.get_req_id(), frame_nano)
        elif msg_type == MsgType.REQ_ACCOUNT:
            obj = f.get_obj(message_pb2.ReqAccount)
            self._on_req_account(obj, f.get_req_id(), frame_nano)
        elif msg_type == MsgType.REQ_ACTIVE_ORDERS:
            obj = f.get_obj(message_pb2.ReqActiveOrders)
            self._on_req_active_orders(obj, f.get_req_id(), frame_nano)
        elif msg_type == MsgType.REQ_CANCEL_ACTIVE_ORDERS:
            obj = f.get_obj(message_pb2.ReqCancelActiveOrders)
            self._on_req_cancel_active_orders(obj, f.get_req_id(), frame_nano)
        elif msg_type == MsgType.REQ_HISTORY_TRADES:
            obj = f.get_obj(message_pb2.ReqHistoryTrades)
            self._on_req_history_trades(obj, f.get_req_id(), frame_nano)

    # --------- utilities for gateway ---------
    #
    def push_err_order_insert(self, order_id, order_ref, err_id, err_msg):
        rsp = message_pb2.RspOrderInsert()
        rsp.order_id = order_id
        rsp.order_ref = order_ref
        rsp.err_id = err_id
        rsp.err_msg = err_msg
        self.push_rsp_order_insert(rsp)

    def push_rsp_order_insert(self, obj):
        self.safe_push(obj, message_pb2.MsgType.MSG_TYPE_RSP_ORDER_INSERT, obj.order_id)

    def push_rsp_order_cancel(self, obj):
        self.safe_push(obj, message_pb2.MsgType.MSG_TYPE_RSP_ORDER_CANCEL, obj.req_id)

    def push_rtn_order(self, obj):
        obj.order_type = message_pb2.OrderType.ORDER_TYPE_PLAIN_ORDER
        self.safe_push(obj, message_pb2.MsgType.MSG_TYPE_RTN_ORDER, obj.order_id)

    def push_rtn_trade(self, obj):
        obj.order_type = message_pb2.OrderType.ORDER_TYPE_PLAIN_ORDER
        self.safe_push(obj, message_pb2.MsgType.MSG_TYPE_RTN_TRADE, obj.order_id)

    def push_position(self, pos_obj, req_id):
        pos_obj.pos_id = req_id
        self.safe_push(pos_obj, message_pb2.MsgType.MSG_TYPE_RSP_POSITION, req_id)

    def push_pos_info(self, pos_info_obj, req_id, is_last):
        if not self._req_positions.has_key(req_id):
            self._req_positions[req_id] = message_pb2.GatewayPosition(account_id=self.fist_name)
        self._req_positions[req_id].positions.append(pos_info_obj)
        if is_last:
            self.push_position(self._req_positions[req_id], req_id)
            self._req_positions.pop(req_id)
        pass

    def push_account(self, acc_obj, req_id):
        self.safe_push(acc_obj, message_pb2.MsgType.MSG_TYPE_RSP_ACCOUNT, req_id)

    def push_active_orders(self, odrs_obj, req_id):
        self.safe_push(odrs_obj, message_pb2.MsgType.MSG_TYPE_RSP_ACTIVE_ORDERS, req_id=req_id)

    def push_active_order(self, odr_obj, req_id, is_last):
        # todo
        pass

    def push_cancel_active_ordres(self, obj, req_id):
        self.safe_push(obj, message_pb2.MsgType.MSG_TYPE_RSP_CANCEL_ACTIVE_ORDERS, req_id=req_id)

    def push_history_trades(self, obj, req_id):
        self.safe_push(obj, message_pb2.MsgType.MSG_TYPE_RSP_HISTORY_TRADES, req_id=req_id)

    def save_order(self, obj):
        # todo
        pass

    def has_order(self, order_id):
        # todo
        pass

    def get_order(self, order_id):
        # todo
        pass
