// <auto-generated />
namespace Microsoft.AspNetCore.Identity
{
    using System.Globalization;
    using System.Reflection;
    using System.Resources;

    internal static class Resources
    {
        private static readonly ResourceManager _resourceManager
            = new ResourceManager("Microsoft.AspNetCore.Identity.Resources", typeof(Resources).GetTypeInfo().Assembly);

        /// <summary>
        /// Type {0} must derive from {1}&lt;{2}&gt;.
        /// </summary>
        internal static string InvalidManagerType
        {
            get => GetString("InvalidManagerType");
        }

        /// <summary>
        /// Type {0} must derive from {1}&lt;{2}&gt;.
        /// </summary>
        internal static string FormatInvalidManagerType(object p0, object p1, object p2)
            => string.Format(CultureInfo.CurrentCulture, GetString("InvalidManagerType"), p0, p1, p2);

        /// <summary>
        /// The provided PasswordHasherCompatibilityMode is invalid.
        /// </summary>
        internal static string InvalidPasswordHasherCompatibilityMode
        {
            get => GetString("InvalidPasswordHasherCompatibilityMode");
        }

        /// <summary>
        /// The provided PasswordHasherCompatibilityMode is invalid.
        /// </summary>
        internal static string FormatInvalidPasswordHasherCompatibilityMode()
            => GetString("InvalidPasswordHasherCompatibilityMode");

        /// <summary>
        /// The iteration count must be a positive integer.
        /// </summary>
        internal static string InvalidPasswordHasherIterationCount
        {
            get => GetString("InvalidPasswordHasherIterationCount");
        }

        /// <summary>
        /// The iteration count must be a positive integer.
        /// </summary>
        internal static string FormatInvalidPasswordHasherIterationCount()
            => GetString("InvalidPasswordHasherIterationCount");

        private static string GetString(string name, params string[] formatterNames)
        {
            var value = _resourceManager.GetString(name);

            System.Diagnostics.Debug.Assert(value != null);

            if (formatterNames != null)
            {
                for (var i = 0; i < formatterNames.Length; i++)
                {
                    value = value.Replace("{" + formatterNames[i] + "}", "{" + i + "}");
                }
            }

            return value;
        }
    }
}
