# Copyright 2021 VMware, Inc.
# SPDX-License-Identifier: Apache-2.0
import pathlib

import setuptools

"""
Builds a package with the help of setuptools in order for this package to be imported in other projects

"plugin-package-template" is the name of the package which contains the plugin/s.

"vdk-lineage" is the name of the plugin contained within this package. Note that you can include
more than one plugin in a single package. Also note that the contained plugin may have the same name as the package.

"plugin_template" is the Python file which contains the plugin hooks for the corresponding plugin.
"""

__version__ = "0.1.3"

setuptools.setup(
    name="vdk-lineage",
    version=__version__,
    url="https://github.com/vmware/versatile-data-kit",
    description="Plugin template project used to quick start development of a new Versatile Data Kit SDK plugin.",
    long_description=pathlib.Path("README.md").read_text(),
    long_description_content_type="text/markdown",
    install_requires=["vdk-core", "sqlparse", "sqllineage",
                      "openlineage-integration-common", "openlineage-python"],
    package_dir={"": "src"},
    packages=setuptools.find_namespace_packages(where="src"),
    entry_points={
        "vdk.plugin.run": [
            "vdk-lineage = vdk.plugin.lineage.plugin_lineage"
        ]
    },
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "License :: OSI Approved :: Apache Software License",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
)
