# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flask_session']

package_data = \
{'': ['*']}

install_requires = \
['Flask>=2.2.2,<3.0.0', 'cachelib>=0.9.0,<0.10.0']

setup_kwargs = {
    'name': 'flask-session2',
    'version': '1.0.0',
    'description': 'Adds server-side session support to your Flask application',
    'long_description': '<h1 align="center">\n  <br>\n  <img src="https://github.com/christopherpickering/flask-session2/raw/master/resources/flask-session.png" alt="logo" width="370" />\n  <br>\n</h1>\n\n<h4 align="center">Adds support for Server-side Session to your Flask application.</h4>\n\n\nWelcome to Flask-Session\'s documentation.  Flask-Session is an extension for [Flask](https://flask.palletsprojects.com) that adds support for Server-side `Session` to your application.\n\n\n## Installation\n\nInstall the extension with the following command::\n\n```bash\npip install Flask-Session2\n```\n\n## Quickstart\n\nFlask-Session is really easy to use.\n\nBasically for the common use of having one Flask application all you have to do is to create your Flask application, load the configuration of choice and\nthen create the :class:`Session` object by passing it the application.\n\nThe `Session` instance is not used for direct access, you should always use `flask.session`:\n\n```py\nfrom flask import Flask, session\nfrom flask_session import Session\n\napp = Flask(__name__)\n# Check Configuration section for more details\nSESSION_TYPE = \'redis\'\napp.config.from_object(__name__)\nSession(app)\n\n@app.route(\'/set/\')\ndef set():\n    session[\'key\'] = \'value\'\n    return \'ok\'\n\n@app.route(\'/get/\')\ndef get():\n    return session.get(\'key\', \'not set\')\n```\n\nYou may also set up your application later using `Session.init_app` method:\n\n```py\nsess = Session()\nsess.init_app(app)\n```\n\n## Configuration\n\nThe following configuration values exist for Flask-Session.  Flask-Session loads these values from your Flask application config, so you should configure\nyour app first before you pass it to Flask-Session.  Note that these values cannot be modified after the ``init_app`` was applyed so make sure to not modify them at runtime.\n\nWe are not supplying something like ``SESSION_REDIS_HOST`` and ``SESSION_REDIS_PORT``, if you want to use the ``RedisSessionInterface``, you should configure ``SESSION_REDIS`` to your own ``redis.Redis`` instance. This gives you more flexibility, like maybe you want to use the same ``redis.Redis`` instance for cache purpose too, then you do not need to keep two ``redis.Redis`` instance in the same process.\n\nThe following configuration values are builtin configuration values within Flask itself that are related to session.  **They are all understood by\nFlask-Session, for example, you should use PERMANENT_SESSION_LIFETIME to control your session lifetime.**\n\n| Name | Description |\n|--|--|\n|`SESSION_COOKIE_NAME`          | the name of the session cookie         |\n|`SESSION_COOKIE_DOMAIN`        | the domain for the session cookie.  If this is not set, the cookie will be valid for all subdomains of `SERVER_NAME`. |\n|`SESSION_COOKIE_PATH`          | the path for the session cookie.  If this is not set the cookie will be valid for all of `APPLICATION_ROOT` or if that is not set for `\'/\'`. |\n|`SESSION_COOKIE_HTTPONLY`      | controls if the cookie should be set with the httponly flag.  Defaults to `True`. |\n|`SESSION_COOKIE_SECURE`        | controls if the cookie should be set with the secure flag.  Defaults to `False`. |\n|`PERMANENT_SESSION_LIFETIME`   | the lifetime of a permanent session as :class:`datetime.timedelta` object. Starting with Flask 0.8 this can also be an integer representing seconds. |\n\n\nA list of configuration keys also understood by the extension:\n\n| Name | Description |\n|--|--|\n| `SESSION_TYPE`            |  Specifies which type of session interface to use.  Built-in session types:<br>- **null**: NullSessionInterface (default) <br> - **redis**: RedisSessionInterface <br> - **memcached**: MemcachedSessionInterface <br> - **filesystem**: FileSystemSessionInterface <br> - **mongodb**: MongoDBSessionInterface <br> - **sqlalchemy**: SqlAlchemySessionInterface |\n| `SESSION_PERMANENT`       |  Whether use permanent session or not, default to be `True` |\n| `SESSION_USE_SIGNER`      |  Whether sign the session cookie sid or not, if set to `True`, you have to set :attr:`flask.Flask.secret_key`, default to be `False` |\n| `SESSION_KEY_PREFIX`      |  A prefix that is added before all session keys. This makes it possible to use the same backend storage server for different apps, default "session:" |\n| `SESSION_REDIS`           |  A `redis.Redis` instance, default connect to `127.0.0.1:6379` |\n| `SESSION_MEMCACHED`       |  A `memcache.Client` instance, default connect to `127.0.0.1:11211` |\n| `SESSION_FILE_DIR`        |  The directory where session files are stored. Default to use `flask_session` directory under current working directory. |\n| `SESSION_FILE_THRESHOLD`  |  The maximum number of items the session stores before it starts deleting some, default 500 |\n| `SESSION_FILE_MODE`       |  The file mode wanted for the session files, default 0600 |\n| `SESSION_MONGODB`         |  A `pymongo.MongoClient` instance, default connect to `127.0.0.1:27017` |\n| `SESSION_MONGODB_DB`      |  The MongoDB database you want to use, default "flask_session" |\n| `SESSION_MONGODB_COLLECT` |  The MongoDB collection you want to use, default "sessions" |\n| `SESSION_SQLALCHEMY`      |  A `flask_sqlalchemy.SQLAlchemy` instance whose database connection URI is configured using the `SQLALCHEMY_DATABASE_URI` parameter |\n| `SESSION_SQLALCHEMY_TABLE`|  The name of the SQL table you want to use, default "sessions" |\n\n\nBasically you only need to configure `SESSION_TYPE`.\n\n    By default, all non-null sessions in Flask-Session are permanent.\n\n\n## Built-in Session Interfaces\n\n### `NullSessionInterface`\n\nIf you do not configure a different ``SESSION_TYPE``, this will be used to\ngenerate nicer error messages.  Will allow read-only access to the empty\nsession but fail on setting.\n\n### `RedisSessionInterface`\n\nUses the Redis key-value store as a session backend. ([redis-py](https://github.com/andymccurdy/redis-py) required)\n\nRelevant configuration values:\n\n- SESSION_REDIS\n\n### `MemcachedSessionInterface`\n\nUses the Memcached as a session backend. ([pylibmc](http://sendapatch.se/projects/pylibmc/) or [memcache](https://github.com/linsomniac/python-memcached) required)\n\n- SESSION_MEMCACHED\n\n### `FileSystemSessionInterface`\n\nUses the `cachelib.file.FileSystemCache` as a session backend.\n\n- SESSION_FILE_DIR\n- SESSION_FILE_THRESHOLD\n- SESSION_FILE_MODE\n\n### `MongoDBSessionInterface`\n\nUses the MongoDB as a session backend. ([pymongo](http://api.mongodb.org/python/current/index.html) required)\n\n- SESSION_MONGODB\n- SESSION_MONGODB_DB\n- SESSION_MONGODB_COLLECT\n\n\n### `SqlAlchemySessionInterface`\n\n\nUses SQLAlchemy as a session backend. ([Flask-SQLAlchemy](https://pythonhosted.org/Flask-SQLAlchemy/) required)\n\n- SESSION_SQLALCHEMY\n- SESSION_SQLALCHEMY_TABLE\n',
    'author': 'Shipeng Feng',
    'author_email': 'fsp261@gmail.com',
    'maintainer': 'Christopher Pickering',
    'maintainer_email': 'christopher@going.bg',
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.2,<4.0.0',
}


setup(**setup_kwargs)
