"""added gps tracking

Peek Plugin Database Migration Script

Revision ID: 02f9305f9e7f
Revises: 6bf6ecef3108
Create Date: 2021-02-22 15:17:11.886057

"""

# revision identifiers, used by Alembic.
revision = "02f9305f9e7f"
down_revision = "6bf6ecef3108"
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "GpsLocation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("deviceToken", sa.String(length=50), nullable=False),
        sa.Column("latitude", sa.Float(), nullable=False),
        sa.Column("longitude", sa.Float(), nullable=False),
        sa.Column("updatedDate", sa.DateTime(timezone=True), nullable=False),
        sa.ForeignKeyConstraint(
            ["deviceToken"],
            ["core_device.DeviceInfo.deviceToken"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("deviceToken"),
        schema="core_device",
    )
    op.create_table(
        "GpsLocationHistory",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("deviceToken", sa.String(length=50), nullable=False),
        sa.Column("latitude", sa.Float(), nullable=False),
        sa.Column("longitude", sa.Float(), nullable=False),
        sa.Column("loggedDate", sa.DateTime(timezone=True), nullable=False),
        sa.ForeignKeyConstraint(
            ["deviceToken"],
            ["core_device.DeviceInfo.deviceToken"],
        ),
        sa.PrimaryKeyConstraint("id", "loggedDate"),
        schema="core_device",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("GpsLocationHistory", schema="core_device")
    op.drop_table("GpsLocation", schema="core_device")
    # ### end Alembic commands ###
